<?xml version="1.0" ?>
<!--
NAME
    cmkucolumn.xsl
DESCRIPTION
    XSLT stylesheet for XML => CMXML conversion of ku$_column_list_t ADTs

MODIFIED    MM/DD/YY
    pkaliren    05/15/08 - Merge 11GC functionality
    xshen       08/10/05 - bug 4531495 
    xshen       04/27/05 - adding ignore table column number support 
    xshen       03/08/05 - changing schema mapping 
    xshen       03/08/05 - fixing schema mapping 
    lhan        03/04/05 - fix support for OPAQUE, UDT, Nested Table, Varray type
    lhan        08/10/04 - add xmltype column support
    lhan        08/09/04 - change not null
    lhan        07/21/04 - size/length
    lhan        07/13/04 - add COL_LIST template
    lhan        07/12/04 - lhan_xsl_0712
    lhan        07/12/04 - initial version
 -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

<!-- Top level imports -->
<xsl:import href="cmkucommon.xsl"/>

<xsl:param name="IGNORE_TBLCOL_NUM">0</xsl:param>  <!-- default not ignore -->

<xsl:template match="COL_LIST">

 <COL_LIST>
   <!-- exclude hidden columns                            - prop bit 0x000020
        (but do include hidden snapshot base table column - prop bit 0x100000
         and do include RLS hidden column                 - prop bit 0x800000)
     -->
 <xsl:for-each select="COL_LIST_ITEM[(PROPERTY mod 64)&lt;32
                     or (PROPERTY mod 2097152)>=1048576
                     or (PROPERTY mod 8388608)>=4194304]">
  <COL_LIST_ITEM> 
   <COL>
    <xsl:value-of select="NAME"/>
   </COL>
  </COL_LIST_ITEM>
 </xsl:for-each>
 </COL_LIST>

</xsl:template>

<xsl:template match="TYPE_NUM">
 <xsl:param name="ADT_type"></xsl:param>
 <DATATYPE>
 <xsl:choose>
  <xsl:when test=".='1'">
   <xsl:choose>
    <xsl:when test="../CHARSETFORM='2'">
     <xsl:text>NVARCHAR2</xsl:text>
    </xsl:when>
    <xsl:otherwise>
     <xsl:text>VARCHAR2</xsl:text>
    </xsl:otherwise>
   </xsl:choose>
  </xsl:when>
  <xsl:when test=".='2'">
   <xsl:choose>
    <xsl:when test="(../PRECISION_NUM) and not(../SCALE)">FLOAT</xsl:when>
    <xsl:otherwise>NUMBER</xsl:otherwise>
   </xsl:choose>
  </xsl:when>
  <xsl:when test=".='8'">LONG</xsl:when>  
  <xsl:when test=".='12'">DATE</xsl:when>
  <xsl:when test=".='23'">RAW</xsl:when>  
  <xsl:when test=".='24'">LONG_RAW</xsl:when>
  <xsl:when test=".='121' or .='122' or .='123' or .='58'">
   <xsl:choose>
     <xsl:when test="../TYPEMD/SCHEMA_OBJ/OWNER_NAME='SYS' and
                     ../TYPEMD/SCHEMA_OBJ/NAME='XMLTYPE'">
     <xsl:text>XMLTYPE</xsl:text>
    </xsl:when>
    <xsl:otherwise>
     <!-- xsl:text>OPAQUE</xsl:text -->
             <xsl:choose>
               <xsl:when test="$SCHEMA_MAP=1 and (../TYPEMD/SCHEMA_OBJ/OWNER_NAME=$R_SCHEMA)">
                 <xsl:value-of select="$L_SCHEMA"/>
               </xsl:when>
               <xsl:otherwise>
                 <xsl:value-of select="../TYPEMD/SCHEMA_OBJ/OWNER_NAME"/>
               </xsl:otherwise>
             </xsl:choose>
     <xsl:text>.</xsl:text>
     <xsl:value-of select="../TYPEMD/SCHEMA_OBJ/NAME"/>
    </xsl:otherwise>
   </xsl:choose>
  </xsl:when>  
  <xsl:when test=".='69'">ROWID</xsl:when>  
  <xsl:when test=".='96'">
   <xsl:choose>
    <xsl:when test="../CHARSETFORM='2'">
     <xsl:text>NCHAR</xsl:text>
    </xsl:when>
    <xsl:otherwise>
     <xsl:text>CHAR</xsl:text>
    </xsl:otherwise>
   </xsl:choose>
  </xsl:when>
  <xsl:when test=".='100'">BINARY_FLOAT</xsl:when>  
  <xsl:when test=".='101'">BINARY_DOUBLE</xsl:when>  
  <xsl:when test=".='105'">MLSLABEL</xsl:when>  
  <xsl:when test=".='111'">REF</xsl:when>
  <xsl:when test=".='112'">
   <xsl:choose>
    <xsl:when test="../CHARSETFORM='2'">
     <xsl:text>NCLOB</xsl:text>
    </xsl:when>
    <xsl:otherwise>
     <xsl:text>CLOB</xsl:text>
    </xsl:otherwise>
   </xsl:choose>
  </xsl:when>
  <xsl:when test=".='113'">BLOB</xsl:when>
  <xsl:when test=".='114'">BFILE</xsl:when>  
  <!-- xsl:when test=".='121'">UDT</xsl:when -->
  <!-- xsl:when test=".='122'">NESTED_TABLE</xsl:when -->
  <!-- xsl:when test=".='123'">VARRAY</xsl:when -->    
  <xsl:when test=".='178'">TIME</xsl:when>  
  <xsl:when test=".='179'">TIME_WITH_TIMEZONE</xsl:when>    
  <xsl:when test=".='180'">TIMESTAMP</xsl:when>    
  <xsl:when test=".='181'">TIMESTAMP_WITH_TIMEZONE</xsl:when>  
  <xsl:when test=".='182'">INTERVAL_YEAR_TO_MONTH</xsl:when>      
  <xsl:when test=".='183'">INTERVAL_DAY_TO_SECOND</xsl:when>  
  <xsl:when test=".='208'">UROWID</xsl:when>  
  <xsl:when test=".='231'">TIMESTAMP_WITH_LOCAL_TIMEZONE</xsl:when>    
 </xsl:choose>
 </DATATYPE>

 <xsl:if test="not($ADT_type='TABLE') or $IGNORE_TBLCOL_NUM=0">
   <COL_NUM>
     <xsl:value-of select="../COL_NUM"/>
   </COL_NUM>
 </xsl:if>
  
 <xsl:if test="../CON">
  <xsl:element name="CONSTRAINT">
   <xsl:element name="TYPE">
   <xsl:text>NOT_NULL</xsl:text>
   </xsl:element>
   <!-- Add State for NOT NULL constraints: Bug 4531495. -->
   <!-- process [en/dis]able syntax -->
   <xsl:element name="ENABLE">
     <xsl:choose>
       <xsl:when test="../CON/ENABLED=1">
         <xsl:text>Y</xsl:text>
       </xsl:when>
       <xsl:otherwise>
         <xsl:text>N</xsl:text>
       </xsl:otherwise>
     </xsl:choose>
   </xsl:element>
   <xsl:element name="VALIDATE">
    <xsl:choose>
      <xsl:when test="(../CON/FLAGS mod 8) >= 4">
      <xsl:text>Y</xsl:text>
     </xsl:when>
     <xsl:otherwise>
      <xsl:text>N</xsl:text>
     </xsl:otherwise>
    </xsl:choose>
   </xsl:element>

   <xsl:if test="$USAGE=2 or (../CON/FLAGS mod 16) &lt; 8">
    <xsl:element name="NAME">
    <xsl:value-of select="../CON/NAME"/>
    </xsl:element>
   </xsl:if>
  </xsl:element>
 </xsl:if>

 <xsl:if test="../DEFAULT_VAL">
  <xsl:element name="DEFAULT">
    <xsl:value-of select="../DEFAULT_VAL"/>
  </xsl:element>
 </xsl:if>

 <!--xsl:if test="(PROPERTY mod 2097152)&lt;1048576">
   <xsl:element name="DEFAULT">
    <xsl:call-template name="Trim_string">
     <xsl:with-param name="String" select="."/>
    </xsl:call-template> 
   </xsl:element>
 </xsl:if-->

 <xsl:if test=".='1' or .='96'">
  <xsl:element name="LENGTH">
   <xsl:choose>
    <xsl:when test="../CHARSETFORM='2' or (../PROPERTY mod 16777216)>=8388608">
     <xsl:value-of select="../SPARE3"/>
    </xsl:when>
    <xsl:otherwise>
     <xsl:value-of select="../LENGTH"/>
    </xsl:otherwise>
   </xsl:choose>
  </xsl:element>
 </xsl:if>

 <xsl:if test=".='23' or .='208'">
  <xsl:element name="LENGTH">
   <xsl:value-of select="../LENGTH"/>
  </xsl:element>
 </xsl:if>

 <xsl:if test=".='2' or .='178' or .='179' or .='180' or .='181' or .='182' or .='183' or .='231'">
  <xsl:if test="../PRECISION_NUM">
   <xsl:element name="PRECISION">
    <xsl:value-of select="../PRECISION_NUM"/>
   </xsl:element>
  </xsl:if>
  <xsl:if test="../SCALE">
   <xsl:element name="SCALE">
    <xsl:value-of select="../SCALE"/>
   </xsl:element>
  </xsl:if>
 </xsl:if>
 
 <xsl:if test="(../PROPERTY mod 268435456)>= 134217728">
  <xsl:element name="SORT">
  </xsl:element>
 </xsl:if>

 <xsl:if test=".='122'">
  <xsl:element name="TYPE_PROPERTIES">
   <xsl:call-template name="DoSchemaWithMapping">
    <xsl:with-param name="CurrentSchema" select="../TYPEMD/SCHEMA_OBJ/OWNER_NAME"/>
   </xsl:call-template>
   <xsl:element name="NAME">
   <xsl:value-of select="../TYPEMD/SCHEMA_OBJ/NAME"/>
   </xsl:element>
  </xsl:element>
 </xsl:if>

</xsl:template>

</xsl:stylesheet>
