/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.thirdparty.mongodb;

import java.sql.Connection;
import java.sql.Driver;
import java.sql.SQLException;
import java.util.Properties;
import oracle.dbtools.connections.db.CustomConnectionCreator;
import oracle.dbtools.raptor.explorer.dt.dialog.ConnectionDialogArb;

public class MongoConnectionCreator
extends CustomConnectionCreator {
    protected void setCustomProperties(Properties properties, Properties properties2) {
        super.setCustomProperties(properties, properties2);
        if (properties.get("zeroDateTimeBehavior") == null) {
            properties2.put("zeroDateTimeBehavior", "convertToNull");
        } else {
            properties2.put("zeroDateTimeBehavior", properties.get("zeroDateTimeBehavior"));
        }
    }

    protected boolean allowNullPassword() {
        return true;
    }

    public boolean shouldPromptForPassword(Properties properties) {
        return false;
    }

    public Connection getConnection(Properties properties) throws SQLException {
        try {
            return super.getConnection(properties);
        }
        catch (SQLException sQLException) {
            if (sQLException.getClass().getName().equals("com.mongo.jdbc.CommunicationsException")) {
                throw new SQLException(ConnectionDialogArb.format((String)"MONGO_CONNECTION_ERROR", (Object[])new Object[]{properties.getProperty("hostname")}), sQLException.getSQLState(), sQLException.getErrorCode());
            }
            throw sQLException;
        }
    }

    protected Driver loadDriver(String string) throws SQLException {
        try {
            return super.loadDriver(string);
        }
        catch (ThreadDeath threadDeath) {
            throw threadDeath;
        }
        catch (Throwable throwable) {
            SQLException sQLException = new SQLException(throwable.getLocalizedMessage());
            sQLException.initCause(throwable);
            throw sQLException;
        }
    }
}

