/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.thirdparty.db2;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Properties;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import oracle.dbtools.raptor.connections.CDComponentView;
import oracle.dbtools.raptor.explorer.dt.dialog.ConnectionDialogArb;
import oracle.dbtools.thirdparty.db2.DB2ConnectionPanel;
import oracle.dbtools.thirdparty.db2.DB2ExplorerArb;
import oracle.dbtools.thirdparty.db2.DB2NavigatorArb;
import oracle.ide.util.ResourceUtils;

public class DB2BasicPanel
extends JPanel
implements CDComponentView {
    private static final String UDB = "UDB";
    private static final String ISERIES = "ISeries";
    public static final String PLATFORM = "Platform";
    public static final String DRIVER_CLASSNAME = "com.ibm.db2.jcc.DB2Driver";
    private static final long serialVersionUID = -8190519193576488547L;
    public static final String ISER_DRIVER_CLASSNAME = "com.ibm.as400.access.AS400JDBCDriver";
    private JLabel m_chooseDataSource = new JLabel();
    protected JTextField m_db2DataSource = new JTextField();
    private JLabel m_hostLbl = new JLabel();
    protected JTextField m_tfdHost = new JTextField(15);
    private JLabel m_portLbl = new JLabel();
    protected JTextField m_tfdPort = new JTextField(15);
    private JLabel m_platformLbl = new JLabel();
    protected JComboBox m_platformCmb = new JComboBox();

    public DB2BasicPanel(DB2ConnectionPanel dB2ConnectionPanel) {
        try {
            this.m_platformCmb.addItem(UDB);
            this.jbInit();
            this.m_platformCmb.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (DB2BasicPanel.ISERIES.equals(DB2BasicPanel.this.m_platformCmb.getSelectedItem())) {
                        DB2BasicPanel.this.m_tfdPort.setEnabled(false);
                    } else {
                        DB2BasicPanel.this.m_tfdPort.setEnabled(true);
                    }
                }
            });
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void jbInit() {
        this.setLayout(new GridBagLayout());
        ResourceUtils.resLabel((JLabel)this.m_platformLbl, (Component)this.m_platformCmb, (String)DB2NavigatorArb.getString("DB2PLATFORM"));
        this.add((Component)this.m_platformLbl, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(10, 5, 0, 0), 0, 0));
        this.add((Component)new JLabel(UDB), new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 18, 2, new Insets(10, 5, 0, 0), 0, 0));
        this.m_tfdHost.setText("localhost");
        this.m_tfdPort.setText("50000");
        ResourceUtils.resLabel((JLabel)this.m_hostLbl, (Component)this.m_tfdHost, (String)ConnectionDialogArb.getString((String)"CONNECTION_DIALOG_DETAILS_HOST"));
        ResourceUtils.resLabel((JLabel)this.m_portLbl, (Component)this.m_tfdPort, (String)ConnectionDialogArb.getString((String)"CONNECTION_DIALOG_DETAILS_PORT"));
        this.add((Component)this.m_hostLbl, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 18, 0, new Insets(10, 5, 0, 0), 0, 0));
        this.add((Component)this.m_tfdHost, new GridBagConstraints(2, 1, 1, 1, 1.0, 0.0, 18, 2, new Insets(10, 5, 0, 0), 0, 0));
        this.add((Component)this.m_portLbl, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 18, 0, new Insets(10, 5, 0, 0), 0, 0));
        this.add((Component)this.m_tfdPort, new GridBagConstraints(2, 2, 1, 1, 1.0, 0.0, 18, 2, new Insets(10, 5, 0, 0), 0, 0));
        ResourceUtils.resLabel((JLabel)this.m_chooseDataSource, (Component)this.m_db2DataSource, (String)DB2ExplorerArb.getString("LABEL_CHOOSEDATABASE"));
        this.add((Component)this.m_chooseDataSource, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 18, 0, new Insets(10, 5, 0, 0), 0, 0));
        this.add((Component)this.m_db2DataSource, new GridBagConstraints(2, 3, 1, 1, 0.0, 0.0, 18, 2, new Insets(10, 5, 0, 0), 0, 0));
    }

    public void clear() {
        this.m_tfdHost.setText("");
        this.m_tfdPort.setText("");
        this.m_db2DataSource.setText("");
    }

    public void generateProperties(Properties properties) {
        String string = this.m_db2DataSource.getText();
        properties.setProperty("hostname", this.m_tfdHost.getText().trim());
        properties.put("port", this.m_tfdPort.getText().trim());
        properties.put(PLATFORM, this.m_platformCmb.getSelectedItem());
        String string2 = null;
        string2 = ISERIES.equals(this.m_platformCmb.getSelectedItem()) ? "jdbc:as400:" + this.m_tfdHost.getText().trim() + "/" + string : "jdbc:db2://" + this.m_tfdHost.getText().trim() + ":" + this.m_tfdPort.getText().trim() + "/" + string;
        properties.setProperty("customUrl", string2);
        properties.setProperty("driver", this.getDriver());
    }

    public void setDefaultPrompts() {
        this.m_tfdHost.setText("localhost");
        this.m_tfdPort.setText("50000");
        this.m_db2DataSource.setText("");
    }

    public String getDriver() {
        if (ISERIES.equals(this.m_platformCmb.getSelectedItem())) {
            return ISER_DRIVER_CLASSNAME;
        }
        return DRIVER_CLASSNAME;
    }

    public void updatePrompts(Properties properties) {
        String string = properties.getProperty(PLATFORM);
        if (string != null) {
            this.m_platformCmb.setSelectedItem(string);
        } else {
            this.m_platformCmb.setSelectedIndex(0);
        }
        String string2 = properties.getProperty("hostname");
        this.m_tfdHost.setText(string2);
        String string3 = properties.getProperty("port");
        this.m_tfdPort.setText(string3 != null ? string3 : "50000");
        String string4 = properties.getProperty("dataSourceName");
        if (string4 != null) {
            this.m_db2DataSource.setText(string4);
        }
    }
}

