/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.thirdparty.copy;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.text.SimpleDateFormat;
import java.util.Date;
import oracle.dbtools.util.Logger;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.editor.Editor;
import oracle.ide.editor.EditorManager;
import oracle.ide.editor.OpenEditorOptions;
import oracle.ide.model.Node;
import oracle.ide.model.TextNode;
import oracle.ide.net.URLFactory;
import oracle.ide.util.IdeUtil;

public class CopyToOracleLog {
    private File m_file;
    protected OutputStreamWriter m_out;
    private Context context;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void showLogFile(String string) {
        try {
            this.openLog();
            this.log(string);
            this.closeLog();
            TextNode textNode = new TextNode(URLFactory.newFileURL((File)this.m_file));
            this.context = Context.newIdeContext((Node)textNode);
            OpenEditorOptions openEditorOptions = new OpenEditorOptions(this.context);
            openEditorOptions.setFlags(1);
            Editor editor = EditorManager.getEditorManager().openEditor(openEditorOptions);
        }
        catch (Exception exception) {
            Logger.warn(this.getClass(), (Throwable)exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void showLogFile() {
        try {
            this.closeLog();
            TextNode textNode = new TextNode(URLFactory.newFileURL((File)this.m_file));
            this.context = Context.newIdeContext((Node)textNode);
            OpenEditorOptions openEditorOptions = new OpenEditorOptions(this.context);
            openEditorOptions.setFlags(1);
            Editor editor = EditorManager.getEditorManager().openEditor(openEditorOptions);
        }
        catch (Exception exception) {
            Logger.warn(this.getClass(), (Throwable)exception);
        }
    }

    public void openLog() {
        SimpleDateFormat simpleDateFormat = null;
        StringBuilder stringBuilder = null;
        try {
            simpleDateFormat = new SimpleDateFormat("MM.dd.yyyy-HH.mm.ss");
            stringBuilder = new StringBuilder(simpleDateFormat.format(new Date()));
            String string = Ide.getUserSettingsDirectory() + "DatabaseCopy." + stringBuilder + ".log";
            this.m_file = new File(string);
            this.m_out = new OutputStreamWriter((OutputStream)new BufferedOutputStream(new FileOutputStream(this.m_file.getPath())), IdeUtil.getIdeEncoding());
        }
        catch (IOException iOException) {
            Logger.warn(this.getClass(), (Throwable)iOException);
        }
    }

    public void log(String string) {
        try {
            if (this.m_out != null) {
                this.m_out.write(string + System.getProperty("line.separator"));
            }
        }
        catch (IOException iOException) {
            Logger.warn(this.getClass(), (Throwable)iOException);
        }
    }

    public void closeLog() {
        try {
            if (this.m_out != null) {
                this.m_out.flush();
                this.m_out.close();
            }
        }
        catch (IOException iOException) {
            Logger.warn(this.getClass(), (Throwable)iOException);
        }
    }
}

