/*
 * Decompiled with CFR 0.152.
 */
package oracle.sdovis.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import oracle.xml.parser.v2.XMLDocument;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class XMLDOMParser {
    Document doc;
    DocumentBuilder parser;

    public XMLDOMParser() {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setIgnoringComments(true);
            factory.setIgnoringElementContentWhitespace(true);
            factory.setCoalescing(true);
            factory.setNamespaceAware(true);
            factory.setExpandEntityReferences(false);
            this.parser = factory.newDocumentBuilder();
            this.parser.setEntityResolver(new MyResolver());
        }
        catch (Error e) {
            e.printStackTrace(System.err);
            System.err.println("Cannot create XMLDOMParser due to an error.");
            throw new IllegalArgumentException(e.getMessage());
        }
        catch (Exception ex) {
            ex.printStackTrace(System.err);
            System.err.println("Cannot create XMLDOMParser due to an exception.");
            throw new IllegalArgumentException(ex.getMessage());
        }
    }

    public void close() {
        this.parser = null;
        this.doc = null;
    }

    public boolean parse(Reader rdr) {
        try {
            this.doc = this.parser.parse(new InputSource(rdr));
            return true;
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            return false;
        }
    }

    public boolean parse(String xml) {
        return this.parse(new StringReader(xml));
    }

    public Document getDocument() {
        return this.doc;
    }

    public Node getElementNode(String tag) {
        NodeList nl = this.doc.getElementsByTagName(tag);
        if (nl != null && nl.getLength() > 0) {
            return nl.item(0);
        }
        return null;
    }

    public Node getElementNode(String tag, int nth) {
        NodeList nl = this.doc.getElementsByTagName(tag);
        if (nl != null && nl.getLength() >= nth) {
            return nl.item(nth);
        }
        return null;
    }

    public NodeList getElementNodes(String tag) {
        return this.doc.getElementsByTagName(tag);
    }

    public Node getLastElement(String tag) {
        NodeList nl = this.doc.getElementsByTagName(tag);
        if (nl != null && nl.getLength() > 0) {
            return nl.item(nl.getLength() - 1);
        }
        return null;
    }

    public Node getElementWithAttr(String tag, String attrName, String attrValue) {
        NodeList nl = this.doc.getElementsByTagName(tag);
        if (nl != null && nl.getLength() > 0) {
            for (int i = 0; i < nl.getLength(); ++i) {
                Node node = nl.item(i);
                if (!attrValue.equals(XMLDOMParser.getAttribute(node, attrName))) continue;
                return node;
            }
        }
        return null;
    }

    public static String getElementValue(Node node) {
        if (node == null) {
            return null;
        }
        NodeList nl = node.getChildNodes();
        if (nl == null || nl.getLength() == 0) {
            String nv = node.getNodeValue();
            if (nv == null) {
                return null;
            }
            return nv;
        }
        String v = "";
        for (int i = 0; i < nl.getLength(); ++i) {
            String nv;
            Node n = nl.item(i);
            short type = n.getNodeType();
            if (type != 3 && type != 6 && type != 4 && type != 5 && type != 12 || (nv = n.getNodeValue()) == null) continue;
            v = v + nv;
        }
        return (v = v.trim()) == null || v.length() == 0 ? null : v;
    }

    public String getElementValue(String tag) {
        NodeList nl = this.doc.getElementsByTagName(tag);
        if (nl != null && nl.getLength() > 0) {
            Node n = nl.item(0).getFirstChild();
            if (n == null) {
                return null;
            }
            return XMLDOMParser.getElementValue(n);
        }
        return null;
    }

    public String getAttribute(String tag, String name) {
        NodeList nl = this.doc.getElementsByTagName(tag);
        if (nl != null && nl.getLength() > 0) {
            NamedNodeMap map = nl.item(0).getAttributes();
            if (map == null) {
                return null;
            }
            Node nd = map.getNamedItem(name);
            if (nd != null) {
                return nd.getNodeValue();
            }
            return null;
        }
        return null;
    }

    public String getElementValue(String tag, int nth) {
        NodeList nl = this.doc.getElementsByTagName(tag);
        if (nl != null && nl.getLength() >= nth) {
            Node n = nl.item(nth);
            return XMLDOMParser.getElementValue(n);
        }
        return null;
    }

    /*
     * Exception decompiling
     */
    public static Document parseToDoc(String xml) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static String getSubElementValue(Node node, String sub) {
        NodeList nl = node.getChildNodes();
        for (int i = 0; i < nl.getLength(); ++i) {
            Node nd = nl.item(i);
            if (!nd.getNodeName().equals(sub)) continue;
            return XMLDOMParser.getElementValue(nd);
        }
        return null;
    }

    public static Node getSubElement(Node node, String sub) {
        if (node == null) {
            return null;
        }
        NodeList nl = node.getChildNodes();
        for (int i = 0; i < nl.getLength(); ++i) {
            Node nd = nl.item(i);
            if (!nd.getNodeName().equals(sub)) continue;
            return nd;
        }
        return null;
    }

    public static Node getSubElementStartsWith(Node node, String starts) {
        if (node == null) {
            return null;
        }
        NodeList nl = node.getChildNodes();
        for (int i = 0; i < nl.getLength(); ++i) {
            Node nd = nl.item(i);
            if (!nd.getNodeName().startsWith(starts)) continue;
            return nd;
        }
        return null;
    }

    public static ArrayList getSubElements(Node node, String name) {
        int subCnt = 0;
        ArrayList<Node> subNL = null;
        NodeList nl = node.getChildNodes();
        subCnt = nl.getLength();
        if (subCnt <= 0) {
            return null;
        }
        subNL = new ArrayList<Node>(subCnt);
        for (int i = 0; i < subCnt; ++i) {
            Node n = nl.item(i);
            if (!n.getNodeName().equals(name)) continue;
            subNL.add(n);
        }
        return subNL;
    }

    public static ArrayList getRealChildNodes(Node nd) {
        if (!nd.hasChildNodes()) {
            return null;
        }
        NodeList nl = nd.getChildNodes();
        ArrayList<Node> al = new ArrayList<Node>(nl.getLength());
        for (int i = 0; i < nl.getLength(); ++i) {
            Node n = nl.item(i);
            if (n.getNodeType() != 1) continue;
            al.add(n);
        }
        return al;
    }

    public static Node getFirstRealChildNode(Node nd) {
        if (!nd.hasChildNodes()) {
            return null;
        }
        NodeList nl = nd.getChildNodes();
        for (int i = 0; i < nl.getLength(); ++i) {
            Node n = nl.item(i);
            if (n.getNodeType() != 1) continue;
            return n;
        }
        return null;
    }

    public static Vector getSubNodesWithTagName(Node nd, String name) {
        int subCnt = 0;
        Vector<Node> subNL = null;
        NodeList nl = nd.getChildNodes();
        subCnt = nl.getLength();
        if (subCnt <= 0) {
            return null;
        }
        subNL = new Vector<Node>(subCnt);
        for (int i = 0; i < subCnt; ++i) {
            Node n = nl.item(i);
            if (!n.getNodeName().equals(name)) continue;
            subNL.add(nd);
        }
        return subNL;
    }

    public static Node getAnySubElement(Node n, String tag) {
        NodeList nl;
        if (n.getNodeName().equals(tag)) {
            return n;
        }
        if (n.hasChildNodes() && (nl = n.getChildNodes()) != null && nl.getLength() > 0) {
            for (int i = 0; i < nl.getLength(); ++i) {
                Node res = XMLDOMParser.getAnySubElement(nl.item(i), tag);
                if (res == null) continue;
                return res;
            }
        }
        return null;
    }

    public static String getValue(Node node) {
        return XMLDOMParser.getElementValue(node);
    }

    public static String getAttribute(Node node, String name) {
        if (node == null) {
            return null;
        }
        NamedNodeMap map = node.getAttributes();
        if (map == null || map.getLength() == 0) {
            return null;
        }
        Node nd = map.getNamedItem(name);
        return nd != null ? nd.getNodeValue() : null;
    }

    public static void dumpNode(Node node) {
        System.out.println("Node name:  " + node.getNodeName());
        System.out.println("Node type:  " + XMLDOMParser.getNodeTypeName(node));
        String val = node.getNodeValue();
        if (val != null) {
            val = val.trim();
        }
        if (val != null && val.length() == 0) {
            System.out.println("Node value: \"\"");
        } else {
            System.out.println("Node value: " + val);
        }
    }

    public static void dumpAllNodes(Node node) {
        Node nextNode;
        XMLDOMParser.dumpNode(node);
        if (node.hasChildNodes()) {
            System.out.print("\n");
            Node firstChild = node.getFirstChild();
            XMLDOMParser.dumpAllNodes(firstChild);
        }
        if ((nextNode = node.getNextSibling()) != null) {
            System.out.print("\n");
            XMLDOMParser.dumpAllNodes(nextNode);
        }
    }

    public static void dumpAllDescendants(Node node) {
        XMLDOMParser.dumpNode(node);
        if (node.hasChildNodes()) {
            System.out.print("\n");
            Node firstChild = node.getFirstChild();
            XMLDOMParser.dumpAllDescendants(firstChild);
        }
    }

    public static String getNodeTypeName(Node node) {
        short type = node.getNodeType();
        switch (type) {
            case 1: {
                return "Element";
            }
            case 2: {
                return "Attribute";
            }
            case 3: {
                return "Text";
            }
            case 4: {
                return "CDATA Section";
            }
            case 5: {
                return "Entity Reference";
            }
            case 6: {
                return "Entity";
            }
            case 7: {
                return "Processing Instruction";
            }
            case 8: {
                return "Comment";
            }
            case 9: {
                return "Document";
            }
            case 10: {
                return "Document Type Declaration";
            }
            case 11: {
                return "Document Fragment";
            }
            case 12: {
                return "Notation";
            }
        }
        return "Unknown Type";
    }

    public static String nodeToString(Node node) throws TransformerException {
        StringWriter sw = new StringWriter();
        Transformer t = TransformerFactory.newInstance().newTransformer();
        t.setOutputProperty("omit-xml-declaration", "no");
        t.setOutputProperty("indent", "yes");
        t.setOutputProperty("standalone", "yes");
        t.transform(new DOMSource(node), new StreamResult(sw));
        return sw.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean validateXMLReq(XMLDocument xDoc, InputStream isSchema) {
        if (isSchema == null) {
            return false;
        }
        SchemaFactory factory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        StreamSource schemaSource = new StreamSource(isSchema);
        Schema schema = null;
        try {
            schema = factory.newSchema(schemaSource);
            Validator validator = schema.newValidator();
            validator.validate(new DOMSource((Node)xDoc));
        }
        catch (Exception e) {
            System.err.println("XML request validation warning: " + e.getMessage());
            boolean bl = false;
            return bl;
        }
        finally {
            if (isSchema != null) {
                try {
                    isSchema.close();
                }
                catch (Exception ex) {}
            }
        }
        return true;
    }

    private static void printoutDoc(XMLDocument xDoc) {
        Transformer transformer = null;
        try {
            transformer = TransformerFactory.newInstance().newTransformer();
        }
        catch (TransformerConfigurationException e) {
        }
        catch (TransformerFactoryConfigurationError e) {
            // empty catch block
        }
        transformer.setOutputProperty("indent", "yes");
        DOMSource source = new DOMSource((Node)xDoc);
        StreamResult console = new StreamResult(System.out);
        try {
            transformer.transform(source, console);
        }
        catch (TransformerException e) {
            // empty catch block
        }
    }

    public static class MyResolver
    implements EntityResolver {
        @Override
        public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
            throw new SAXException("External entity reference not supported.");
        }
    }
}

