/*
 * Decompiled with CFR 0.152.
 */
package oracle.sdovis.util;

import java.util.ArrayList;
import java.util.Vector;
import java.util.logging.Logger;
import oracle.mapviewer.share.util.LogFactory;
import oracle.sdovis.util.ComparisonOperator;
import oracle.sdovis.util.LogicalOperator;

public class WhereClause {
    private static Logger log = LogFactory.getLogger(LogFactory.LoggerEnum.SDOVIS);
    private Object rootOperator = null;

    public Object getRootOperator() {
        return this.rootOperator;
    }

    public String getAsWFSxml(int blankSpaces, String featName, String nameSpace) {
        if (featName == null) {
            return "";
        }
        if (this.rootOperator == null) {
            return "";
        }
        String xml = "";
        Object obj = this.rootOperator;
        if (obj instanceof LogicalOperator) {
            LogicalOperator lop = (LogicalOperator)obj;
            xml = xml + lop.getAsWFSxml(blankSpaces + 2, featName, nameSpace);
        } else if (obj instanceof ComparisonOperator) {
            ComparisonOperator cop = (ComparisonOperator)obj;
            xml = xml + cop.getAsWFSxml(blankSpaces + 2, featName, nameSpace);
        }
        return xml;
    }

    public String getAsWFSstring() {
        if (this.rootOperator == null) {
            return "";
        }
        String xml = "";
        Object obj = this.rootOperator;
        if (obj instanceof LogicalOperator) {
            LogicalOperator lop = (LogicalOperator)obj;
            xml = xml + lop.getAsWFSstring();
        } else if (obj instanceof ComparisonOperator) {
            ComparisonOperator cop = (ComparisonOperator)obj;
            xml = xml + cop.getAsWFSstring();
        }
        return xml;
    }

    public Object parse(String condition) {
        this.rootOperator = null;
        if (condition == null) {
            log.warning("Query condition is null.");
            return null;
        }
        String[] fragments = this.getExpressions(condition);
        if (fragments == null || fragments.length == 0) {
            log.warning("Unable to get query condition fragments.");
            return null;
        }
        boolean lookLogicalOp = false;
        boolean firstLogicalOp = true;
        for (int i = 0; i < fragments.length; ++i) {
            Object op = this.parseFragment(fragments[i], lookLogicalOp);
            if (op == null) {
                this.rootOperator = null;
                log.warning("Unable to parse fragment: " + fragments[i]);
                return null;
            }
            if (op instanceof LogicalOperator) {
                LogicalOperator lop = (LogicalOperator)op;
                if (this.rootOperator == null) {
                    lookLogicalOp = !fragments[i].trim().toLowerCase().endsWith(" " + lop.getLogicalOperator().toLowerCase());
                    this.rootOperator = op;
                    continue;
                }
                lookLogicalOp = lop.getElements().size() != 0;
                if (this.rootOperator instanceof ComparisonOperator) {
                    lop.addElement(this.rootOperator);
                    this.rootOperator = lop;
                    continue;
                }
                if (firstLogicalOp) {
                    lop.addElement(this.rootOperator);
                    this.rootOperator = lop;
                    firstLogicalOp = false;
                    continue;
                }
                int childs = lop.getElements().size();
                for (int k = 0; k < childs; ++k) {
                    ((LogicalOperator)this.rootOperator).addElement(lop.getElements().get(k));
                }
                continue;
            }
            if (this.rootOperator == null) {
                this.rootOperator = op;
            } else {
                ((LogicalOperator)this.rootOperator).addElement(op);
            }
            lookLogicalOp = true;
        }
        return this.rootOperator;
    }

    private Object parseFragment(String condition, boolean lookLogicalFirst) {
        if (condition == null) {
            return null;
        }
        if (condition.indexOf("(") > -1 || condition.indexOf(")") > -1) {
            log.info("Fragment expression can not have parenthesis.");
            return null;
        }
        String[] result = condition.split("\\s");
        result = this.cleanStringArray(result);
        boolean lookFirstOp = true;
        boolean lookScndOp = false;
        boolean lookOperator = false;
        boolean lookLogicalOperator = false;
        if (lookLogicalFirst) {
            lookFirstOp = false;
            lookLogicalOperator = true;
        }
        String currOp = null;
        ComparisonOperator cop = null;
        LogicalOperator lop = null;
        for (int x = 0; x < result.length; ++x) {
            if (lookFirstOp) {
                cop = new ComparisonOperator();
                cop.setVariable(result[x]);
                lookFirstOp = false;
                lookOperator = true;
                if (lop == null) continue;
                lop.addElement(cop);
                continue;
            }
            if (lookOperator) {
                if (!ComparisonOperator.isOperator(result[x])) {
                    log.info("Expecting comparison operator, not: " + result[x]);
                    return null;
                }
                cop.setOperator(result[x]);
                lookOperator = false;
                lookScndOp = true;
                continue;
            }
            if (lookScndOp) {
                if (result[x].startsWith("'") && result[x].endsWith("'")) {
                    cop.setValue(result[x].substring(1, result[x].length() - 1));
                } else {
                    cop.setValue(result[x]);
                }
                lookScndOp = false;
                lookLogicalOperator = true;
                continue;
            }
            if (!lookLogicalOperator) continue;
            if (currOp == null) {
                if (lop == null) {
                    lop = new LogicalOperator(result[x]);
                    lop.addElement(cop);
                }
                currOp = result[x];
            } else if (!currOp.equalsIgnoreCase(result[x])) {
                log.info("Use parenthesis to separate different logic operators.");
                return null;
            }
            lookLogicalOperator = false;
            lookFirstOp = true;
        }
        if (lop == null && cop == null) {
            return null;
        }
        if (lop != null) {
            return lop;
        }
        return cop;
    }

    private String[] getExpressions(String condition) {
        if (condition == null) {
            return null;
        }
        ArrayList<String> exprs = new ArrayList<String>();
        int startindex = condition.lastIndexOf("(");
        if (startindex == -1) {
            exprs.add(condition.trim());
        } else {
            boolean started = false;
            String expr = "";
            for (int i = 0; i < condition.length(); ++i) {
                char currentChar = condition.charAt(i);
                if (currentChar == '(') {
                    if (!started) continue;
                    exprs.add(expr);
                    expr = "";
                    started = false;
                    continue;
                }
                if (currentChar == ')') {
                    if (!started) continue;
                    exprs.add(expr);
                    expr = "";
                    started = false;
                    continue;
                }
                if (!started) {
                    expr = expr + currentChar;
                    started = true;
                    continue;
                }
                expr = expr + currentChar;
            }
            if (expr.trim().length() > 0) {
                exprs.add(expr);
            }
        }
        return exprs.toArray(new String[exprs.size()]);
    }

    private String[] cleanStringArray(String[] input) {
        if (input == null) {
            return null;
        }
        Vector<String> newarray = new Vector<String>();
        int pos = 0;
        while (pos < input.length) {
            if (input[pos].trim().length() == 0) {
                ++pos;
                continue;
            }
            String str = input[pos].trim();
            if (str.equalsIgnoreCase("is")) {
                if (input[pos + 1].trim().equalsIgnoreCase("null")) {
                    str = str + " null";
                    newarray.add(str);
                    ++pos;
                    continue;
                }
                if (!input[pos + 1].trim().equalsIgnoreCase("not") || !input[pos + 2].trim().equalsIgnoreCase("null")) continue;
                str = str + " not null";
                newarray.add(str);
                pos += 2;
                continue;
            }
            if (str.startsWith("'") && !str.endsWith("'")) {
                str = str + " ";
                if (++pos == input.length) break;
                String str1 = input[pos];
                while (!str1.endsWith("'") && pos < input.length) {
                    str = str1.length() == 0 ? str + " " : str + str1;
                    str1 = input[++pos];
                }
                str = str + str1;
                newarray.add(str);
                ++pos;
                continue;
            }
            newarray.add(str);
            ++pos;
        }
        if (newarray.size() == 0) {
            return null;
        }
        return newarray.toArray(new String[newarray.size()]);
    }
}

