/*
 * Decompiled with CFR 0.152.
 */
package oracle.sdovis.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import java.util.logging.Logger;
import oracle.mapviewer.share.util.LogFactory;
import oracle.sdovis.util.HttpConnection;
import oracle.sdovis.util.Util;
import oracle.sdovis.util.XMLDOMParser;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class WfsUtil {
    private static Logger log = LogFactory.getLogger(LogFactory.LoggerEnum.SDOVIS);

    public static Hashtable getFeatureTypesAttrNamesUsingHttpGet(String url, String wfsVersion) {
        String getreq;
        if (url == null || url.trim().length() == 0) {
            return null;
        }
        String version = "1.0.0";
        if (wfsVersion != null) {
            version = wfsVersion;
        }
        if ((getreq = url.trim()).lastIndexOf(63) > -1) {
            if (!getreq.endsWith("?") && !getreq.endsWith("&")) {
                getreq = getreq + "&";
            }
        } else if (!getreq.endsWith("&")) {
            getreq = getreq + "?";
        }
        getreq = getreq + "VERSION=" + version + "&SERVICE=WFS&REQUEST=DescribeFeatureType";
        log.info("WFS GET request: " + getreq);
        String result = "";
        try {
            result = Util.issueHttpGetRequest(getreq);
        }
        catch (Exception e) {
            log.info("Exception: " + e.getMessage());
            return null;
        }
        if (result == null) {
            log.warning("Http GET request returned NULL string.");
            return null;
        }
        if (result.indexOf("<ExceptionReport") > -1) {
            log.warning("Exception report returned:\n" + result);
            return null;
        }
        Hashtable attrNames = null;
        attrNames = WfsUtil.hasComplexTypeNode(result) ? WfsUtil.processAttributeNamesRequest(result) : WfsUtil.processMultipleAttributeSchemas(result);
        return attrNames;
    }

    public static Hashtable getFeatureTypesAttrNamesUsingHttpPost(String url, String wfsVersion) {
        if (url == null || url.trim().length() == 0) {
            return null;
        }
        String version = "1.0.0";
        if (wfsVersion != null) {
            version = wfsVersion;
        }
        String postreq = url.trim();
        String xml = "<?xml version=\"1.0\" ?>\n<wfs:DescribeFeatureType\n   service=\"WFS\"\n   version=\"" + version + "\"\n" + "   xmlns:wfs=\"http://www.opengis.net/wfs\"\n" + "   xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\n" + "   xmlns:xd=\"http://www.w3.org/2001/XMLSchema\"\n";
        xml = version.equals("1.1.0") ? xml + "   xsi:schemaLocation=\"http://www.opengis.net/wfs ../wfs/1.1.0/WFS.xsd\">\n" : xml + "   xsi:schemaLocation=\"http://www.opengis.net/wfs ../wfs/1.0.0/WFS-basic.xsd\">\n";
        xml = xml + "</wfs:DescribeFeatureType>\n";
        log.info("WFS POST address: " + postreq);
        log.info("WFS POST Request: " + xml);
        String result = "";
        try {
            HttpConnection hurl = new HttpConnection();
            hurl.connect(postreq);
            hurl.sendXMLRequest("", xml);
            result = hurl.getXMLResponse();
        }
        catch (Exception e) {
            log.info("Exception: " + e.getMessage());
            return null;
        }
        if (result == null) {
            log.warning("Http POST request returned NULL string.");
            return null;
        }
        if (result.indexOf("<ExceptionReport") > -1) {
            log.warning("Exception report returned:\n" + result);
            return null;
        }
        Hashtable attrNames = null;
        attrNames = WfsUtil.hasComplexTypeNode(result) ? WfsUtil.processAttributeNamesRequest(result) : WfsUtil.processMultipleAttributeSchemas(result);
        return attrNames;
    }

    private static Hashtable processAttributeNamesRequest(String result) {
        if (result == null || result.trim().length() == 0) {
            return null;
        }
        Hashtable featattrs = new Hashtable();
        try {
            XMLDOMParser parser = new XMLDOMParser();
            if (!parser.parse(result)) {
                log.info("Unable to parse describe feature type result.");
                return null;
            }
            Document doc = parser.getDocument();
            Node root = doc.getFirstChild();
            if (root == null) {
                log.info("No root node found while processing attribute names.");
                return null;
            }
            if (root.getNodeName().indexOf("schema") < 0 && (root = WfsUtil.getSchemaNode(doc)) == null) {
                log.info("Unable to find schema node.");
                return null;
            }
            log.info("Parsing feature attribute names.");
            String alias = "";
            String rootName = root.getNodeName();
            int index = rootName.indexOf(":");
            if (index > -1) {
                alias = rootName.substring(0, index) + ":";
            } else {
                ArrayList childs = XMLDOMParser.getRealChildNodes(root);
                if (childs != null) {
                    for (int i = 0; i < childs.size(); ++i) {
                        Node child = (Node)childs.get(i);
                        int idx = child.getNodeName().indexOf(":element");
                        if (idx <= -1) continue;
                        alias = child.getNodeName().substring(0, idx + 1);
                        break;
                    }
                }
            }
            Vector nodes = WfsUtil.getChildNodes(root, alias + "element");
            String featType = null;
            String featName = null;
            String type = null;
            if (nodes != null) {
                for (int i = 0; i < nodes.size(); ++i) {
                    Node sequence;
                    Node extension;
                    Node cxcontent;
                    featType = null;
                    Node child = (Node)nodes.get(i);
                    featName = XMLDOMParser.getAttribute(child, "name");
                    if (featName == null) continue;
                    type = XMLDOMParser.getAttribute(child, "type");
                    if (type == null) continue;
                    featType = Util.normalize(type.trim());
                    Vector cnodes = WfsUtil.getChildNodes(root, alias + "complexType");
                    Node featTypeNode = null;
                    if (cnodes != null) {
                        for (int j = 0; j < cnodes.size(); ++j) {
                            Node cchild = (Node)cnodes.get(j);
                            type = XMLDOMParser.getAttribute(cchild, "name");
                            if (type == null || !type.trim().equalsIgnoreCase(featType)) continue;
                            featTypeNode = cchild;
                            break;
                        }
                    }
                    if (featTypeNode == null || (cnodes = WfsUtil.getChildNodes(featTypeNode, alias + "complexContent")) == null || (cnodes = WfsUtil.getChildNodes(cxcontent = (Node)cnodes.get(0), alias + "extension")) == null || (cnodes = WfsUtil.getChildNodes(extension = (Node)cnodes.get(0), alias + "sequence")) == null || (cnodes = WfsUtil.getChildNodes(sequence = (Node)cnodes.get(0), alias + "element")) == null) continue;
                    ArrayList<String> atnames = new ArrayList<String>();
                    for (int k = 0; k < cnodes.size(); ++k) {
                        Node fchild = (Node)cnodes.get(k);
                        String ref = XMLDOMParser.getAttribute(fchild, "ref");
                        if (ref != null) {
                            if (ref.indexOf("gml:") == -1) {
                                atnames.add(Util.normalize(ref));
                                continue;
                            }
                            atnames.add(ref);
                            continue;
                        }
                        String name = XMLDOMParser.getAttribute(fchild, "name");
                        if (name == null) continue;
                        atnames.add(name);
                    }
                    Collections.sort(atnames);
                    featattrs.put(featName, atnames);
                    log.info("Feature " + featName + " completed.");
                }
            }
        }
        catch (Exception e) {
            log.info("Exception in processAttributeNamesRequest: " + e.getMessage());
            return null;
        }
        if (featattrs.size() == 0) {
            featattrs = null;
        }
        log.info("End of parsing feature attribute names.");
        return featattrs;
    }

    private static Hashtable processMultipleAttributeSchemas(String result) {
        if (result == null || result.trim().length() == 0) {
            return null;
        }
        Hashtable attrNames = null;
        try {
            XMLDOMParser parser = new XMLDOMParser();
            if (!parser.parse(result)) {
                log.info("Unable to parse describe feature type result.");
                return null;
            }
            Document doc = parser.getDocument();
            Node root = doc.getFirstChild();
            if (root == null) {
                log.info("No root node found while processing attribute names.");
                return null;
            }
            if (root.getNodeName().indexOf("schema") < 0 && (root = WfsUtil.getSchemaNode(doc)) == null) {
                log.info("Unable to find schema node.");
                return null;
            }
            log.info("Parsing feature attribute names with multiple schemas.");
            String alias = "";
            String rootName = root.getNodeName();
            int index = rootName.indexOf(":");
            if (index > -1) {
                alias = rootName.substring(0, index) + ":";
            } else {
                ArrayList childs = XMLDOMParser.getRealChildNodes(root);
                if (childs != null) {
                    for (int i = 0; i < childs.size(); ++i) {
                        Node child = (Node)childs.get(i);
                        int idx = child.getNodeName().indexOf(":import");
                        if (idx <= -1) continue;
                        alias = child.getNodeName().substring(0, idx + 1);
                        break;
                    }
                }
            }
            Vector cnodes = WfsUtil.getChildNodes(root, alias + "import");
            if (cnodes != null) {
                for (int j = 0; j < cnodes.size(); ++j) {
                    Node cchild = (Node)cnodes.get(j);
                    String schemaLocation = XMLDOMParser.getAttribute(cchild, "schemaLocation");
                    if (schemaLocation == null || schemaLocation.trim().length() <= 0) continue;
                    log.info("Schema Location: " + schemaLocation);
                    result = Util.issueHttpGetRequest(schemaLocation);
                    Hashtable htable = WfsUtil.processAttributeNamesRequest(result);
                    if (htable == null) continue;
                    if (attrNames == null) {
                        attrNames = htable;
                        continue;
                    }
                    Enumeration e = htable.keys();
                    while (e.hasMoreElements()) {
                        String key = (String)e.nextElement();
                        attrNames.put(key, htable.get(key));
                    }
                }
            }
        }
        catch (Exception e) {
            log.info("Exception in processMultipleAttributeSchemas:\n" + e.getMessage());
            return null;
        }
        log.info("End of parsing feature attribute names with multiple schemas.");
        return attrNames;
    }

    private static boolean hasComplexTypeNode(String result) {
        if (result == null || result.trim().length() == 0) {
            return false;
        }
        try {
            Vector cnodes;
            XMLDOMParser parser = new XMLDOMParser();
            if (!parser.parse(result)) {
                log.info("Unable to parse describe feature type result.");
                return false;
            }
            Document doc = parser.getDocument();
            Node root = doc.getFirstChild();
            if (root == null) {
                log.info("Root node not found while processing attribute names.");
                return false;
            }
            if (root.getNodeName().indexOf("schema") < 0 && (root = WfsUtil.getSchemaNode(doc)) == null) {
                log.info("Unable to find schema node.");
                return false;
            }
            String alias = "";
            String rootName = root.getNodeName();
            int index = rootName.indexOf(":");
            if (index > -1) {
                alias = rootName.substring(0, index) + ":";
            }
            if ((cnodes = WfsUtil.getChildNodes(root, alias + "complexType")) != null && cnodes.size() > 0) {
                return true;
            }
            if (index == -1) {
                ArrayList childs = XMLDOMParser.getRealChildNodes(root);
                if (childs != null) {
                    for (int i = 0; i < childs.size(); ++i) {
                        Node child = (Node)childs.get(i);
                        int idx = child.getNodeName().indexOf(":complexType");
                        if (idx <= -1) continue;
                        return true;
                    }
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public static Vector getChildNodes(Node parent, String childNodeName) {
        if (parent == null || childNodeName == null) {
            return null;
        }
        NodeList ndlist = parent.getChildNodes();
        if (ndlist == null) {
            return null;
        }
        Vector<Node> nodes = new Vector<Node>();
        for (int i = 0; i < ndlist.getLength(); ++i) {
            Node child = ndlist.item(i);
            String ndname = child.getNodeName().trim();
            if (!ndname.equalsIgnoreCase(childNodeName)) continue;
            nodes.add(child);
        }
        if (nodes.size() == 0) {
            return null;
        }
        return nodes;
    }

    private static Node getSchemaNode(Document doc) {
        if (doc == null) {
            return null;
        }
        NodeList nodes = doc.getChildNodes();
        if (nodes == null || nodes.getLength() < 1) {
            return null;
        }
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node nd = nodes.item(i);
            if (nd.getNodeName().indexOf("schema") <= -1) continue;
            return nd;
        }
        return null;
    }
}

