/*
 * Decompiled with CFR 0.152.
 */
package oracle.sdovis.util;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.Vector;
import java.util.logging.Logger;
import oracle.mapviewer.share.util.LogFactory;
import oracle.spatial.geometry.JGeometry;
import oracle.sql.ArrayDescriptor;
import oracle.sql.STRUCT;
import oracle.sql.StructDescriptor;

public class ORADBGeometryOperations {
    public static Logger log = LogFactory.getLogger(LogFactory.LoggerEnum.SDOVIS);

    public static JGeometry union(Connection conn, String table1, String geomColumn1, String keyAttr1, String[] keyValues1, String table2, String geomColumn2, String keyAttr2, String[] keyValues2, double tolerance) {
        return ORADBGeometryOperations.executeOperation("union", conn, table1, geomColumn1, keyAttr1, keyValues1, table2, geomColumn2, keyAttr2, keyValues2, tolerance);
    }

    public static JGeometry difference(Connection conn, String table1, String geomColumn1, String keyAttr1, String[] keyValues1, String table2, String geomColumn2, String keyAttr2, String[] keyValues2, double tolerance) {
        return ORADBGeometryOperations.executeOperation("difference", conn, table1, geomColumn1, keyAttr1, keyValues1, table2, geomColumn2, keyAttr2, keyValues2, tolerance);
    }

    public static JGeometry intersection(Connection conn, String table1, String geomColumn1, String keyAttr1, String[] keyValues1, String table2, String geomColumn2, String keyAttr2, String[] keyValues2, double tolerance) {
        return ORADBGeometryOperations.executeOperation("intersection", conn, table1, geomColumn1, keyAttr1, keyValues1, table2, geomColumn2, keyAttr2, keyValues2, tolerance);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static JGeometry executeOperation(String operation, Connection conn, String table1, String geomColumn1, String keyAttr1, String[] keyValues1, String table2, String geomColumn2, String keyAttr2, String[] keyValues2, double tolerance) {
        String key2;
        if (operation == null || conn == null || table1 == null || geomColumn1 == null || keyValues1 == null || keyValues1.length == 0 || table2 == null || geomColumn2 == null || keyValues2 == null || keyValues2.length == 0) {
            return null;
        }
        String sdoGeomOper = null;
        if (operation.equalsIgnoreCase("union")) {
            sdoGeomOper = "SDO_GEOM.SDO_UNION";
        } else if (operation.equalsIgnoreCase("difference")) {
            sdoGeomOper = "SDO_GEOM.SDO_DIFFERENCE";
        } else if (operation.equalsIgnoreCase("intersection")) {
            sdoGeomOper = "SDO_GEOM.SDO_INTERSECTION";
        } else {
            return null;
        }
        String key1 = keyAttr1;
        if (key1 == null) {
            key1 = "rowid";
        }
        if ((key2 = keyAttr2) == null) {
            key2 = "rowid";
        }
        JGeometry geom = null;
        String rowids1 = "(";
        int pos = 0;
        for (int i = 0; i < keyValues1.length; ++i) {
            String id = keyValues1[i];
            if (pos > 0) {
                rowids1 = rowids1 + ",";
            }
            rowids1 = rowids1 + "'" + id + "'";
            ++pos;
        }
        rowids1 = rowids1 + ")";
        String rowids2 = "(";
        pos = 0;
        for (int i = 0; i < keyValues2.length; ++i) {
            String id = keyValues2[i];
            if (pos > 0) {
                rowids2 = rowids2 + ",";
            }
            rowids2 = rowids2 + "'" + id + "'";
            ++pos;
        }
        rowids2 = rowids2 + ")";
        String query = "SELECT " + sdoGeomOper + "(c_a." + geomColumn1 + ", c_c." + geomColumn2 + ", " + tolerance + ") " + "FROM " + table1 + " c_a," + table2 + " c_c " + "WHERE c_a." + key1 + " in " + rowids1 + " AND c_c." + key2 + " in " + rowids2;
        PreparedStatement st = null;
        ResultSet rs = null;
        try {
            st = conn.prepareStatement(query);
            rs = st.executeQuery();
            if (rs.next()) {
                STRUCT stc = (STRUCT)rs.getObject(1);
                geom = JGeometry.load((STRUCT)stc);
            }
        }
        catch (Exception ex) {
            log.warning("Exception while executing:" + sdoGeomOper + "\n" + ex.getMessage());
            geom = null;
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (Exception re) {}
            }
            if (st != null) {
                try {
                    st.close();
                }
                catch (Exception re) {}
            }
        }
        return geom;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JGeometry buffer(Connection conn, String table, String geomColumn, String keyAttr, String keyValue, double distance, double tolerance) {
        if (conn == null || table == null || geomColumn == null || keyValue == null) {
            return null;
        }
        String key = keyAttr;
        if (key == null) {
            key = "rowid";
        }
        String query = "SELECT SDO_GEOM.SDO_BUFFER(" + geomColumn + ", " + distance + ", " + tolerance + ") " + "FROM " + table + " WHERE " + key + " = '" + keyValue + "'";
        JGeometry geom = null;
        PreparedStatement st = null;
        ResultSet rs = null;
        try {
            st = conn.prepareStatement(query);
            rs = st.executeQuery();
            if (rs.next()) {
                STRUCT stc = (STRUCT)rs.getObject(1);
                geom = JGeometry.load((STRUCT)stc);
            }
        }
        catch (Exception ex) {
            log.warning("Exception while executing buffer.\n" + ex.getMessage());
            geom = null;
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (Exception re) {}
            }
            if (st != null) {
                try {
                    st.close();
                }
                catch (Exception re) {}
            }
        }
        return geom;
    }

    public static JGeometry union(Connection conn, JGeometry geom1, JGeometry geom2, double tolerance) {
        return ORADBGeometryOperations.executeOperation("union", conn, geom1, geom2, tolerance);
    }

    public static JGeometry difference(Connection conn, JGeometry geom1, JGeometry geom2, double tolerance) {
        return ORADBGeometryOperations.executeOperation("difference", conn, geom1, geom2, tolerance);
    }

    public static JGeometry intersection(Connection conn, JGeometry geom1, JGeometry geom2, double tolerance) {
        return ORADBGeometryOperations.executeOperation("intersection", conn, geom1, geom2, tolerance);
    }

    public static JGeometry xor(Connection conn, JGeometry geom1, JGeometry geom2, double tolerance) {
        return ORADBGeometryOperations.executeOperation("xor", conn, geom1, geom2, tolerance);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static JGeometry executeOperation(String operation, Connection conn, JGeometry geom1, JGeometry geom2, double tolerance) {
        if (operation == null || conn == null || geom1 == null || geom2 == null) {
            return null;
        }
        String sdoGeomOper = null;
        if (operation.equalsIgnoreCase("union")) {
            sdoGeomOper = "SDO_GEOM.SDO_UNION";
        } else if (operation.equalsIgnoreCase("difference")) {
            sdoGeomOper = "SDO_GEOM.SDO_DIFFERENCE";
        } else if (operation.equalsIgnoreCase("intersection")) {
            sdoGeomOper = "SDO_GEOM.SDO_INTERSECTION";
        } else if (operation.equalsIgnoreCase("xor")) {
            sdoGeomOper = "SDO_GEOM.SDO_XOR";
        } else {
            return null;
        }
        Statement st = null;
        ResultSet rs = null;
        JGeometry geom = null;
        try {
            String query = "SELECT " + sdoGeomOper + "(?,?,?) from dual";
            StructDescriptor geomDesc = StructDescriptor.createDescriptor((String)"MDSYS.SDO_GEOMETRY", (Connection)conn);
            StructDescriptor pointDesc = StructDescriptor.createDescriptor((String)"MDSYS.SDO_POINT_TYPE", (Connection)conn);
            ArrayDescriptor elemInfoDesc = ArrayDescriptor.createDescriptor((String)"MDSYS.SDO_ELEM_INFO_ARRAY", (Connection)conn);
            ArrayDescriptor ordinatesDesc = ArrayDescriptor.createDescriptor((String)"MDSYS.SDO_ORDINATE_ARRAY", (Connection)conn);
            Object[] descs = new Object[]{geomDesc, pointDesc, elemInfoDesc, ordinatesDesc};
            STRUCT sgeom1 = null;
            sgeom1 = JGeometry.store((JGeometry)geom1, (Connection)conn, (Object[])descs);
            STRUCT sgeom2 = null;
            sgeom2 = JGeometry.store((JGeometry)geom2, (Connection)conn, (Object[])descs);
            st = conn.prepareStatement(query);
            st.setObject(1, sgeom1);
            st.setObject(2, sgeom2);
            st.setDouble(3, tolerance);
            rs = st.executeQuery();
            if (rs.next()) {
                STRUCT strc = (STRUCT)rs.getObject(1);
                geom = JGeometry.load((STRUCT)strc);
            }
        }
        catch (Exception ex) {
            log.warning("Exception while executing " + sdoGeomOper + ".\n" + ex.getMessage());
            geom = null;
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (Exception re) {}
            }
            if (st != null) {
                try {
                    st.close();
                }
                catch (Exception re) {}
            }
        }
        return geom;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String validateGeometry(Connection conn, JGeometry geom, double tolerance) {
        if (conn == null || geom == null) {
            return null;
        }
        Statement st = null;
        ResultSet rs = null;
        try {
            String query = "SELECT SDO_GEOM.VALIDATE_GEOMETRY_WITH_CONTEXT(?,?) from dual";
            StructDescriptor geomDesc = StructDescriptor.createDescriptor((String)"MDSYS.SDO_GEOMETRY", (Connection)conn);
            StructDescriptor pointDesc = StructDescriptor.createDescriptor((String)"MDSYS.SDO_POINT_TYPE", (Connection)conn);
            ArrayDescriptor elemInfoDesc = ArrayDescriptor.createDescriptor((String)"MDSYS.SDO_ELEM_INFO_ARRAY", (Connection)conn);
            ArrayDescriptor ordinatesDesc = ArrayDescriptor.createDescriptor((String)"MDSYS.SDO_ORDINATE_ARRAY", (Connection)conn);
            Object[] descs = new Object[]{geomDesc, pointDesc, elemInfoDesc, ordinatesDesc};
            STRUCT sgeom1 = null;
            sgeom1 = JGeometry.store((JGeometry)geom, (Connection)conn, (Object[])descs);
            st = conn.prepareStatement(query);
            st.setObject(1, sgeom1);
            st.setDouble(2, tolerance);
            rs = st.executeQuery();
            if (rs.next()) {
                String string = rs.getString(1);
                return string;
            }
        }
        catch (Exception ex) {
            log.warning("Exception while executing validateGeometry.\n" + ex.getMessage());
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (Exception re) {}
            }
            if (st != null) {
                try {
                    st.close();
                }
                catch (Exception re) {}
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JGeometry rectifyGeometry(Connection conn, JGeometry geom, double tolerance) {
        if (conn == null || geom == null) {
            return null;
        }
        Statement st = null;
        ResultSet rs = null;
        JGeometry outgeom = null;
        try {
            String query = "SELECT SDO_UTIL.RECTIFY_GEOMETRY(?,?) from dual";
            StructDescriptor geomDesc = StructDescriptor.createDescriptor((String)"MDSYS.SDO_GEOMETRY", (Connection)conn);
            StructDescriptor pointDesc = StructDescriptor.createDescriptor((String)"MDSYS.SDO_POINT_TYPE", (Connection)conn);
            ArrayDescriptor elemInfoDesc = ArrayDescriptor.createDescriptor((String)"MDSYS.SDO_ELEM_INFO_ARRAY", (Connection)conn);
            ArrayDescriptor ordinatesDesc = ArrayDescriptor.createDescriptor((String)"MDSYS.SDO_ORDINATE_ARRAY", (Connection)conn);
            Object[] descs = new Object[]{geomDesc, pointDesc, elemInfoDesc, ordinatesDesc};
            STRUCT sgeom1 = null;
            sgeom1 = JGeometry.store((JGeometry)geom, (Connection)conn, (Object[])descs);
            st = conn.prepareStatement(query);
            st.setObject(1, sgeom1);
            st.setDouble(2, tolerance);
            rs = st.executeQuery();
            if (rs.next()) {
                STRUCT strc = (STRUCT)rs.getObject(1);
                outgeom = JGeometry.load((STRUCT)strc);
            }
        }
        catch (Exception ex) {
            log.warning("Exception while executing rectifyGeometry.\n" + ex.getMessage());
            outgeom = null;
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (Exception re) {}
            }
            if (st != null) {
                try {
                    st.close();
                }
                catch (Exception re) {}
            }
        }
        return outgeom;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JGeometry removeDuplicateVertices(Connection conn, JGeometry geom, double tolerance) {
        if (conn == null || geom == null) {
            return null;
        }
        Statement st = null;
        ResultSet rs = null;
        JGeometry outgeom = null;
        try {
            String query = "SELECT SDO_UTIL.REMOVE_DUPLICATE_VERTICES(?,?) from dual";
            StructDescriptor geomDesc = StructDescriptor.createDescriptor((String)"MDSYS.SDO_GEOMETRY", (Connection)conn);
            StructDescriptor pointDesc = StructDescriptor.createDescriptor((String)"MDSYS.SDO_POINT_TYPE", (Connection)conn);
            ArrayDescriptor elemInfoDesc = ArrayDescriptor.createDescriptor((String)"MDSYS.SDO_ELEM_INFO_ARRAY", (Connection)conn);
            ArrayDescriptor ordinatesDesc = ArrayDescriptor.createDescriptor((String)"MDSYS.SDO_ORDINATE_ARRAY", (Connection)conn);
            Object[] descs = new Object[]{geomDesc, pointDesc, elemInfoDesc, ordinatesDesc};
            STRUCT sgeom1 = null;
            sgeom1 = JGeometry.store((JGeometry)geom, (Connection)conn, (Object[])descs);
            st = conn.prepareStatement(query);
            st.setObject(1, sgeom1);
            st.setDouble(2, tolerance);
            rs = st.executeQuery();
            if (rs.next()) {
                STRUCT strc = (STRUCT)rs.getObject(1);
                outgeom = JGeometry.load((STRUCT)strc);
            }
        }
        catch (Exception ex) {
            log.warning("Exception while executing removeDuplicateVertices.\n" + ex.getMessage());
            outgeom = null;
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (Exception re) {}
            }
            if (st != null) {
                try {
                    st.close();
                }
                catch (Exception re) {}
            }
        }
        return outgeom;
    }

    public static JGeometry union(Connection conn, JGeometry srcGeom, JGeometry[] otherGeoms, double tolerance) {
        if (srcGeom == null) {
            return null;
        }
        JGeometry clone = (JGeometry)srcGeom.clone();
        if (otherGeoms == null || otherGeoms.length == 0) {
            return srcGeom;
        }
        for (int j = 0; j < otherGeoms.length; ++j) {
            JGeometry geom = otherGeoms[j];
            if ((clone = ORADBGeometryOperations.union(conn, clone, geom, tolerance)) != null) continue;
            return null;
        }
        return clone;
    }

    public static JGeometry difference(Connection conn, JGeometry srcGeom, JGeometry[] otherGeoms, double tolerance) {
        if (srcGeom == null) {
            return null;
        }
        JGeometry clone = (JGeometry)srcGeom.clone();
        if (otherGeoms == null || otherGeoms.length == 0) {
            return srcGeom;
        }
        for (int j = 0; j < otherGeoms.length; ++j) {
            JGeometry geom = otherGeoms[j];
            if ((clone = ORADBGeometryOperations.difference(conn, clone, geom, tolerance)) != null) continue;
            return null;
        }
        return clone;
    }

    public static JGeometry intersection(Connection conn, JGeometry srcGeom, JGeometry[] otherGeoms, double tolerance) {
        if (srcGeom == null) {
            return null;
        }
        if (otherGeoms == null || otherGeoms.length == 0) {
            return null;
        }
        JGeometry clone = (JGeometry)srcGeom.clone();
        Vector<JGeometry> intersectGeoms = new Vector<JGeometry>();
        for (int j = 0; j < otherGeoms.length; ++j) {
            JGeometry it = ORADBGeometryOperations.intersection(conn, clone, otherGeoms[j], tolerance);
            if (it == null) continue;
            intersectGeoms.add(it);
        }
        if (intersectGeoms.size() == 0) {
            return null;
        }
        clone = (JGeometry)intersectGeoms.get(0);
        for (int i = 1; i < intersectGeoms.size(); ++i) {
            clone = ORADBGeometryOperations.union(conn, clone, (JGeometry)intersectGeoms.get(i), tolerance);
        }
        return clone;
    }
}

