/*
 * Decompiled with CFR 0.152.
 */
package oracle.sdovis.util;

import java.util.Vector;
import oracle.sdovis.util.ComparisonOperator;

public class LogicalOperator {
    public static String And_OP = "And";
    public static String Or_OP = "Or";
    public static String Not_OP = "Not";
    private String operator = null;
    private Vector elements = new Vector();

    public LogicalOperator() {
    }

    public LogicalOperator(String op) {
        this.setLogicalOperator(op);
    }

    public void setLogicalOperator(String op) {
        if (!(op == null || op.equalsIgnoreCase(And_OP) || op.equalsIgnoreCase(Or_OP) || op.equalsIgnoreCase(Not_OP))) {
            return;
        }
        this.operator = op;
    }

    public void addElement(Object obj) {
        if (obj == null) {
            return;
        }
        if (!(obj instanceof LogicalOperator) && !(obj instanceof ComparisonOperator)) {
            return;
        }
        this.elements.add(obj);
    }

    public String getLogicalOperator() {
        return this.operator;
    }

    public int getNumberOfElements() {
        return this.elements.size();
    }

    public Vector getElements() {
        return this.elements;
    }

    public String getAsWFSxml(int blankSpaces, String featName, String nameSpace) {
        if (featName == null || nameSpace == null) {
            return "";
        }
        if (this.operator == null || this.elements.size() == 0) {
            return "";
        }
        String tabs = "";
        for (int i = 0; i < blankSpaces; ++i) {
            tabs = tabs + " ";
        }
        String op = null;
        if (this.operator.equalsIgnoreCase(And_OP)) {
            op = "And";
        } else if (this.operator.equalsIgnoreCase(Or_OP)) {
            op = "Or";
        } else if (this.operator.equalsIgnoreCase(Not_OP)) {
            op = "Not";
        } else {
            return "";
        }
        String xml = tabs + "<ogc:" + op + ">\n";
        for (int i = 0; i < this.elements.size(); ++i) {
            Object obj = this.elements.get(i);
            if (obj instanceof LogicalOperator) {
                LogicalOperator lop = (LogicalOperator)obj;
                xml = xml + lop.getAsWFSxml(blankSpaces + 2, featName, nameSpace);
                continue;
            }
            if (!(obj instanceof ComparisonOperator)) continue;
            ComparisonOperator cop = (ComparisonOperator)obj;
            xml = xml + cop.getAsWFSxml(blankSpaces + 2, featName, nameSpace);
        }
        xml = xml + tabs + "</ogc:" + op + ">\n";
        return xml;
    }

    public String getAsWFSstring() {
        if (this.operator == null || this.elements.size() == 0) {
            return "";
        }
        String op = null;
        if (this.operator.equalsIgnoreCase(And_OP)) {
            op = "And";
        } else if (this.operator.equalsIgnoreCase(Or_OP)) {
            op = "Or";
        } else if (this.operator.equalsIgnoreCase(Not_OP)) {
            op = "Not";
        } else {
            return "";
        }
        String xml = "<" + op + ">";
        for (int i = 0; i < this.elements.size(); ++i) {
            Object obj = this.elements.get(i);
            if (obj instanceof LogicalOperator) {
                LogicalOperator lop = (LogicalOperator)obj;
                xml = xml + lop.getAsWFSstring();
                continue;
            }
            if (!(obj instanceof ComparisonOperator)) continue;
            ComparisonOperator cop = (ComparisonOperator)obj;
            xml = xml + cop.getAsWFSstring();
        }
        xml = xml + "</" + op + ">";
        return xml;
    }
}

