/*
 * Decompiled with CFR 0.152.
 */
package oracle.sdovis.theme;

import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dms.instrument.PhaseEvent;
import oracle.mapviewer.share.GeoRasterBitmapMask;
import oracle.mapviewer.share.util.LogFactory;
import oracle.mapviewer.share.util.SensorCreator;
import oracle.mapviewer.share.util.SharedUtils;
import oracle.sdovis.DataException;
import oracle.sdovis.JSDOGeometry;
import oracle.sdovis.LocalTheme;
import oracle.sdovis.MapMaker;
import oracle.sdovis.RSBundle;
import oracle.sdovis.SRS;
import oracle.sdovis.SRSCache;
import oracle.sdovis.StyledFeatureI;
import oracle.sdovis.Theme;
import oracle.sdovis.VisContext;
import oracle.sdovis.ds.DSManager;
import oracle.sdovis.ds.DSUtil;
import oracle.sdovis.theme.GeoRasterThemeDefinition;
import oracle.sdovis.theme.ThemeDataProducer;
import oracle.sdovis.util.JDBCUtil;
import oracle.sdovis.util.TopThemeQueries;
import oracle.sdovis.util.Util;
import oracle.spatial.geometry.JGeometry;
import oracle.spatial.georaster.JGeoRaster;
import oracle.spatial.georaster.LayerInfo;
import oracle.spatial.georaster.SubLayerInfo;
import oracle.spatial.georaster.image.GeoRasterImageProcessUtil;
import oracle.sql.NUMBER;
import oracle.sql.STRUCT;

public class GeoRasterThemeProducer
implements ThemeDataProducer {
    private static Logger log = LogFactory.getLogger(LogFactory.LoggerEnum.SDOVIS);
    private static final PhaseEvent geoRasterSensor = SensorCreator.createPhaseEvent(SensorCreator.NounsEnum.THEMEPRODUCER, "GeoRaster", "Producer", "Time spent preparing data");
    protected Theme owner;
    protected GeoRasterThemeDefinition def;
    double[][] mbrs = null;
    Vector<String> imgModelLocations = new Vector();
    HashMap renderImages = new HashMap();
    private Hashtable<String, Double> imgRotations = new Hashtable();
    private Hashtable<String, Point2D> imgRotRefPoint = new Hashtable();
    private Hashtable<String, Boolean> imgRotFlip = new Hashtable();
    private Hashtable<String, JSDOGeometry> imgRotMask = new Hashtable();
    private Hashtable<String, Integer> imgTransf = new Hashtable();
    private Hashtable<String, JSDOGeometry> imgReprojMask = new Hashtable();
    private JSDOGeometry themePolyMask = null;
    private Hashtable<String, Vector<JSDOGeometry>> themePolygonMasks = new Hashtable();
    private Vector<String> georasterIds = new Vector();
    private Object[] bindingParameters = null;
    private String[] overoperationNames = null;
    private Hashtable overoperationParameters = null;
    private Hashtable overbitmapMasks = null;
    private double screenResolution = 0.0;
    private boolean preparedWithReprojection = false;
    private long maxFeaturesToBePrepared = -1L;
    private double[] queryMBR = new double[]{Double.NaN, Double.NaN, Double.NaN, Double.NaN};
    private double[] queryMBR2 = new double[]{Double.NaN, Double.NaN, Double.NaN, Double.NaN};
    private boolean hasQueryWin2 = false;

    public GeoRasterThemeProducer() {
    }

    public GeoRasterThemeProducer(Theme t) {
        this.owner = t;
        this.def = (GeoRasterThemeDefinition)t.getDefinition();
    }

    public GeoRasterThemeProducer(Theme t, Object[] bindingVars) {
        this.owner = t;
        this.def = (GeoRasterThemeDefinition)t.getDefinition();
        this.bindingParameters = bindingVars;
    }

    public boolean hasQueryWindow2() {
        return this.hasQueryWin2;
    }

    @Override
    public Theme getTheme() {
        return this.owner;
    }

    public void setBindingParameters(Object[] params) {
        this.bindingParameters = params;
    }

    public Object[] getBindingParameters() {
        return this.bindingParameters;
    }

    @Override
    public int size() {
        return this.mbrs == null ? 0 : this.mbrs.length;
    }

    @Override
    public void setStyledFeatures(StyledFeatureI[] sfs) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int prepareData(Rectangle2D queryWin, VisContext vc) throws DataException {
        long tokenG = 0L;
        try {
            tokenG = geoRasterSensor.start();
            this.preparedWithReprojection = false;
            this.destroy();
            if (this.def.getImageQuery() == null && this.def.getRasterId() == null) {
                log.warning("Unable to prepare data. GeoRaster query or raster id must be defined.");
                int n = 0;
                return n;
            }
            if (this.def.getSrid() == 0) {
                log.warning("GeoRaster SRID can not be 0.");
                int n = 0;
                return n;
            }
            double xl = queryWin.getMinX();
            double yl = queryWin.getMinY();
            double xh = queryWin.getMaxX();
            double yh = queryWin.getMaxY();
            boolean fullExtent = false;
            if (xl == Double.NEGATIVE_INFINITY || yl == Double.NEGATIVE_INFINITY || xh == Double.POSITIVE_INFINITY || yh == Double.POSITIVE_INFINITY) {
                fullExtent = true;
            }
            Connection conn = null;
            try {
                conn = DSUtil.getDBConnection(this.def.getDataSourceName(), vc);
            }
            catch (Exception e) {
                log.warning(e.getMessage());
                throw new DataException("cannot obtain a connection to database.");
            }
            if (this.getTheme().getDecorator().getWorkspaceName() != null) {
                try {
                    if (this.getTheme().getDecorator().getWorkspaceName() != null) {
                        if (this.getTheme().getDecorator().getWorkspaceDate() != null) {
                            Util.gotoWorkspaceDate(conn, this.getTheme().getDecorator().getWorkspaceName(), this.getTheme().getDecorator().getWorkspaceDate(), this.getTheme().getDecorator().getWorkspaceDateFormat(), this.getTheme().getDecorator().getWorkspaceDateNlsParam(), this.getTheme().getDecorator().isWorkspaceDateTsWtz());
                        } else if (this.getTheme().getDecorator().getWorkspaceSavedPoint() != null) {
                            Util.gotoWorkspaceSavedPoint(conn, this.getTheme().getDecorator().getWorkspaceName(), this.getTheme().getDecorator().getWorkspaceSavedPoint());
                        } else {
                            Util.gotoWorkspace(conn, this.getTheme().getDecorator().getWorkspaceName());
                        }
                    }
                }
                catch (Exception e) {
                    String err = "Cannot go to workspace " + this.getTheme().getDecorator().getWorkspaceName();
                    if (this.getTheme().getDecorator().getWorkspaceDate() != null) {
                        err = err + ", Date " + this.getTheme().getDecorator().getWorkspaceDate();
                    } else if (this.getTheme().getDecorator().getWorkspaceSavedPoint() != null) {
                        err = err + ", Saved Point " + this.getTheme().getDecorator().getWorkspaceSavedPoint();
                    }
                    log.log(Level.SEVERE, err, e);
                    throw new DataException(err);
                }
            }
            SRSCache sc = DSManager.getSRSCache(this.def.getDataSourceName());
            SRS srs = sc.get(this.def.getSrid());
            boolean isGeodetic = false;
            String unit = null;
            if (srs != null) {
                isGeodetic = srs.isGeodetic();
                unit = srs.getUnit();
            } else if (this.def.getSrid() > 0) {
                log.warning("cannot locate an SRS object for srid: " + this.def.getSrid());
            }
            double xi = xl;
            double xf = xh;
            double yi = yl;
            double yf = yh;
            boolean csTransform = false;
            double masterScale = vc.getCurrentScale();
            double[] qmbr = new double[]{Double.NaN, Double.NaN, Double.NaN, Double.NaN};
            double[] qmbr2 = new double[]{Double.NaN, Double.NaN, Double.NaN, Double.NaN};
            double[] inmbr = new double[]{xl, yl, xh, yh};
            double[] inmbrValid = new double[]{Double.NaN, Double.NaN, Double.NaN, Double.NaN};
            double[] inmbrValid2 = new double[]{Double.NaN, Double.NaN, Double.NaN, Double.NaN};
            this.hasQueryWin2 = SRS.splitQueryMBR(inmbr, inmbrValid, inmbrValid2, vc.getMasterSRID());
            log.finest("Original query window is adjusted to: (" + inmbrValid[0] + "," + inmbrValid[1] + " " + inmbrValid[2] + "," + inmbrValid[3] + ")");
            this.setRequestMBR(inmbrValid);
            if (this.hasQueryWin2) {
                this.setRequestMBR2(inmbrValid2);
                log.finest("Query box2 is st to: (" + inmbrValid2[0] + "," + inmbrValid2[1] + " " + inmbrValid2[2] + "," + inmbrValid2[3] + ")");
            }
            if (vc.getMasterSRID() > 0 && this.def.getSrid() > 0 && this.def.getSrid() != vc.getMasterSRID() && this.def.getSrid() != 999999 && this.def.getSrid() != 262148) {
                if (masterScale != Double.POSITIVE_INFINITY && masterScale != Double.NEGATIVE_INFINITY) {
                    if (!this.transformQueryMBRFromMasterToNative(inmbrValid, inmbrValid2, qmbr, qmbr2, conn, vc, this.hasQueryWin2)) {
                        if (this.getTheme().getDecorator().getWorkspaceName() != null) {
                            try {
                                Util.gotoWorkspace(conn, "LIVE");
                            }
                            catch (Exception ex) {
                                log.warning(ex.getMessage());
                            }
                        }
                        try {
                            if (conn != null) {
                                DSUtil.closeDBConnection(conn, this.def.getDataSourceName());
                            }
                        }
                        catch (Exception e) {
                            log.warning(e.getMessage());
                        }
                        vc.processDataError(null, log, RSBundle.getMsg("MAPVIEWER-01024"));
                        int e = 0;
                        return e;
                    }
                    csTransform = true;
                }
            } else {
                for (int k = 0; k < 4; ++k) {
                    qmbr[k] = inmbrValid[k];
                    qmbr2[k] = inmbrValid2[k];
                }
            }
            long t0 = System.currentTimeMillis();
            Vector mbrs_ = new Vector(3);
            int startRows = 0;
            int endRows = 0;
            try {
                endRows = this.doPrepareData(qmbr, inmbrValid, vc, masterScale, fullExtent, isGeodetic, mbrs_, conn, startRows);
                if (this.hasQueryWin2) {
                    endRows = this.doPrepareData(qmbr2, inmbrValid2, vc, masterScale, fullExtent, isGeodetic, mbrs_, conn, endRows);
                }
            }
            finally {
                if (conn != null) {
                    try {
                        DSUtil.closeDBConnection(conn, this.def.getDataSourceName());
                    }
                    catch (Exception ex) {
                        log.warning(ex.getMessage());
                    }
                }
            }
            this.mbrs = new double[mbrs_.size()][];
            for (int i = 0; i < this.mbrs.length; ++i) {
                this.mbrs[i] = (double[])mbrs_.get(i);
            }
            mbrs_.clear();
            mbrs_ = null;
            int n = this.mbrs.length;
            return n;
        }
        finally {
            geoRasterSensor.stop(tokenG);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int doPrepareData(double[] queryWin, double[] inmbrValid, VisContext vc, double masterScale, boolean fullExtent, boolean isGeodetic, Vector mbrs_, Connection conn, int startRow) throws DataException {
        double xl = queryWin[0];
        double yl = queryWin[1];
        double xh = queryWin[2];
        double yh = queryWin[3];
        double xi = inmbrValid[0];
        double yi = inmbrValid[1];
        double xf = inmbrValid[2];
        double yf = inmbrValid[3];
        this.themePolyMask = this.def.getPolygonMask();
        JSDOGeometry pmask = this.def.getPolygonMask();
        int pmaskSRID = 0;
        if (pmask != null) {
            pmaskSRID = pmask.getSRID();
            if (pmask != null && vc.getMasterSRID() > 0 && pmaskSRID > 0 && pmaskSRID != vc.getMasterSRID() && pmaskSRID != 999999 && pmaskSRID != 262148) {
                String srid = "NULL";
                if (pmaskSRID != 0) {
                    srid = String.valueOf(pmaskSRID);
                }
                String geomstr = "MDSYS.SDO_GEOMETRY(2003, " + srid + ", NULL, " + "MDSYS.SDO_ELEM_INFO_ARRAY(1, 1003, 1), " + "MDSYS.SDO_ORDINATE_ARRAY(";
                double[] ordinates = this.def.getPolygonMask().getOrdinatesArray();
                for (int k = 0; k < ordinates.length; ++k) {
                    geomstr = k > 0 ? geomstr + "," + ordinates[k] : geomstr + ordinates[k];
                }
                geomstr = geomstr + "))";
                String transfSRid = "select sdo_cs.transform(" + geomstr + "," + vc.getMasterSRID() + ") from dual";
                PreparedStatement stmt = null;
                ResultSet rs = null;
                try {
                    stmt = conn.prepareStatement(transfSRid);
                    rs = stmt.executeQuery();
                    if (rs.next()) {
                        JSDOGeometry geom;
                        this.themePolyMask = geom = JDBCUtil.loadGeometry(rs, 1, false);
                    }
                    log.warning("No conversion record returned. Mask will be ignored.");
                }
                catch (Exception e) {
                    log.warning(e.getMessage());
                    log.warning("Conversion of polygon mask was not successfull. Mask will be ignored.");
                    this.themePolyMask = null;
                }
                finally {
                    try {
                        if (rs != null) {
                            rs.close();
                        }
                    }
                    catch (Exception ex) {
                        log.warning(ex.getMessage());
                    }
                    try {
                        if (stmt != null) {
                            stmt.close();
                        }
                    }
                    catch (Exception ex) {
                        log.warning(ex.getMessage());
                    }
                }
            }
        } else if (this.def.getPolygonMaskTable() != null && this.def.getPolygonMaskGeometryColumn() != null) {
            this.processPolygonMasks(conn, xl, yl, xh, yh, vc.getMasterSRID());
        }
        String[] bands = null;
        int totbands = 0;
        int defaultRed = 0;
        int defaultGreen = 1;
        int defaultBlue = 2;
        if (this.def.mBands != null) {
            ArrayList al = Util.splitBy(this.def.mBands, ",");
            bands = al.toArray(new String[al.size()]);
            try {
                totbands = bands.length;
                if (bands.length == 1) {
                    defaultGreen = defaultRed = Integer.parseInt(bands[0]);
                    defaultBlue = defaultRed;
                } else {
                    block133: for (int j = 0; j < bands.length; ++j) {
                        switch (j) {
                            case 0: {
                                defaultRed = Integer.parseInt(bands[j]);
                                continue block133;
                            }
                            case 1: {
                                defaultGreen = Integer.parseInt(bands[j]);
                                continue block133;
                            }
                            case 2: {
                                defaultBlue = Integer.parseInt(bands[j]);
                                continue block133;
                            }
                        }
                    }
                }
            }
            catch (Exception ex) {
                log.warning(ex.getMessage());
                log.warning("Invalid band number. " + ex.getMessage());
                if (this.getTheme().getDecorator().getWorkspaceName() != null) {
                    try {
                        Util.gotoWorkspace(conn, "LIVE");
                    }
                    catch (Exception e) {
                        log.warning(e.getMessage());
                    }
                }
                if (conn != null) {
                    try {
                        DSUtil.closeDBConnection(conn, this.def.getDataSourceName());
                    }
                    catch (Exception e) {
                        log.warning(e.getMessage());
                    }
                }
                return 0;
            }
            log.finest("Bands: Red - " + defaultRed + " Green - " + defaultGreen + " Blue - " + defaultBlue);
        }
        log.finer("Original query window: " + xl + "," + yl + "," + xh + "," + yh);
        boolean applyRotation = false;
        if (!this.def.passThrough) {
            if (MapMaker.isSpecial(xl, yl, xh, yh) && vc.getRotation() != 0.0) {
                log.warning("Rotation is currently ignored for full extent.");
            } else if (vc.getRotation() != 0.0 && !MapMaker.isSpecial(xl, yl, xh, yh)) {
                if (vc.getRotation() < -360.0 && vc.getRotation() > 360.0) {
                    log.warning("Rotation value must be in between -360 to 360 degrees. ignored");
                } else {
                    double[] rmbr = Util.rotateMBR(xl, yl, xh, yh, vc.getRotation());
                    if (rmbr != null) {
                        xl = Math.min(rmbr[0], xl);
                        yl = Math.min(rmbr[1], yl);
                        xh = Math.max(rmbr[2], xh);
                        yh = Math.max(rmbr[3], yh);
                        log.finest("Rotation angle: " + vc.getRotation());
                        log.finest("Search window for rotation: " + xl + "," + yl + "," + xh + "," + yh);
                        applyRotation = true;
                    } else {
                        log.info("Rotated MBR is null. Rotation ignored.");
                    }
                }
            }
        }
        String geoquery = this.def.getImageQuery();
        if (this.def.getRasterId() == null) {
            geoquery = this.def.predefined ? this.getPredefinedQuery(xl, yl, xh, yh, isGeodetic) : this.rewriteQuery(xl, yl, xh, yh, isGeodetic);
        }
        if (geoquery == null) {
            if (this.getTheme().getDecorator().getWorkspaceName() != null) {
                try {
                    Util.gotoWorkspace(conn, "LIVE");
                }
                catch (Exception ex) {
                    // empty catch block
                }
            }
            if (conn != null) {
                try {
                    DSUtil.closeDBConnection(conn, this.def.getDataSourceName());
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            vc.processDataError(null, log, "PrepareData - Invalid query: null.");
            return 0;
        }
        log.finer("[Query] " + geoquery);
        PreparedStatement getGeor = null;
        ResultSet rset = null;
        int row = startRow;
        long t0 = 0L;
        long t1 = 0L;
        try {
            String dbVersion = Util.getDBVersion(conn);
            getGeor = conn.prepareStatement(geoquery);
            int offset = 0;
            if (this.def.getRasterId() == null) {
                if (!this.isFullExtent(this.def.passThrough, xl, yl, xh, yh)) {
                    offset = 4;
                    getGeor.setDouble(1, xl);
                    getGeor.setDouble(2, yl);
                    getGeor.setDouble(3, xh);
                    getGeor.setDouble(4, yh);
                }
            } else {
                String rid = this.def.getRasterId();
                String rdtable = this.def.getRasterTable();
                getGeor.setDouble(1, Double.parseDouble(rid));
                if (rdtable != null) {
                    getGeor.setString(2, rdtable.toUpperCase());
                }
            }
            if (this.def.predefined && this.bindingParameters != null && this.bindingParameters != null) {
                int countBP = SharedUtils.countBindingVariables(geoquery);
                if (countBP > 0 && this.bindingParameters.length < countBP) {
                    if (conn != null) {
                        try {
                            DSUtil.closeDBConnection(conn, this.def.getDataSourceName());
                        }
                        catch (Exception e) {
                            log.warning(e.getMessage());
                        }
                    }
                    vc.processDataError(null, log, RSBundle.getMsg("MAPVIEWER-01031"));
                    int e = 0;
                    return e;
                }
                if (countBP > 0) {
                    for (int i = 0; i < countBP; ++i) {
                        this.setBindingVariable(getGeor, this.bindingParameters[i], offset + i + 1);
                    }
                }
            }
            getGeor.setFetchSize(this.owner.getFetchSize());
            log.finer("Fetch size: " + getGeor.getFetchSize());
            t0 = System.currentTimeMillis();
            rset = getGeor.executeQuery();
            t1 = System.currentTimeMillis();
            log.finer("Query executed");
            int lastDataSRID = 0;
            xl = xi;
            yl = yi;
            xh = xf;
            yh = yf;
            boolean firstRecord = true;
            log.finest("Max features to be prepared: " + this.maxFeaturesToBePrepared);
            while (rset.next()) {
                LayerInfo linfo;
                double[] rmbr;
                if (this.maxFeaturesToBePrepared > 0L && (long)mbrs_.size() >= this.maxFeaturesToBePrepared) {
                    break;
                }
                String georasterId = null;
                STRUCT geor = JDBCUtil.getOracleSTRUCT(rset, 1);
                JGeoRaster geoRaster = null;
                try {
                    geoRaster = new JGeoRaster(geor);
                }
                catch (Exception ex) {
                    vc.processDataError(null, log, ex.getMessage());
                    int n = 0;
                    if (this.getTheme().getDecorator().getWorkspaceName() != null) {
                        try {
                            Util.gotoWorkspace(conn, "LIVE");
                        }
                        catch (Exception ex2) {
                            log.warning(ex2.getMessage());
                        }
                    }
                    if (rset != null) {
                        try {
                            rset.close();
                        }
                        catch (Exception re) {
                            log.warning(re.getMessage());
                        }
                    }
                    if (getGeor != null) {
                        try {
                            getGeor.close();
                        }
                        catch (Exception re) {
                            log.warning(re.getMessage());
                        }
                    }
                    return n;
                }
                if (geoRaster == null) continue;
                if (this.themePolygonMasks.size() > 0 && this.def.getPolygonMaskGeoRasterJoinColumn() != null) {
                    georasterId = rset.getString(this.def.getPolygonMaskGeoRasterJoinColumn());
                    this.georasterIds.add(georasterId);
                }
                long numBands = 1L;
                if (geoRaster.getMetadataObject().getRasterInfo().getDimensionSize(2) != null) {
                    numBands = geoRaster.getMetadataObject().getRasterInfo().getDimensionSize(2);
                }
                NUMBER ridN = geoRaster.getRasterID();
                double rasterId = ridN.doubleValue();
                String rasterTable = geoRaster.getRasterDataTable();
                int dataSRID = geoRaster.getMetadataObject().getSpatialReferenceInfo().getModelSRID();
                log.finest("Data SRID: " + dataSRID);
                if (firstRecord && !this.isDataWithinScale(conn, vc, masterScale, fullExtent, dataSRID, xi, yi, xf, yf)) {
                    int n = 0;
                    return n;
                }
                long offx = 0L;
                if (geoRaster.getMetadataObject().getRasterInfo().getULTCoordinate(1) != null) {
                    offx = geoRaster.getMetadataObject().getRasterInfo().getULTCoordinate(1);
                }
                long offy = 0L;
                if (geoRaster.getMetadataObject().getRasterInfo().getULTCoordinate(0) != null) {
                    offy = geoRaster.getMetadataObject().getRasterInfo().getULTCoordinate(0);
                }
                log.finer("ULT offset: [row] " + offy + ", [column] " + offx);
                String modelLocation = geoRaster.getMetadataObject().getSpatialReferenceInfo().getModelCoordinateLocation();
                log.finest("Model Location: " + modelLocation);
                if (geoRaster.getSpatialExtent() == null) {
                    vc.processDataError(null, log, RSBundle.getMsg("MAPVIEWER-01032") + " [id=" + rasterId + "]");
                    int n = 0;
                    return n;
                }
                double[] spatialExtent = geoRaster.getSpatialExtent().getMBR();
                if (spatialExtent == null) {
                    vc.processDataError(null, log, RSBundle.getMsg("MAPVIEWER-01032") + " [id=" + rasterId + "]");
                    int re = 0;
                    return re;
                }
                double[] ulModel = geoRaster.getMetadataObject().getSpatialReferenceInfo().getModelCoordinate(0.0, 0.0, 0L);
                if (ulModel == null) {
                    vc.processDataError(null, log, "GeoRaster data extent for raster Id " + rasterId + " is null.");
                    int re = 0;
                    return re;
                }
                log.finest("Upper Left Model Coordinate (without ULT offset): " + ulModel[0] + " , " + ulModel[1]);
                double[] ulModel01 = geoRaster.getMetadataObject().getSpatialReferenceInfo().getModelCoordinate(0.0, 1.0, 0L);
                double[] ulModel10 = geoRaster.getMetadataObject().getSpatialReferenceInfo().getModelCoordinate(1.0, 0.0, 0L);
                double[] spatialResolution = new double[2];
                double d1 = ulModel01[0] - ulModel[0];
                double d2 = ulModel01[1] - ulModel[1];
                spatialResolution[0] = Math.sqrt(d1 * d1 + d2 * d2);
                d1 = ulModel10[0] - ulModel[0];
                d2 = ulModel10[1] - ulModel[1];
                spatialResolution[1] = Math.sqrt(d1 * d1 + d2 * d2);
                if (spatialResolution == null) {
                    vc.processDataError(null, log, "GeoRaster spatial resolution for raster Id " + rasterId + " is null.");
                    int n = 0;
                    return n;
                }
                log.finer("Original spatial resolution: " + spatialResolution[0] + "," + spatialResolution[1]);
                ulModel[0] = ulModel[0] + (double)offx * spatialResolution[0];
                ulModel[1] = ulModel[1] - (double)offy * spatialResolution[1];
                log.finest("Upper Left Model Coordinate: " + ulModel[0] + " , " + ulModel[1]);
                long ncols = geoRaster.getMetadataObject().getRasterInfo().getDimensionSize(1);
                long nrows = geoRaster.getMetadataObject().getRasterInfo().getDimensionSize(0);
                boolean useReprojection = false;
                if (vc.getMasterSRID() > 0 && dataSRID > 0 && dataSRID != vc.getMasterSRID() && dataSRID != 999999 && dataSRID != 262148 && this.def.getSrid() != 999999 && this.def.getSrid() != 262148) {
                    log.finest("DB version: " + dbVersion);
                    useReprojection = true;
                    log.info("Raster data will be reprojected");
                    if (masterScale != Double.POSITIVE_INFINITY && masterScale != Double.NEGATIVE_INFINITY && lastDataSRID != dataSRID) {
                        double[] inmbr = new double[]{xi, yi, xf, yf};
                        double[] outmbr = Util.convertMBR(inmbr, vc.getMasterSRID(), dataSRID, conn);
                        lastDataSRID = dataSRID;
                        if (outmbr != null) {
                            xl = outmbr[0];
                            yl = outmbr[1];
                            xh = outmbr[2];
                            yh = outmbr[3];
                        } else {
                            log.finest("Unable to convert query window to data SRID " + dataSRID + ". Conversion ignored");
                            xl = xi;
                            yl = yi;
                            xh = xf;
                            yh = yf;
                        }
                    }
                } else {
                    xl = xi;
                    yl = yi;
                    xh = xf;
                    yh = yf;
                }
                if (applyRotation && (rmbr = Util.rotateMBR(xl, yl, xh, yh, vc.getRotation())) != null) {
                    xl = Math.min(rmbr[0], xl);
                    yl = Math.min(rmbr[1], yl);
                    xh = Math.max(rmbr[2], xh);
                    yh = Math.max(rmbr[3], yh);
                }
                if (fullExtent && this.def.getOriginalPyramidLevel() == null) {
                    this.screenResolution = (double)nrows * spatialResolution[1] / vc.getDeviceWindow().getHeight();
                }
                if (this.screenResolution > 0.0 && (this.screenResolution * vc.getDeviceWindow().getHeight() <= spatialResolution[1] || this.screenResolution * vc.getDeviceWindow().getWidth() <= spatialResolution[0])) {
                    log.warning("Map scale is too detailed for GeoRaster [" + rasterId + "] spatial resolution. Rendered is discarded.");
                    continue;
                }
                long pyramidLevel = this.computePyramidLevel(geoRaster, spatialResolution);
                if (pyramidLevel == -1L) {
                    vc.processDataError(null, log, "Unable to compute the best pyramid level.");
                    int n = 0;
                    return n;
                }
                log.finest("Pyramid level to use: " + pyramidLevel + " , GeoRaster: " + rasterId + " , screen resolution: " + this.screenResolution);
                spatialResolution[0] = spatialResolution[0] * Math.pow(2.0, pyramidLevel);
                spatialResolution[1] = spatialResolution[1] * Math.pow(2.0, pyramidLevel);
                if (spatialResolution == null) {
                    vc.processDataError(null, log, "GeoRaster spatial resolution for raster Id " + rasterId + " is null.");
                    int n = 0;
                    return n;
                }
                log.finer("Spatial resolution to use: " + spatialResolution[0] + "," + spatialResolution[1]);
                long div = (long)Math.pow(2.0, pyramidLevel);
                log.finer("GeoRaster Dimension: width= " + geoRaster.getMetadataObject().getRasterInfo().getDimensionSize(1) + " height= " + geoRaster.getMetadataObject().getRasterInfo().getDimensionSize(0));
                long dimX = geoRaster.getMetadataObject().getRasterInfo().getDimensionSize(1) / div - 1L;
                long dimY = geoRaster.getMetadataObject().getRasterInfo().getDimensionSize(0) / div - 1L;
                log.finer("[DimX] " + dimX + "[DimY] " + dimY);
                long xini = 0L;
                long yini = 0L;
                long xend = dimX;
                long yend = dimY;
                double[] offcell = new double[]{0.0, 0.0};
                if (offx != 0L || offy != 0L) {
                    offcell = geoRaster.getMetadataObject().getSpatialReferenceInfo().getCellCoordinate(ulModel[0], ulModel[1], pyramidLevel);
                    log.finer("[Pyramid level] " + pyramidLevel + " [Offset (row,column)] " + (long)offcell[0] + "," + (long)offcell[1]);
                }
                if (!fullExtent) {
                    long[] cell = this.computeCellCoordinate(geoRaster, pyramidLevel, xl, yl, xh, yh, offcell);
                    yini = cell[0] < 0L ? 0L : cell[0];
                    xini = cell[1] < 0L ? 0L : cell[1];
                    yend = cell[2] > dimY ? dimY : cell[2];
                    xend = cell[3] > dimX ? dimX : cell[3];
                }
                if (xini > dimX || yini > dimY) {
                    log.warning("Query window  is out of GeoRaster area, for raster Id " + rasterId);
                    geoRaster = null;
                    continue;
                }
                if (xend < 0L || yend < 0L) {
                    log.warning("Query window  is out of GeoRaster area, for raster Id " + rasterId);
                    geoRaster = null;
                    continue;
                }
                if (this.def.mBands != null) {
                    geoRaster.getGeoRasterImageObject().setRed(defaultRed + 1);
                    geoRaster.getGeoRasterImageObject().setGreen(defaultGreen + 1);
                    if (totbands != 2) {
                        geoRaster.getGeoRasterImageObject().setBlue(defaultBlue + 1);
                    }
                }
                if (this.def.getAlphaBand() >= 0) {
                    geoRaster.getGeoRasterImageObject().setAlpha(this.def.getAlphaBand() + 1);
                }
                if (this.def.isNODATATransparent() && (linfo = geoRaster.getMetadataObject().getLayerInfo()) != null) {
                    SubLayerInfo slayer;
                    SubLayerInfo objLayer = linfo.getObjectLayer();
                    if (objLayer != null) {
                        this.processNodata(geoRaster, objLayer);
                    }
                    if ((slayer = linfo.getSubLayer((long)(defaultRed + 1))) != null) {
                        this.processNodata(geoRaster, slayer);
                    }
                    if (totbands == 2) {
                        slayer = linfo.getSubLayer((long)(defaultGreen + 1));
                        if (slayer != null) {
                            this.processNodata(geoRaster, slayer);
                        }
                    } else if (totbands == 3) {
                        slayer = linfo.getSubLayer((long)(defaultGreen + 1));
                        if (slayer != null) {
                            this.processNodata(geoRaster, slayer);
                        }
                        if ((slayer = linfo.getSubLayer((long)(defaultBlue + 1))) != null) {
                            this.processNodata(geoRaster, slayer);
                        }
                    }
                }
                double[] bgvalues = null;
                RenderedImage ri = null;
                long[] outWindow = new long[4];
                JGeometry outArea = null;
                try {
                    if (useReprojection) {
                        log.info("Reprojection mode: " + this.def.getReprojectionMode());
                        log.finer("Calling JGeoRaster.getRasterImage.getReprojectedRasterImage - area: " + xini + " , " + yini + " , " + " , " + xend + " , " + yend);
                        ri = geoRaster.getGeoRasterImageObject().getReprojectedRasterImage((int)pyramidLevel, yini, xini, yend, xend, this.def.getReprojectionMode(), vc.getMasterSRID(), outWindow, bgvalues);
                        log.finer("End of JGeoRaster.getRasterImage.getReprojectedRasterImage call.");
                        if (ri == null) {
                            log.warning("JGeoRaster.getRasterImage.getReprojectedRasterImage returned null image. ");
                        } else {
                            outArea = geoRaster.getGeoRasterImageObject().getOutArea();
                        }
                    } else {
                        GeoRasterBitmapMask geormask = null;
                        geormask = this.overbitmapMasks == null ? this.def.getBitmapMask("" + (long)rasterId + ":" + rasterTable) : (GeoRasterBitmapMask)this.overbitmapMasks.get("" + (long)rasterId + ":" + rasterTable);
                        if (geormask == null) {
                            log.finer("Calling JGeoRaster.getRasterImage - area: " + xini + " , " + yini + " , " + " , " + xend + " , " + yend);
                            ri = geoRaster.getGeoRasterImageObject().getRasterImage((int)pyramidLevel, yini, xini, yend, xend, outWindow);
                            if (ri == null) {
                                log.warning("JGeoRaster.getRasterImage returned null image.");
                            }
                            log.finer("End of JGeoRaster.getRasterImage call.");
                        } else {
                            Vector<Integer> layerNo = new Vector<Integer>();
                            int[] imglys = geormask.getLayers();
                            for (int l = 0; l < imglys.length; ++l) {
                                layerNo.add(new Integer(imglys[l]));
                            }
                            log.finer("Calling JGeoRaster.getRasterImageWithMask - area: " + xini + " , " + yini + " , " + " , " + xend + " , " + yend);
                            ri = geoRaster.getGeoRasterImageObject().getRasterImageWithMask((int)pyramidLevel, yini, xini, yend, xend, layerNo, geormask.getZeroMapping(), geormask.getOneMapping(), outWindow);
                            if (ri == null) {
                                log.warning("JGeoRaster.getRasterImageWithMask returned null image.");
                            }
                            log.finer("End of JGeoRaster.getRasterImageWithMask call.");
                        }
                    }
                }
                catch (Exception ex) {
                    vc.processDataError(ex, log, "Exception while getting raster image: ");
                    int n = 0;
                    if (this.getTheme().getDecorator().getWorkspaceName() != null) {
                        try {
                            Util.gotoWorkspace(conn, "LIVE");
                        }
                        catch (Exception ex3) {
                            log.warning(ex3.getMessage());
                        }
                    }
                    if (rset != null) {
                        try {
                            rset.close();
                        }
                        catch (Exception re) {
                            log.warning(re.getMessage());
                        }
                    }
                    if (getGeor != null) {
                        try {
                            getGeor.close();
                        }
                        catch (Exception re) {
                            log.warning(re.getMessage());
                        }
                    }
                    return n;
                }
                if (ri == null) {
                    log.info("Null rendered image for GeoRaster [" + rasterId + "," + rasterTable + "]. Ignored.");
                    geoRaster = null;
                    continue;
                }
                double imgRotation = 0.0;
                Point2D.Double imgrotref = null;
                boolean imgFlipped = false;
                int imgTransform = 0;
                JSDOGeometry imgMask = null;
                JSDOGeometry reprojMask = null;
                double[] mbr_row = new double[4];
                if (dataSRID == 999999 || dataSRID == 0 || this.def.getSrid() == 262148) {
                    mbr_row[0] = ulModel[0] + (double)xini * spatialResolution[0];
                    mbr_row[1] = ulModel[1] - (double)(yend + 1L) * spatialResolution[1];
                    mbr_row[2] = ulModel[0] + (double)(xend + 1L) * spatialResolution[0];
                    mbr_row[3] = ulModel[1] - (double)yini * spatialResolution[1];
                } else {
                    double[] llcell;
                    double[] lrcell;
                    double[] urcell;
                    Vector vrow = geoRaster.getMetadataObject().getSpatialReferenceInfo().getFunctionalFittingModel().getRowNumerator();
                    Vector vcol = geoRaster.getMetadataObject().getSpatialReferenceInfo().getFunctionalFittingModel().getColNumerator();
                    double[] ul = geoRaster.getMetadataObject().getSpatialReferenceInfo().getModelCoordinate((double)yini, (double)xini, pyramidLevel);
                    if (modelLocation == null || modelLocation.equalsIgnoreCase("CENTER")) {
                        ul[0] = ul[0] - spatialResolution[0] / 2.0;
                        ul[1] = ul[1] + spatialResolution[1] / 2.0;
                    }
                    double[] lr = geoRaster.getMetadataObject().getSpatialReferenceInfo().getModelCoordinate((double)(yend + 1L), (double)(xend + 1L), pyramidLevel);
                    if (modelLocation == null || modelLocation.equalsIgnoreCase("CENTER")) {
                        lr[0] = lr[0] - spatialResolution[0] / 2.0;
                        lr[1] = lr[1] + spatialResolution[1] / 2.0;
                    }
                    double Xmin = Math.min(ul[0], lr[0]);
                    double Xmax = Math.max(ul[0], lr[0]);
                    double Ymin = Math.min(ul[1], lr[1]);
                    double Ymax = Math.max(ul[1], lr[1]);
                    double[] ll = geoRaster.getMetadataObject().getSpatialReferenceInfo().getModelCoordinate((double)(yend + 1L), (double)xini, pyramidLevel);
                    if (modelLocation == null || modelLocation.equalsIgnoreCase("CENTER")) {
                        ll[0] = ll[0] - spatialResolution[0] / 2.0;
                        ll[1] = ll[1] + spatialResolution[1] / 2.0;
                    }
                    Xmin = Math.min(Xmin, ll[0]);
                    Xmax = Math.max(Xmax, ll[0]);
                    Ymin = Math.min(Ymin, ll[1]);
                    Ymax = Math.max(Ymax, ll[1]);
                    double[] ur = geoRaster.getMetadataObject().getSpatialReferenceInfo().getModelCoordinate((double)yini, (double)(xend + 1L), pyramidLevel);
                    if (modelLocation == null || modelLocation.equalsIgnoreCase("CENTER")) {
                        ur[0] = ur[0] - spatialResolution[0] / 2.0;
                        ur[1] = ur[1] + spatialResolution[1] / 2.0;
                    }
                    Xmin = Math.min(Xmin, ur[0]);
                    Xmax = Math.max(Xmax, ur[0]);
                    Ymin = Math.min(Ymin, ur[1]);
                    Ymax = Math.max(Ymax, ur[1]);
                    mbr_row[0] = Xmin + (double)offx * spatialResolution[0];
                    mbr_row[1] = Ymin - (double)offy * spatialResolution[1];
                    mbr_row[2] = Xmax + (double)offx * spatialResolution[0];
                    mbr_row[3] = Ymax - (double)offy * spatialResolution[1];
                    double[] ulcell = geoRaster.getMetadataObject().getSpatialReferenceInfo().getCellCoordinate(mbr_row[0], mbr_row[3], pyramidLevel);
                    double[] flipCoords = new double[]{ulcell[1], -1.0 * ulcell[0], (urcell = geoRaster.getMetadataObject().getSpatialReferenceInfo().getCellCoordinate(mbr_row[2], mbr_row[3], pyramidLevel))[1], -1.0 * urcell[0], (lrcell = geoRaster.getMetadataObject().getSpatialReferenceInfo().getCellCoordinate(mbr_row[2], mbr_row[1], pyramidLevel))[1], -1.0 * lrcell[0], (llcell = geoRaster.getMetadataObject().getSpatialReferenceInfo().getCellCoordinate(mbr_row[0], mbr_row[1], pyramidLevel))[1], -1.0 * llcell[0], ulcell[1], -1.0 * ulcell[0]};
                    if (!this.isClockwise(flipCoords)) {
                        imgFlipped = true;
                    }
                    if (Double.valueOf(vrow.get(5).toString()) != 0.0 || Double.valueOf(vcol.get(6).toString()) != 0.0) {
                        double xoff = ulcell[1];
                        double yoff = ulcell[0];
                        double x1 = urcell[1];
                        double y1 = urcell[0];
                        imgRotation = this.computeRotation(xoff, yoff, x1, y1);
                        if (imgRotation == 0.0) {
                            // empty if block
                        }
                        if (imgRotation != 0.0) {
                            imgTransform = 1;
                            double rotv = this.computeRotation(xoff, yoff, llcell[1], llcell[0]);
                            if ((int)(Math.abs(rotv - imgRotation) + 0.5) != 90) {
                                imgTransform = 3;
                            }
                            if (imgTransform == 1) {
                                double[] dcell = geoRaster.getMetadataObject().getSpatialReferenceInfo().getCellCoordinate(mbr_row[0] + (mbr_row[2] - mbr_row[0]) / 2.0, mbr_row[1] + (mbr_row[3] - mbr_row[1]) / 2.0, pyramidLevel);
                                imgrotref = new Point2D.Double(dcell[1], dcell[0]);
                            }
                            if (imgFlipped) {
                                imgRotation = -1.0 * imgRotation;
                            }
                            imgMask = this.changeMaskSRID(conn, JSDOGeometry.recast(geoRaster.getSpatialExtent()), vc.getMasterSRID());
                        } else if (useReprojection) {
                            reprojMask = this.changeMaskSRID(conn, JSDOGeometry.recast(geoRaster.getSpatialExtent()), vc.getMasterSRID());
                        }
                    } else if (useReprojection) {
                        reprojMask = this.changeMaskSRID(conn, JSDOGeometry.recast(geoRaster.getSpatialExtent()), vc.getMasterSRID());
                    }
                }
                if (outArea != null && useReprojection) {
                    mbr_row = outArea.getMBR();
                    this.preparedWithReprojection = true;
                } else if (vc.getMasterSRID() > 0 && dataSRID > 0 && dataSRID != vc.getMasterSRID() && dataSRID != 999999 && dataSRID != 262148) {
                    double[] outmbr = Util.convertMBR(mbr_row, dataSRID, vc.getMasterSRID(), conn);
                    if (outmbr == null) {
                        vc.processDataError(null, log, "Unable to convert MBR SRID from " + dataSRID + " to " + vc.getMasterSRID());
                        int n = 0;
                        return n;
                    }
                    mbr_row = outmbr;
                }
                String[] opNames = this.def.getImageProcessNames();
                if (opNames != null || this.overoperationNames != null) {
                    ri = this.performImageProcessing(ri);
                }
                if (ri != null) {
                    mbrs_.add(mbr_row);
                    this.imgModelLocations.add(modelLocation);
                    this.renderImages.put(String.valueOf(row), ri);
                    if (imgFlipped) {
                        this.imgRotFlip.put(String.valueOf(row), new Boolean(imgFlipped));
                    }
                    if (imgRotation != 0.0) {
                        this.imgRotations.put(String.valueOf(row), new Double(imgRotation));
                        this.imgTransf.put(String.valueOf(row), new Integer(imgTransform));
                        if (imgrotref != null) {
                            this.imgRotRefPoint.put(String.valueOf(row), imgrotref);
                        }
                        if (imgMask != null) {
                            this.imgRotMask.put(String.valueOf(row), imgMask);
                        }
                    }
                    if (reprojMask != null) {
                        this.imgReprojMask.put(String.valueOf(row), reprojMask);
                    }
                    ++row;
                }
                geoRaster = null;
                firstRecord = false;
            }
        }
        catch (Exception ex) {
            log.log(Level.SEVERE, "GeoRaster load Exception: ", ex);
            throw new DataException("GeoRaster load Exception: " + ex.getMessage());
        }
        finally {
            if (this.getTheme().getDecorator().getWorkspaceName() != null) {
                try {
                    Util.gotoWorkspace(conn, "LIVE");
                }
                catch (Exception ex) {
                    log.warning(ex.getMessage());
                }
            }
            if (rset != null) {
                try {
                    rset.close();
                }
                catch (Exception re) {
                    log.warning(re.getMessage());
                }
            }
            if (getGeor != null) {
                try {
                    getGeor.close();
                }
                catch (Exception re) {
                    log.warning(re.getMessage());
                }
            }
        }
        long t2 = System.currentTimeMillis();
        log.info("[ " + this.def.name + " ] sql exec time: " + (t1 - t0) + "ms, loading time for " + mbrs_.size() + " GeoRaster objects: " + (t2 - t1) + "ms.");
        TopThemeQueries.add(t2 - t0, this.getTheme().getName(), this.getTheme().getDataSourceName(), geoquery, "GeoRaster objects loaded = " + mbrs_.size());
        return row;
    }

    private double computeRotation(double xoff, double yoff, double x, double y) {
        double ox = x - xoff;
        double oy = y - yoff;
        if (Math.abs(ox) > Math.abs(oy)) {
            oy /= Math.abs(ox);
            ox /= Math.abs(ox);
        } else {
            ox /= Math.abs(oy);
            oy /= Math.abs(oy);
        }
        double radians = Math.atan2(oy, ox);
        double degrees = 180.0 * radians / Math.PI;
        return degrees;
    }

    public JSDOGeometry getPolygonMask() {
        return this.themePolyMask;
    }

    public Hashtable<String, Vector<JSDOGeometry>> getPolygonMasks() {
        return this.themePolygonMasks;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private JSDOGeometry changeMaskSRID(Connection conn, JSDOGeometry polyMask, int toSRID) {
        if (polyMask == null) {
            return null;
        }
        int pmkSRID = polyMask.getSRID();
        boolean isRect = polyMask.isRectangle();
        if (toSRID > 0 && pmkSRID > 0 && pmkSRID != toSRID && pmkSRID != 999999 && pmkSRID != 262148) {
            String srid = "NULL";
            if (pmkSRID != 0) {
                srid = String.valueOf(pmkSRID);
            }
            String geomstr = "MDSYS.SDO_GEOMETRY(2003, " + srid + ", NULL, " + "MDSYS.SDO_ELEM_INFO_ARRAY(1, 1003, 1), " + "MDSYS.SDO_ORDINATE_ARRAY(";
            if (isRect) {
                geomstr = "MDSYS.SDO_GEOMETRY(2003, " + srid + ", NULL, " + "MDSYS.SDO_ELEM_INFO_ARRAY(1, 1003, 3), " + "MDSYS.SDO_ORDINATE_ARRAY(";
            }
            double[] ordinates = polyMask.getOrdinatesArray();
            for (int k = 0; k < ordinates.length; ++k) {
                geomstr = k > 0 ? geomstr + "," + ordinates[k] : geomstr + ordinates[k];
            }
            geomstr = geomstr + "))";
            String transfSRid = "select sdo_cs.transform(" + geomstr + "," + toSRID + ") from dual";
            PreparedStatement stmt = null;
            ResultSet rs = null;
            try {
                stmt = conn.prepareStatement(transfSRid);
                rs = stmt.executeQuery();
                if (rs.next()) {
                    JSDOGeometry geom;
                    JSDOGeometry jSDOGeometry = geom = JDBCUtil.loadGeometry(rs, 1, false);
                    return jSDOGeometry;
                }
                log.finest("Polygon mask SRID convertion (" + pmkSRID + " to " + toSRID + " returned null value.");
            }
            catch (Exception e) {
                log.warning(e.getMessage());
            }
            finally {
                try {
                    if (rs != null) {
                        rs.close();
                    }
                }
                catch (Exception ex) {}
                try {
                    if (stmt != null) {
                        stmt.close();
                    }
                }
                catch (Exception ex) {}
            }
        } else {
            return polyMask;
        }
        return null;
    }

    @Override
    public void postPreparation(VisContext vc) {
    }

    @Override
    public StyledFeatureI getStyledFeature(int idx) {
        return null;
    }

    @Override
    public double[] getDataMBR() {
        if (this.mbrs == null || this.mbrs.length == 0) {
            return null;
        }
        RectangularShape r2d = null;
        for (int i = 0; i < this.mbrs.length; ++i) {
            double[] mbr = this.mbrs[i];
            if (r2d == null) {
                r2d = new Rectangle2D.Double(mbr[0], mbr[1], 0.0, 0.0);
            } else {
                ((Rectangle2D)r2d).add(mbr[0], mbr[1]);
            }
            ((Rectangle2D)r2d).add(mbr[2], mbr[3]);
        }
        double[] res = new double[]{r2d.getMinX(), r2d.getMinY(), r2d.getMaxX(), r2d.getMaxY()};
        return res;
    }

    @Override
    public StyledFeatureI[] getStyledFeatures() {
        return null;
    }

    @Override
    public LocalTheme getSelectedFeaturesAsTheme(Rectangle2D window, String name) {
        return null;
    }

    @Override
    public StyledFeatureI[] getSelectedFeatures(Rectangle2D window) {
        return null;
    }

    public double[][] getMBRs() {
        return this.mbrs;
    }

    public void setImageMBRs(double[][] mbrs) {
        this.mbrs = mbrs;
    }

    private boolean transformQueryMBRFromMasterToNative(double[] inmbrValid, double[] inmbrValid2, double[] qmbr, double[] qmbr2, Connection conn, VisContext vc, boolean hasQueryWin2) throws DataException {
        boolean isFullExt;
        double masterScale = vc.getCurrentScale();
        boolean bl = isFullExt = !(masterScale != Double.POSITIVE_INFINITY && masterScale != Double.NEGATIVE_INFINITY || inmbrValid[0] != Double.NaN && inmbrValid[0] != Double.NEGATIVE_INFINITY && inmbrValid[0] != Double.POSITIVE_INFINITY);
        if (!isFullExt) {
            double[] outmbr = Util.convertMBR(inmbrValid, vc.getMasterSRID(), this.def.getSrid(), conn);
            if (outmbr != null) {
                for (int k = 0; k < 4; ++k) {
                    qmbr[k] = outmbr[k];
                }
                log.finest("Transformed query box:[" + qmbr[0] + "," + qmbr[1] + " " + qmbr[2] + "," + qmbr[3] + "]");
                double[] outmbr2 = null;
                if (hasQueryWin2) {
                    outmbr2 = Util.convertMBR(inmbrValid2, vc.getMasterSRID(), this.def.getSrid(), conn);
                    if (outmbr2 != null) {
                        for (int k = 0; k < 4; ++k) {
                            qmbr2[k] = outmbr2[k];
                        }
                        log.finest("Transformed query box2:[" + qmbr2[0] + "," + qmbr2[1] + " " + qmbr2[2] + "," + qmbr2[3] + "]");
                    } else {
                        log.warning("Error in converting query MBR2");
                    }
                }
                return true;
            }
            vc.processDataError(null, log, RSBundle.getMsg("MAPVIEWER-01024"));
            return false;
        }
        return true;
    }

    public Vector<String> getGeoRasterIds() {
        return this.georasterIds;
    }

    private long[] computeCellCoordinate(JGeoRaster geoRaster, long pyramidLevel, double xl, double yl, double xh, double yh, double[] offcell) {
        log.finer("Converting to cell coordinate: [pyramidLevel] " + pyramidLevel + " [Xl] " + xl + " [Yl] " + yl);
        double[] dcell = geoRaster.getMetadataObject().getSpatialReferenceInfo().getCellCoordinate(xl, yl, pyramidLevel);
        log.finer("Cell coordinates: Row=" + dcell[0] + ", Column=" + dcell[1]);
        double off = 0.5;
        long xmin = (long)(dcell[1] + off) - (long)offcell[1];
        long ymax = (long)(dcell[0] + off) - (long)offcell[0];
        long xmax = xmin;
        long ymin = ymax;
        log.finer("Converting to cell coordinate: [pyramidLevel] " + pyramidLevel + " [Xl] " + xl + " [Yh] " + yh);
        dcell = geoRaster.getMetadataObject().getSpatialReferenceInfo().getCellCoordinate(xl, yh, pyramidLevel);
        log.finer("Cell coordinates: Row=" + dcell[0] + ", Column=" + dcell[1]);
        xmin = Math.min(xmin, (long)(dcell[1] + off) - (long)offcell[1]);
        ymin = Math.min(ymin, (long)(dcell[0] + off) - (long)offcell[0]);
        xmax = Math.max(xmax, (long)(dcell[1] + off) - (long)offcell[1]);
        ymax = Math.max(ymax, (long)(dcell[0] + off) - (long)offcell[0]);
        log.finer("Converting to cell coordinate: [pyramidLevel] " + pyramidLevel + " [Xh] " + xh + " [Yh] " + yh);
        dcell = geoRaster.getMetadataObject().getSpatialReferenceInfo().getCellCoordinate(xh, yh, pyramidLevel);
        log.finer("Cell coordinates: Row=" + dcell[0] + ", Column=" + dcell[1]);
        xmin = Math.min(xmin, (long)(dcell[1] + off) - (long)offcell[1]);
        ymin = Math.min(ymin, (long)(dcell[0] + off) - (long)offcell[0]);
        xmax = Math.max(xmax, (long)(dcell[1] + off) - (long)offcell[1]);
        ymax = Math.max(ymax, (long)(dcell[0] + off) - (long)offcell[0]);
        log.finer("Converting to cell coordinate: [pyramidLevel] " + pyramidLevel + " [Xh] " + xh + " [Yl] " + yl);
        dcell = geoRaster.getMetadataObject().getSpatialReferenceInfo().getCellCoordinate(xh, yl, pyramidLevel);
        log.finer("Cell coordinates: Row=" + dcell[0] + ", Column=" + dcell[1]);
        xmin = Math.min(xmin, (long)(dcell[1] + off) - (long)offcell[1]);
        ymin = Math.min(ymin, (long)(dcell[0] + off) - (long)offcell[0]);
        xmax = Math.max(xmax, (long)(dcell[1] + off) - (long)offcell[1]);
        ymax = Math.max(ymax, (long)(dcell[0] + off) - (long)offcell[0]);
        long[] cell = new long[]{ymin, xmin, ymax, xmax};
        return cell;
    }

    @Override
    public void destroy() {
        if (this.mbrs != null) {
            for (int i = 0; i < this.mbrs.length; ++i) {
                this.mbrs[i] = null;
            }
        }
        this.mbrs = null;
        if (this.renderImages.size() > 0) {
            Object[] obj = this.renderImages.values().toArray();
            this.renderImages.clear();
            for (int i = 0; i < obj.length; ++i) {
                if (obj[i] instanceof BufferedImage) {
                    BufferedImage bi = (BufferedImage)obj[i];
                    bi.flush();
                }
                obj[i] = null;
            }
            Object var1_2 = null;
        }
        if (this.imgRotations.size() > 0) {
            this.imgRotations.clear();
        }
        if (this.imgRotRefPoint.size() > 0) {
            this.imgRotRefPoint.clear();
        }
        if (this.imgRotFlip.size() > 0) {
            this.imgRotFlip.clear();
        }
        if (this.imgRotMask.size() > 0) {
            this.imgRotMask.clear();
        }
        if (this.imgTransf.size() > 0) {
            this.imgTransf.clear();
        }
        if (this.imgReprojMask.size() > 0) {
            this.imgReprojMask.clear();
        }
        this.themePolyMask = null;
        this.themePolygonMasks.clear();
        this.georasterIds.clear();
        this.imgModelLocations.clear();
    }

    @Override
    public void abort() {
    }

    protected String rewriteQuery(double xl, double yl, double xh, double yh, boolean isGeodetic) {
        String querystr = this.def.getImageQuery();
        if (querystr == null) {
            return null;
        }
        if (this.def.passThrough || xl == Double.NEGATIVE_INFINITY || yl == Double.NEGATIVE_INFINITY || xh == Double.POSITIVE_INFINITY || yh == Double.POSITIVE_INFINITY) {
            return querystr;
        }
        String filter = this.getFilter(this.def.getGeoRasterColumn(), this.def.getSrid(), xl, yl, xh, yh, this.def.is9i(), isGeodetic);
        return "SELECT * FROM ( " + querystr + " ) grt WHERE " + filter;
    }

    final String getFilter(String spatialColumn, int srid, double xl, double yl, double xh, double yh, boolean is9i, boolean geodetic) {
        StringBuffer sb = new StringBuffer(256);
        if (!geodetic) {
            sb.append("MDSYS.SDO_FILTER(grt." + spatialColumn + ".spatialextent, " + "MDSYS.SDO_GEOMETRY(2003, ");
            if (srid == 0) {
                sb.append("NULL");
            } else {
                sb.append(srid);
            }
            sb.append(", NULL, MDSYS.SDO_ELEM_INFO_ARRAY(1, 1003, 3), MDSYS.SDO_ORDINATE_ARRAY(?,?,?,?)), 'querytype=WINDOW') = 'TRUE'");
        } else {
            sb.append("MDSYS.SDO_ANYINTERACT(grt." + spatialColumn + ".spatialextent, " + "MDSYS.SDO_GEOMETRY(2003, ");
            if (srid == 0) {
                sb.append("NULL");
            } else {
                sb.append(srid);
            }
            sb.append(", NULL, MDSYS.SDO_ELEM_INFO_ARRAY(1, 1003, 3), MDSYS.SDO_ORDINATE_ARRAY(?,?,?,?))) = 'TRUE'");
        }
        return sb.toString();
    }

    final String getPolygonMaskFilter(String spatialColumn, int srid, double xl, double yl, double xh, double yh) {
        StringBuffer sb = new StringBuffer(256);
        sb.append("MDSYS.SDO_FILTER(pmasktb." + spatialColumn + ", " + "MDSYS.SDO_GEOMETRY(2003, ");
        if (srid == 0) {
            sb.append("NULL");
        } else {
            sb.append(srid);
        }
        sb.append(", NULL, MDSYS.SDO_ELEM_INFO_ARRAY(1, 1003, 3), MDSYS.SDO_ORDINATE_ARRAY(" + xl + "," + yl + "," + xh + "," + yh + ")), " + "'querytype=WINDOW') = 'TRUE'");
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processPolygonMasks(Connection conn, double xl, double yl, double xh, double yh, int vcSrid) {
        this.themePolygonMasks.clear();
        if (conn == null || this.def.getPolygonMaskTable() == null || this.def.getPolygonMaskGeometryColumn() == null) {
            return;
        }
        String filter = null;
        if (!this.def.passThrough && xl != Double.NEGATIVE_INFINITY && yl != Double.NEGATIVE_INFINITY && xh != Double.POSITIVE_INFINITY && yh != Double.POSITIVE_INFINITY) {
            filter = this.getPolygonMaskFilter(this.def.getPolygonMaskGeometryColumn(), vcSrid, xl, yl, xh, yh);
        }
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            int srid = 0;
            String tbsrid = "select srid from user_sdo_geom_metadata where table_name = ? and column_name = ?";
            stmt = conn.prepareStatement(tbsrid);
            stmt.setString(1, this.def.getPolygonMaskTable().toUpperCase());
            stmt.setString(2, this.def.getPolygonMaskGeometryColumn().toUpperCase());
            rs = stmt.executeQuery();
            if (rs.next() && rs.getObject(1) != null) {
                srid = rs.getInt(1);
            }
            log.info("Polygon mask table [" + this.def.getPolygonMaskTable().toUpperCase() + "] geometry column [" + this.def.getPolygonMaskGeometryColumn().toUpperCase() + "] SRID=" + srid);
            rs.close();
            stmt.close();
            String pmaskQuery = "select ";
            pmaskQuery = vcSrid > 0 && srid > 0 && srid != vcSrid && srid != 999999 && srid != 262148 ? pmaskQuery + "sdo_cs.transform(pmasktb." + this.def.getPolygonMaskGeometryColumn() + "," + vcSrid + ") " : pmaskQuery + "pmasktb." + this.def.getPolygonMaskGeometryColumn();
            if (this.def.getPolygonMaskGeometryJoinColumn() != null) {
                pmaskQuery = pmaskQuery + ", pmasktb." + this.def.getPolygonMaskGeometryJoinColumn();
            }
            pmaskQuery = pmaskQuery + " from " + this.def.getPolygonMaskTable() + " pmasktb";
            if (filter != null) {
                pmaskQuery = pmaskQuery + " where " + filter;
                if (this.def.getPolygonMaskQueryCondition() != null) {
                    pmaskQuery = pmaskQuery + " and " + this.def.getPolygonMaskQueryCondition();
                }
            } else if (this.def.getPolygonMaskQueryCondition() != null) {
                pmaskQuery = pmaskQuery + " where " + this.def.getPolygonMaskQueryCondition();
            }
            log.info("Polygon mask query:\n" + pmaskQuery);
            stmt = conn.prepareStatement(pmaskQuery);
            rs = stmt.executeQuery();
            while (rs.next()) {
                JSDOGeometry geom = JDBCUtil.loadGeometry(rs, 1, false);
                if (geom == null) continue;
                if (this.def.getPolygonMaskGeometryJoinColumn() != null) {
                    Object joinId = rs.getObject(2);
                    if (joinId == null) continue;
                    Vector<JSDOGeometry> polys = null;
                    polys = this.themePolygonMasks.get(joinId.toString());
                    if (polys == null) {
                        polys = new Vector();
                        this.themePolygonMasks.put(joinId.toString(), polys);
                    }
                    polys.add(geom);
                    continue;
                }
                Vector<Object> polys = null;
                if (this.themePolygonMasks.size() == 0) {
                    polys = new Vector();
                    this.themePolygonMasks.put("1", polys);
                } else {
                    polys = this.themePolygonMasks.get("1");
                }
                polys.add(geom);
            }
        }
        catch (Exception e) {
            log.warning(e.getMessage());
            log.warning("Polygon masks from table will be ignored.");
            this.themePolygonMasks.clear();
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (Exception ex) {
                log.warning(ex.getMessage());
            }
            try {
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (Exception ex) {
                log.warning(ex.getMessage());
            }
        }
    }

    private String getPredefinedQuery(double xl, double yl, double xh, double yh, boolean isGeodetic) {
        String cond;
        String subQuery = "select grt." + this.def.getGeoRasterColumn() + ", grt." + this.def.getGeoRasterColumn() + ".metadata.getClobVal()";
        if (this.themePolygonMasks.size() > 0 && this.def.hasPolygonMaskJoinColumns()) {
            subQuery = subQuery + ", grt." + this.def.getPolygonMaskGeoRasterJoinColumn();
        }
        subQuery = subQuery + " from " + this.def.mBaseTable + " grt";
        String filter = null;
        if (!this.def.passThrough && xl != Double.NEGATIVE_INFINITY && yl != Double.NEGATIVE_INFINITY && xh != Double.POSITIVE_INFINITY && yh != Double.POSITIVE_INFINITY) {
            filter = this.getFilter(this.def.getGeoRasterColumn(), this.def.getSrid(), xl, yl, xh, yh, this.def.is9i(), isGeodetic);
        }
        String string = cond = this.def.mSRule != null ? this.def.mSRule.getFeatureCond() : null;
        if (filter != null) {
            subQuery = subQuery + " WHERE " + filter;
            if (cond != null) {
                subQuery = subQuery + " AND " + cond;
            }
        } else if (cond != null) {
            subQuery = subQuery + " WHERE " + cond;
        }
        return subQuery;
    }

    public HashMap getRenderedImages() {
        return this.renderImages;
    }

    public Hashtable getImagesRotation() {
        return this.imgRotations;
    }

    public RenderedImage getRenderedImage(int index) {
        if (this.renderImages == null) {
            return null;
        }
        if (index < 0 || index > this.renderImages.size() - 1) {
            return null;
        }
        return (RenderedImage)this.renderImages.get(String.valueOf(index));
    }

    public double getImageRotation(int index) {
        if (this.imgRotations == null) {
            return 0.0;
        }
        Double rot = this.imgRotations.get(String.valueOf(index));
        if (rot == null) {
            return 0.0;
        }
        return rot;
    }

    public int getImageTransformation(int index) {
        if (this.imgTransf == null) {
            return 0;
        }
        Integer trf = this.imgTransf.get(String.valueOf(index));
        if (trf == null) {
            return 0;
        }
        return trf;
    }

    public Point2D getImageRotationRefPoint(int index) {
        if (this.imgRotRefPoint == null) {
            return null;
        }
        Point2D rot = this.imgRotRefPoint.get(String.valueOf(index));
        return rot;
    }

    public JSDOGeometry getImageRotationMask(int index) {
        if (this.imgRotMask == null) {
            return null;
        }
        JSDOGeometry rot = this.imgRotMask.get(String.valueOf(index));
        return rot;
    }

    public JSDOGeometry getImageReprojectionMask(int index) {
        if (this.imgReprojMask == null) {
            return null;
        }
        JSDOGeometry rot = this.imgReprojMask.get(String.valueOf(index));
        return rot;
    }

    public String getImageModelLocation(int index) {
        if (this.imgModelLocations == null) {
            return "CENTER";
        }
        if (index < 0 || index > this.imgModelLocations.size() - 1) {
            return "CENTER";
        }
        return this.imgModelLocations.get(index);
    }

    public boolean isImageFlipped(int index) {
        if (this.imgRotFlip == null) {
            return false;
        }
        Boolean flip = this.imgRotFlip.get(String.valueOf(index));
        if (flip == null) {
            return false;
        }
        return flip;
    }

    public RenderedImage performImageProcessing(RenderedImage image) {
        RenderedImage im = image;
        String[] opNames = this.def.getImageProcessNames();
        Hashtable imageProcess = this.def.getImageProcessParameters();
        if (this.overoperationNames != null) {
            opNames = this.overoperationNames;
            imageProcess = this.overoperationParameters;
        }
        if (opNames != null) {
            for (int op = 0; op < opNames.length; ++op) {
                log.finer("Operation name: " + opNames[op]);
                Hashtable params = null;
                if (imageProcess != null) {
                    params = (Hashtable)imageProcess.get(opNames[op]);
                }
                if (opNames[op].equalsIgnoreCase("NORMALIZE")) {
                    log.finer("Normalize operation.");
                    GeoRasterImageProcessUtil normalizeOp = new GeoRasterImageProcessUtil(im);
                    RenderedImage res = normalizeOp.amplitudeRescaling();
                    normalizeOp.setImage(res);
                    res = normalizeOp.normalize();
                    if (res == null) {
                        log.info("Unable to normalize image.");
                    } else {
                        im = res;
                    }
                    normalizeOp = null;
                    continue;
                }
                if (opNames[op].equalsIgnoreCase("EQUALIZE")) {
                    log.finer("Equalize operation");
                    GeoRasterImageProcessUtil equalizeOp = new GeoRasterImageProcessUtil(im);
                    RenderedImage res = equalizeOp.amplitudeRescaling();
                    equalizeOp.setImage(res);
                    res = equalizeOp.equalize();
                    if (res == null) {
                        log.info("Unable to equalize image.");
                    } else {
                        im = res;
                    }
                    equalizeOp = null;
                    continue;
                }
                if (opNames[op].equalsIgnoreCase("PIECEWISELINEARSTRETCH")) {
                    log.finer("Piecewise operation");
                    GeoRasterImageProcessUtil piecewiseOp = new GeoRasterImageProcessUtil(im);
                    RenderedImage res = piecewiseOp.amplitudeRescaling();
                    piecewiseOp.setImage(res);
                    res = piecewiseOp.piecewiseLinearStretch();
                    if (res == null) {
                        log.info("Unable to perform piecewise operation on image.");
                    } else {
                        im = res;
                    }
                    piecewiseOp = null;
                    continue;
                }
                if (opNames[op].equalsIgnoreCase("LINEARSTRETCH")) {
                    int stretchHighValue;
                    int stretchLowValue;
                    GeoRasterImageProcessUtil linearstretchOp;
                    block54: {
                        block53: {
                            log.finer("Linear stretch operation");
                            String autoMode = null;
                            if (params != null) {
                                autoMode = (String)params.get("autostretch");
                            }
                            if (autoMode == null || autoMode.trim().length() < 1 || !autoMode.trim().equals("false")) {
                                log.finer("Performing automatic linear stretch.");
                                linearstretchOp = new GeoRasterImageProcessUtil(im);
                                RenderedImage res = linearstretchOp.amplitudeRescaling();
                                if (res == null) {
                                    log.info("Unable to perform automatic linear stretch on image.");
                                } else {
                                    im = res;
                                }
                                linearstretchOp = null;
                                continue;
                            }
                            log.finer("Performing manual linear stretch.");
                            linearstretchOp = new GeoRasterImageProcessUtil(im);
                            String lowstretch = (String)params.get("lowstretch");
                            stretchLowValue = 0;
                            if (lowstretch != null) {
                                try {
                                    int value;
                                    stretchLowValue = value = Integer.parseInt(lowstretch);
                                    log.info("Manual low stretch value: " + stretchLowValue);
                                    break block53;
                                }
                                catch (Exception e) {
                                    log.severe(RSBundle.getMsg("MAPVIEWER-01033"));
                                    continue;
                                }
                            }
                            log.info("Manual low stretch value not defined: 0 is assumed.");
                        }
                        String highstretch = (String)params.get("highstretch");
                        stretchHighValue = 256;
                        if (highstretch != null) {
                            try {
                                int value;
                                stretchHighValue = value = Integer.parseInt(highstretch);
                                log.info("Manual high stretch value: " + stretchHighValue);
                                break block54;
                            }
                            catch (Exception e) {
                                log.severe(RSBundle.getMsg("MAPVIEWER-01034"));
                                continue;
                            }
                        }
                        log.info("Manual high stretch value not defined: 256 is assumed.");
                    }
                    RenderedImage res = linearstretchOp.amplitudeRescaling((double)stretchLowValue, (double)stretchHighValue);
                    if (res == null) {
                        log.info("Unable to perform manual linear stretch on image.");
                    } else {
                        im = res;
                    }
                    linearstretchOp = null;
                    continue;
                }
                if (opNames[op].equalsIgnoreCase("BRIGHTNESS")) {
                    if (params == null) {
                        log.info("Parameter element for brightness must be defined.");
                        continue;
                    }
                    String bright = (String)params.get("value");
                    int brightness = 0;
                    if (bright != null && bright.trim().length() > 0) {
                        try {
                            int value = Integer.parseInt(bright);
                            log.info("Brightness value: " + value);
                            if (value >= 0 && value <= 256) {
                                brightness = value;
                            }
                            log.finer("Changing brightness.");
                            GeoRasterImageProcessUtil brightnessOp = new GeoRasterImageProcessUtil(im);
                            RenderedImage res = brightnessOp.changeBrightness(brightness);
                            if (res == null) {
                                log.info("Unable to change image brightness.");
                            } else {
                                im = res;
                            }
                            brightnessOp = null;
                        }
                        catch (Exception e) {
                            log.severe(RSBundle.getMsg("MAPVIEWER-01035"));
                        }
                        continue;
                    }
                    log.severe(RSBundle.getMsg("MAPVIEWER-01036"));
                    continue;
                }
                if (opNames[op].equalsIgnoreCase("CONTRAST")) {
                    if (params == null) {
                        log.info("Parameter element for contrast must be defined.");
                        continue;
                    }
                    String contr = (String)params.get("value");
                    int contrast = 256;
                    if (contr != null && contr.trim().length() > 0) {
                        try {
                            int value;
                            contrast = value = Integer.parseInt(contr);
                            log.finer("Changing contrast.");
                            GeoRasterImageProcessUtil contrastOp = new GeoRasterImageProcessUtil(im);
                            RenderedImage res = contrastOp.changeContrast((double)contrast);
                            if (res == null) {
                                log.info("Unable to change image contrast.");
                            } else {
                                im = res;
                            }
                            contrastOp = null;
                        }
                        catch (Exception e) {
                            log.severe(RSBundle.getMsg("MAPVIEWER-01037"));
                        }
                        continue;
                    }
                    log.severe(RSBundle.getMsg("MAPVIEWER-01038"));
                    continue;
                }
                if (!opNames[op].equalsIgnoreCase("CHANGETHRESHOLD")) continue;
                if (params == null) {
                    log.info("Parameter elements for threshold must be defined.");
                    continue;
                }
                String thresh = (String)params.get("threshold");
                double threshold = 0.0;
                if (thresh != null) {
                    try {
                        double value;
                        threshold = value = Double.parseDouble(thresh);
                    }
                    catch (Exception e) {
                        log.severe(RSBundle.getMsg("MAPVIEWER-01039"));
                        continue;
                    }
                }
                String lowthresh = (String)params.get("lowthreshold");
                double thresholdLowValue = 0.0;
                if (lowthresh != null) {
                    try {
                        double value;
                        thresholdLowValue = value = Double.parseDouble(lowthresh);
                    }
                    catch (Exception e) {
                        log.severe(RSBundle.getMsg("MAPVIEWER-01040"));
                        continue;
                    }
                }
                String highthresh = (String)params.get("highthreshold");
                double thresholdHighValue = 0.0;
                if (highthresh != null) {
                    try {
                        double value;
                        thresholdHighValue = value = Double.parseDouble(highthresh);
                    }
                    catch (Exception e) {
                        log.severe(RSBundle.getMsg("MAPVIEWER-01041"));
                        continue;
                    }
                }
                log.finer("Changing threshold");
                GeoRasterImageProcessUtil thresholdOp = new GeoRasterImageProcessUtil(im);
                RenderedImage res = thresholdOp.changeThreshold(thresholdLowValue, thresholdHighValue, threshold);
                if (res == null) {
                    log.info("Unable to change image threshold.");
                } else {
                    im = res;
                }
                thresholdOp = null;
            }
        }
        return im;
    }

    private void setBindingVariable(PreparedStatement stmt, Object var, int idx) throws SQLException, IllegalArgumentException {
        if (var instanceof String) {
            stmt.setString(idx, (String)var);
        } else if (var instanceof Integer) {
            stmt.setInt(idx, (Integer)var);
        } else if (var instanceof Double) {
            stmt.setDouble(idx, (Double)var);
        } else if (var instanceof Float) {
            stmt.setFloat(idx, ((Float)var).floatValue());
        } else if (var instanceof Long) {
            stmt.setLong(idx, (Long)var);
        } else if (var instanceof Short) {
            stmt.setShort(idx, (Short)var);
        } else if (var instanceof Byte) {
            stmt.setByte(idx, (Byte)var);
        } else if (var instanceof BigDecimal) {
            stmt.setBigDecimal(idx, (BigDecimal)var);
        } else if (var instanceof byte[]) {
            stmt.setBytes(idx, (byte[])var);
        } else if (var instanceof Date) {
            stmt.setDate(idx, (Date)var);
        } else if (var instanceof Time) {
            stmt.setTime(idx, (Time)var);
        } else if (var instanceof Timestamp) {
            stmt.setTimestamp(idx, (Timestamp)var);
        } else {
            throw new IllegalArgumentException("Binding data type not supported:" + var.getClass().toString());
        }
    }

    private boolean isFullExtent(boolean passThrough, double xl, double yl, double xh, double yh) {
        return passThrough || Double.isInfinite(xl) || Double.isNaN(xl) || Double.isInfinite(yl) || Double.isNaN(yl) || Double.isInfinite(xh) || Double.isNaN(xh) || Double.isInfinite(yh) || Double.isNaN(yh);
    }

    private boolean isDataWithinScale(Connection conn, VisContext vc, double masterScale, boolean fullExtent, int datasrid, double qwx1, double qwy1, double qwx2, double qwy2) {
        if (datasrid == 0) {
            log.warning("Data SRID is equal 0. Can not verify if theme is within scale limits.");
            return false;
        }
        double xl = qwx1;
        double yl = qwy1;
        double xh = qwx2;
        double yh = qwy2;
        if (masterScale != Double.POSITIVE_INFINITY && masterScale != Double.NEGATIVE_INFINITY) {
            if (vc.getMasterSRID() > 0 && datasrid > 0 && datasrid != vc.getMasterSRID() && datasrid != 999999 && datasrid != 262148 && masterScale != Double.POSITIVE_INFINITY && masterScale != Double.NEGATIVE_INFINITY) {
                double[] inmbr = new double[]{qwx1, qwy1, qwx2, qwy2};
                double[] outmbr = Util.convertMBR(inmbr, vc.getMasterSRID(), datasrid, conn);
                if (outmbr != null) {
                    xl = outmbr[0];
                    yl = outmbr[1];
                    xh = outmbr[2];
                    yh = outmbr[3];
                } else {
                    log.finest("Unable to convert query window to data SRID " + datasrid + ".");
                    return false;
                }
            }
            double factor = Math.abs(yh - yl) / Math.abs(qwy2 - qwy1);
            log.finer("[Master scale] " + masterScale + " [Scale factor for theme " + this.getTheme().getName() + "] " + factor);
            double scale = masterScale * factor;
            if (this.getTheme().getScaleType() == "RATIO") {
                double centery;
                double centerx;
                SRSCache sc = DSManager.getSRSCache(this.def.getDataSourceName());
                SRS srs = sc.get(datasrid);
                if (vc.getMasterSRID() > 0 && datasrid > 0 && datasrid != vc.getMasterSRID() && datasrid != 999999 && datasrid != 262148) {
                    srs = sc.get(vc.getMasterSRID());
                    centerx = (qwx1 + qwx2) / 2.0;
                    centery = (qwy1 + qwy2) / 2.0;
                    factor = 1.0;
                } else {
                    centerx = (xl + xh) / 2.0;
                    centery = (yl + yh) / 2.0;
                }
                if (vc.isTileRequest() && srs.isGeodetic()) {
                    centerx = 0.0;
                    centery = 0.0;
                }
                if (srs != null) {
                    scale = Math.round(srs.getRatioScale(masterScale * factor, new Point2D.Double(centerx, centery)));
                    log.finer("Ratio scale to compare: " + scale);
                } else {
                    log.severe(RSBundle.getMsg("MAPVIEWER-01025"));
                    return false;
                }
            }
            if (!this.getTheme().withinRenderScaleLimits(scale)) {
                log.warning("Scale definition for theme " + this.getTheme().getName() + " is out of range.");
                return false;
            }
        }
        if (!fullExtent) {
            this.screenResolution = Math.abs(yh - yl) / vc.getDeviceWindow().getHeight();
            log.info("Screen resolution: " + this.screenResolution);
        }
        return true;
    }

    public long computePyramidLevel(JGeoRaster geoRaster, double[] res) {
        if (geoRaster == null || res == null) {
            return -1L;
        }
        long pyrLevel = this.def.getPyramidLevel();
        if (this.screenResolution <= 0.0 || this.def.getOriginalPyramidLevel() != null) {
            return pyrLevel;
        }
        long maxlevel = 0L;
        Long pyrl = geoRaster.getMetadataObject().getRasterInfo().getPyramidMaxLevel();
        if (pyrl != null) {
            maxlevel = pyrl;
        }
        if (this.screenResolution <= res[1]) {
            pyrLevel = 0L;
        } else if (this.screenResolution >= res[1] * Math.pow(2.0, maxlevel)) {
            pyrLevel = maxlevel;
        } else {
            double lastres = res[1];
            int i = 1;
            while ((long)i <= maxlevel) {
                double nextres = res[1] * Math.pow(2.0, i);
                if (this.screenResolution <= nextres) {
                    double delta1 = this.screenResolution - lastres;
                    double delta2 = nextres - this.screenResolution;
                    if (delta1 < delta2) {
                        pyrLevel = i - 1;
                        break;
                    }
                    pyrLevel = i;
                    break;
                }
                lastres = nextres;
                ++i;
            }
        }
        return pyrLevel;
    }

    private boolean isClockwise(double[] coords) {
        if (coords == null) {
            return true;
        }
        double r1 = 0.0;
        double r2 = 0.0;
        double area = 0.0;
        double prev_x = coords[0];
        double prev_y = coords[1];
        for (int k = 2; k < coords.length - 1; k += 2) {
            double next_x = coords[k];
            double next_y = coords[k + 1];
            r1 += prev_x * next_y;
            r2 += prev_y * next_x;
            prev_x = next_x;
            prev_y = next_y;
        }
        area = (r2 - r1) / 2.0;
        return !(area < 0.0);
    }

    @Override
    public StyledFeatureI getNewStyledFeatureInstance() {
        return null;
    }

    public void OverwriteImageProcess(String[] opNames, Hashtable opParameters) {
        this.overoperationNames = opNames;
        this.overoperationParameters = opParameters;
    }

    public void ClearOverwriteImageProcess() {
        this.overoperationNames = null;
        this.overoperationParameters = null;
    }

    public void OverwriteBitmapMasks(GeoRasterBitmapMask[] masks) {
        if (masks == null || masks.length == 0) {
            this.overbitmapMasks = null;
            return;
        }
        this.overbitmapMasks = new Hashtable();
        for (int i = 0; i < masks.length; ++i) {
            int rid = masks[i].getRasterId();
            String rdtname = masks[i].getRasterDataTableName();
            this.overbitmapMasks.put("" + rid + ":" + rdtname.toUpperCase(), masks[i]);
        }
    }

    public void ClearOverwriteBitmapMasks() {
        this.overbitmapMasks = null;
    }

    private void processNodata(JGeoRaster geor, SubLayerInfo layer) {
        Vector ndr;
        if (geor == null || layer == null) {
            return;
        }
        Vector ndv = layer.getNODATAValue();
        if (ndv != null && ndv.size() > 0) {
            for (int n = 0; n < ndv.size(); ++n) {
                Double dnd = (Double)ndv.get(n);
                geor.getGeoRasterImageObject().addNodataMapping(dnd.doubleValue(), null, true);
            }
        }
        if ((ndr = layer.getNODATARange()) != null && ndr.size() > 0) {
            for (int n = 0; n < ndr.size() / 2; ++n) {
                Double mind = (Double)ndr.get(2 * n);
                Double maxd = (Double)ndr.get(2 * n + 1);
                geor.getGeoRasterImageObject().addNodataMapping(mind.doubleValue(), maxd.doubleValue(), null, true);
            }
        }
    }

    public boolean isPreparedWithReprojection() {
        return this.preparedWithReprojection;
    }

    @Override
    public long getMaxFeaturesToBePrepared() {
        return this.maxFeaturesToBePrepared;
    }

    @Override
    public void setMaxFeaturesToBePrepared(long size) {
        this.maxFeaturesToBePrepared = size;
    }

    public void setRequestMBR(double[] mbr) {
        for (int k = 0; k < 4; ++k) {
            this.queryMBR[k] = mbr[k];
        }
    }

    public void setRequestMBR2(double[] mbr2) {
        for (int k = 0; k < 4; ++k) {
            this.queryMBR2[k] = mbr2[k];
        }
    }
}

