/*
 * Decompiled with CFR 0.152.
 */
package oracle.sdovis.theme;

import java.awt.Color;
import java.awt.Font;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import java.util.logging.Logger;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.Unmarshaller;
import oracle.dms.instrument.PhaseEvent;
import oracle.mapviewer.share.Field;
import oracle.mapviewer.share.LabelingHints;
import oracle.mapviewer.share.SizeDefinition;
import oracle.mapviewer.share.SizeDefinition2D;
import oracle.mapviewer.share.style.LineStyleModel;
import oracle.mapviewer.share.style.StyleUtils;
import oracle.mapviewer.share.style.TextStyleModel;
import oracle.mapviewer.share.util.LogFactory;
import oracle.mapviewer.share.util.SensorCreator;
import oracle.mapviewer.share.util.SharedUtils;
import oracle.sdovis.DataException;
import oracle.sdovis.JSDOGeometry;
import oracle.sdovis.LocalTheme;
import oracle.sdovis.MapMaker;
import oracle.sdovis.RSBundle;
import oracle.sdovis.SRS;
import oracle.sdovis.SRSCache;
import oracle.sdovis.StyleFactory;
import oracle.sdovis.StyledFeature;
import oracle.sdovis.StyledFeatureI;
import oracle.sdovis.Theme;
import oracle.sdovis.VisContext;
import oracle.sdovis.ds.DSManager;
import oracle.sdovis.ds.DSUtil;
import oracle.sdovis.style.Style;
import oracle.sdovis.style.StyleColor;
import oracle.sdovis.style.StyleLine;
import oracle.sdovis.style.StyleText;
import oracle.sdovis.style.StylingRule;
import oracle.sdovis.text.AnnotationText;
import oracle.sdovis.text.AnnotationTextElement;
import oracle.sdovis.text.AnnotationTextFeature;
import oracle.sdovis.text.jaxb.FontStyle;
import oracle.sdovis.text.jaxb.TextAttributesType;
import oracle.sdovis.text.jaxb.TextStyle;
import oracle.sdovis.text.jaxb.Textlayout;
import oracle.sdovis.theme.AnnotationTextThemeDefinition;
import oracle.sdovis.theme.LocalThemeDataProducer;
import oracle.sdovis.theme.ThemeDataProducer;
import oracle.sdovis.util.JDBCUtil;
import oracle.sdovis.util.TopThemeQueries;
import oracle.sdovis.util.Util;
import oracle.spatial.geometry.JGeometry;

public class AnnotationTextThemeProducer
implements ThemeDataProducer {
    private static Logger log = LogFactory.getLogger(LogFactory.LoggerEnum.SDOVIS);
    private static PhaseEvent annotationSensor = SensorCreator.createPhaseEvent(SensorCreator.NounsEnum.THEMEPRODUCER, "AnnotationText", "Producer", "Time spent preparing data");
    protected Theme owner = null;
    protected AnnotationTextThemeDefinition def = null;
    private LocalThemeDataProducer features = null;
    private static final int YIELD_COUNT = 20;
    private JAXBContext jc = null;
    private Unmarshaller u = null;
    private Object[] bindingParameters = null;
    private Color textHighlightColor = null;
    private Color leaderlineHighlightColor = null;
    private boolean aborted = false;
    private long maxFeaturesToBePrepared = -1L;

    public AnnotationTextThemeProducer(Theme t) {
        this.owner = t;
        this.def = (AnnotationTextThemeDefinition)t.getDefinition();
    }

    public AnnotationTextThemeProducer(Theme t, Object[] bindingVars) {
        this.owner = t;
        this.def = (AnnotationTextThemeDefinition)t.getDefinition();
        this.bindingParameters = bindingVars;
    }

    public void setBindingParameters(Object[] params) {
        this.bindingParameters = params;
    }

    public Object[] getBindingParameters() {
        return this.bindingParameters;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public int prepareData(Rectangle2D queryWin, VisContext vc) throws DataException {
        long tokenA = 0L;
        try {
            StyledFeatureI sf;
            int hasAttributes;
            long t2;
            long t1;
            ArrayList<StyledFeatureI> featureSet;
            String textQuery;
            boolean applyRotation;
            boolean transformSRid;
            double yf;
            double yi;
            double xf;
            double xi;
            double yh;
            double xh;
            double yl;
            double xl;
            block181: {
                ResultSet rset;
                PreparedStatement textStmt;
                String dataException;
                Connection conn;
                block178: {
                    int i;
                    block176: {
                        block177: {
                            block174: {
                                block175: {
                                    Style llStyle;
                                    StyleText metaStyle;
                                    int cnt;
                                    String metacolumn;
                                    boolean fullExtent;
                                    block173: {
                                        boolean workaround;
                                        block172: {
                                            tokenA = annotationSensor.start();
                                            this.aborted = false;
                                            this.clearFeatures();
                                            xl = queryWin.getMinX();
                                            yl = queryWin.getMinY();
                                            xh = queryWin.getMaxX();
                                            yh = queryWin.getMaxY();
                                            fullExtent = this.isFullExtent(this.def.getFilterUse(), xl, yl, xh, yh);
                                            conn = null;
                                            try {
                                                conn = DSUtil.getDBConnection(this.def.getDataSourceName(), vc);
                                            }
                                            catch (Exception e) {
                                                log.warning(e.getMessage());
                                                throw new DataException("cannot obtain a connection to database.");
                                            }
                                            if (this.getTheme().getDecorator().getWorkspaceName() != null) {
                                                try {
                                                    if (this.getTheme().getDecorator().getWorkspaceName() == null) break block172;
                                                    if (this.getTheme().getDecorator().getWorkspaceDate() != null) {
                                                        Util.gotoWorkspaceDate(conn, this.getTheme().getDecorator().getWorkspaceName(), this.getTheme().getDecorator().getWorkspaceDate(), this.getTheme().getDecorator().getWorkspaceDateFormat(), this.getTheme().getDecorator().getWorkspaceDateNlsParam(), this.getTheme().getDecorator().isWorkspaceDateTsWtz());
                                                        break block172;
                                                    }
                                                    if (this.getTheme().getDecorator().getWorkspaceSavedPoint() != null) {
                                                        Util.gotoWorkspaceSavedPoint(conn, this.getTheme().getDecorator().getWorkspaceName(), this.getTheme().getDecorator().getWorkspaceSavedPoint());
                                                    } else {
                                                        Util.gotoWorkspace(conn, this.getTheme().getDecorator().getWorkspaceName());
                                                    }
                                                }
                                                catch (Exception e) {
                                                    log.severe(e.getMessage());
                                                    String err = "Cannot go to workspace " + this.getTheme().getDecorator().getWorkspaceName();
                                                    if (this.getTheme().getDecorator().getWorkspaceDate() != null) {
                                                        err = err + ", Date " + this.getTheme().getDecorator().getWorkspaceDate();
                                                        throw new DataException(err);
                                                    }
                                                    if (this.getTheme().getDecorator().getWorkspaceSavedPoint() == null) throw new DataException(err);
                                                    err = err + ", Saved Point " + this.getTheme().getDecorator().getWorkspaceSavedPoint();
                                                    throw new DataException(err);
                                                }
                                            }
                                        }
                                        SRSCache sc = DSManager.getSRSCache(this.def.getDataSourceName());
                                        SRS srs = sc.get(this.def.getSrid());
                                        log.finest("Theme definition SRID: " + this.def.getSrid());
                                        boolean isGeodetic = false;
                                        String unit = null;
                                        if (srs != null) {
                                            isGeodetic = srs.isGeodetic();
                                            unit = srs.getUnit();
                                        } else if (this.def.getSrid() > 0) {
                                            log.warning("cannot locate an SRS object for srid: " + this.def.getSrid());
                                        }
                                        xi = xl;
                                        xf = xh;
                                        yi = yl;
                                        yf = yh;
                                        double masterScale = vc.getCurrentScale();
                                        transformSRid = false;
                                        if (vc.getMasterSRID() > 0 && this.def.getSrid() > 0 && this.def.getSrid() != vc.getMasterSRID() && this.def.getSrid() != 999999 && masterScale != Double.POSITIVE_INFINITY && masterScale != Double.NEGATIVE_INFINITY) {
                                            double[] inmbr = new double[]{xl, yl, xh, yh};
                                            double[] outmbr = Util.convertMBR(inmbr, vc.getMasterSRID(), this.def.getSrid(), conn);
                                            if (outmbr != null) {
                                                xl = outmbr[0];
                                                yl = outmbr[1];
                                                xh = outmbr[2];
                                                yh = outmbr[3];
                                                transformSRid = true;
                                            } else {
                                                if (this.getTheme().getDecorator().getWorkspaceName() != null) {
                                                    try {
                                                        Util.gotoWorkspace(conn, "LIVE");
                                                    }
                                                    catch (Exception ex) {
                                                        // empty catch block
                                                    }
                                                }
                                                try {
                                                    if (conn != null) {
                                                        DSUtil.closeDBConnection(conn, this.def.getDataSourceName());
                                                    }
                                                }
                                                catch (Exception e) {
                                                    log.warning(e.getMessage());
                                                }
                                                vc.processDataError(null, log, RSBundle.getMsg("MAPVIEWER-01024"));
                                                int e = 0;
                                                return e;
                                            }
                                        }
                                        if (masterScale != Double.POSITIVE_INFINITY && masterScale != Double.NEGATIVE_INFINITY) {
                                            double factor = Math.abs(yh - yl) / Math.abs(yf - yi);
                                            log.finer("[Master scale] " + masterScale + " [Theme scale factor] " + factor);
                                            double scale = masterScale * factor;
                                            if (this.getTheme().getScaleType() == "RATIO") {
                                                double centery;
                                                double centerx;
                                                if (vc.getMasterSRID() > 0 && this.def.getSrid() > 0 && this.def.getSrid() != vc.getMasterSRID()) {
                                                    srs = sc.get(vc.getMasterSRID());
                                                    centerx = (xi + xf) / 2.0;
                                                    centery = (yi + yf) / 2.0;
                                                    factor = 1.0;
                                                } else {
                                                    centerx = (xl + xh) / 2.0;
                                                    centery = (yl + yh) / 2.0;
                                                }
                                                if (vc.isTileRequest() && srs.isGeodetic()) {
                                                    centerx = 0.0;
                                                    centery = 0.0;
                                                }
                                                if (srs != null) {
                                                    scale = Math.round(srs.getRatioScale(masterScale * factor, new Point2D.Double(centerx, centery)));
                                                    log.finer("Ratio scale to compare: " + scale);
                                                } else {
                                                    if (this.getTheme().getDecorator().getWorkspaceName() != null) {
                                                        try {
                                                            Util.gotoWorkspace(conn, "LIVE");
                                                        }
                                                        catch (Exception ex) {
                                                            // empty catch block
                                                        }
                                                    }
                                                    try {
                                                        if (conn != null) {
                                                            DSUtil.closeDBConnection(conn, this.def.getDataSourceName());
                                                        }
                                                    }
                                                    catch (Exception e) {
                                                        log.warning(e.getMessage());
                                                    }
                                                    vc.processDataError(null, log, RSBundle.getMsg("MAPVIEWER-01025"));
                                                    int e = 0;
                                                    return e;
                                                }
                                            }
                                            if (!this.getTheme().withinRenderScaleLimits(scale)) {
                                                log.warning("Scale definition for theme " + this.getTheme().getName() + " is out of range.");
                                                if (this.getTheme().getDecorator().getWorkspaceName() != null) {
                                                    try {
                                                        Util.gotoWorkspace(conn, "LIVE");
                                                    }
                                                    catch (Exception ex) {
                                                        // empty catch block
                                                    }
                                                }
                                                try {
                                                    if (conn != null) {
                                                        DSUtil.closeDBConnection(conn, this.def.getDataSourceName());
                                                    }
                                                }
                                                catch (Exception e) {
                                                    log.warning(e.getMessage());
                                                }
                                                int e = 0;
                                                return e;
                                            }
                                        }
                                        boolean bl = workaround = isGeodetic && xh - xl > 2.0 && xh - xl < 120.0;
                                        if (workaround) {
                                            xl = Math.floor(xl);
                                        }
                                        log.finest("[ " + this.def.getName() + " ]:  " + xl + "," + yl + "," + xh + "," + yh);
                                        applyRotation = false;
                                        if (MapMaker.isSpecial(xl, yl, xh, yh) && vc.getRotation() != 0.0) {
                                            log.warning("Rotation is currently ignored for full extent.");
                                        } else if (vc.getRotation() != 0.0 && !MapMaker.isSpecial(xl, yl, xh, yh)) {
                                            if (vc.getRotation() < -360.0 || vc.getRotation() > 360.0) {
                                                log.warning("Rotation value must be in between -360 to 360 degrees. ignored");
                                            } else {
                                                double[] rmbr = Util.rotateMBR(xl, yl, xh, yh, vc.getRotation());
                                                if (rmbr != null) {
                                                    xl = Math.min(rmbr[0], xl);
                                                    yl = Math.min(rmbr[1], yl);
                                                    xh = Math.max(rmbr[2], xh);
                                                    yh = Math.max(rmbr[3], yh);
                                                    log.finest("Rotation angle: " + vc.getRotation());
                                                    log.finest("Search window for rotation: " + xl + "," + yl + "," + xh + "," + yh);
                                                    applyRotation = true;
                                                } else {
                                                    log.info("Rotated MBR is null. Rotation ignored.");
                                                }
                                            }
                                        }
                                        textQuery = null;
                                        metacolumn = this.getMetaExpression();
                                        textQuery = this.def.isPredefined() ? this.getPredefinedQuery(xl, yl, xh, yh, metacolumn) : this.getDynamicQuery(xl, yl, xh, yh);
                                        log.info("[Annotation Text query]: " + textQuery);
                                        featureSet = new ArrayList<StyledFeatureI>(128);
                                        cnt = 0;
                                        metaStyle = this.getMetadataTextStyle();
                                        if (metaStyle == null) {
                                            log.warning("Metadata text style is null. Set to a default text style.");
                                            metaStyle = (StyleText)StyleFactory.getDefaultTextStyle();
                                        }
                                        Style defaultllStyle = null;
                                        if (this.def.getLeaderLineStyle() != null) {
                                            defaultllStyle = MapMaker.getStyleWithName(this.def.getLeaderLineStyle(), this.def.getDataSourceName(), vc);
                                        }
                                        if (defaultllStyle == null) {
                                            defaultllStyle = StyleFactory.getDefaultStyle(2);
                                        }
                                        llStyle = null;
                                        try {
                                            if (this.leaderlineHighlightColor == null) break block173;
                                            if (defaultllStyle.getModel().getTypeName().equalsIgnoreCase("COLOR")) {
                                                llStyle = (StyleColor)((StyleColor)defaultllStyle).clone();
                                                ((StyleColor)llStyle).setFillColor(this.leaderlineHighlightColor);
                                                ((StyleColor)llStyle).setStrokeColor(this.leaderlineHighlightColor);
                                                break block173;
                                            }
                                            if (defaultllStyle.getModel().getTypeName().equalsIgnoreCase("LINE")) {
                                                llStyle = (StyleLine)((StyleLine)defaultllStyle).clone();
                                                ((LineStyleModel)llStyle.getModel()).setFillColor(this.leaderlineHighlightColor);
                                            }
                                        }
                                        catch (Exception ex) {
                                            // empty catch block
                                        }
                                    }
                                    StyleColor transpStyle = new StyleColor(new Color(0, 0, 0, 0));
                                    dataException = null;
                                    textStmt = null;
                                    rset = null;
                                    t1 = 0L;
                                    t2 = 0L;
                                    try {
                                        int textobjIndex;
                                        int metacolumnIndex;
                                        int totalColCount;
                                        ResultSetMetaData meta;
                                        block180: {
                                            block179: {
                                                textStmt = conn.prepareStatement(textQuery);
                                                int offset = 0;
                                                if (!fullExtent) {
                                                    offset = 4;
                                                    textStmt.setDouble(1, xl);
                                                    textStmt.setDouble(2, yl);
                                                    textStmt.setDouble(3, xh);
                                                    textStmt.setDouble(4, yh);
                                                }
                                                if (this.def.isPredefined && this.bindingParameters != null && this.bindingParameters != null) {
                                                    int countBP = SharedUtils.countBindingVariables(textQuery);
                                                    if (countBP > 0 && this.bindingParameters.length < countBP) {
                                                        if (conn != null) {
                                                            try {
                                                                DSUtil.closeDBConnection(conn, this.def.getDataSourceName());
                                                            }
                                                            catch (Exception e) {
                                                                log.warning(e.getMessage());
                                                            }
                                                        }
                                                        vc.processDataError(null, log, RSBundle.getMsg("MAPVIEWER-01031"));
                                                        int e = 0;
                                                        return e;
                                                    }
                                                    if (countBP > 0) {
                                                        for (int i2 = 0; i2 < countBP; ++i2) {
                                                            this.setBindingVariable(textStmt, this.bindingParameters[i2], offset + i2 + 1);
                                                        }
                                                    }
                                                }
                                                textStmt.setFetchSize(this.owner.getFetchSize());
                                                log.finer("Fetch size: " + textStmt.getFetchSize());
                                                t1 = System.currentTimeMillis();
                                                rset = textStmt.executeQuery();
                                                t2 = System.currentTimeMillis();
                                                meta = rset.getMetaData();
                                                hasAttributes = 0;
                                                totalColCount = meta.getColumnCount();
                                                metacolumnIndex = 0;
                                                textobjIndex = 0;
                                                if (!this.def.isPredefined()) break block179;
                                                textobjIndex = 2;
                                                if (metacolumn != null) {
                                                    metacolumnIndex = 3;
                                                    if (totalColCount > 3) {
                                                        hasAttributes = 1;
                                                    }
                                                    break block180;
                                                } else if (totalColCount > 2) {
                                                    hasAttributes = 1;
                                                }
                                                break block180;
                                            }
                                            String defaultTextColumn = this.def.getDefaultTextExpressionColumn();
                                            String spatialCol = this.def.getTextColumn();
                                            if (this.def.getBaseColumnAlias() != null) {
                                                spatialCol = this.def.getBaseColumnAlias();
                                            }
                                            for (i = 0; i < totalColCount; ++i) {
                                                if (spatialCol != null && meta.getColumnName(i + 1).equalsIgnoreCase(spatialCol)) {
                                                    textobjIndex = i + 1;
                                                }
                                                if (defaultTextColumn == null || !meta.getColumnName(i + 1).equalsIgnoreCase(defaultTextColumn)) continue;
                                                metacolumnIndex = i + 1;
                                            }
                                            if (textobjIndex == 0) {
                                                dataException = "Annotation text column not found [" + this.getTheme().getName() + "].";
                                                vc.processDataError(null, log, dataException);
                                                i = 0;
                                                if (this.getTheme().getDecorator().getWorkspaceName() == null) break block174;
                                                break block175;
                                            }
                                            if (defaultTextColumn != null && defaultTextColumn.length() > 0 && metacolumnIndex == 0) {
                                                dataException = "Text expression column [" + defaultTextColumn + "] not found" + " [" + this.getTheme().getName() + "].";
                                                vc.processDataError(null, log, dataException);
                                                i = 0;
                                                if (this.getTheme().getDecorator().getWorkspaceName() == null) break block176;
                                                break block177;
                                            }
                                            if (metacolumnIndex > 0 && totalColCount > 2 || metacolumnIndex == 0 && totalColCount > 1) {
                                                hasAttributes = 1;
                                            }
                                        }
                                        String column = this.def.getTextColumn();
                                        if (!this.def.isPredefined() && this.def.getBaseColumnAlias() != null) {
                                            column = this.def.getBaseColumnAlias();
                                        }
                                        while (rset.next() && (this.maxFeaturesToBePrepared <= 0L || (long)featureSet.size() < this.maxFeaturesToBePrepared)) {
                                            AnnotationTextElement[] elems;
                                            AnnotationText antext;
                                            String id = null;
                                            if (this.def.isPredefined() && this.def.getKeyColumn() != null) {
                                                id = rset.getString(this.def.getKeyColumn());
                                            }
                                            if ((antext = this.loadAnnotation(id, rset, column)) == null || (elems = antext.getElements()) == null || elems.length <= 0) continue;
                                            String previousText = this.def.getMetadataExpression();
                                            if (metacolumnIndex > 0) {
                                                previousText = rset.getString(metacolumnIndex);
                                            }
                                            for (int i3 = 0; i3 < elems.length; ++i3) {
                                                JGeometry leaderline;
                                                StyledFeatureI sf2;
                                                String textValue = elems[i3].getValue();
                                                if (textValue == null) {
                                                    textValue = previousText;
                                                } else {
                                                    previousText = textValue;
                                                }
                                                if (textValue == null) continue;
                                                JGeometry location = elems[i3].getLocation();
                                                if (location != null) {
                                                    StyleText elemStyle = AnnotationTextThemeProducer.getTextStyle(elems[i3].getAttributes());
                                                    if (elemStyle == null) {
                                                        elemStyle = metaStyle;
                                                    }
                                                    if (this.textHighlightColor != null && elemStyle != null) {
                                                        ((TextStyleModel)elemStyle.getModel()).setColor(this.textHighlightColor);
                                                    }
                                                    if (!fullExtent && !Double.isNaN(this.def.getMapBaseScale()) && this.def.getMapBaseScale() > 0.0) {
                                                        double inmeter = this.def.getMapBaseScale() * 0.0254 / vc.getDPI();
                                                        float fsize = elemStyle.getFont().getSize2D();
                                                        SizeDefinition sizeDef = new SizeDefinition(fsize *= (float)inmeter, "m");
                                                        if (sizeDef != null) {
                                                            ((TextStyleModel)elemStyle.getModel()).setFontSize((float)sizeDef.getValue(), sizeDef.getUnit());
                                                        }
                                                    }
                                                    sf2 = this.getNewStyledFeatureInstance();
                                                    JSDOGeometry locGeom = JSDOGeometry.recast(location);
                                                    sf2.setGeometry(locGeom);
                                                    sf2.setFeatureStyle(transpStyle);
                                                    sf2.setLabel(textValue);
                                                    sf2.setLabelStyle(elemStyle);
                                                    sf2.setForceLabel(true);
                                                    sf2.setLabelAsOrientedPoint(true);
                                                    sf2.setDataSource(this.def.getDataSourceName());
                                                    sf2.setID(id);
                                                    sf2.setElementPosition(i3);
                                                    if (hasAttributes != 0) {
                                                        this.fillAttributes(sf2, meta, rset, totalColCount, textobjIndex, metacolumnIndex);
                                                    }
                                                    featureSet.add(sf2);
                                                    if (++cnt % 20 == 0) {
                                                        Thread.currentThread();
                                                        Thread.yield();
                                                    }
                                                    this.addAnchorLocationFeature(featureSet, locGeom);
                                                }
                                                if ((leaderline = elems[i3].getLeaderLine()) == null) continue;
                                                sf2 = this.getNewStyledFeatureInstance();
                                                sf2.setGeometry(JSDOGeometry.recast(leaderline));
                                                sf2.setFeatureStyle(llStyle);
                                                sf2.setFeatureStyleName(this.def.getLeaderLineStyle());
                                                sf2.setDataSource(this.def.getDataSourceName());
                                                sf2.setID(id);
                                                sf2.setElementPosition(i3);
                                                if (hasAttributes != 0) {
                                                    this.fillAttributes(sf2, meta, rset, totalColCount, textobjIndex, metacolumnIndex);
                                                }
                                                featureSet.add(sf2);
                                            }
                                        }
                                        if (MapMaker.isSpecial(xl, yl, xh, yh)) {
                                            this.loadNewFeatures(featureSet, metaStyle, fullExtent, vc);
                                        } else {
                                            Rectangle2D.Double rc = new Rectangle2D.Double(xl, yl, xh - xl, yh - yl);
                                            this.loadEditFeatures(rc, featureSet, metaStyle, vc);
                                        }
                                        if (this.getTheme().getDecorator().getWorkspaceName() != null) {
                                        }
                                        break block178;
                                    }
                                    catch (Exception e) {
                                        log.severe(e.getMessage());
                                        throw new DataException(e);
                                    }
                                }
                                try {
                                    Util.gotoWorkspace(conn, "LIVE");
                                }
                                catch (Exception ex) {
                                    // empty catch block
                                }
                            }
                            try {
                                if (rset != null) {
                                    rset.close();
                                }
                            }
                            catch (Exception ex) {
                                log.warning(ex.getMessage());
                            }
                            try {
                                if (textStmt != null) {
                                    textStmt.close();
                                }
                            }
                            catch (Exception ex) {
                                log.warning(ex.getMessage());
                            }
                            try {
                                if (conn != null) {
                                    DSUtil.closeDBConnection(conn, this.def.getDataSourceName());
                                }
                            }
                            catch (Exception ex) {
                                // empty catch block
                            }
                            if (dataException == null) return i;
                            throw new DataException(dataException);
                        }
                        try {
                            Util.gotoWorkspace(conn, "LIVE");
                        }
                        catch (Exception ex) {
                            // empty catch block
                        }
                    }
                    try {
                        if (rset != null) {
                            rset.close();
                        }
                    }
                    catch (Exception ex) {
                        log.warning(ex.getMessage());
                    }
                    try {
                        if (textStmt != null) {
                            textStmt.close();
                        }
                    }
                    catch (Exception ex) {
                        log.warning(ex.getMessage());
                    }
                    try {
                        if (conn != null) {
                            DSUtil.closeDBConnection(conn, this.def.getDataSourceName());
                        }
                    }
                    catch (Exception ex) {
                        // empty catch block
                    }
                    if (dataException == null) return i;
                    throw new DataException(dataException);
                    try {
                        Util.gotoWorkspace(conn, "LIVE");
                    }
                    catch (Exception ex) {
                        // empty catch block
                    }
                }
                try {
                    if (rset != null) {
                        rset.close();
                    }
                }
                catch (Exception ex) {
                    log.warning(ex.getMessage());
                }
                try {
                    if (textStmt != null) {
                        textStmt.close();
                    }
                }
                catch (Exception ex) {
                    log.warning(ex.getMessage());
                }
                try {
                    if (conn != null) {
                        DSUtil.closeDBConnection(conn, this.def.getDataSourceName());
                    }
                }
                catch (Exception ex) {
                    // empty catch block
                }
                if (dataException != null) {
                    throw new DataException(dataException);
                }
                break block181;
                finally {
                    if (this.getTheme().getDecorator().getWorkspaceName() != null) {
                        try {
                            Util.gotoWorkspace(conn, "LIVE");
                        }
                        catch (Exception ex) {}
                    }
                    try {
                        if (rset != null) {
                            rset.close();
                        }
                    }
                    catch (Exception ex) {
                        log.warning(ex.getMessage());
                    }
                    try {
                        if (textStmt != null) {
                            textStmt.close();
                        }
                    }
                    catch (Exception ex) {
                        log.warning(ex.getMessage());
                    }
                    try {
                        if (conn != null) {
                            DSUtil.closeDBConnection(conn, this.def.getDataSourceName());
                        }
                    }
                    catch (Exception ex) {}
                    if (dataException != null) {
                        throw new DataException(dataException);
                    }
                }
            }
            if (featureSet.size() <= 0) {
                long t3 = System.currentTimeMillis();
                log.info("[ " + this.def.name + " ] sql exec time: " + (t2 - t1) + "ms, loading time for 0 features: " + (t3 - t2) + "ms.");
                TopThemeQueries.add(t3 - t1, this.getTheme().getName(), this.getTheme().getDataSourceName(), textQuery, "features loaded = 0");
                hasAttributes = 0;
                return hasAttributes;
            }
            if (transformSRid) {
                log.info("Transforming styled features SRID " + this.def.getSrid() + " to map SRID " + vc.getMasterSRID());
                for (int i = 0; i < featureSet.size(); ++i) {
                    sf = (StyledFeatureI)featureSet.get(i);
                    JSDOGeometry jgeom = sf.getGeometry();
                    if (jgeom == null || jgeom.getSRID() <= 0 || jgeom.getSRID() == vc.getMasterSRID()) continue;
                    JGeometry geom = null;
                    try {
                        geom = Util.processSRIDConversion(this.owner.getDataSourceName(), jgeom, vc.getMasterSRID());
                    }
                    catch (Exception e) {
                        geom = null;
                    }
                    if (geom == null) continue;
                    sf.setGeometry(JSDOGeometry.recast(geom));
                }
                log.info("End of SRID transformation.");
                xl = xi;
                xh = xf;
                yl = yi;
                yh = yf;
            }
            if (applyRotation) {
                log.info("Rotating styled feature geometries.");
                for (int i = 0; i < featureSet.size(); ++i) {
                    JGeometry geomRot;
                    sf = (StyledFeatureI)featureSet.get(i);
                    JSDOGeometry jgeom = sf.getGeometry();
                    if (jgeom == null || (geomRot = Util.rotateGeometry(jgeom, (xl + xh) / 2.0, (yl + yh) / 2.0, vc.getRotation())) == null || (jgeom = JSDOGeometry.recast(geomRot)) == null) continue;
                    sf.setGeometry(JSDOGeometry.recast(jgeom));
                }
            }
            this.setStyledFeatures(featureSet);
            featureSet = null;
            long t3 = System.currentTimeMillis();
            log.info("[ " + this.def.name + " ] sql exec time: " + (t2 - t1) + "ms, loading time for " + this.features.size() + " features: " + (t3 - t2) + "ms.");
            TopThemeQueries.add(t3 - t1, this.getTheme().getName(), this.getTheme().getDataSourceName(), textQuery, "features loaded = " + this.features.size());
            int n = this.features.size();
            return n;
        }
        finally {
            annotationSensor.stop(tokenA);
        }
    }

    protected String getDynamicQuery(double xl, double yl, double xh, double yh) {
        String querystr = this.def.getQuery();
        if (querystr == null) {
            return null;
        }
        if (this.def.passThrough || xl == Double.NEGATIVE_INFINITY || yl == Double.NEGATIVE_INFINITY || xh == Double.POSITIVE_INFINITY || yh == Double.POSITIVE_INFINITY) {
            return querystr;
        }
        String filter = this.getFilter(this.def.getTextColumn(), this.def.getSrid());
        return "SELECT * FROM ( " + querystr + " ) mv_antext WHERE " + filter;
    }

    private String getPredefinedQuery(double xl, double yl, double xh, double yh, String metacolumn) {
        StylingRule[] rules = this.def.getStylingRules();
        String cond = rules != null && rules.length > 0 ? rules[0].getFeatureCond() : null;
        boolean ruleAttrs = false;
        String attrs = "";
        if (rules != null && rules.length > 0) {
            String atrcols = rules[0].getAttributeColumns();
            if (atrcols != null && atrcols.trim().length() > 0) {
                attrs = "," + rules[0].getAttributeColumns().trim();
            }
            ruleAttrs = true;
        }
        if (this.def != null && this.def.getIdentifiableColumns() != null) {
            Field[] infoCols = this.def.getIdentifiableColumns();
            for (int k = 0; k < infoCols.length; ++k) {
                if (this.columnDefinedInStylingRules(infoCols[k].getName())) continue;
                attrs = attrs + "," + infoCols[k].getName();
            }
        }
        metacolumn = metacolumn != null ? "," + metacolumn : "";
        String subQuery = "select " + this.def.getKeyColumn() + ",mv_antext." + this.def.getTextColumn() + metacolumn + attrs + " from " + this.def.getBaseTable() + " mv_antext";
        String filter = null;
        if (!this.def.getFilterUse() && xl != Double.NEGATIVE_INFINITY && yl != Double.NEGATIVE_INFINITY && xh != Double.POSITIVE_INFINITY && yh != Double.POSITIVE_INFINITY) {
            filter = this.getFilter(this.def.getTextColumn(), this.def.getSrid());
        }
        if (filter != null) {
            subQuery = subQuery + " WHERE " + filter;
            if (cond != null) {
                subQuery = subQuery + " AND " + cond;
            }
        } else if (cond != null) {
            subQuery = subQuery + " WHERE " + cond;
        }
        return subQuery;
    }

    private String getMetaExpression() {
        String metaexpr;
        if (this.def.isPredefined() && (metaexpr = this.def.getMetadataExpression()) != null && metaexpr.trim().length() > 0) {
            if (metaexpr.startsWith("'") && metaexpr.endsWith("'")) {
                return metaexpr.trim();
            }
            ArrayList<String> cols = this.def.getTableColumns();
            if (cols != null && cols.size() > 0) {
                for (int i = 0; i < cols.size(); ++i) {
                    if (metaexpr.trim().toUpperCase().indexOf(cols.get(i).toUpperCase()) <= -1) continue;
                    return metaexpr;
                }
                return "'" + metaexpr.trim() + "'";
            }
        }
        return null;
    }

    final String getFilter(String spatialColumn, int srid) {
        StringBuffer sb = new StringBuffer(256);
        String column = spatialColumn;
        if (!this.def.isPredefined() && this.def.getBaseColumnAlias() != null) {
            column = this.def.getBaseColumnAlias();
        }
        sb.append("MDSYS.SDO_FILTER(mv_antext." + column + ".privateenvelope, " + "MDSYS.SDO_GEOMETRY(2003, ");
        if (srid == 0) {
            sb.append("NULL");
        } else {
            sb.append(srid);
        }
        sb.append(", NULL, MDSYS.SDO_ELEM_INFO_ARRAY(1, 1003, 3), MDSYS.SDO_ORDINATE_ARRAY(?,?,?,?))) = 'TRUE'");
        return sb.toString();
    }

    @Override
    public void destroy() {
        if (this.features != null) {
            this.features.destroy();
        }
        this.features = null;
    }

    @Override
    public void abort() {
        this.aborted = true;
    }

    private void clearFeatures() {
        if (this.features != null) {
            this.features.setStyledFeatures((List)null);
        }
    }

    @Override
    public StyledFeatureI[] getStyledFeatures() {
        if (this.features == null) {
            return null;
        }
        return this.features.getStyledFeatures();
    }

    @Override
    public StyledFeatureI getStyledFeature(int idx) {
        if (this.features == null) {
            return null;
        }
        return this.features.getStyledFeature(idx);
    }

    @Override
    public double[] getDataMBR() {
        if (this.features == null) {
            return null;
        }
        return this.features.getDataMBR();
    }

    @Override
    public LocalTheme getSelectedFeaturesAsTheme(Rectangle2D window, String name) {
        if (this.features == null) {
            return null;
        }
        return this.features.getSelectedFeaturesAsTheme(window, name);
    }

    @Override
    public StyledFeatureI[] getSelectedFeatures(Rectangle2D window) {
        if (this.features == null) {
            return null;
        }
        return this.features.getSelectedFeatures(window);
    }

    public void setStyledFeatures(ArrayList sfs) {
        this.features = new LocalThemeDataProducer(this.getTheme());
        this.features.setStyledFeatures(sfs);
    }

    @Override
    public void setStyledFeatures(StyledFeatureI[] sfs) {
        this.features = new LocalThemeDataProducer(this.getTheme());
        this.features.setStyledFeatures(sfs);
    }

    @Override
    public int size() {
        return this.features != null ? this.features.size() : 0;
    }

    @Override
    public void postPreparation(VisContext vc) {
        if (this.features != null) {
            this.features.postPreparation(vc);
        }
    }

    @Override
    public Theme getTheme() {
        return this.owner;
    }

    @Override
    public StyledFeatureI getNewStyledFeatureInstance() {
        return new StyledFeature();
    }

    private boolean isFullExtent(boolean passThrough, double xl, double yl, double xh, double yh) {
        return passThrough || Double.isInfinite(xl) || Double.isNaN(xl) || Double.isInfinite(yl) || Double.isNaN(yl) || Double.isInfinite(xh) || Double.isNaN(xh) || Double.isInfinite(yh) || Double.isNaN(yh);
    }

    private StyleText getMetadataTextStyle() {
        String metaattrs = this.def.getMetadataAttributes();
        if (metaattrs == null) {
            return null;
        }
        try {
            if (this.jc == null) {
                this.jc = JAXBContext.newInstance((String)"oracle.sdovis.text.jaxb");
                this.u = this.jc.createUnmarshaller();
            }
            StringBuffer xmlStr = new StringBuffer(metaattrs);
            JAXBElement jaxbEl = (JAXBElement)this.u.unmarshal((InputStream)new ByteArrayInputStream(xmlStr.toString().getBytes()));
            TextAttributesType txtattrs = (TextAttributesType)jaxbEl.getValue();
            return AnnotationTextThemeProducer.getTextStyle(txtattrs);
        }
        catch (Exception e) {
            e.printStackTrace();
            log.warning("Unable to build text style for metadata.");
            return null;
        }
    }

    public static StyleText getTextStyle(TextAttributesType textAttrs) {
        if (textAttrs == null) {
            return null;
        }
        TextStyle style = textAttrs.getTextStyle();
        if (style == null) {
            return null;
        }
        String fname = style.getFontFamily();
        if (fname == null || fname.length() == 0) {
            return null;
        }
        float fsize = style.getFontSize();
        FontStyle fstyle = style.getFontStyle();
        boolean italic = false;
        if (fstyle != null && fstyle.value().equalsIgnoreCase("Italics")) {
            italic = true;
        }
        boolean bold = false;
        String fweight = style.getFontWeight();
        if (fweight != null && (fweight.equalsIgnoreCase("Bold") || fweight.equalsIgnoreCase("400"))) {
            bold = true;
        }
        int fmode = 0;
        if (bold && italic) {
            fmode = 3;
        } else if (bold) {
            fmode = 1;
        } else if (italic) {
            fmode = 2;
        }
        Font font = new Font(fname, fmode, (int)fsize);
        String textDecor = style.getTextDecoration().value();
        String ltspacing = style.getLetterSpacing();
        float ltspace = -1.0f;
        if (ltspacing != null && !ltspacing.equalsIgnoreCase("normal")) {
            try {
                ltspace = Float.parseFloat(ltspacing);
            }
            catch (Exception e) {
                ltspace = -1.0f;
            }
        }
        String wordspacing = style.getWordSpacing();
        String fillColor = style.getFill();
        float fillOpacity = style.getFillOpacity();
        Color fillC = AnnotationTextThemeProducer.getColor(fillColor);
        if (fillC == null) {
            fillC = Color.black;
        }
        String strokeColor = style.getStroke();
        float strokeWidth = style.getStrokeWidth();
        float strokeOpacity = style.getStrokeOpacity();
        Textlayout layout = textAttrs.getTextlayout();
        String hallign = "start";
        String vallign = "top";
        String multilinejustification = "left";
        float multilinespacing = 0.0f;
        if (layout != null) {
            hallign = layout.getHorizontalAlignment();
            vallign = layout.getVerticalAlignment();
            multilinejustification = layout.getMultilineJustification();
            multilinespacing = layout.getMultilineSpacing();
        }
        StyleText styleTxt = new StyleText(font, fillC, -1.0f);
        ((TextStyleModel)styleTxt.getModel()).setFontSizes(new SizeDefinition2D(fsize, -1.0, null));
        if (ltspace != -1.0f) {
            ((TextStyleModel)styleTxt.getModel()).setLetterSpacing(ltspace);
        }
        Object vertallign = LabelingHints.VALUE_LINE_VALIGN_TOP;
        if (vallign != null && vallign.equalsIgnoreCase("center")) {
            vertallign = LabelingHints.VALUE_LINE_VALIGN_MIDDLE;
        } else if (vallign != null && vallign.equalsIgnoreCase("baseline")) {
            vertallign = LabelingHints.VALUE_LINE_VALIGN_BASELINE;
        } else if (vallign != null && vallign.equalsIgnoreCase("bottom")) {
            vertallign = LabelingHints.VALUE_LINE_VALIGN_BOTTOM;
        }
        LabelingHints hints = ((TextStyleModel)styleTxt.getModel()).getLabelingHints();
        hints.put(LabelingHints.KEY_LINE_VALIGN, vertallign);
        Object horizallign = LabelingHints.VALUE_OPOINT_HALIGN_START;
        if (hallign != null && hallign.equalsIgnoreCase("center")) {
            horizallign = LabelingHints.VALUE_OPOINT_HALIGN_CENTER;
        } else if (hallign != null && hallign.equalsIgnoreCase("end")) {
            horizallign = LabelingHints.VALUE_OPOINT_HALIGN_END;
        }
        Object opvertallign = LabelingHints.VALUE_OPOINT_VALIGN_TOP;
        if (vallign != null && vallign.equalsIgnoreCase("center")) {
            opvertallign = LabelingHints.VALUE_OPOINT_VALIGN_MIDDLE;
        } else if (vallign != null && (vallign.equalsIgnoreCase("bottom") || vallign.equalsIgnoreCase("baseline"))) {
            opvertallign = LabelingHints.VALUE_OPOINT_VALIGN_BOTTOM;
        }
        hints.put(LabelingHints.KEY_OPOINT_HALIGN, horizallign);
        hints.put(LabelingHints.KEY_OPOINT_VALIGN, opvertallign);
        if (layout != null) {
            ((TextStyleModel)styleTxt.getModel()).setMultilineSpacing(multilinespacing);
            Object multilineallign = LabelingHints.VALUE_MULTILINE_TEXT_ALIGN_LEFT;
            if (multilinejustification.equalsIgnoreCase("center")) {
                multilineallign = LabelingHints.VALUE_MULTILINE_TEXT_ALIGN_CENTER;
            } else if (multilinejustification.equalsIgnoreCase("right")) {
                multilineallign = LabelingHints.VALUE_MULTILINE_TEXT_ALIGN_RIGHT;
            }
            hints.put(LabelingHints.KEY_MULTILINE_TEXT_ALIGN, multilineallign);
        }
        ((TextStyleModel)styleTxt.getModel()).setTextDecoration(textDecor);
        ((TextStyleModel)styleTxt.getModel()).setHonorNewline(true);
        return styleTxt;
    }

    private static Color getColor(String colorValue) {
        Color color = StyleUtils.getColor(colorValue);
        if (color == null) {
            color = StyleUtils.getColorFromRGB(colorValue);
        }
        return color;
    }

    protected void fillAttributes(StyledFeatureI sf, ResultSetMetaData meta, ResultSet rs, int totalCol, int textobjIndex, int metacolIndex) throws SQLException, IOException {
        int start = 1;
        if (this.def.isPredefined()) {
            start = 2;
        }
        Vector<Field> v = new Vector<Field>();
        for (int i = start; i < totalCol + 1; ++i) {
            if (i == textobjIndex || i == metacolIndex) continue;
            Field attr = null;
            String name = meta.getColumnName(i);
            int sqlType = meta.getColumnType(i);
            attr = Util.getFieldFromResultSet(sqlType, rs, i);
            attr.setName(name);
            v.add(attr);
        }
        Field[] iAttrs = this.def.getIdentifiableColumns();
        if (iAttrs == null) {
            sf.setRenderableAttributes(v.toArray(new Field[v.size()]));
        } else {
            Field[] myIAttrs = new Field[iAttrs.length];
            block1: for (int i = 0; i < iAttrs.length; ++i) {
                Field a = iAttrs[i];
                String name = a.getName();
                for (int c = 0; c < v.size(); ++c) {
                    Field ca = (Field)v.get(c);
                    if (!name.equalsIgnoreCase(ca.getName())) continue;
                    myIAttrs[i] = ca;
                    ca.setDisplayName(a.getDisplayName());
                    if (this.columnDefinedInStylingRules(a.getName())) continue block1;
                    v.remove(c);
                    continue block1;
                }
            }
            sf.setIdentifiableAttributes(myIAttrs);
            if (v.size() > 0) {
                sf.setRenderableAttributes(v.toArray(new Field[v.size()]));
            }
        }
    }

    private boolean columnDefinedInStylingRules(String col) {
        StylingRule[] rules = this.def.getStylingRules();
        if (rules == null) {
            return false;
        }
        for (int i = 0; i < rules.length; ++i) {
            String[] columns = rules[i].getAttributeColumnsAsArray();
            if (columns == null) continue;
            for (int j = 0; j < columns.length; ++j) {
                if (!col.equalsIgnoreCase(columns[i])) continue;
                return true;
            }
        }
        return false;
    }

    protected AnnotationText loadAnnotation(String key, ResultSet rset, String column) {
        try {
            if (rset == null || column == null) {
                return null;
            }
            return JDBCUtil.loadAnnotationText(rset, column);
        }
        catch (Exception ex) {
            return null;
        }
    }

    protected void loadNewFeatures(ArrayList featVector, StyleText metaStyle, boolean fullExtent, VisContext vc) {
    }

    protected void loadEditFeatures(Rectangle2D mbr, ArrayList featVector, StyleText metaStyle, VisContext vc) {
    }

    protected void addAnchorLocationFeature(ArrayList featVector, JSDOGeometry geom) {
    }

    private void setBindingVariable(PreparedStatement stmt, Object var, int idx) throws SQLException, IllegalArgumentException {
        if (var instanceof String) {
            stmt.setString(idx, (String)var);
        } else if (var instanceof Integer) {
            stmt.setInt(idx, (Integer)var);
        } else if (var instanceof Double) {
            stmt.setDouble(idx, (Double)var);
        } else if (var instanceof Float) {
            stmt.setFloat(idx, ((Float)var).floatValue());
        } else if (var instanceof Long) {
            stmt.setLong(idx, (Long)var);
        } else if (var instanceof Short) {
            stmt.setShort(idx, (Short)var);
        } else if (var instanceof Byte) {
            stmt.setByte(idx, (Byte)var);
        } else if (var instanceof BigDecimal) {
            stmt.setBigDecimal(idx, (BigDecimal)var);
        } else if (var instanceof byte[]) {
            stmt.setBytes(idx, (byte[])var);
        } else if (var instanceof Date) {
            stmt.setDate(idx, (Date)var);
        } else if (var instanceof Time) {
            stmt.setTime(idx, (Time)var);
        } else if (var instanceof Timestamp) {
            stmt.setTimestamp(idx, (Timestamp)var);
        } else {
            throw new IllegalArgumentException("Binding data type not supported:" + var.getClass().toString());
        }
    }

    public Color getTextHighlightColor() {
        return this.textHighlightColor;
    }

    public void setTextHighlightColor(Color c) {
        this.textHighlightColor = c;
    }

    public Color getLeaderLineHighlightColor() {
        return this.leaderlineHighlightColor;
    }

    public void setLeaderLineHighlightColor(Color c) {
        this.leaderlineHighlightColor = c;
    }

    public void resetHighlightColors() {
        this.textHighlightColor = null;
        this.leaderlineHighlightColor = null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public AnnotationTextFeature[] getAnnotationTextFeatures(Rectangle2D queryWin, VisContext vc) throws DataException {
        long t2;
        long t1;
        ArrayList<AnnotationTextFeature> featureSet;
        String textQuery;
        block117: {
            ResultSet rset;
            PreparedStatement textStmt;
            String dataException;
            Connection conn;
            block114: {
                AnnotationTextFeature[] i22;
                block112: {
                    block113: {
                        AnnotationTextFeature[] i22;
                        block110: {
                            block111: {
                                boolean workaround;
                                boolean fullExtent;
                                double yh;
                                double xh;
                                double yl;
                                double xl;
                                block109: {
                                    this.aborted = false;
                                    xl = queryWin.getMinX();
                                    yl = queryWin.getMinY();
                                    xh = queryWin.getMaxX();
                                    yh = queryWin.getMaxY();
                                    fullExtent = this.isFullExtent(this.def.getFilterUse(), xl, yl, xh, yh);
                                    conn = null;
                                    try {
                                        conn = DSUtil.getDBConnection(this.def.getDataSourceName(), vc);
                                    }
                                    catch (Exception e) {
                                        log.warning(e.getMessage());
                                        throw new DataException("cannot obtain a connection to database.");
                                    }
                                    if (this.getTheme().getDecorator().getWorkspaceName() != null) {
                                        try {
                                            if (this.getTheme().getDecorator().getWorkspaceName() == null) break block109;
                                            if (this.getTheme().getDecorator().getWorkspaceDate() != null) {
                                                Util.gotoWorkspaceDate(conn, this.getTheme().getDecorator().getWorkspaceName(), this.getTheme().getDecorator().getWorkspaceDate(), this.getTheme().getDecorator().getWorkspaceDateFormat(), this.getTheme().getDecorator().getWorkspaceDateNlsParam(), this.getTheme().getDecorator().isWorkspaceDateTsWtz());
                                                break block109;
                                            }
                                            if (this.getTheme().getDecorator().getWorkspaceSavedPoint() != null) {
                                                Util.gotoWorkspaceSavedPoint(conn, this.getTheme().getDecorator().getWorkspaceName(), this.getTheme().getDecorator().getWorkspaceSavedPoint());
                                            } else {
                                                Util.gotoWorkspace(conn, this.getTheme().getDecorator().getWorkspaceName());
                                            }
                                        }
                                        catch (Exception e) {
                                            log.severe(e.getMessage());
                                            String err = "Cannot go to workspace " + this.getTheme().getDecorator().getWorkspaceName();
                                            if (this.getTheme().getDecorator().getWorkspaceDate() != null) {
                                                err = err + ", Date " + this.getTheme().getDecorator().getWorkspaceDate();
                                                throw new DataException(err);
                                            }
                                            if (this.getTheme().getDecorator().getWorkspaceSavedPoint() == null) throw new DataException(err);
                                            err = err + ", Saved Point " + this.getTheme().getDecorator().getWorkspaceSavedPoint();
                                            throw new DataException(err);
                                        }
                                    }
                                }
                                SRSCache sc = DSManager.getSRSCache(this.def.getDataSourceName());
                                SRS srs = sc.get(this.def.getSrid());
                                log.finest("Theme definition SRID: " + this.def.getSrid());
                                boolean isGeodetic = false;
                                String unit = null;
                                if (srs != null) {
                                    isGeodetic = srs.isGeodetic();
                                    unit = srs.getUnit();
                                } else if (this.def.getSrid() > 0) {
                                    log.warning("cannot locate an SRS object for srid: " + this.def.getSrid());
                                }
                                double masterScale = vc.getCurrentScale();
                                boolean transformSRid = false;
                                if (vc.getMasterSRID() > 0 && this.def.getSrid() > 0 && this.def.getSrid() != vc.getMasterSRID() && this.def.getSrid() != 999999 && masterScale != Double.POSITIVE_INFINITY && masterScale != Double.NEGATIVE_INFINITY) {
                                    double[] inmbr = new double[]{xl, yl, xh, yh};
                                    double[] outmbr = Util.convertMBR(inmbr, vc.getMasterSRID(), this.def.getSrid(), conn);
                                    if (outmbr != null) {
                                        xl = outmbr[0];
                                        yl = outmbr[1];
                                        xh = outmbr[2];
                                        yh = outmbr[3];
                                        transformSRid = true;
                                    } else {
                                        if (this.getTheme().getDecorator().getWorkspaceName() != null) {
                                            try {
                                                Util.gotoWorkspace(conn, "LIVE");
                                            }
                                            catch (Exception ex) {
                                                // empty catch block
                                            }
                                        }
                                        try {
                                            if (conn != null) {
                                                DSUtil.closeDBConnection(conn, this.def.getDataSourceName());
                                            }
                                        }
                                        catch (Exception e) {
                                            log.warning(e.getMessage());
                                        }
                                        vc.processDataError(null, log, RSBundle.getMsg("MAPVIEWER-01024"));
                                        return null;
                                    }
                                }
                                boolean bl = workaround = isGeodetic && xh - xl > 2.0 && xh - xl < 120.0;
                                if (workaround) {
                                    xl = Math.floor(xl);
                                }
                                log.finest("[ " + this.def.getName() + " ]:  " + xl + "," + yl + "," + xh + "," + yh);
                                textQuery = null;
                                String metacolumn = this.getMetaExpression();
                                textQuery = this.def.isPredefined() ? this.getPredefinedQuery(xl, yl, xh, yh, metacolumn) : this.getDynamicQuery(xl, yl, xh, yh);
                                log.info("[Annotation Text query]: " + textQuery);
                                featureSet = new ArrayList<AnnotationTextFeature>();
                                dataException = null;
                                textStmt = null;
                                rset = null;
                                t1 = 0L;
                                t2 = 0L;
                                try {
                                    int textobjIndex;
                                    int metacolumnIndex;
                                    int totalColCount;
                                    boolean hasAttributes;
                                    ResultSetMetaData meta;
                                    block116: {
                                        block115: {
                                            textStmt = conn.prepareStatement(textQuery);
                                            int offset = 0;
                                            if (!fullExtent) {
                                                offset = 4;
                                                textStmt.setDouble(1, xl);
                                                textStmt.setDouble(2, yl);
                                                textStmt.setDouble(3, xh);
                                                textStmt.setDouble(4, yh);
                                            }
                                            if (this.def.isPredefined && this.bindingParameters != null && this.bindingParameters != null) {
                                                int countBP = SharedUtils.countBindingVariables(textQuery);
                                                if (countBP > 0 && this.bindingParameters.length < countBP) {
                                                    if (conn != null) {
                                                        try {
                                                            DSUtil.closeDBConnection(conn, this.def.getDataSourceName());
                                                        }
                                                        catch (Exception e) {
                                                            log.warning(e.getMessage());
                                                        }
                                                    }
                                                    vc.processDataError(null, log, RSBundle.getMsg("MAPVIEWER-01031"));
                                                    AnnotationTextFeature[] e = null;
                                                    return e;
                                                }
                                                if (countBP > 0) {
                                                    for (int i3 = 0; i3 < countBP; ++i3) {
                                                        this.setBindingVariable(textStmt, this.bindingParameters[i3], offset + i3 + 1);
                                                    }
                                                }
                                            }
                                            textStmt.setFetchSize(this.owner.getFetchSize());
                                            log.finer("Fetch size: " + textStmt.getFetchSize());
                                            t1 = System.currentTimeMillis();
                                            rset = textStmt.executeQuery();
                                            t2 = System.currentTimeMillis();
                                            meta = rset.getMetaData();
                                            hasAttributes = false;
                                            totalColCount = meta.getColumnCount();
                                            metacolumnIndex = 0;
                                            textobjIndex = 0;
                                            if (!this.def.isPredefined()) break block115;
                                            textobjIndex = 2;
                                            if (metacolumn != null) {
                                                metacolumnIndex = 3;
                                                if (totalColCount > 3) {
                                                    hasAttributes = true;
                                                }
                                                break block116;
                                            } else if (totalColCount > 2) {
                                                hasAttributes = true;
                                            }
                                            break block116;
                                        }
                                        String defaultTextColumn = this.def.getDefaultTextExpressionColumn();
                                        String spatialCol = this.def.getTextColumn();
                                        if (this.def.getBaseColumnAlias() != null) {
                                            spatialCol = this.def.getBaseColumnAlias();
                                        }
                                        for (int i22 = 0; i22 < totalColCount; ++i22) {
                                            if (spatialCol != null && meta.getColumnName(i22 + 1).equalsIgnoreCase(spatialCol)) {
                                                textobjIndex = i22 + 1;
                                            }
                                            if (defaultTextColumn == null || !meta.getColumnName(i22 + 1).equalsIgnoreCase(defaultTextColumn)) continue;
                                            metacolumnIndex = i22 + 1;
                                        }
                                        if (textobjIndex == 0) {
                                            dataException = "Annotation text column not found [" + this.getTheme().getName() + "].";
                                            vc.processDataError(null, log, dataException);
                                            i22 = null;
                                            if (this.getTheme().getDecorator().getWorkspaceName() == null) break block110;
                                            break block111;
                                        }
                                        if (defaultTextColumn != null && defaultTextColumn.length() > 0 && metacolumnIndex == 0) {
                                            dataException = "Text expression column [" + defaultTextColumn + "] not found" + " [" + this.getTheme().getName() + "].";
                                            vc.processDataError(null, log, dataException);
                                            i22 = null;
                                            if (this.getTheme().getDecorator().getWorkspaceName() == null) break block112;
                                            break block113;
                                        }
                                        if (metacolumnIndex > 0 && totalColCount > 2 || metacolumnIndex == 0 && totalColCount > 1) {
                                            hasAttributes = true;
                                        }
                                    }
                                    String column = this.def.getTextColumn();
                                    if (!this.def.isPredefined() && this.def.getBaseColumnAlias() != null) {
                                        column = this.def.getBaseColumnAlias();
                                    }
                                    StyledFeatureI sf = this.getNewStyledFeatureInstance();
                                    while (!this.aborted && rset.next()) {
                                        AnnotationText antext;
                                        String id = null;
                                        if (this.def.isPredefined() && this.def.getKeyColumn() != null) {
                                            id = rset.getString(this.def.getKeyColumn());
                                        }
                                        if ((antext = this.loadAnnotation(id, rset, column)) == null) continue;
                                        if (hasAttributes) {
                                            this.fillAttributes(sf, meta, rset, totalColCount, textobjIndex, metacolumnIndex);
                                        }
                                        AnnotationTextFeature feature = new AnnotationTextFeature(antext, sf.getAttributes());
                                        featureSet.add(feature);
                                    }
                                    if (this.getTheme().getDecorator().getWorkspaceName() != null) {
                                    }
                                    break block114;
                                }
                                catch (Exception e) {
                                    log.severe(e.getMessage());
                                    throw new DataException(e);
                                }
                            }
                            try {
                                Util.gotoWorkspace(conn, "LIVE");
                            }
                            catch (Exception ex) {
                                // empty catch block
                            }
                        }
                        try {
                            if (rset != null) {
                                rset.close();
                            }
                        }
                        catch (Exception ex) {
                            log.warning(ex.getMessage());
                        }
                        try {
                            if (textStmt != null) {
                                textStmt.close();
                            }
                        }
                        catch (Exception ex) {
                            log.warning(ex.getMessage());
                        }
                        try {
                            if (conn != null) {
                                DSUtil.closeDBConnection(conn, this.def.getDataSourceName());
                            }
                        }
                        catch (Exception ex) {
                            // empty catch block
                        }
                        if (dataException == null) return i22;
                        throw new DataException(dataException);
                    }
                    try {
                        Util.gotoWorkspace(conn, "LIVE");
                    }
                    catch (Exception ex) {
                        // empty catch block
                    }
                }
                try {
                    if (rset != null) {
                        rset.close();
                    }
                }
                catch (Exception ex) {
                    log.warning(ex.getMessage());
                }
                try {
                    if (textStmt != null) {
                        textStmt.close();
                    }
                }
                catch (Exception ex) {
                    log.warning(ex.getMessage());
                }
                try {
                    if (conn != null) {
                        DSUtil.closeDBConnection(conn, this.def.getDataSourceName());
                    }
                }
                catch (Exception ex) {
                    // empty catch block
                }
                if (dataException == null) return i22;
                throw new DataException(dataException);
                try {
                    Util.gotoWorkspace(conn, "LIVE");
                }
                catch (Exception ex) {
                    // empty catch block
                }
            }
            try {
                if (rset != null) {
                    rset.close();
                }
            }
            catch (Exception ex) {
                log.warning(ex.getMessage());
            }
            try {
                if (textStmt != null) {
                    textStmt.close();
                }
            }
            catch (Exception ex) {
                log.warning(ex.getMessage());
            }
            try {
                if (conn != null) {
                    DSUtil.closeDBConnection(conn, this.def.getDataSourceName());
                }
            }
            catch (Exception ex) {
                // empty catch block
            }
            if (dataException != null) {
                throw new DataException(dataException);
            }
            break block117;
            finally {
                if (this.getTheme().getDecorator().getWorkspaceName() != null) {
                    try {
                        Util.gotoWorkspace(conn, "LIVE");
                    }
                    catch (Exception ex) {}
                }
                try {
                    if (rset != null) {
                        rset.close();
                    }
                }
                catch (Exception ex) {
                    log.warning(ex.getMessage());
                }
                try {
                    if (textStmt != null) {
                        textStmt.close();
                    }
                }
                catch (Exception ex) {
                    log.warning(ex.getMessage());
                }
                try {
                    if (conn != null) {
                        DSUtil.closeDBConnection(conn, this.def.getDataSourceName());
                    }
                }
                catch (Exception ex) {}
                if (dataException != null) {
                    throw new DataException(dataException);
                }
            }
        }
        if (this.aborted) {
            featureSet.clear();
        }
        long t3 = System.currentTimeMillis();
        log.info("[ " + this.def.name + " ] sql exec time: " + (t2 - t1) + "ms, total time loading " + featureSet.size() + " features: " + (t3 - t1) + "ms.");
        TopThemeQueries.add(t3 - t1, this.getTheme().getName(), this.getTheme().getDataSourceName(), textQuery, "features loaded = " + featureSet.size());
        if (featureSet.size() != 0) return featureSet.toArray(new AnnotationTextFeature[featureSet.size()]);
        return null;
    }

    @Override
    public long getMaxFeaturesToBePrepared() {
        return this.maxFeaturesToBePrepared;
    }

    @Override
    public void setMaxFeaturesToBePrepared(long size) {
        this.maxFeaturesToBePrepared = size;
    }
}

