/*
 * Decompiled with CFR 0.152.
 */
package oracle.sdovis.stylex;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.font.FontRenderContext;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.logging.Logger;
import oracle.mapviewer.share.Field;
import oracle.mapviewer.share.LabelingHints;
import oracle.mapviewer.share.SizeDefinition2D;
import oracle.mapviewer.share.style.StyleModel;
import oracle.mapviewer.share.style.StyleUtils;
import oracle.mapviewer.share.stylex.BarChartStyleModel;
import oracle.mapviewer.share.stylex.BarInfo;
import oracle.mapviewer.share.util.LogFactory;
import oracle.mapviewer.share.util.SphereCG;
import oracle.sdovis.LabelHelper;
import oracle.sdovis.SRS;
import oracle.sdovis.StyleCache;
import oracle.sdovis.VisContext;
import oracle.sdovis.style.Style;
import oracle.sdovis.style.StyleException;
import oracle.sdovis.style.StyleModifiers;
import oracle.sdovis.style.StyleNotApplicableException;
import oracle.sdovis.style.StyleText;
import oracle.sdovis.stylex.AdvancedStyle;
import oracle.sdovis.stylex.BarChartStyleModifiers;
import oracle.sdovis.util.ConflictResolver;
import oracle.sdovis.util.RectArray;
import oracle.sdovis.util.Util;
import oracle.sdovis.util.XMLDOMParser;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class BarChartStyle
implements AdvancedStyle {
    private static Logger log = LogFactory.getLogger(LogFactory.LoggerEnum.SDOVIS);
    private BarChartStyleModel bean;
    private BasicStroke barStroke = new BasicStroke(1.0f, 0, 2);

    public BarChartStyle() {
        this.bean = new BarChartStyleModel();
    }

    public BarChartStyle(StyleModel model) {
        this.setModel(model);
    }

    public BarChartStyle(int width, int height, BarInfo[] bi) {
        this.bean = new BarChartStyleModel(bi);
        this.bean.setWidth(width);
        this.bean.setHeight(height);
    }

    public BarChartStyle(Document doc) throws StyleException {
        this.bean = new BarChartStyleModel();
        try {
            Color color;
            String strokeColor;
            String xaxis;
            Node elem = XMLDOMParser.getSubElement(doc, "AdvancedStyle");
            elem = XMLDOMParser.getSubElement(elem, "BarChartStyle");
            String bwidth = XMLDOMParser.getAttribute(elem, "width");
            String bheight = XMLDOMParser.getAttribute(elem, "height");
            SizeDefinition2D barsize = SizeDefinition2D.parse(bwidth, bheight);
            if (barsize == null) {
                throw new StyleException("Invalid bar size in BarChartStyle definition.");
            }
            this.bean.setWidth(barsize.getWidth());
            this.bean.setHeight(barsize.getHeight());
            this.bean.setSizeUnit(barsize.getUnit());
            String scale = XMLDOMParser.getAttribute(elem, "share_scale");
            if (scale != null && "false".equalsIgnoreCase(scale)) {
                this.bean.setShareScale(false);
            }
            if ((xaxis = XMLDOMParser.getAttribute(elem, "show_x_axis")) != null && "true".equalsIgnoreCase(xaxis)) {
                this.bean.setShowXAxis(true);
            }
            double min = Double.NaN;
            double max = Double.NaN;
            String v = XMLDOMParser.getAttribute(elem, "min_value");
            if (v != null && v.length() > 0) {
                min = Double.parseDouble(v);
            }
            if ((v = XMLDOMParser.getAttribute(elem, "max_value")) != null && v.length() > 0) {
                max = Double.parseDouble(v);
            }
            if (!Double.isNaN(min) && !Double.isNaN(max)) {
                this.bean.setMinMaxValues(min, max);
            }
            if ((strokeColor = XMLDOMParser.getAttribute(elem, "stroke")) != null && strokeColor.trim().length() > 0 && (color = StyleUtils.getColor(strokeColor.trim())) != null) {
                String stroke_opacity = XMLDOMParser.getAttribute(elem, "stroke-opacity");
                if (stroke_opacity != null) {
                    try {
                        int value = Integer.parseInt(stroke_opacity);
                        if (value < 0 || value > 255) {
                            log.warning("Stroke opacity value out of range [0,255].");
                        } else {
                            color = new Color(color.getRed(), color.getGreen(), color.getBlue(), value);
                        }
                    }
                    catch (Exception ex) {
                        log.warning("Invalid stroke opacity value: " + stroke_opacity);
                    }
                }
                this.bean.setStrokeColor(color);
            }
            ArrayList nl = XMLDOMParser.getSubElements(elem, "Bar");
            BarInfo[] bi = new BarInfo[nl.size()];
            for (int i = 0; i < nl.size(); ++i) {
                Node el = (Node)nl.get(i);
                BarInfo _psi = new BarInfo();
                _psi.setName(XMLDOMParser.getAttribute(el, "name"));
                try {
                    _psi.setColor(StyleUtils.getColor(XMLDOMParser.getAttribute(el, "color")));
                }
                catch (Exception e) {
                    _psi.setColor(Color.black);
                }
                bi[i] = _psi;
            }
            this.bean.setBars(bi);
        }
        catch (Exception e) {
            throw new StyleException("Invalid BarChartStyle definition.", e);
        }
    }

    public Object clone() {
        try {
            BarChartStyle sty = (BarChartStyle)super.clone();
            sty.setModel((StyleModel)this.bean.clone());
            return sty;
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError(e.toString());
        }
    }

    @Override
    public int getMaxLegendWidth(Graphics2D g, int fontSize) {
        int curWidth = 0;
        int maxWidth = 0;
        Font defaultFont = new Font("Serif", 0, fontSize);
        String label = null;
        BarInfo[] bi = this.bean.getBars();
        FontRenderContext frc = g == null ? new FontRenderContext(null, true, false) : g.getFontRenderContext();
        for (int i = 0; i < this.bean.getNumBars(); ++i) {
            label = bi[i].getName();
            if (label == null || label.length() == 0 || (curWidth = (int)defaultFont.getStringBounds(label, frc).getWidth()) <= maxWidth) continue;
            maxWidth = curWidth;
        }
        return maxWidth;
    }

    @Override
    public StyleModel getModel() {
        return this.bean;
    }

    @Override
    public void setModel(StyleModel model) {
        if (!(model instanceof BarChartStyleModel)) {
            throw new IllegalArgumentException("Not a BarChartStyleModel instance.");
        }
        this.bean = (BarChartStyleModel)model;
    }

    @Override
    public String getDefinition() {
        return this.bean.toXMLString();
    }

    public void setDimension(int width, int height) {
        this.bean.setWidth(width);
        this.bean.setHeight(height);
    }

    @Override
    public boolean resolveStyles(StyleCache sc, Hashtable dynaStyles) {
        return true;
    }

    @Override
    public boolean refreshResolvedStyles(StyleCache sc, Hashtable dynaStyles) {
        return this.resolveStyles(sc, dynaStyles);
    }

    @Override
    public void apply(VisContext vc, Graphics2D g, float x, float y, StyleModifiers stymods) throws StyleNotApplicableException {
        throw new StyleNotApplicableException("BarChartStyle not applicable to a point.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void apply(VisContext vc, Graphics2D g, Rectangle2D rect, StyleModifiers stymods) throws StyleNotApplicableException {
        int n = this.bean.getNumBars();
        if (n <= 0) {
            return;
        }
        int inc = 100 / (n / 2 + 1);
        int m = (int)Math.ceil((double)n / 2.0) - 1;
        double[] fakeValues = new double[n];
        fakeValues[m] = 96.0;
        for (int i = 1; i <= n / 2; ++i) {
            try {
                fakeValues[m - i] = 100 - i * inc;
            }
            catch (Exception ex) {
                // empty catch block
            }
            try {
                fakeValues[m + i] = 100 - i * inc;
                continue;
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        boolean sf = this.bean.isShareScale();
        boolean xaxis = this.bean.isShowXAxis();
        this.bean.setShareScale(false);
        this.bean.setShowXAxis(true);
        try {
            this.drawBarChart(g, rect, fakeValues, true);
        }
        finally {
            this.bean.setShareScale(sf);
            this.bean.setShowXAxis(xaxis);
        }
    }

    @Override
    public void apply(VisContext vc, Graphics2D g, Shape shp, int gtype, StyleModifiers stymods) throws StyleNotApplicableException {
        if (!(shp instanceof Rectangle2D)) {
            throw new StyleNotApplicableException("BarChartStyle not applicable without values.");
        }
        this.apply(null, g, (Rectangle2D)shp, stymods);
    }

    @Override
    public void apply(VisContext vc, Graphics2D g, Shape shp, int gtype, String label, Point2D labelPoint, ConflictResolver cr, Field[] values, StyleModifiers stymods) throws StyleNotApplicableException {
        int w = this.bean.getWidth();
        int h = this.bean.getHeight();
        if (stymods != null && stymods instanceof BarChartStyleModifiers) {
            w = ((BarChartStyleModifiers)stymods).getBarWidth();
            h = ((BarChartStyleModifiers)stymods).getBarHeight();
        }
        if (labelPoint == null) {
            if (gtype == 3 || gtype == 7) {
                float[] pos = LabelHelper.findLoc4RectInPolygon(shp, 5.0, 5.0, (RectArray)cr, true, false, null);
                if (pos != null) {
                    labelPoint = new Point2D.Float(pos[0], pos[1]);
                }
            } else {
                return;
            }
        }
        if (labelPoint != null && cr != null) {
            cr.insert(labelPoint.getX() - (double)(w / 2), labelPoint.getY() - (double)(h / 2), (double)w, (double)h);
        }
        int numBars = this.bean.getNumBars();
        if (values == null || values.length < numBars) {
            log.warning("Insufficient attribute fields for the given bar chart style.");
            return;
        }
        double[] vs = new double[numBars];
        try {
            for (int i = 0; i < numBars; ++i) {
                vs[i] = values[i].isNoData() ? Double.NaN : (values[i].getShortJavaTypeName().equalsIgnoreCase("string") ? Double.parseDouble(values[i].getString()) : values[i].getDouble());
            }
        }
        catch (Exception e) {
            log.warning("invalid (type of) values for BarChartStyle.");
            return;
        }
        int cx = (int)labelPoint.getX();
        int cy = (int)labelPoint.getY();
        this.drawBarChart(g, new Rectangle2D.Double(cx - w / 2, cy - h / 2, w, h), vs, false);
    }

    @Override
    public void apply(VisContext vc, Graphics2D g, Shape shp, int gtype, String label, Point2D labelPoint, ConflictResolver cr, Field[] values, String[] styleColumns, StyleModifiers stymods) throws StyleNotApplicableException {
        if (values == null) {
            throw new StyleNotApplicableException("BarChartStyle not applicable without attribute values.");
        }
        int numBars = this.bean.getNumBars();
        if (styleColumns == null) {
            this.apply(null, g, shp, gtype, label, labelPoint, cr, values, stymods);
        } else {
            if (numBars < 1) {
                throw new StyleNotApplicableException("BarChartStyle must have at least one bar.");
            }
            if (styleColumns.length < numBars) {
                throw new StyleNotApplicableException("Not enough style columns for BarChartStyle.");
            }
            Field[] svalue = new Field[numBars];
            for (int i = 0; i < styleColumns.length; ++i) {
                svalue[i] = null;
                String column = styleColumns[i];
                svalue[i] = Util.getField(column, values);
                if (svalue[i] != null) continue;
                throw new StyleNotApplicableException("Unable to find attribute " + column + " for BarChartStyle.");
            }
            this.apply(null, g, shp, gtype, label, labelPoint, cr, svalue, stymods);
        }
    }

    @Override
    public void apply(VisContext vc, Graphics2D g, Shape shp, int gtype, String label, Point2D labelPoint, ConflictResolver cr, Field[] values, String[] styleColumns, Style subStyle, String[] substyleColumns, String changeProperty, StyleModifiers stymods) throws StyleNotApplicableException {
        if (styleColumns == null) {
            this.apply(null, g, shp, gtype, label, labelPoint, cr, values, stymods);
        } else {
            this.apply(null, g, shp, gtype, label, labelPoint, cr, values, styleColumns, stymods);
        }
    }

    public void drawBarChart(Graphics2D g2, Rectangle2D rect, double[] values, boolean drawBarName) {
        int n = this.bean.getNumBars();
        double w = rect.getWidth();
        double h = rect.getHeight();
        double barW = (w - (double)n + 1.0) / (double)n;
        double vpp = 0.0;
        double min = this.bean.getMinValue();
        double max = this.bean.getMaxValue();
        if (barW < 1.0) {
            barW = 1.0;
        }
        double localMin = values[0];
        double localMax = values[0];
        for (int i = 0; i < values.length; ++i) {
            if (Double.isNaN(values[i])) continue;
            if (localMax < values[i]) {
                localMax = values[i];
            }
            if (!(localMin > values[i])) continue;
            localMin = values[i];
        }
        if (!this.bean.isShareScale() || Double.isNaN(min) || Double.isNaN(max)) {
            min = localMin;
            max = localMax;
        }
        double valueRange = max - (min < 0.0 ? min : 0.0);
        int yoffset = 6;
        if (!drawBarName) {
            yoffset = 0;
        }
        vpp = (h - (double)yoffset) / valueRange;
        int zeroY = 0;
        if (localMin < 0.0) {
            zeroY = (int)(Math.abs(localMin) * vpp);
        }
        float[] labelX = drawBarName ? new float[n] : null;
        float[] labelY = drawBarName ? new float[n] : null;
        double sx = rect.getMinX();
        for (int i = 0; i < n; ++i) {
            BarInfo bi = this.bean.getBarInfo(i);
            Color c = bi.getColor();
            g2.setColor(c);
            double value = values[i];
            double sy = rect.getMaxY() - (double)zeroY + (double)yoffset;
            double barH = 0.0;
            if (!Double.isNaN(value)) {
                barH = Math.abs(value) * vpp;
            }
            if (value >= 0.0) {
                sy -= barH;
            }
            if ((int)sy + (int)barH < (int)rect.getMaxY()) {
                barH += 1.0;
            }
            if (!Double.isNaN(value)) {
                g2.fillRect((int)sx, (int)sy, (int)barW, (int)barH);
                Color strokeColor = this.bean.getStrokeColor();
                if (strokeColor != null) {
                    g2.setStroke(this.barStroke);
                    g2.setColor(strokeColor);
                    g2.drawRect((int)sx, (int)sy, (int)barW, (int)barH);
                }
            }
            if (drawBarName) {
                labelX[i] = (float)(sx + barW / 2.0);
                labelY[i] = (float)(sy - 6.0);
            }
            sx = this.bean.getStrokeColor() == null ? (double)((int)sx + (int)barW + 1) : (double)((int)sx + (int)barW + 2);
        }
        if (drawBarName) {
            StyleText st = new StyleText(new Font("serif", 0, 9), Color.black, 2.0f);
            for (int i = 0; i < n; ++i) {
                BarInfo bi = this.bean.getBarInfo(i);
                String txt = bi.getName();
                try {
                    st.apply(g2, labelX[i], labelY[i], LabelingHints.VALUE_OPOINT_HALIGN_CENTER, 0.0, 0, txt, null);
                    continue;
                }
                catch (Exception ex) {
                    // empty catch block
                }
            }
        }
        if (this.bean.isShowXAxis()) {
            g2.setColor(Color.gray);
            int y = (int)rect.getMaxY() - zeroY + yoffset;
            if ((double)y >= rect.getMaxY()) {
                --y;
            }
            g2.drawLine((int)rect.getMinX() - 1, y, (int)(sx + 1.0), y);
        }
    }

    @Override
    public Object getPropertyValue(String propertyType) {
        return null;
    }

    @Override
    public StyleModifiers convertToPixelSize(VisContext vc) {
        if (this.bean.getBarSize().isPixelUnit()) {
            return null;
        }
        BarChartStyleModifiers barmods = new BarChartStyleModifiers();
        if (vc == null || Util.isFullExtent(vc.getQueryWindow().getMinX(), vc.getQueryWindow().getMinX(), vc.getQueryWindow().getMaxX(), vc.getQueryWindow().getMaxY()) || vc.getQueryWindow().getWidth() == 0.0 && vc.getQueryWindow().getHeight() == 0.0) {
            if (this.bean.getBarSize().isPixelUnit()) {
                barmods.setBarWidth(this.bean.getWidth());
                barmods.setBarHeight(this.bean.getHeight());
            }
        } else {
            Rectangle2D devW = vc.getDeviceWindow();
            Rectangle2D queW = vc.getQueryWindow();
            double pixelX = queW.getWidth() / devW.getWidth();
            double pixelY = queW.getHeight() / devW.getHeight();
            Double convFactor = null;
            if (this.bean.getSizeUnit() != null) {
                convFactor = SRS.getDistanceConversionFactor(this.bean.getSizeUnit());
            }
            if (this.bean.getBarSize().isPixelUnit()) {
                barmods.setBarWidth(this.bean.getWidth());
                barmods.setBarHeight(this.bean.getHeight());
            } else if (convFactor != null) {
                double barw = this.bean.getDoubleWidth() * convFactor;
                if (vc.getSrs() != null && vc.getSrs().isGeodetic()) {
                    double dgw = SphereCG.convertRadius(0.0, 0.0, barw);
                    barmods.setBarWidth((int)(dgw / pixelX + 0.5));
                } else {
                    barmods.setBarWidth((int)(barw / pixelX + 0.5));
                }
                double barh = this.bean.getDoubleHeight() * convFactor;
                if (vc.getSrs() != null && vc.getSrs().isGeodetic()) {
                    double dgw = SphereCG.convertRadius(0.0, 0.0, barh);
                    barmods.setBarHeight((int)(dgw / pixelY + 0.5));
                } else {
                    barmods.setBarHeight((int)(barh / pixelY + 0.5));
                }
            }
        }
        return barmods;
    }
}

