/*
 * Decompiled with CFR 0.152.
 */
package oracle.sdovis.style;

import java.awt.Color;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Vector;
import oracle.mapviewer.share.RenderingRule;
import oracle.mapviewer.share.SizeDefinition;
import oracle.sdovis.DataException;
import oracle.sdovis.style.Style;
import oracle.sdovis.style.StyleColor;
import oracle.sdovis.style.StyleTable;
import oracle.sdovis.util.Util;
import oracle.sdovis.util.XMLDOMParser;
import org.w3c.dom.Node;

public class StylingRule
implements Serializable {
    private String mBaseTable = null;
    private String mLabelCol = null;
    private String mLabelFunc = null;
    private int[] mLabelRange = null;
    private String mLabelStyleName = null;
    private Style mLabelStyle = null;
    private boolean labeled = true;
    private String mFeatureStyleName = null;
    private Style mFeatureStyle = null;
    private String mFeatureCond = null;
    private boolean mIsFullQuery = false;
    private boolean mIsPassThrough = false;
    private String mSpatialCol = null;
    private String[] mAttrColumns = null;
    private int[] hiddenInfoColumns = null;
    private String[] hiddenInfoNames = null;
    private boolean hasHiddenInfo = false;
    private boolean simpleFlag = false;
    private String linkStyle = null;
    private String nodeStyle = null;
    private String directionStyle = null;
    private String bidirectionStyle = null;
    private SizeDefinition dirStyleSize = new SizeDefinition(8.0, null);
    private double dirPosition = 0.75;
    private boolean multipleMarker = false;
    private SizeDefinition nodeStyleSize = new SizeDefinition(5.0, null);
    private String pathStyles = null;
    private String idPaths = null;
    private String linkLabelStyle = null;
    private String linkLabelColumn = null;
    private String nodeLabelStyle = null;
    private String nodeLabelColumn = null;
    private String pathLabelStyle = null;
    private String pathLabelColumn = null;
    private String orderByColumns = null;
    private String sortOrder = null;
    private boolean starColumn = false;
    private RenderingRule[] renderRules = null;

    public StylingRule() {
        this.labeled = false;
        this.simpleFlag = true;
        this.mFeatureStyle = new StyleColor(null, Color.gray);
    }

    public StylingRule(Color fillColor, Color strokeColor) {
        this.labeled = false;
        this.simpleFlag = true;
        this.mFeatureStyle = new StyleColor(fillColor, strokeColor);
    }

    public StylingRule(String baseTable, String spColumn, XMLDOMParser parser, Node nd) {
        this.mAttrColumns = null;
        this.mBaseTable = baseTable;
        this.mSpatialCol = spColumn;
        this.simpleFlag = false;
        this.parseRuleNode(parser, nd);
    }

    public String getLabelColumn() {
        return this.mLabelCol;
    }

    public void setLabelColumn(String labelCol) {
        this.mLabelCol = labelCol;
    }

    public int[] getLabelRange() {
        return this.mLabelRange;
    }

    public void setLabelRange(int[] ranges) {
        this.mLabelRange = ranges;
    }

    public String getFeatureStyleName() {
        if (this.renderRules == null || this.renderRules.length == 0) {
            return this.mFeatureStyleName;
        }
        return this.renderRules[0].getStyleName();
    }

    public void setFeatureStyleName(String featStyle) {
        this.mFeatureStyleName = featStyle;
    }

    public Style getFeatureStyle() {
        return this.mFeatureStyle;
    }

    public void setFeatureStyle(Style sty) {
        this.mFeatureStyle = sty;
    }

    public boolean getLabeled() {
        return this.labeled;
    }

    public void setLabeled(boolean flag) {
        this.labeled = flag;
    }

    public String getLabelFunction() {
        if (this.labeled && this.mLabelFunc != null) {
            return this.mLabelFunc;
        }
        return "-1";
    }

    public void setLabeFunction(String func) {
        this.mLabelFunc = func;
    }

    public String getLabelStyleName() {
        return this.mLabelStyleName;
    }

    public void setLabelStyleName(String labelStyle) {
        this.mLabelStyleName = labelStyle;
    }

    public Style getLabelStyle() {
        return this.mLabelStyle;
    }

    public void setLabelStyle(Style sty) {
        this.mLabelStyle = sty;
    }

    public String[] getAttributeColumnsAsArray() {
        return this.mAttrColumns;
    }

    public void setAttributeColumns(String[] attrs) {
        this.mAttrColumns = attrs;
    }

    public String getAttributeColumns() {
        String res = "";
        if (this.mAttrColumns == null || this.mAttrColumns.length == 0) {
            return res;
        }
        res = this.mAttrColumns[0];
        for (int i = 1; i < this.mAttrColumns.length; ++i) {
            res = res + "," + this.mAttrColumns[i];
        }
        return res;
    }

    public void setAttributeColumns(String attrs) {
        if (attrs == null) {
            this.mAttrColumns = null;
        } else {
            ArrayList cols = Util.splitBy(attrs, ",");
            if (cols == null || cols.size() == 0) {
                this.mAttrColumns = null;
            } else {
                this.mAttrColumns = new String[cols.size()];
                for (int i = 0; i < cols.size(); ++i) {
                    this.mAttrColumns[i] = cols.get(i).toString();
                }
            }
        }
    }

    public String getFeatureCond() {
        return this.simpleFlag ? null : this.mFeatureCond;
    }

    public void setFeatureCond(String cond) {
        this.mFeatureCond = cond;
    }

    public boolean getIsSimpleRule() {
        return this.simpleFlag;
    }

    public void setIsSimpleRule(boolean flag) {
        this.simpleFlag = flag;
    }

    public String getBaseTable() {
        return this.mBaseTable;
    }

    public void setBaseTable(String table) {
        this.mBaseTable = table;
    }

    public String getSpatialColumn() {
        return this.mSpatialCol;
    }

    public void setSpatialColumn(String column) {
        this.mSpatialCol = column;
    }

    public void loadAllStyles(StyleTable st) throws DataException {
        if (this.simpleFlag) {
            return;
        }
        if (this.mFeatureStyleName != null) {
            this.mFeatureStyle = st.getStyleObject(this.mFeatureStyleName);
        }
        if (this.mLabelStyleName != null) {
            this.mLabelStyle = st.getStyleObject(this.mLabelStyleName);
        }
    }

    public boolean isCompleteSQLQuery() {
        return this.mIsFullQuery;
    }

    public boolean getIsCompleteSQLQuery() {
        return this.isCompleteSQLQuery();
    }

    public void setIsCompleteSQLQuery(boolean flag) {
        this.mIsFullQuery = flag;
    }

    public boolean isQueryPassThrough() {
        return this.mIsPassThrough;
    }

    public boolean getIsQueryPassThrough() {
        return this.isQueryPassThrough();
    }

    public void setIsQueryPassThrough(boolean flag) {
        this.mIsPassThrough = flag;
    }

    private void parseRuleNode(XMLDOMParser parser, Node nd) {
        Node lRd;
        Node fNd;
        String temp = null;
        Object attr = null;
        temp = XMLDOMParser.getAttribute(nd, "column");
        ArrayList<String> attrColumns = null;
        if (temp != null) {
            if (!temp.equals("*")) {
                attrColumns = Util.splitBy(temp, ", \t\n\r\f");
                this.starColumn = false;
            } else {
                this.starColumn = true;
            }
        } else {
            this.starColumn = false;
        }
        this.orderByColumns = null;
        temp = XMLDOMParser.getAttribute(nd, "order_by");
        if (temp != null && temp.length() > 0) {
            this.orderByColumns = temp;
        }
        this.sortOrder = null;
        temp = XMLDOMParser.getAttribute(nd, "sort_order");
        if (temp != null && temp.length() > 0) {
            if ("ASC".equalsIgnoreCase(temp) || "DESC".equalsIgnoreCase(temp)) {
                this.sortOrder = temp.toUpperCase();
            } else {
                System.err.println("sort_order value must be ASC or DESC.");
            }
        }
        if ((fNd = XMLDOMParser.getSubElement(nd, "features")) == null) {
            throw new NullPointerException("no <features> element in styling rule.");
        }
        temp = XMLDOMParser.getAttribute(fNd, "asis");
        try {
            if (temp != null) {
                this.mIsPassThrough = new Boolean(temp);
            }
        }
        catch (Exception e) {
            System.err.println("unrecognized value for attribute \"asis\".");
        }
        if (this.parseNetworkFeatures(parser, fNd)) {
            Node lNd = XMLDOMParser.getSubElement(nd, "label");
            if (lNd == null) {
                this.labeled = false;
            } else {
                this.parseNetworkLabels(parser, lNd);
            }
            return;
        }
        temp = XMLDOMParser.getAttribute(fNd, "style");
        if (temp == null) {
            temp = XMLDOMParser.getAttribute(fNd, "style_id");
        }
        if (temp != null) {
            this.mFeatureStyleName = temp.trim();
        }
        this.mFeatureCond = XMLDOMParser.getElementValue(fNd);
        if (this.mFeatureCond != null && this.mFeatureCond.length() > 0) {
            String upper = this.mFeatureCond.toUpperCase();
            if (upper.indexOf("SELECT ") == 0 && upper.indexOf("FROM ") > 0) {
                this.mIsFullQuery = true;
            } else if (!this.mFeatureCond.startsWith("(") || !this.mFeatureCond.endsWith(")")) {
                this.mFeatureCond = "(" + this.mFeatureCond + ")";
            }
        } else {
            this.mFeatureCond = null;
        }
        Node lNd = XMLDOMParser.getSubElement(nd, "label");
        if (lNd == null) {
            this.labeled = false;
        } else {
            this.labeled = true;
            this.mLabelCol = XMLDOMParser.getAttribute(lNd, "column");
            temp = XMLDOMParser.getAttribute(lNd, "style");
            if (temp == null) {
                temp = XMLDOMParser.getAttribute(lNd, "style_id");
            }
            if (temp != null) {
                this.mLabelStyleName = temp.trim();
            }
            this.mLabelFunc = (temp = XMLDOMParser.getElementValue(lNd)) != null ? new String(temp) : "1";
            String range = XMLDOMParser.getAttribute(lNd, "range");
            if (range != null) {
                int start = Integer.parseInt(range.substring(0, range.indexOf(44)));
                int end = Integer.parseInt(range.substring(range.indexOf(44) + 1, range.length()));
                this.mLabelRange = new int[2];
                this.mLabelRange[0] = start;
                this.mLabelRange[1] = end;
            } else {
                this.mLabelRange = null;
            }
        }
        Vector hNodes = XMLDOMParser.getSubNodesWithTagName(nd, "hidden_info");
        if (hNodes == null || hNodes.size() == 0) {
            this.hasHiddenInfo = false;
        } else {
            this.hasHiddenInfo = true;
            this.hiddenInfoColumns = new int[hNodes.size()];
            this.hiddenInfoNames = new String[hNodes.size()];
            if (attrColumns == null) {
                attrColumns = new ArrayList<String>(hNodes.size());
            }
            for (int i = 0; i < hNodes.size(); ++i) {
                Node hNd = (Node)hNodes.get(i);
                String col = XMLDOMParser.getAttribute(hNd, "column");
                temp = XMLDOMParser.getAttribute(hNd, "name");
                this.hiddenInfoNames[i] = temp == null ? col : temp;
                for (int j = 0; j < attrColumns.size(); ++j) {
                    if (!((String)attrColumns.get(i)).equalsIgnoreCase(col)) continue;
                    this.hiddenInfoColumns[i] = j;
                }
                this.hiddenInfoColumns[i] = attrColumns.size();
                attrColumns.add(col);
            }
        }
        if (attrColumns != null && attrColumns.size() > 0) {
            this.mAttrColumns = attrColumns.toArray(new String[attrColumns.size()]);
        }
        if ((lRd = XMLDOMParser.getSubElement(nd, "rendering")) != null) {
            this.renderRules = StylingRule.getRenderRules(parser, lRd);
        }
    }

    private boolean parseNetworkFeatures(XMLDOMParser parser, Node nd) {
        Node pathNd;
        Node nodeNd;
        String attr = null;
        boolean networkTheme = false;
        Node linkNd = XMLDOMParser.getSubElement(nd, "link");
        if (linkNd != null) {
            networkTheme = true;
            attr = XMLDOMParser.getAttribute(linkNd, "style");
            if (attr != null && attr.trim().length() > 0) {
                this.linkStyle = attr;
            }
            if ((attr = XMLDOMParser.getAttribute(linkNd, "direction_style")) != null && attr.trim().length() > 0) {
                this.directionStyle = attr;
            }
            if ((attr = XMLDOMParser.getAttribute(linkNd, "bidirection_style")) != null && attr.trim().length() > 0) {
                this.bidirectionStyle = attr;
            }
            if ((attr = XMLDOMParser.getAttribute(linkNd, "direction_position")) != null && attr.trim().length() > 0) {
                try {
                    this.dirPosition = Double.parseDouble(attr);
                }
                catch (Exception e) {
                    this.dirPosition = 0.75;
                }
            }
            if ((attr = XMLDOMParser.getAttribute(linkNd, "direction_markersize")) != null && attr.trim().length() > 0) {
                this.dirStyleSize = SizeDefinition.parse(attr.trim());
                if (this.dirStyleSize == null) {
                    this.dirStyleSize = new SizeDefinition(8.0, null);
                }
            }
            if ((attr = XMLDOMParser.getAttribute(linkNd, "direction_multimarker")) != null && attr.trim().length() > 0 && attr.trim().equalsIgnoreCase("true")) {
                this.multipleMarker = true;
            }
        }
        if ((nodeNd = XMLDOMParser.getSubElement(nd, "node")) != null) {
            networkTheme = true;
            attr = XMLDOMParser.getAttribute(nodeNd, "style");
            if (attr != null && attr.trim().length() > 0) {
                this.nodeStyle = attr;
            }
            if ((attr = XMLDOMParser.getAttribute(nodeNd, "markersize")) != null && attr.trim().length() > 0) {
                this.nodeStyleSize = SizeDefinition.parse(attr.trim());
                if (this.nodeStyleSize == null) {
                    this.nodeStyleSize = new SizeDefinition(8.0, null);
                }
            }
        }
        if ((pathNd = XMLDOMParser.getSubElement(nd, "path")) != null) {
            networkTheme = true;
            attr = XMLDOMParser.getAttribute(pathNd, "ids");
            if (attr != null && attr.trim().length() > 0) {
                this.idPaths = attr;
            }
            if ((attr = XMLDOMParser.getAttribute(pathNd, "styles")) != null && attr.trim().length() > 0) {
                this.pathStyles = attr;
            }
        }
        return networkTheme;
    }

    private void parseNetworkLabels(XMLDOMParser parser, Node nd) {
        Node pathNd;
        Node nodeNd;
        String attr = null;
        Node linkNd = XMLDOMParser.getSubElement(nd, "link");
        if (linkNd != null) {
            attr = XMLDOMParser.getAttribute(linkNd, "column");
            if (attr != null && attr.trim().length() > 0) {
                this.linkLabelColumn = attr;
            }
            if ((attr = XMLDOMParser.getAttribute(linkNd, "style")) != null && attr.trim().length() > 0) {
                this.linkLabelStyle = attr;
            }
            this.labeled = true;
        }
        if ((nodeNd = XMLDOMParser.getSubElement(nd, "node")) != null) {
            attr = XMLDOMParser.getAttribute(nodeNd, "column");
            if (attr != null && attr.trim().length() > 0) {
                this.nodeLabelColumn = attr;
            }
            if ((attr = XMLDOMParser.getAttribute(nodeNd, "style")) != null && attr.trim().length() > 0) {
                this.nodeLabelStyle = attr;
            }
            this.labeled = true;
        }
        if ((pathNd = XMLDOMParser.getSubElement(nd, "path")) != null) {
            attr = XMLDOMParser.getAttribute(pathNd, "column");
            if (attr != null && attr.trim().length() > 0) {
                this.pathLabelColumn = attr;
            }
            if ((attr = XMLDOMParser.getAttribute(pathNd, "style")) != null && attr.trim().length() > 0) {
                this.pathLabelStyle = attr;
            }
            this.labeled = true;
        }
    }

    public String getLinkStyle() {
        return this.linkStyle;
    }

    public void setLinkStyle(String styleName) {
        this.linkStyle = styleName;
    }

    public String getNodeStyle() {
        return this.nodeStyle;
    }

    public void setNodeStyle(String styleName) {
        this.nodeStyle = styleName;
    }

    public String getDirectionStyle() {
        return this.directionStyle;
    }

    public void setDirectionStyle(String styleName) {
        this.directionStyle = styleName;
    }

    public String getBiDirectionStyle() {
        return this.bidirectionStyle;
    }

    public void setBiDirectionStyle(String styleName) {
        this.bidirectionStyle = styleName;
    }

    public SizeDefinition getDirectionStyleSize() {
        return this.dirStyleSize;
    }

    public int getDirectionStyleIntSize() {
        return (int)this.dirStyleSize.getValue();
    }

    public double getDirectionStyleDoubleSize() {
        return this.dirStyleSize.getValue();
    }

    public void setDirectionStyleDoubleSize(double size) {
        this.dirStyleSize.setValue(size);
    }

    public void setDirectionStyleSize(int size) {
        this.dirStyleSize.setValue(size);
    }

    public void setDirectionStyleSize(SizeDefinition size) {
        this.dirStyleSize = size == null ? new SizeDefinition(8.0, null) : size;
    }

    public String getDirectionStyleUnit() {
        return this.dirStyleSize.getUnit();
    }

    public void setDirectionStyleUnit(String unit) {
        this.dirStyleSize.setUnit(unit);
    }

    public double getDirectionPosition() {
        return this.dirPosition;
    }

    public void setDirectionPosition(double pos) {
        this.dirPosition = pos;
        if (pos < 0.0) {
            this.dirPosition = 0.0;
        } else if (pos > 1.0) {
            this.dirPosition = 1.0;
        }
    }

    public boolean hasMultipleDirectionMarkers() {
        return this.multipleMarker;
    }

    public boolean getMultipleDirectionMarkers() {
        return this.hasMultipleDirectionMarkers();
    }

    public void setMultipleDirectionMarkers(boolean value) {
        this.multipleMarker = value;
    }

    public SizeDefinition getNodeStyleSize() {
        return this.nodeStyleSize;
    }

    public int getNodeStyleIntSize() {
        return (int)this.nodeStyleSize.getValue();
    }

    public double getNodeStyleDoubleSize() {
        return this.nodeStyleSize.getValue();
    }

    public void setNodeStyleDoubleSize(double size) {
        this.nodeStyleSize.setValue(size);
    }

    public void setNodeStyleSize(int size) {
        this.nodeStyleSize.setValue(size);
    }

    public void setNodeStyleSize(SizeDefinition size) {
        this.nodeStyleSize = size == null ? new SizeDefinition(8.0, null) : size;
    }

    public String getNodeStyleUnit() {
        return this.nodeStyleSize.getUnit();
    }

    public void setNodeStyleUnit(String unit) {
        this.nodeStyleSize.setUnit(unit);
    }

    public String getPathStyles() {
        return this.pathStyles;
    }

    public void setPathStyles(String styles) {
        this.pathStyles = styles;
    }

    public String getPathIds() {
        return this.idPaths;
    }

    public void setPathIds(String pathIds) {
        this.idPaths = pathIds;
    }

    public String getLinkLabelStyle() {
        return this.linkLabelStyle;
    }

    public void setLinkLabelStyle(String styleName) {
        this.linkLabelStyle = styleName;
    }

    public String getLinkLabelColumn() {
        return this.linkLabelColumn;
    }

    public void setLinkLabelColumn(String column) {
        this.linkLabelColumn = column;
    }

    public String getNodeLabelStyle() {
        return this.nodeLabelStyle;
    }

    public void setNodeLabelStyle(String styleName) {
        this.nodeLabelStyle = styleName;
    }

    public String getNodeLabelColumn() {
        return this.nodeLabelColumn;
    }

    public void setNodeLabelColumn(String column) {
        this.nodeLabelColumn = column;
    }

    public String getPathLabelStyle() {
        return this.pathLabelStyle;
    }

    public void setPathLabelStyle(String styleName) {
        this.pathLabelStyle = styleName;
    }

    public String getPathLabelColumn() {
        return this.pathLabelColumn;
    }

    public void setPathLabelColumn(String column) {
        this.pathLabelColumn = column;
    }

    public String getOrderByColumns() {
        return this.orderByColumns;
    }

    public void setOrderByColumns(String order) {
        this.orderByColumns = order;
    }

    public String getSortOrder() {
        return this.sortOrder;
    }

    public void setSortOrder(String sort) {
        this.sortOrder = sort == null || !sort.equalsIgnoreCase("ASC") && !sort.equalsIgnoreCase("DESC") ? "ASC" : sort;
    }

    public boolean getStarColumn() {
        return this.starColumn;
    }

    public void setStarColumn(boolean flag) {
        this.starColumn = flag;
    }

    public static RenderingRule[] getRenderRules(XMLDOMParser parser, Node nd) {
        if (parser == null && nd == null) {
            return null;
        }
        if (!nd.getNodeName().equalsIgnoreCase("rendering")) {
            return null;
        }
        ArrayList<RenderingRule> rules = new ArrayList<RenderingRule>();
        ArrayList styleNodes = XMLDOMParser.getSubElements(nd, "style");
        if (styleNodes != null) {
            for (int i = 0; i < styleNodes.size(); ++i) {
                Node substyle;
                Node labelNd;
                String maxScale;
                String minScale;
                String columns;
                Node child = (Node)styleNodes.get(i);
                RenderingRule rule = new RenderingRule();
                String name = XMLDOMParser.getAttribute(child, "name");
                if (name != null && name.trim().length() > 0) {
                    rule.setStyleName(name.trim());
                }
                if ((columns = XMLDOMParser.getAttribute(child, "value_columns")) != null && columns.trim().length() > 0) {
                    ArrayList al = Util.splitBy(columns, ",");
                    String[] columnNames = al.toArray(new String[al.size()]);
                    if (columnNames != null) {
                        for (int k = 0; k < columnNames.length; ++k) {
                            columnNames[k] = columnNames[k].trim();
                        }
                    }
                    rule.setStyleColumns(columnNames);
                }
                if ((minScale = XMLDOMParser.getAttribute(child, "min_scale")) != null && minScale.trim().length() > 0) {
                    try {
                        rule.setMinScale(Double.parseDouble(minScale.trim()));
                    }
                    catch (Exception ex) {
                        // empty catch block
                    }
                }
                if ((maxScale = XMLDOMParser.getAttribute(child, "max_scale")) != null && maxScale.trim().length() > 0) {
                    try {
                        rule.setMaxScale(Double.parseDouble(maxScale.trim()));
                    }
                    catch (Exception ex) {
                        // empty catch block
                    }
                }
                if ((labelNd = XMLDOMParser.getSubElement(child, "label")) != null) {
                    String allow_naked_points;
                    String upside_down_labels;
                    String no_repetitive_label;
                    String label_always_on = XMLDOMParser.getAttribute(labelNd, RenderingRule.LABEL_ALWAYS_ON_PROPERTY);
                    if (label_always_on != null) {
                        rule.setLabelProperty(RenderingRule.LABEL_ALWAYS_ON_PROPERTY, label_always_on);
                    }
                    if ((no_repetitive_label = XMLDOMParser.getAttribute(labelNd, RenderingRule.NO_REPETITIVE_LABEL_PROPERTY)) != null) {
                        rule.setLabelProperty(RenderingRule.NO_REPETITIVE_LABEL_PROPERTY, no_repetitive_label);
                    }
                    if ((upside_down_labels = XMLDOMParser.getAttribute(labelNd, RenderingRule.UPSIDE_DOWN_LABELS_PROPERTY)) != null) {
                        rule.setLabelProperty(RenderingRule.UPSIDE_DOWN_LABELS_PROPERTY, upside_down_labels);
                    }
                    if ((allow_naked_points = XMLDOMParser.getAttribute(labelNd, RenderingRule.ALLOW_NAKED_POINTS_PROPERTY)) != null) {
                        rule.setLabelProperty(RenderingRule.ALLOW_NAKED_POINTS_PROPERTY, allow_naked_points);
                    }
                }
                if ((substyle = XMLDOMParser.getSubElement(child, "substyle")) != null) {
                    String change;
                    String subcolumns;
                    String subname = XMLDOMParser.getAttribute(substyle, "name");
                    if (subname != null && subname.trim().length() > 0) {
                        rule.setSubStyleName(subname.trim());
                    }
                    if ((subcolumns = XMLDOMParser.getAttribute(substyle, "value_columns")) != null && subcolumns.trim().length() > 0) {
                        ArrayList al = Util.splitBy(subcolumns, ",");
                        String[] subcolumnNames = al.toArray(new String[al.size()]);
                        if (subcolumnNames != null) {
                            for (int k = 0; k < subcolumnNames.length; ++k) {
                                subcolumnNames[k] = subcolumnNames[k].trim();
                            }
                        }
                        rule.setSubStyleColumns(subcolumnNames);
                    }
                    if ((change = XMLDOMParser.getAttribute(substyle, "changes")) != null && change.trim().length() > 0) {
                        rule.setSubStyleChangeProperty(change.trim());
                    }
                }
                rules.add(rule);
            }
        }
        if (rules.size() == 0) {
            return null;
        }
        return rules.toArray(new RenderingRule[rules.size()]);
    }

    public void setRenderingRules(RenderingRule[] rrules) {
        this.renderRules = rrules;
    }

    public RenderingRule[] getRenderingRules() {
        return this.renderRules;
    }
}

