/*
 * Decompiled with CFR 0.152.
 */
package oracle.sdovis.stream;

import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import oracle.sdovis.CustomGeomTheme;
import oracle.sdovis.DynamicGeometryTheme;
import oracle.sdovis.PredefinedGeometryTheme;
import oracle.sdovis.RSBundle;
import oracle.sdovis.Theme;
import oracle.sdovis.ThemeCache;
import oracle.sdovis.VisContext;
import oracle.sdovis.ds.DSManager;
import oracle.sdovis.ds.DataSourceI;
import oracle.sdovis.stream.GeometryFeaturePump;
import oracle.sdovis.theme.CustomGeomThemeDefinition;
import oracle.sdovis.theme.DynGeomThemeDefinition;
import oracle.sdovis.theme.PredGeomThemeDefinition;
import oracle.sdovis.theme.ThemeDefinition;

public class GeometryGateway {
    public static GeometryFeaturePump getFeaturePumpFromPT(String ptName, String dataSource, int targetSRID, String workspace, Object[] parameters) throws Exception {
        return GeometryGateway.getFeaturePumpFromPT(ptName, dataSource, targetSRID, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY, workspace, parameters);
    }

    public static GeometryFeaturePump getFeaturePumpFromPT(String ptName, String dataSource, int targetSRID, double minx, double miny, double maxx, double maxy, String workspace, Object[] parameters) throws Exception {
        Theme t = GeometryGateway.getPredefinedTheme(ptName, dataSource, parameters);
        if (workspace != null && t != null) {
            t.getDecorator().setWorkspaceName(workspace);
        }
        VisContext vc = new VisContext();
        vc.setMasterDataSourceName(dataSource);
        vc.setMasterSRID(targetSRID);
        Rectangle2D.Double rect = new Rectangle2D.Double(minx, miny, maxx - minx, maxy - miny);
        vc.setQueryWindow(rect);
        GeometryFeaturePump pump = new GeometryFeaturePump(t, vc, rect);
        return pump;
    }

    static Theme getPredefinedTheme(String ptName, String dataSource, Object[] params) throws Exception {
        Theme theme = null;
        ThemeDefinition themeDef = null;
        ThemeCache tCache = null;
        DataSourceI ads = DSManager.get(dataSource);
        tCache = ads.getThemeCache();
        themeDef = tCache.getOrLoadThemeDefinition(ptName);
        if (themeDef == null) {
            throw new Exception(RSBundle.getMsg("MAPVIEWER-01002") + " [" + ptName + "]");
        }
        String tt = themeDef.getThemeType();
        if ("GEOM_PREDEFINED".equals(tt)) {
            PredGeomThemeDefinition pdef = (PredGeomThemeDefinition)themeDef;
            theme = new PredefinedGeometryTheme(ptName, pdef, params);
            return theme;
        }
        if ("GEOM_CUSTOM".equals(tt)) {
            CustomGeomThemeDefinition cdef = (CustomGeomThemeDefinition)themeDef;
            theme = new CustomGeomTheme(cdef);
            return theme;
        }
        if ("GEOM_DYNAMIC".equals(tt)) {
            theme = new DynamicGeometryTheme((DynGeomThemeDefinition)themeDef, params);
            return theme;
        }
        throw new Exception("Theme is not a supported geometry theme.");
    }

    public static GeometryFeaturePump getFeaturePumpFromDynamicTheme(String themeName, String query, String geomCol, String ds, int targetSrid, String workspace, String baseTable) {
        return GeometryGateway.getFeaturePumpFromDynamicTheme(themeName, query, geomCol, ds, targetSrid, true, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY, workspace, baseTable);
    }

    public static GeometryFeaturePump getFeaturePumpFromDynamicTheme(String themeName, String query, String geomCol, String ds, int targetSrid, boolean asis, double minx, double miny, double maxx, double maxy, String workspace, String baseTable) {
        Theme t = GeometryGateway.createDynamicTheme(themeName, query, geomCol, ds, asis);
        if (workspace != null) {
            t.getDecorator().setWorkspaceName(workspace);
        }
        if (baseTable != null) {
            ((DynGeomThemeDefinition)t.getDefinition()).setBaseTable(baseTable);
        }
        VisContext vc = new VisContext();
        vc.setMasterDataSourceName(ds);
        vc.setMasterSRID(targetSrid);
        Rectangle2D.Double rect = new Rectangle2D.Double(minx, miny, maxx - minx, maxy - miny);
        vc.setQueryWindow(rect);
        vc.setQueryWindowSrid(targetSrid);
        if (rect.getMinX() != Double.NEGATIVE_INFINITY && rect.getMinY() != Double.NEGATIVE_INFINITY && ((RectangularShape)rect).getWidth() != Double.POSITIVE_INFINITY && ((RectangularShape)rect).getHeight() != Double.POSITIVE_INFINITY) {
            vc.setCurrentScale(1.0E7);
        }
        GeometryFeaturePump pump = new GeometryFeaturePump(t, vc, rect);
        return pump;
    }

    private static Theme createDynamicTheme(String themeName, String query, String geomCol, String ds, boolean asis) {
        DynGeomThemeDefinition dtd = new DynGeomThemeDefinition(themeName, ds, query, geomCol, 0);
        if (!dtd.isPassthrough()) {
            dtd.setPassthrough(asis);
        }
        return new DynamicGeometryTheme(dtd, null);
    }
}

