/*
 * Decompiled with CFR 0.152.
 */
package oracle.sdovis.stream;

import java.awt.geom.Rectangle2D;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Random;
import java.util.logging.Logger;
import oracle.mapviewer.share.BasicFeatureDescriptor;
import oracle.mapviewer.share.FeatureDescriptor;
import oracle.mapviewer.share.FeatureGroup;
import oracle.mapviewer.share.Field;
import oracle.mapviewer.share.SimpleFeature;
import oracle.mapviewer.share.SimpleFeatureI;
import oracle.mapviewer.share.SimpleGeometry;
import oracle.mapviewer.share.SimpleStyledFeature;
import oracle.mapviewer.share.util.LogFactory;
import oracle.sdovis.CustomGeomTheme;
import oracle.sdovis.DynamicGeometryTheme;
import oracle.sdovis.JSDOGeometry;
import oracle.sdovis.PredefinedGeometryTheme;
import oracle.sdovis.SRS;
import oracle.sdovis.SRSCache;
import oracle.sdovis.StyledFeatureI;
import oracle.sdovis.Theme;
import oracle.sdovis.VisContext;
import oracle.sdovis.ds.DSManager;
import oracle.sdovis.ds.DSUtil;
import oracle.sdovis.theme.ThemeDataProducer;
import oracle.sdovis.util.JDBCUtil;
import oracle.spatial.geometry.JGeometry;

public class GeometryFeaturePump
extends Thread {
    private static Logger log = LogFactory.getLogger(LogFactory.LoggerEnum.SDOVIS);
    private static String PSEUDO_LABEL_COL = "_label_";
    Theme theme;
    Rectangle2D queryWindow = null;
    VisContext vc = null;
    boolean success = true;
    Throwable exception = null;
    static Random random = new Random(System.currentTimeMillis());

    public GeometryFeaturePump(Theme theme, VisContext vc, Rectangle2D queryWindow) {
        if (queryWindow == null) {
            queryWindow = new Rectangle2D.Double(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY);
        }
        this.queryWindow = queryWindow;
        this.vc = vc;
        if (!(theme instanceof PredefinedGeometryTheme || theme instanceof DynamicGeometryTheme || theme instanceof CustomGeomTheme)) {
            this.success = false;
            this.exception = new IllegalArgumentException("Only geometry themes are supported.");
            throw (RuntimeException)this.exception;
        }
        this.theme = theme;
    }

    @Override
    public void run() {
        try {
            ThemeDataProducer themeProducer = this.theme.getProducer();
            themeProducer.prepareData(this.queryWindow, this.vc);
        }
        catch (Exception e) {
            this.success = false;
            this.exception = e;
        }
    }

    public void abort() {
        this.theme.abortPreparation();
        this.exception = new Exception("Feature pump process aborted voluntarily.");
        this.success = false;
    }

    public boolean isSuccessful() {
        return this.success;
    }

    public Throwable getException() {
        return this.exception;
    }

    public Theme getTheme() {
        return this.theme;
    }

    public void setTheme(Theme theme) {
        this.theme = theme;
    }

    public FeatureGroup getFeatures() {
        if (this.success) {
            StyledFeatureI[] features = this.theme.getProducer().getStyledFeatures();
            return this.toFeatureGroup(features, this.theme);
        }
        return null;
    }

    public SimpleFeature[] getFeatures(JGeometry filter, String mask) {
        log.finest("getFeatures(filter, mask) not implemented.");
        return new SimpleFeature[0];
    }

    public final FeatureGroup toFeatureGroup(StyledFeatureI[] features, Theme theme) {
        String themeName = theme.getName();
        if (features == null || features.length == 0) {
            return new FeatureGroup(0, themeName);
        }
        FeatureDescriptor ftype = this.createFeatureType(features, theme);
        FeatureGroup fg = new FeatureGroup(features.length, themeName);
        fg.setType(ftype);
        boolean geodeticCheck = false;
        for (int i = 0; i < features.length; ++i) {
            SRS srs;
            StyledFeatureI sf = features[i];
            SimpleFeatureI simpleFeature = this.toSimpleFeature(sf, theme);
            fg.addFeature(simpleFeature);
            if (geodeticCheck || fg.getSrid() <= 0 || sf.getDataSource() == null) continue;
            SRSCache sc = DSManager.getSRSCache(sf.getDataSource());
            if (sc != null && (srs = sc.get(fg.getSrid())) != null) {
                fg.setIsGeodeticSrid(srs.isGeodetic());
            }
            geodeticCheck = true;
        }
        log.finest("Streaming geometry features: " + features.length + ".");
        return fg;
    }

    public SimpleFeatureI toSimpleFeature(StyledFeatureI sf, Theme theme) {
        int i;
        if (sf == null) {
            return null;
        }
        SimpleStyledFeature res = new SimpleStyledFeature();
        res.setGeometry(GeometryFeaturePump.toSimpleGeometry(sf.getGeometry()));
        res.setFeatureType(null);
        Field[] attrs = null;
        int numAttrsAndLabel = sf.getNumAttributes() + (sf.getLabel() != null ? 1 : 0);
        attrs = new Field[numAttrsAndLabel];
        if (sf.getNumAttributes() > 0) {
            int countR = sf.getNumRenderableAttributes();
            for (i = 0; i < countR; ++i) {
                attrs[i] = sf.getRenderableAttribute(i);
            }
            for (i = 0; i < sf.getNumIdentifiableAttributes(); ++i) {
                attrs[countR + i] = sf.getIdentifiableAttribute(i);
            }
        }
        if (sf.getLabel() != null) {
            Field f = new Field();
            f.setString(sf.getLabel());
            attrs[numAttrsAndLabel - 1] = f;
        }
        res.setKey(sf.getID());
        if (res.getKey() == null) {
            if (sf.getLabel() != null) {
                res.setKey(sf.getLabel());
            } else {
                res.setKey("auto-key-" + new Random().nextLong());
            }
        }
        res.setAttributes(attrs);
        res.setRenderingStyleName(sf.getFeatureStyleName());
        attrs = sf.getRenderableAttributes();
        if (attrs != null && attrs.length > 0) {
            String[] rc = new String[attrs.length];
            for (i = 0; i < rc.length; ++i) {
                rc[i] = attrs[i].getName();
            }
            res.setRenderingColumns(rc);
        }
        res.setLabelingStylename(sf.getLabelStyleName());
        res.setLabeingColumns(new String[]{PSEUDO_LABEL_COL});
        return res;
    }

    public static final SimpleGeometry toSimpleGeometry(JSDOGeometry geometry) {
        SimpleGeometry res = new SimpleGeometry();
        JSDOGeometry geom = geometry;
        if (geometry.hasCircularArcs()) {
            geom = geometry.densifyArcs(5.0E-5);
        }
        res.dim = geom.getDimensions();
        res.setGtype(geom.getType());
        res.setSrid(geom.getSRID());
        res.setElemInfo(geom.getElemInfo());
        res.setOrdinates(geom.getOrdinatesArray());
        double[] xyz = geom.getLabelPointXYZ();
        if (xyz != null && xyz[0] != Double.NaN) {
            res.setX(xyz[0]);
            res.setY(xyz[1]);
            if (xyz.length > 2) {
                res.setZ(xyz[2]);
            }
        }
        res.setLinfo(geom.getLRMDimension());
        res.setMbr(geom.getMBR());
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    FeatureDescriptor createFeatureType(StyledFeatureI[] features, Theme originalTheme) {
        BasicFeatureDescriptor ftp = new BasicFeatureDescriptor();
        StyledFeatureI sf = features[0];
        Field[] attrs = null;
        int numAttrsAndLabel = sf.getNumAttributes() + (sf.getLabel() != null ? 1 : 0);
        attrs = new Field[numAttrsAndLabel];
        if (sf.getNumAttributes() > 0) {
            int i;
            int countR = sf.getNumRenderableAttributes();
            for (i = 0; i < countR; ++i) {
                attrs[i] = sf.getRenderableAttribute(i);
            }
            for (i = 0; i < sf.getNumIdentifiableAttributes(); ++i) {
                attrs[countR + i] = sf.getIdentifiableAttribute(i);
            }
        }
        if (sf.getLabel() != null) {
            Field f = new Field();
            f.setName(PSEUDO_LABEL_COL);
            f.setType(8);
            attrs[numAttrsAndLabel - 1] = f;
        }
        ftp.setAttributeTypes(attrs);
        if (sf.getDataSource() != null && attrs.length > 0) {
            Connection conn = null;
            try {
                String[] nonNullAttrs;
                conn = DSUtil.getDBConnection(sf.getDataSource(), null);
                if (conn != null && originalTheme.getDefinition().getBasicThemeInfo().getBaseTable() != null && (nonNullAttrs = JDBCUtil.getNonNullAttributes(conn, originalTheme.getDefinition().getBasicThemeInfo().getBaseTable())) != null && nonNullAttrs.length > 0) {
                    int len = attrs.length;
                    ArrayList<String> notnull = new ArrayList<String>();
                    block13: for (int i = 0; i < len; ++i) {
                        Field f = attrs[i];
                        String name = f.getName();
                        for (int j = 0; j < nonNullAttrs.length; ++j) {
                            if (!name.equalsIgnoreCase(nonNullAttrs[j])) continue;
                            if (notnull.contains(nonNullAttrs[j])) continue block13;
                            notnull.add(nonNullAttrs[j]);
                            continue block13;
                        }
                    }
                    if (notnull.size() > 0) {
                        ftp.setNotNullAttributes(notnull.toArray(new String[notnull.size()]));
                    }
                }
            }
            catch (Exception ex) {
                log.warning("Unable to check for non null attributes.");
            }
            finally {
                if (conn != null) {
                    try {
                        DSUtil.closeDBConnection(conn, sf.getDataSource());
                    }
                    catch (Exception e) {}
                }
            }
        }
        return ftp;
    }

    public VisContext getVisContext() {
        return this.vc;
    }
}

