/*
 * Decompiled with CFR 0.152.
 */
package oracle.sdovis.stream;

import java.awt.geom.Rectangle2D;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.logging.Logger;
import oracle.mapviewer.share.BasicFeatureDescriptor;
import oracle.mapviewer.share.FeatureDescriptor;
import oracle.mapviewer.share.FeatureGroup;
import oracle.mapviewer.share.Field;
import oracle.mapviewer.share.util.LogFactory;
import oracle.sdovis.AnnotationTextTheme;
import oracle.sdovis.SRS;
import oracle.sdovis.SRSCache;
import oracle.sdovis.VisContext;
import oracle.sdovis.ds.DSManager;
import oracle.sdovis.ds.DSUtil;
import oracle.sdovis.text.AnnotationTextFeature;
import oracle.sdovis.theme.AnnotationTextThemeProducer;
import oracle.sdovis.util.JDBCUtil;

public class AnnotationTextFeaturePump
extends Thread {
    private static Logger log = LogFactory.getLogger(LogFactory.LoggerEnum.SDOVIS);
    AnnotationTextTheme theme;
    Rectangle2D queryWindow = null;
    VisContext vc = null;
    boolean success = true;
    Throwable exception = null;
    AnnotationTextFeature[] features = null;

    public AnnotationTextFeaturePump(AnnotationTextTheme theme, VisContext vc, Rectangle2D queryWindow) {
        if (queryWindow == null) {
            queryWindow = new Rectangle2D.Double(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY);
        }
        this.queryWindow = queryWindow;
        this.vc = vc;
        this.theme = theme;
    }

    @Override
    public void run() {
        try {
            this.features = null;
            AnnotationTextThemeProducer themeProducer = (AnnotationTextThemeProducer)this.theme.getProducer();
            this.features = themeProducer.getAnnotationTextFeatures(this.queryWindow, this.vc);
        }
        catch (Exception e) {
            this.success = false;
            this.exception = e;
            this.features = null;
        }
    }

    public void abort() {
        this.theme.abortPreparation();
        this.exception = new Exception("Feature pump process aborted voluntarily.");
        this.features = null;
        this.success = false;
    }

    public boolean isSuccessful() {
        return this.success;
    }

    public Throwable getException() {
        return this.exception;
    }

    public AnnotationTextFeature[] getFeatures() {
        if (this.success) {
            return this.features;
        }
        return null;
    }

    public final FeatureGroup getFeatureGroup() {
        SRS srs;
        SRSCache sc;
        if (this.theme == null || !this.success) {
            return null;
        }
        String themeName = this.theme.getName();
        if (this.features == null || this.features.length == 0) {
            return new FeatureGroup(0, themeName);
        }
        FeatureDescriptor ftype = this.createFeatureType();
        FeatureGroup fg = new FeatureGroup(this.features.length, themeName);
        fg.setType(ftype);
        fg.setSrid(this.features[0].getAnnotationTextObject().getEnvelope().getSRID());
        if (this.theme.getDefinition().getSrid() > 0 && this.theme.getDefinition().getDataSourceName() != null && (sc = DSManager.getSRSCache(this.theme.getDefinition().getDataSourceName())) != null && (srs = sc.get(fg.getSrid())) != null) {
            fg.setIsGeodeticSrid(srs.isGeodetic());
        }
        log.finest("Streaming annotation text features: " + this.features.length + ".");
        return fg;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FeatureDescriptor createFeatureType() {
        BasicFeatureDescriptor ftp = new BasicFeatureDescriptor();
        AnnotationTextFeature sf = this.features[0];
        Field[] attrs = null;
        attrs = sf.getAttributes() == null ? new Field[]{} : new Field[sf.getAttributes().length];
        if (sf.getAttributes().length > 0) {
            for (int i = 0; i < sf.getAttributes().length; ++i) {
                attrs[i] = sf.getAttributes()[i];
            }
        }
        ftp.setAttributeTypes(attrs);
        if (this.theme.getDefinition().getDataSourceName() != null && attrs.length > 0) {
            Connection conn = null;
            try {
                String[] nonNullAttrs;
                conn = DSUtil.getDBConnection(this.theme.getDefinition().getDataSourceName(), null);
                if (conn != null && this.theme.getDefinition().getBasicThemeInfo().getBaseTable() != null && (nonNullAttrs = JDBCUtil.getNonNullAttributes(conn, this.theme.getDefinition().getBasicThemeInfo().getBaseTable())) != null && nonNullAttrs.length > 0) {
                    int len = attrs.length;
                    ArrayList<String> notnull = new ArrayList<String>();
                    block12: for (int i = 0; i < len; ++i) {
                        Field f = attrs[i];
                        String name = f.getName();
                        for (int j = 0; j < nonNullAttrs.length; ++j) {
                            if (!name.equalsIgnoreCase(nonNullAttrs[j])) continue;
                            if (notnull.contains(nonNullAttrs[j])) continue block12;
                            notnull.add(nonNullAttrs[j]);
                            continue block12;
                        }
                    }
                    if (notnull.size() > 0) {
                        ftp.setNotNullAttributes(notnull.toArray(new String[notnull.size()]));
                    }
                }
            }
            catch (Exception ex) {
                log.warning("Unable to check for non null attributes.");
            }
            finally {
                if (conn != null) {
                    try {
                        DSUtil.closeDBConnection(conn, this.theme.getDefinition().getDataSourceName());
                    }
                    catch (Exception e) {}
                }
            }
        }
        return ftp;
    }
}

