/*
 * Decompiled with CFR 0.152.
 */
package oracle.sdovis.raytracing;

import java.awt.color.ColorSpace;
import java.awt.image.BufferedImage;
import java.awt.image.ComponentColorModel;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import javax.vecmath.Point2d;
import javax.vecmath.Vector3d;
import oracle.sdovis.raytracing.Camera;
import oracle.sdovis.raytracing.DEMTracer;
import oracle.sdovis.raytracing.Group;
import oracle.sdovis.raytracing.Hit;
import oracle.sdovis.raytracing.LightSource;
import oracle.sdovis.raytracing.Material;
import oracle.sdovis.raytracing.PhongMaterial;
import oracle.sdovis.raytracing.Ray;
import oracle.sdovis.raytracing.Render3DException;

public class RTRenderer {
    Camera cam;
    Group gr;
    Vector3d background_color;
    Vector3d ambient_light;
    LightSource[] lights;
    Material[] materials;

    public RTRenderer() {
        this.cam = null;
        this.gr = null;
        this.background_color = null;
        this.ambient_light = null;
        this.lights = null;
        this.materials = null;
    }

    public RTRenderer(Camera cam_, Group gr_, Vector3d bkgCol, Vector3d ambLi, LightSource[] lights_, Material[] mats_) {
        this.cam = cam_;
        this.gr = gr_;
        this.background_color = bkgCol;
        this.ambient_light = ambLi;
        this.lights = lights_;
        this.materials = mats_;
    }

    public RenderedImage doRendering(WritableRaster ras, int bounces, int weight, int width, int height) {
        Vector3d bkg = this.background_color;
        Vector3d zero = new Vector3d();
        PhongMaterial background = new PhongMaterial(bkg, zero, 1.0, zero, zero, 1.0);
        DEMTracer dt = new DEMTracer(this, bounces, weight);
        double tmin = Double.NEGATIVE_INFINITY;
        int k1 = height - 1;
        for (int j = 0; j < width; ++j) {
            for (int k = 0; k < height; ++k) {
                Point2d out_point = new Point2d((double)k / (double)width, (double)j / (double)height);
                Ray theRay = this.cam.generateRay(out_point);
                Hit theHit = new Hit(Double.POSITIVE_INFINITY, background);
                Vector3d color = new Vector3d();
                color = dt.traceRay(theRay, tmin, bounces, weight, 1.0, theHit);
                double[] color_arr = new double[]{color.x, color.y, color.z};
                ras.setPixel(j, k1 - k, color_arr);
            }
        }
        ComponentColorModel cm = new ComponentColorModel(ColorSpace.getInstance(1000), false, false, 1, ras.getSampleModel().getDataType());
        BufferedImage bi = new BufferedImage(cm, ras, false, null);
        return bi;
    }

    public void saveTGA(String filename, int width, int height, Raster ras) throws FileNotFoundException, IOException, Render3DException {
        if (!(filename = filename.trim()).endsWith(".tga")) {
            // empty if block
        }
        FileOutputStream fos = new FileOutputStream(filename);
        byte[] header = new byte[18];
        for (int i = 0; i < 18; ++i) {
            header[i] = i == 2 ? 2 : (i == 12 ? (int)(width % 256) : (i == 13 ? (int)(width / 256) : (i == 14 ? (int)(height % 256) : (i == 15 ? (int)(height / 256) : (i == 16 ? 24 : (i == 17 ? 32 : 0))))));
        }
        fos.write(header);
        fos.flush();
        for (int y = 0; y < height; ++y) {
            byte[] data = new byte[width * 3];
            int z = 0;
            for (int x = 0; x < width; ++x) {
                double[] pix = new double[ras.getNumBands()];
                if (pix.length < 3) {
                    double tmp = pix[0];
                    pix = new double[]{tmp, tmp, tmp};
                }
                pix = ras.getPixel(x, y, pix);
                Vector3d v = new Vector3d(pix);
                data[z] = this.clampColorComponent(v.z);
                data[z + 1] = this.clampColorComponent(v.y);
                data[z + 2] = this.clampColorComponent(v.x);
                z += 3;
            }
            fos.write(data);
        }
        fos.flush();
        fos.close();
    }

    private byte clampColorComponent(double c) {
        int tmp = (int)(c * 255.0);
        if (tmp < 0) {
            tmp = 0;
        }
        if (tmp > 255) {
            tmp = 255;
        }
        return (byte)tmp;
    }

    public void setCamera(Camera cam_) {
        this.cam = cam_;
    }

    public void setGroup(Group gr_) {
        this.gr = gr_;
    }

    public void setBackgroundColor(Vector3d bkgCol) {
        this.background_color = bkgCol;
    }

    public void setAmbientLight(Vector3d ambLi) {
        this.ambient_light = ambLi;
    }

    public void setLights(LightSource[] lights_) {
        this.lights = lights_;
    }

    public void setMaterials(Material[] mats_) {
        this.materials = mats_;
    }

    public Camera getCamera() {
        return this.cam;
    }

    public Group getGroup() {
        return this.gr;
    }

    public Vector3d getBackgroundColor() {
        return this.background_color;
    }

    public Vector3d getAmbientLight() {
        return this.ambient_light;
    }

    public LightSource[] getLights() {
        return this.lights;
    }

    public LightSource getLight(int idx) {
        return this.lights[idx];
    }

    public Material[] getMaterials() {
        return this.materials;
    }

    public Material getMaterial(int idx) {
        return this.materials[idx];
    }
}

