/*
 * Decompiled with CFR 0.152.
 */
package oracle.sdovis.query;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import oracle.jdbc.OraclePreparedStatement;
import oracle.sdovis.query.SpatialOp;
import oracle.sdovis.util.Util;
import oracle.spatial.geometry.JGeometry;
import oracle.sql.STRUCT;

public class SDOWithinDistance
implements SpatialOp {
    protected double distance;
    protected String dataSource;
    protected String targetGeometryColumn;
    protected JGeometry opGeometry;
    protected boolean primaryFilterOnly = false;

    public SDOWithinDistance(String dsrc, String targetGeomColumn, double distanceInMeter) {
        this.dataSource = dsrc;
        this.targetGeometryColumn = targetGeomColumn;
        this.distance = distanceInMeter;
    }

    @Override
    public void setOperationGeometry(JGeometry geom) {
        this.opGeometry = geom;
    }

    @Override
    public JGeometry getOperationGeometry() {
        return this.opGeometry;
    }

    @Override
    public String getSpatialPredicate() {
        if (this.opGeometry == null) {
            throw new IllegalArgumentException("Operation geometry must be set!");
        }
        int srid = this.opGeometry.getSRID();
        String dist = "" + this.distance;
        String queryType = this.primaryFilterOnly ? " querytype=FILTER" : "";
        String pred = "SDO_WITHIN_DISTANCE(" + this.targetGeometryColumn + ", :svqwdistg, " + "'distance = " + dist + " unit=meter" + queryType + "') = 'TRUE'";
        return pred;
    }

    @Override
    public void prepare(PreparedStatement stmt) throws SQLException {
        STRUCT st = null;
        Connection conn = stmt.getConnection();
        Object[] descs = Util.createDBGeomDescriptors(conn);
        st = JGeometry.store((JGeometry)this.opGeometry, (Connection)conn, (Object[])descs);
        OraclePreparedStatement ops = (OraclePreparedStatement)stmt;
        ops.setObjectAtName("svqwdistg", (Object)st);
    }

    @Override
    public void setDataSource(String dsrc) {
        this.dataSource = dsrc;
    }

    @Override
    public String getDataSource() {
        return this.dataSource;
    }

    @Override
    public int getNumBindingVariables() {
        return 1;
    }

    @Override
    public int getSrid() {
        return this.opGeometry != null ? this.opGeometry.getSRID() : 0;
    }

    public void setPrimaryFilterOnly(boolean primaryFilterOnly) {
        this.primaryFilterOnly = primaryFilterOnly;
    }

    public boolean isPrimaryFilterOnly() {
        return this.primaryFilterOnly;
    }
}

