/*
 * Decompiled with CFR 0.152.
 */
package oracle.sdovis.query;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import oracle.jdbc.OraclePreparedStatement;
import oracle.sdovis.ds.AbstractDBDataSource;
import oracle.sdovis.ds.DSManager;
import oracle.sdovis.query.SDOFilter;
import oracle.sdovis.query.SpatialOp;
import oracle.sdovis.util.Util;
import oracle.spatial.geometry.JGeometry;
import oracle.sql.STRUCT;

public class SDORelate
implements SpatialOp {
    protected String dataSource;
    protected String targetGeometryColumn;
    protected JGeometry filterGeometry;
    double minResolution = Double.NaN;
    double maxResolution = Double.NaN;
    protected String mask;
    protected static String[] MASKS = new String[]{"anyinteract", "touch", "overlapbdyintersect", "equal", "inside", "coveredby", "contains", "covers", "on", "overlapbdydisjoint"};

    public SDORelate(String dsrc, String targetGeomColumn, String mask) {
        this.dataSource = dsrc;
        this.targetGeometryColumn = targetGeomColumn;
        if (mask == null) {
            mask = "anyinteract";
        } else {
            this.setMask(mask);
        }
    }

    @Override
    public void setOperationGeometry(JGeometry geom) {
        this.filterGeometry = geom;
    }

    @Override
    public JGeometry getOperationGeometry() {
        return this.filterGeometry;
    }

    @Override
    public int getSrid() {
        return this.filterGeometry != null ? this.filterGeometry.getSRID() : 0;
    }

    @Override
    public void prepare(PreparedStatement stmt) throws SQLException {
        STRUCT st = null;
        Connection conn = stmt.getConnection();
        Object[] descs = Util.createDBGeomDescriptors(conn);
        st = JGeometry.store((JGeometry)this.filterGeometry, (Connection)conn, (Object[])descs);
        OraclePreparedStatement ops = (OraclePreparedStatement)stmt;
        ops.setObjectAtName("svqfilterg", (Object)st);
        AbstractDBDataSource ads = (AbstractDBDataSource)DSManager.get(this.dataSource);
        if (ads == null) {
            throw new IllegalArgumentException("invalid data source.");
        }
        if (!ads.is9i() && !ads.isPre9i()) {
            if (!Double.isNaN(this.minResolution)) {
                ops.setDoubleAtName("svqminres", this.minResolution);
            }
            if (!Double.isNaN(this.maxResolution)) {
                ops.setDoubleAtName("svqmaxres", this.maxResolution);
            }
        }
    }

    @Override
    public String getSpatialPredicate() {
        AbstractDBDataSource ads = (AbstractDBDataSource)DSManager.get(this.dataSource);
        if (ads == null) {
            throw new IllegalArgumentException("invalid data source.");
        }
        StringBuffer sb = new StringBuffer(512);
        if (ads.is9i() || ads.isPre9i()) {
            sb.append("MDSYS.SDO_RELATE(" + this.targetGeometryColumn + ", " + ":svqfilterg, " + "'mask=" + this.mask + "'" + ") = 'TRUE'");
        } else if (Double.isNaN(this.minResolution) && Double.isNaN(this.maxResolution)) {
            sb.append("MDSYS.SDO_RELATE(" + this.targetGeometryColumn + ", " + ":svqfilterg, " + "'mask=" + this.mask + "'" + ") = 'TRUE'");
        } else {
            String p1 = Double.isNaN(this.minResolution) ? "" : " min_resolution=:svqminres";
            String p2 = Double.isNaN(this.maxResolution) ? "" : " max_resolution=:svqmaxres";
            String p = "'mask=" + this.mask + p1 + p2 + "'";
            sb.append("MDSYS.SDO_RELATE(" + this.targetGeometryColumn + ", " + ":svqfilterg, " + p + ") = 'TRUE'");
        }
        return sb.toString();
    }

    public void setMask(String mask) {
        boolean found = false;
        if (mask != null) {
            mask = mask.toLowerCase();
            for (int i = 0; i < MASKS.length; ++i) {
                if (!MASKS[i].equals(mask)) continue;
                found = true;
                break;
            }
        }
        if (mask == null || !found) {
            throw new IllegalArgumentException("Invalid mask for sdo_relate:" + mask + ".");
        }
        this.mask = mask;
    }

    public String getMask() {
        return this.mask;
    }

    @Override
    public void setDataSource(String dsrc) {
        this.dataSource = dsrc;
    }

    @Override
    public String getDataSource() {
        return this.dataSource;
    }

    public void setMinResoultion(double min) {
        this.minResolution = min;
    }

    public double getMinResoultion() {
        return this.minResolution;
    }

    public void setMaxResoultion(double max) {
        this.maxResolution = max;
    }

    public double getMaxResoultion() {
        return this.maxResolution;
    }

    @Override
    public int getNumBindingVariables() {
        return SDOFilter.getNumBindingVariables(this.dataSource, this.minResolution, this.maxResolution);
    }
}

