/*
 * Decompiled with CFR 0.152.
 */
package oracle.sdovis.edit.session.layer;

import java.sql.SQLException;
import oracle.sdovis.edit.session.layer.EditSessionLayer;
import oracle.sdovis.util.GMLGeometryUtils;
import oracle.spatial.geometry.JGeometry;
import oracle.sql.STRUCT;
import org.w3c.dom.Node;

public class GeometryEditSessionLayer
extends EditSessionLayer {
    public GeometryEditSessionLayer(String name) {
        this.name = name;
    }

    @Override
    public String getSpatialType() {
        return EditSessionLayer.GEOMETRY_TYPE;
    }

    @Override
    public boolean allowDataLoad() {
        return true;
    }

    public JGeometry parseElement(Node valueNode) throws Exception {
        return GMLGeometryUtils.parseGML(valueNode);
    }

    @Override
    public boolean allowGetConflicts() {
        return true;
    }

    @Override
    public String object2String(Object obj) throws Exception {
        return GMLGeometryUtils.toGML((JGeometry)obj);
    }

    @Override
    public boolean isMyObjectType(Object obj) {
        return obj instanceof JGeometry;
    }

    public JGeometry loadFromDB(Object obj) throws SQLException {
        return JGeometry.load((STRUCT)((STRUCT)obj));
    }

    public boolean isPartOfSpatialModel() {
        return this.getParameterValue("topology") != null || this.getParameterValue("network") != null;
    }
}

