/*
 * Decompiled with CFR 0.152.
 */
package oracle.sdovis.ds;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.HashMap;
import java.util.logging.Logger;
import oracle.mapviewer.share.util.LogFactory;
import oracle.mapviewer.template.TTemplate;
import oracle.mapviewer.template.TVectorLayer;
import oracle.sdovis.BasemapCache;
import oracle.sdovis.SRSCache;
import oracle.sdovis.StyleCache;
import oracle.sdovis.ThemeCache;
import oracle.sdovis.TileLayerCache;
import oracle.sdovis.ds.DataSourceI;
import oracle.sdovis.edit.session.EditSessionCache;

public class TemplateDataSource
implements DataSourceI {
    private static final Logger log = LogFactory.getLogger(LogFactory.LoggerEnum.SDOVIS);
    protected String name;
    protected boolean isEditable = false;
    protected String folder = null;
    protected String configFileName = null;
    protected TTemplate template = null;

    public TemplateDataSource() {
    }

    public TemplateDataSource(String name, String myFolder, String configFileName) {
        this.name = name.toUpperCase();
        this.folder = myFolder;
        if (!this.folder.endsWith(File.separator)) {
            this.folder = this.folder + File.separator;
        }
        this.configFileName = configFileName;
        boolean res = this.loadMetaData();
        if (!res) {
            throw new IllegalArgumentException("Invalid template data source found.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean loadMetaData() {
        FileInputStream fis = null;
        try {
            File conf = new File(this.folder + this.configFileName);
            fis = new FileInputStream(conf);
            this.template = new TTemplate();
            this.template.loadTemplate((InputStream)fis);
            boolean bl = true;
            return bl;
        }
        catch (Exception x) {
            log.warning("Exception while loading metadata for template " + this.folder);
            boolean bl = false;
            return bl;
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (Exception ex) {}
            }
        }
    }

    public TTemplate getTemplate() {
        return this.template;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void close() {
    }

    @Override
    public boolean isClosed() {
        return false;
    }

    @Override
    public HashMap getMetaDataDefinition(String name, int type) {
        return null;
    }

    @Override
    public HashMap storeMetaDataDefinition(String name, int type, HashMap data) {
        return null;
    }

    @Override
    public HashMap deleteMetaData(String name, int type) {
        return null;
    }

    @Override
    public StyleCache getStyleCache() {
        return null;
    }

    @Override
    public ThemeCache getThemeCache() {
        return null;
    }

    @Override
    public BasemapCache getBasemapCache() {
        return null;
    }

    @Override
    public TileLayerCache getTileLayerCache() {
        return null;
    }

    @Override
    public EditSessionCache getEditSessionCache() {
        return null;
    }

    @Override
    public SRSCache getSRSCache() {
        return null;
    }

    @Override
    public String getTemporaryDirectory() {
        return null;
    }

    @Override
    public void setTemporaryDirectory(String dir) {
    }

    @Override
    public String getOwner() {
        return null;
    }

    @Override
    public boolean isEditable() {
        return this.isEditable;
    }

    @Override
    public void setIsEditable(boolean v) {
        this.isEditable = v;
    }

    @Override
    public boolean isJDBCThemeAllowed() {
        return false;
    }

    @Override
    public void setJDBCThemeAllowed(boolean v) {
    }

    public String getThemeInfo(String vectorLayer) {
        TVectorLayer tvl = this.template.getVectorLayerByName(vectorLayer);
        if (tvl != null) {
            return tvl.getThemeInfoXML();
        }
        return "";
    }
}

