/*
 * Decompiled with CFR 0.152.
 */
package oracle.sdovis.ds;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.InitialContext;
import javax.sql.DataSource;
import oracle.jdbc.OracleConnection;
import oracle.mapviewer.share.util.LogFactory;
import oracle.sdovis.ds.AbstractDBDataSource;
import oracle.sdovis.ds.DSUtil;
import oracle.sdovis.util.Util;

public class ContainerDataSource
extends AbstractDBDataSource {
    private static final Logger log = LogFactory.getLogger(LogFactory.LoggerEnum.SDOVIS);
    private DataSource ds;
    private String jndiLocation;

    public ContainerDataSource(String name, String jndiLocation) {
        try {
            InitialContext ic = new InitialContext();
            this.ds = (DataSource)ic.lookup(jndiLocation);
            this.name = name;
            this.jndiLocation = jndiLocation;
            this.closed = false;
            Connection c = this.ds.getConnection();
            this.dbProductVersion = Util.getDBVersion(c);
            this.is9i = Util.is9i(c);
            this.pre9i = Util.isPre9i(c);
            this.tenG = Util.is10g(c);
            DSUtil.createArrayTypes(c, name);
            c.close();
        }
        catch (Exception ne) {
            ne.printStackTrace(System.err);
            throw new IllegalArgumentException("Invalid JNDI location encountered when creating NativeOracleDataSource.");
        }
    }

    public ContainerDataSource(String name, DataSource dataSrc) {
        try {
            this.name = name;
            this.ds = dataSrc;
            this.closed = false;
            Connection c = this.ds.getConnection();
            this.pre9i = Util.isPre9i(c);
            this.tenG = Util.is10g(c);
            c.close();
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            throw new IllegalArgumentException("Invalid existing DataSource instance.");
        }
    }

    @Override
    public Connection getConnection() throws SQLException {
        return this.ds.getConnection();
    }

    @Override
    public Connection getConnection(String user, String passwd) throws SQLException {
        return this.ds.getConnection(user, passwd);
    }

    @Override
    public Connection getProxyConnection(String type, Properties p) throws SQLException {
        OracleConnection conn = (OracleConnection)this.ds.getConnection();
        int t = 1;
        if ("DISTINGUISHED_NAME".equals(type)) {
            t = 2;
        }
        conn.openProxySession(t, p);
        return conn;
    }

    @Override
    public void close() {
    }

    @Override
    public boolean supportOLS() {
        return false;
    }

    @Override
    public DataSource getUnwrappedDataSource() {
        return this.ds;
    }

    public String getJNDILocation() {
        return this.jndiLocation;
    }

    @Override
    public String getUserInfoPackageName() {
        return this.userInfoPackageName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setUserInfoPackageName(String pkgName) {
        this.userInfoPackageName = pkgName;
        Connection conn = null;
        try {
            conn = this.getConnection();
            boolean valid = DSUtil.validPLSQLPackage(conn, pkgName);
            this.setUserIfnoPackageValid(valid);
            if (!valid) {
                log.warning("PL/SQL package " + pkgName + " will be ignored.");
            }
        }
        catch (Exception e) {
            log.log(Level.WARNING, "Error validating pl/sql package " + pkgName + ".", e);
            this.setUserIfnoPackageValid(false);
            log.warning("PL/SQL package " + pkgName + " will be ignored.");
        }
        finally {
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getUser() {
        if (this.ds == null) {
            return null;
        }
        Connection c = null;
        try {
            c = this.ds.getConnection();
            DatabaseMetaData meta = c.getMetaData();
            String string = meta.getUserName().toUpperCase();
            return string;
        }
        catch (Exception ne) {
            log.severe(ne.getMessage());
            String string = null;
            return string;
        }
        finally {
            if (c != null) {
                try {
                    c.close();
                }
                catch (Exception e) {}
            }
        }
    }
}

