/*
 * Decompiled with CFR 0.152.
 */
package oracle.sdovis.charts.internal;

import java.util.Vector;

public final class SliceLabelBreak {
    boolean test = false;
    String pieLabel;
    String SeparateLineChars = "";
    Vector[] SliceLabelPermutations;
    Vector[] SliceLabelBest;
    int[] labelBlockWidthIndex;
    int numDelimiters = 0;
    int numPermutations = 0;
    char[] Delimiters = new char[]{' '};
    int[] indexOfDelimiters;
    boolean lastWordNewline = false;

    public SliceLabelBreak(String label) {
        this.pieLabel = label.trim();
    }

    public Vector getLabel(int index) {
        return this.SliceLabelBest[index];
    }

    public int getNumDelimiters() {
        return this.numDelimiters;
    }

    void setLabel(String label) {
        this.pieLabel = label.trim();
    }

    public void setDelimiters(char[] delimiters) {
        this.Delimiters = delimiters;
    }

    int countDelimiters() {
        int s;
        int numDelimiters = 0;
        int k = 0;
        for (s = 0; s < this.Delimiters.length; ++s) {
            k = 0;
            while (k != -1) {
                if ((k = this.pieLabel.indexOf(this.Delimiters[s], k)) == -1) continue;
                ++k;
                ++numDelimiters;
            }
        }
        if (numDelimiters == 0) {
            return numDelimiters;
        }
        this.indexOfDelimiters = new int[numDelimiters];
        numDelimiters = 0;
        int[] kIndex = new int[this.Delimiters.length];
        for (s = 0; s < this.Delimiters.length; ++s) {
            kIndex[s] = 0;
        }
        for (s = 0; s < this.Delimiters.length; ++s) {
            kIndex[s] = this.pieLabel.indexOf(this.Delimiters[s], kIndex[s]);
        }
        while (true) {
            int smallestIndex = 1000;
            int smallestDelimiter = -1;
            for (s = 0; s < this.Delimiters.length; ++s) {
                if (kIndex[s] == -1 || kIndex[s] >= smallestIndex) continue;
                smallestIndex = kIndex[s];
                smallestDelimiter = s;
            }
            if (smallestDelimiter == -1) break;
            this.indexOfDelimiters[numDelimiters] = smallestIndex;
            kIndex[smallestDelimiter] = this.pieLabel.indexOf(this.Delimiters[smallestDelimiter], smallestIndex + 1);
            ++numDelimiters;
        }
        return numDelimiters;
    }

    public void setLastWordNewline() {
        this.lastWordNewline = true;
    }

    void rank() {
        int i;
        this.labelBlockWidthIndex = new int[this.numDelimiters];
        int[] minBlockWidth = new int[this.numDelimiters];
        for (i = 0; i < this.numDelimiters; ++i) {
            minBlockWidth[i] = Integer.MAX_VALUE;
            this.labelBlockWidthIndex[i] = -1;
        }
        if (this.test) {
            System.out.println("numPerm " + this.numPermutations);
        }
        for (i = 0; i < this.numPermutations - 1; ++i) {
            if (this.test) {
                System.out.println("i = " + i);
                this.dump(i);
            }
            if ((!this.lastWordNewline || !this.isLastWordNewline(i)) && this.lastWordNewline) continue;
            if (this.isSpecialCharCompliant(this.SliceLabelPermutations[i])) {
                int index = this.SliceLabelPermutations[i].size() - 2;
                int phraseWidth = this.getWidth(this.SliceLabelPermutations[i]);
                if (phraseWidth >= minBlockWidth[index]) continue;
                this.labelBlockWidthIndex[index] = i;
                minBlockWidth[index] = phraseWidth;
                continue;
            }
            if (!this.test) continue;
            System.out.println("Not Compliant");
        }
        for (i = 0; i < this.numDelimiters; ++i) {
            if (this.labelBlockWidthIndex[i] > -1) {
                this.SliceLabelBest[i] = this.SliceLabelPermutations[this.labelBlockWidthIndex[i]];
                if (this.test) {
                    System.out.println("assign " + this.labelBlockWidthIndex[i]);
                }
                if (!this.test) continue;
                System.out.println("assign " + this.SliceLabelBest[i]);
                continue;
            }
            this.SliceLabelBest[i] = null;
        }
    }

    boolean isLastWordNewline(int counter) {
        return counter % 2 == 0;
    }

    int getWidth(Vector p) {
        int maxStringLength = 0;
        for (int i = 0; i < p.size(); ++i) {
            String s = (String)p.elementAt(i);
            if (s.length() <= maxStringLength) continue;
            maxStringLength = s.length();
        }
        return maxStringLength;
    }

    boolean isSpecialCharCompliant(Vector p) {
        if (this.SeparateLineChars.length() == 0) {
            return true;
        }
        boolean maxStringLength = false;
        for (int i = 0; i < p.size(); ++i) {
            String s = (String)p.elementAt(i);
            if (!this.containsDelimiters(s)) continue;
            for (int j = 0; j < this.SeparateLineChars.length(); ++j) {
                if (s.indexOf(this.SeparateLineChars.charAt(j)) <= -1) continue;
                return false;
            }
        }
        return true;
    }

    private boolean containsDelimiters(String str) {
        for (int s = 0; s < this.Delimiters.length; ++s) {
            if (str.indexOf(this.Delimiters[s]) <= -1) continue;
            return true;
        }
        return false;
    }

    void increment(int[] counter) {
        int digits = counter.length;
        if (counter.length == 0) {
            return;
        }
        int last_digit = digits - 1;
        counter[last_digit] = (counter[last_digit] + 1) % 2;
        for (int i = last_digit - 1; i >= 0; --i) {
            if (counter[i + 1] != 0) {
                return;
            }
            counter[i] = (counter[i] + 1) % 2;
        }
    }

    void printCounter(int[] counter) {
        System.out.print("Counter [");
        for (int i = 0; i < counter.length; ++i) {
            System.out.print(counter[i]);
        }
        System.out.println("]");
    }

    public void printBestSliceLabel() {
        System.out.println("Best Slice Label: ");
        for (int i = 0; i < this.labelBlockWidthIndex.length; ++i) {
            System.out.print("(" + (i + 2) + ", " + this.labelBlockWidthIndex[i] + ")");
        }
        System.out.println("");
    }

    public void dump(int index) {
        for (int i = 0; i < this.SliceLabelPermutations[index].size(); ++i) {
            String s = (String)this.SliceLabelPermutations[index].elementAt(i);
            System.out.println(s);
        }
        System.out.println();
    }

    public void init(String SeparateLineChars) {
        int i;
        this.SeparateLineChars = SeparateLineChars;
        this.numDelimiters = this.countDelimiters();
        int[] counter = new int[this.numDelimiters];
        for (i = 0; i < this.numDelimiters; ++i) {
            counter[i] = 0;
        }
        this.numPermutations = (int)Math.pow(2.0, this.numDelimiters);
        this.SliceLabelPermutations = new Vector[this.numPermutations];
        this.SliceLabelBest = new Vector[this.numDelimiters];
        for (i = 0; i < this.numPermutations - 1; ++i) {
            this.SliceLabelPermutations[i] = new Vector();
            this.increment(counter);
            int digits = counter.length;
            int lastIndex = 0;
            for (int j = 0; j < digits; ++j) {
                if (counter[j] != 1) continue;
                String word = new String(this.pieLabel.substring(lastIndex, this.indexOfDelimiters[j] + 1));
                word = word.trim();
                this.SliceLabelPermutations[i].addElement(word);
                lastIndex = this.indexOfDelimiters[j] + 1;
            }
            this.SliceLabelPermutations[i].addElement(new String(this.pieLabel.substring(lastIndex)));
        }
        this.rank();
    }
}

