/*
 * Decompiled with CFR 0.152.
 */
package oracle.sdovis;

import java.awt.Color;
import java.awt.Image;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.lbs.mapcache.MapCacheServer;
import oracle.lbs.mapcache.cache.MapCache;
import oracle.mapviewer.share.NorthArrow;
import oracle.mapviewer.share.ScaleBar;
import oracle.sdovis.BaseMap;
import oracle.sdovis.BasemapCache;
import oracle.sdovis.CasedLineHelper;
import oracle.sdovis.DBMapMaker;
import oracle.sdovis.DataException;
import oracle.sdovis.Legend;
import oracle.sdovis.LiveFeature;
import oracle.sdovis.MapCacheTheme;
import oracle.sdovis.NsDpHandler;
import oracle.sdovis.Proj;
import oracle.sdovis.SRS;
import oracle.sdovis.SRSCache;
import oracle.sdovis.StyleCache;
import oracle.sdovis.StyledFeatureI;
import oracle.sdovis.ThemeList;
import oracle.sdovis.UTFGrid;
import oracle.sdovis.VisConstants;
import oracle.sdovis.VisException;
import oracle.sdovis.WMTSTheme;
import oracle.sdovis.XFViewPort;
import oracle.sdovis.ds.AbstractDBDataSource;
import oracle.sdovis.ds.DSManager;
import oracle.sdovis.ds.DataSourceI;
import oracle.sdovis.style.Style;
import oracle.sdovis.style.StyleText;
import oracle.sdovis.style.TextStroke;
import oracle.sdovis.util.RectArray;
import oracle.sdovis.util.UserIdentity;

public class VisContext
implements VisConstants {
    public static boolean MAC_OS_X = false;
    public static int BUFFER_LABEL_THEME = 256;
    public static int BUFFER_VECTOR_THEME = 64;
    public static int STYLE_REGULAR = 1;
    public static int STYLE_UTFGRID = 2;
    public static int STYLE_TRANSPARENT = 3;
    String masterDataSourceName;
    int masterSRID;
    boolean antialiasing = true;
    Rectangle2D deviceWindow;
    int imageType;
    boolean imageScaling;
    BufferedImage mapImage;
    BufferedImage legendImage;
    Vector liveFeatures;
    Rectangle2D queryWindow;
    int queryWindowSrid;
    SRS srs = new SRS();
    ThemeList themeList;
    boolean textAntialiasing;
    boolean transparent;
    private UTFGrid utfGrid = null;
    private Boolean isWithUTFGrid = false;
    private short utfgrid_resolution = (short)4;
    boolean noRequery = false;
    AffineTransform affineXF;
    int deviceType;
    Legend legend;
    Color bgColor;
    Image bgImage;
    String bgImageUrl;
    String footnote;
    String footnotePos;
    String footnoteStyleName;
    StyleText footnoteStyle;
    String title;
    String titlePos;
    String titleStyleName;
    StyleText titleStyle;
    XFViewPort xfViewport;
    Hashtable dynamicStyles;
    boolean ugp;
    boolean bBox = false;
    String mapFileName;
    RectArray limitRects = null;
    RectArray markerLimitRects = null;
    RectArray renderedMarkerLimitRects = null;
    TextStroke textStroke = null;
    int zoomLevels = 4;
    double zoomFactor = 2.0;
    String[] boundingThemes = null;
    float boundingThemeBorderMargin = 0.05f;
    boolean boundingThemeKeepAspectRatio = true;
    double boundingSizeHint = 0.0;
    boolean renderRasterOnly = false;
    boolean renderRasterBaseMap = false;
    ScaleBar scaleBar = null;
    double lastMapScale = 0.0;
    private boolean isTileRequest = false;
    private boolean isFOIRequest = false;
    private boolean isGetFeatureInfoRequest = false;
    boolean keepThemesOrder = false;
    Vector nsdpHandlers = null;
    MapCache mapCache = null;
    BaseMap.PredefinedThemeDesc[] baseMapThemes = null;
    boolean snapToCachedScale = false;
    boolean wrapAround = false;
    String[] rasterThemeNames = null;
    String[] rasterImageNames = null;
    double currentScale = Double.POSITIVE_INFINITY;
    double currentRatioScale = Double.POSITIVE_INFINITY;
    Proj projection = null;
    boolean interrupted = false;
    boolean useCachedBaseMap = false;
    private String cachedBaseMap = null;
    String proxyType = null;
    Properties proxyProperties = null;
    String proxyDataSrc = null;
    UserIdentity userIdentity = null;
    private boolean disableMapPieces = false;
    private CasedLineHelper casedLines = new CasedLineHelper(15);
    private double rotation = 0.0;
    private double lastRotation = 0.0;
    private NorthArrow northArrow = null;
    private DataException dataException = null;
    private boolean isPDFrequest = false;
    private Rectangle2D queryWindowConstraint = null;
    private int markerSequenceFormat = 0;
    private int markerSequence = 0;
    private int themeWindowBuffer = 0;
    private String userLanguage = null;
    private double dpi = SRS.getDPI();
    private StyleCache tempStyleCache = null;

    public VisContext() {
        this.themeList = new ThemeList();
        this.reset();
    }

    private void destroy() {
        if (this.mapImage != null) {
            this.mapImage.flush();
            this.mapImage = null;
        }
        if (this.legendImage != null) {
            this.legendImage.flush();
            this.legendImage = null;
        }
        if (this.bgImage != null) {
            this.bgImage.flush();
            this.bgImage = null;
        }
        if (this.dynamicStyles != null) {
            this.dynamicStyles.clear();
        }
        if (this.liveFeatures != null) {
            this.liveFeatures.clear();
        }
        if (this.themeList != null) {
            this.themeList.clear();
        }
        if (this.limitRects != null) {
            this.limitRects.reset();
        }
        if (this.markerLimitRects != null) {
            this.markerLimitRects.reset();
        }
        if (this.renderedMarkerLimitRects != null) {
            this.renderedMarkerLimitRects.reset();
        }
        this.boundingThemes = null;
        if (this.casedLines != null) {
            this.casedLines.clear();
        }
        this.dataException = null;
    }

    public void reset() {
        this.destroy();
        this.masterDataSourceName = null;
        this.masterSRID = 0;
        this.antialiasing = true;
        this.deviceWindow = null;
        this.imageType = VisContext.getDefaultImageType();
        this.imageScaling = true;
        this.liveFeatures = null;
        this.queryWindow = null;
        this.queryWindowSrid = 0;
        this.srs = new SRS();
        this.noRequery = false;
        this.bBox = false;
        this.textAntialiasing = true;
        this.transparent = false;
        this.affineXF = null;
        this.deviceType = 1;
        this.legend = null;
        this.bgColor = DEFAULT_MAP_BACKGROUND;
        this.footnote = null;
        this.footnotePos = null;
        this.footnoteStyleName = null;
        this.footnoteStyle = null;
        this.title = null;
        this.titlePos = null;
        this.titleStyleName = null;
        this.titleStyle = null;
        this.xfViewport = new XFViewPort();
        this.ugp = false;
        this.mapFileName = null;
        this.zoomLevels = 4;
        this.zoomFactor = 2.0;
        this.boundingThemeBorderMargin = 0.05f;
        this.boundingThemeKeepAspectRatio = true;
        this.scaleBar = null;
        this.lastMapScale = 0.0;
        this.isTileRequest = false;
        this.isFOIRequest = false;
        this.removeAllNsDpHandlers();
        this.baseMapThemes = null;
        this.mapCache = null;
        this.snapToCachedScale = false;
        this.rasterThemeNames = null;
        this.rasterImageNames = null;
        this.currentScale = Double.POSITIVE_INFINITY;
        this.currentRatioScale = Double.POSITIVE_INFINITY;
        this.projection = null;
        this.interrupted = false;
        this.useCachedBaseMap = false;
        this.cachedBaseMap = null;
        this.proxyType = null;
        this.proxyProperties = null;
        this.proxyDataSrc = null;
        this.userIdentity = null;
        this.disableMapPieces = false;
        this.rotation = 0.0;
        this.lastRotation = 0.0;
        this.northArrow = null;
        this.dataException = null;
    }

    public String getMasterDataSourceName() {
        return this.masterDataSourceName;
    }

    public void setMasterDataSourceName(String mds) {
        this.masterDataSourceName = mds;
    }

    public int getMasterSRID() {
        return this.masterSRID;
    }

    public void setMasterSRID(int msrid) {
        this.masterSRID = msrid;
        DataSourceI ds = DSManager.get(this.masterDataSourceName);
        if (ds != null) {
            SRSCache sc = ds.getSRSCache();
            this.srs = sc.get(msrid);
        }
    }

    public boolean getAntialiasing() {
        return this.antialiasing;
    }

    public void setAntialiasing(boolean v) {
        this.antialiasing = v;
    }

    public Rectangle2D getDeviceWindow() {
        return this.deviceWindow;
    }

    public void setDeviceWindow(Rectangle2D r2d) throws VisException {
        this.deviceWindow = r2d;
        int w = (int)r2d.getWidth();
        int h = (int)r2d.getHeight();
        this.allocateImage(w, h, this.imageType);
    }

    public int getImageType() {
        return this.imageType;
    }

    public void setImageType(int newType) throws VisException {
        int oldType = this.imageType;
        this.imageType = newType;
        if (newType == 12 || newType == 10) {
            this.setDeviceType(3);
        } else {
            this.setDeviceType(1);
        }
        if (oldType != newType && this.deviceWindow != null) {
            this.allocateImage((int)this.deviceWindow.getWidth(), (int)this.deviceWindow.getHeight(), this.imageType);
        }
    }

    public boolean getImageScaling() {
        return this.imageScaling;
    }

    public void setImageScaling(boolean v) {
        this.imageScaling = v;
    }

    public BufferedImage getMapImage() {
        return this.mapImage;
    }

    public void setMapImage(BufferedImage bimage) {
        this.mapImage = bimage;
    }

    public BufferedImage getLegendImage() {
        return this.legendImage;
    }

    public void setLegendImage(BufferedImage limage) {
        this.legendImage = limage;
    }

    public Vector getLiveFeatures() {
        return this.liveFeatures;
    }

    public void setLiveFeatures(Vector features) {
        this.liveFeatures = features;
    }

    public void clearLiveFeatures() {
        if (this.liveFeatures != null) {
            this.liveFeatures.clear();
        }
    }

    public void addLiveFeature(StyledFeatureI sf) {
        LiveFeature cf = new LiveFeature();
        if (sf.getPoint() != null) {
            Point2D p = sf.getPoint();
            cf.setCenter(p.getX(), p.getY());
        } else {
            cf.setShape(sf.getShape());
        }
        cf.setGeomType(sf.getGeomType());
        if (sf.getNumAttributes() > 0) {
            int i;
            String[] as = new String[sf.getNumAttributes()];
            int countR = sf.getNumRenderableAttributes();
            for (i = 0; i < countR; ++i) {
                as[i] = "" + sf.getRenderableAttribute(i).getValue();
            }
            for (i = 0; i < sf.getNumIdentifiableAttributes(); ++i) {
                as[countR + i] = "" + sf.getIdentifiableAttribute(i).getValue();
            }
            cf.setAttrs(as);
        }
        cf.setLabel(sf.getLabel());
        cf.setMarkerStyleSize(sf.getMarkerStyleSize());
        cf.setRadius(sf.getRadius());
        if (this.liveFeatures == null) {
            this.liveFeatures = new Vector(32);
        }
        this.liveFeatures.add(cf);
    }

    public Rectangle2D getQueryWindow() {
        return this.queryWindow;
    }

    public void setQueryWindow(Rectangle2D r2d) {
        this.queryWindow = r2d;
    }

    public int getQueryWindowSrid() {
        return this.queryWindowSrid;
    }

    public void setQueryWindowSrid(int srid) {
        this.queryWindowSrid = srid;
    }

    public SRS getSrs() {
        return this.srs;
    }

    public void setSrs(SRS srs) {
        this.srs = srs;
        if (srs != null) {
            this.masterSRID = srs.getSRID();
        }
    }

    public ThemeList getThemeList() {
        return this.themeList;
    }

    public void setThemeList(ThemeList tl) {
        this.themeList = tl;
    }

    public boolean getTextAntialiasing() {
        return this.textAntialiasing;
    }

    public void setTextAntialiasing(boolean v) {
        this.textAntialiasing = v;
    }

    public boolean getTransparent() {
        return this.transparent;
    }

    public void setTransparent(boolean v) {
        this.transparent = v;
    }

    public AffineTransform getAffineXF() {
        return this.affineXF;
    }

    public void setAffineXF(AffineTransform axf) {
        this.affineXF = axf;
    }

    public int getDeviceType() {
        return this.deviceType;
    }

    public void setDeviceType(int dt) {
        this.deviceType = dt;
    }

    public Legend getLegend() {
        return this.legend;
    }

    public void setLegend(Legend gd) {
        this.legend = gd;
    }

    public Color getBgColor() {
        return this.bgColor;
    }

    public void setBgColor(Color c) {
        this.bgColor = c;
    }

    public Image getBgImage() {
        return this.bgImage;
    }

    public void setBgImage(Image img) {
        this.bgImage = img;
    }

    public String getBgImageUrl() {
        return this.bgImageUrl;
    }

    public void setBgImageUrl(String img) {
        this.bgImageUrl = img;
    }

    public String getFootnote() {
        return this.footnote;
    }

    public void setFootnote(String note) {
        this.footnote = note;
    }

    public String getFootnotePos() {
        return this.footnotePos;
    }

    public void setFootnotePos(String pos) {
        this.footnotePos = pos;
    }

    public String getFootnoteStyleName() {
        return this.footnoteStyleName;
    }

    public void setFootnoteStyleName(String sty) {
        this.footnoteStyleName = sty;
        if (sty == null) {
            return;
        }
        if (this.footnoteStyle != null && !this.footnoteStyle.getModel().getName().equalsIgnoreCase(sty)) {
            this.footnoteStyle = null;
        }
    }

    public StyleText getFootnoteStyle() {
        return this.footnoteStyle;
    }

    public void setFootnoteStyle(StyleText st) {
        this.footnoteStyle = st;
        this.footnoteStyleName = st != null ? st.getModel().getName() : null;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String t) {
        this.title = t;
    }

    public String getTitlePos() {
        return this.titlePos;
    }

    public void setTitlePos(String pos) {
        this.titlePos = pos;
    }

    public String getTitleStyleName() {
        return this.titleStyleName;
    }

    public void setTitleStyleName(String sty) {
        this.titleStyleName = sty;
        if (sty == null) {
            return;
        }
        if (this.titleStyle != null && !this.titleStyle.getModel().getName().equalsIgnoreCase(sty)) {
            this.titleStyle = null;
        }
    }

    public StyleText getTitleStyle() {
        return this.titleStyle;
    }

    public void setTitleStyle(StyleText sty) {
        this.titleStyle = sty;
        this.titleStyleName = sty != null ? sty.getModel().getName() : null;
    }

    public XFViewPort getViewportTransform() {
        return this.xfViewport;
    }

    public void setViewportTransform(XFViewPort xfp) {
        this.xfViewport = xfp;
    }

    public Hashtable getDynamicStyles() {
        return this.dynamicStyles;
    }

    public void setDynamicStyles(Hashtable styles) {
        this.dynamicStyles = styles;
    }

    public void addDynamicStyle(String name, Style sty) {
        if (this.dynamicStyles == null) {
            this.dynamicStyles = new Hashtable();
        }
        this.dynamicStyles.put(name.toUpperCase(), sty);
    }

    public Style getDynamicStyle(String name) {
        return this.dynamicStyles == null ? null : (Style)this.dynamicStyles.get(name.toUpperCase());
    }

    public void clearDynamicStyles() {
        if (this.dynamicStyles != null) {
            this.dynamicStyles.clear();
        }
    }

    public boolean getUgp() {
        return this.ugp;
    }

    public void setUgp(boolean v) {
        this.ugp = v;
    }

    public boolean getBBox() {
        return this.bBox;
    }

    public void setBBox(boolean v) {
        this.bBox = v;
    }

    public void setNoQuery(boolean v) {
        this.noRequery = v;
    }

    public boolean getNoQuery() {
        return this.noRequery;
    }

    public RectArray getCRArray() {
        return this.limitRects;
    }

    public void setCRArray(RectArray ra) {
        this.limitRects = ra;
    }

    public RectArray getMarkerCRArray() {
        return this.markerLimitRects;
    }

    public void setMarkerCRArray(RectArray ra) {
        this.markerLimitRects = ra;
    }

    public RectArray getRenderedMarkerCRArray() {
        return this.renderedMarkerLimitRects;
    }

    public void setRenderedMarkerCRArray(RectArray ra) {
        this.renderedMarkerLimitRects = ra;
    }

    public TextStroke getTextStroke() {
        return this.textStroke;
    }

    public void setTextStroke(TextStroke ts) {
        this.textStroke = ts;
    }

    public void setMapFileName(String name) {
        this.mapFileName = name;
    }

    public String getMapFileName() {
        return this.mapFileName;
    }

    public Style resolveStyle(String styleName) {
        return this.resolveStyle(styleName, this.masterDataSourceName);
    }

    public Style resolveStyle(String styleName, String dataSource) {
        Style sty;
        if (styleName == null) {
            return null;
        }
        if (this.dynamicStyles != null && (sty = (Style)this.dynamicStyles.get(styleName.toUpperCase())) != null) {
            return sty;
        }
        if (dataSource == null) {
            dataSource = this.masterDataSourceName;
        }
        try {
            DataSourceI ds = DSManager.get(dataSource);
            StyleCache sc = ds.getStyleCache();
            return sc.get(styleName);
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            return null;
        }
    }

    public static int getDefaultImageType() {
        return 2;
    }

    private void allocateImage(int w, int h, int type) throws VisException {
        if (this.mapImage != null) {
            this.mapImage.flush();
        }
        this.mapImage = null;
        try {
            this.mapImage = new BufferedImage(w, h, type);
        }
        catch (OutOfMemoryError e) {
            System.gc();
            throw new VisException("Out of memory error. Map image size is too big? " + w + " x " + h, e);
        }
    }

    public void setBoundingThemes(String[] themes, float borderMargin, boolean keepAspectRatio) {
        if (themes == null) {
            this.boundingThemes = null;
            return;
        }
        this.boundingThemes = new String[themes.length];
        for (int i = 0; i < themes.length; ++i) {
            this.boundingThemes[i] = themes[i];
        }
        this.boundingThemeBorderMargin = borderMargin < 0.0f ? 0.05f : borderMargin;
        this.boundingThemeKeepAspectRatio = keepAspectRatio;
    }

    public void setBoundingThemesSizeHint(double size) {
        this.boundingSizeHint = size;
    }

    public String[] getBoundingThemes() {
        return this.boundingThemes;
    }

    public float getBorderMarginForBoundingThemes() {
        return this.boundingThemeBorderMargin;
    }

    public double getBoundingThemesSizeHint() {
        return this.boundingSizeHint;
    }

    public boolean boundingThemesRespectAspectRatio() {
        return this.boundingThemeKeepAspectRatio;
    }

    public boolean renderRasterOnly() {
        return this.renderRasterOnly;
    }

    public void setRenderRasterOnly(boolean v) {
        this.renderRasterOnly = v;
    }

    public boolean hasRasterThemes() {
        return this.themeList != null ? this.themeList.hasRasterThemes() : false;
    }

    public void setScaleBar(ScaleBar sbar) {
        this.scaleBar = sbar;
    }

    public ScaleBar getScaleBar() {
        return this.scaleBar;
    }

    public double getLastMapScale() {
        return this.lastMapScale;
    }

    public void setLastMapScale(double s) {
        this.lastMapScale = s;
    }

    public boolean isTileRequest() {
        return this.isTileRequest;
    }

    public boolean isGetFeatureInfoRequest() {
        return this.isGetFeatureInfoRequest;
    }

    public boolean isFOIRequest() {
        return this.isFOIRequest;
    }

    public void setIsTileRequest(boolean tileRequest) {
        this.isTileRequest = tileRequest;
        this.bgColor = null;
    }

    public void setIsFOIRequest(boolean foiRequest) {
        this.isFOIRequest = foiRequest;
    }

    public void setIsGetFeatureInfoRequest(boolean gfiRequest) {
        this.isGetFeatureInfoRequest = gfiRequest;
    }

    public void addNsDpHandler(NsDpHandler nsdp) {
        if (this.nsdpHandlers == null) {
            this.nsdpHandlers = new Vector();
        }
        this.nsdpHandlers.add(nsdp);
    }

    public boolean getKeepThemesOrder() {
        return this.keepThemesOrder;
    }

    public void setKeepThemesOrder(boolean order) {
        this.keepThemesOrder = order;
    }

    public void removeNsDp(NsDpHandler nsdp) {
        if (this.nsdpHandlers == null || this.nsdpHandlers.size() == 0) {
            return;
        }
        this.nsdpHandlers.remove(nsdp);
    }

    public void removeAllNsDpHandlers() {
        if (this.nsdpHandlers == null || this.nsdpHandlers.size() == 0) {
            return;
        }
        for (int i = 0; i < this.nsdpHandlers.size(); ++i) {
            NsDpHandler h = (NsDpHandler)this.nsdpHandlers.get(i);
            h.destroy();
        }
        this.nsdpHandlers.removeAllElements();
    }

    public Vector getNsDpHandlers() {
        return this.nsdpHandlers;
    }

    public MapCache getMapCache() {
        return this.mapCache;
    }

    public void removeBaseMapThemes() {
        if (this.baseMapThemes == null || this.baseMapThemes.length == 0) {
            return;
        }
        for (int i = 0; i < this.baseMapThemes.length; ++i) {
            this.themeList.removeTheme(this.baseMapThemes[i].name);
        }
    }

    public void setSnapToCachedZoomLevel(boolean snap) {
        this.snapToCachedScale = snap;
    }

    public boolean snapToCachedScale() {
        return this.snapToCachedScale;
    }

    public boolean getWrapAround() {
        return this.wrapAround;
    }

    public void setWrapAround(boolean wa) {
        this.wrapAround = wa;
    }

    public boolean mapCacheThemeExists() {
        for (int i = 0; i < this.themeList.size(); ++i) {
            if (!(this.themeList.getTheme(i) instanceof MapCacheTheme)) continue;
            return true;
        }
        return false;
    }

    public boolean mapWMTSThemeExists() {
        for (int i = 0; i < this.themeList.size(); ++i) {
            if (!(this.themeList.getTheme(i) instanceof WMTSTheme)) continue;
            return true;
        }
        return false;
    }

    public void setRasterThemeNames(String[] themeNames) {
        this.rasterThemeNames = themeNames;
    }

    public void setRasterImageNames(String[] imageNames) {
        this.rasterImageNames = imageNames;
    }

    public void setCurrentScale(double currentScale) {
        this.currentScale = currentScale;
    }

    public double getCurrentScale() {
        return this.currentScale;
    }

    public void setScale(Rectangle2D queryWin, Rectangle2D deviceWin) {
        double inches = deviceWin.getHeight() / this.dpi;
        this.currentScale = queryWin.getHeight() / inches;
        this.computeRatioScale();
    }

    public double getCurrentRatioScale() {
        return this.currentRatioScale;
    }

    private void computeRatioScale() {
        this.currentRatioScale = Double.POSITIVE_INFINITY;
        if (this.currentScale == Double.POSITIVE_INFINITY || this.srs == null) {
            return;
        }
        Rectangle2D mQueryWin = this.getQueryWindow();
        if (mQueryWin == null) {
            return;
        }
        Point2D.Double center = new Point2D.Double(mQueryWin.getMinX() + mQueryWin.getWidth() / 2.0, mQueryWin.getMinY() + mQueryWin.getHeight() / 2.0);
        this.currentRatioScale = center != null ? this.srs.getRatioScale(this.currentScale, center) : this.srs.getRatioScale(this.currentScale, null);
        if (this.currentRatioScale == -1.0) {
            this.currentRatioScale = Double.POSITIVE_INFINITY;
        }
    }

    public void setProjection(Proj projection) {
        this.projection = projection;
    }

    public Proj getProjection() {
        return this.projection;
    }

    public void setInterrupted(boolean interrupted) {
        this.interrupted = interrupted;
    }

    public boolean isInterrupted() {
        return this.interrupted;
    }

    public void enableCachedBaseMap(String baseMapName) {
        this.useCachedBaseMap = true;
        this.cachedBaseMap = baseMapName;
    }

    public void disableCachedBaseMap() {
        this.useCachedBaseMap = false;
        this.mapCache = null;
    }

    public void setMapCacheInstance(DBMapMaker mapper) {
        this.mapCache = MapCacheServer._server.getMapCacheByBaseMap(mapper.getMasterDataSource(), this.cachedBaseMap, this.masterSRID);
        this.baseMapThemes = VisContext.getBaseMapThemes(mapper, this.cachedBaseMap);
    }

    public boolean shouldUseCachedBaseMap() {
        return this.useCachedBaseMap;
    }

    private static BaseMap.PredefinedThemeDesc[] getBaseMapThemes(DBMapMaker mapper, String baseMapName) {
        BasemapCache mc = null;
        AbstractDBDataSource ads = (AbstractDBDataSource)DSManager.get(mapper.getVisContext().getMasterDataSourceName());
        mc = ads.getBasemapCache();
        BaseMap map = mc.getOrLoadBasemap(baseMapName);
        if (map != null) {
            return map.getThemes();
        }
        return new BaseMap.PredefinedThemeDesc[0];
    }

    public void setDisableMapPieces(boolean disableMapPieces) {
        this.disableMapPieces = disableMapPieces;
    }

    public boolean isDisableMapPieces() {
        return this.disableMapPieces;
    }

    public void setCasedLines(CasedLineHelper casedLines) {
        this.casedLines = casedLines;
    }

    public CasedLineHelper getCasedLines() {
        return this.casedLines;
    }

    public void setRotation(double angle) {
        this.rotation = angle;
    }

    public double getRotation() {
        return this.rotation;
    }

    public void setLastRotation(double angle) {
        this.lastRotation = angle;
    }

    public double getLastRotation() {
        return this.lastRotation;
    }

    public NorthArrow getNorthArrow() {
        return this.northArrow;
    }

    public void setNorthArrow(NorthArrow na) {
        this.northArrow = na;
    }

    public void setDataException(DataException param) {
        this.dataException = param;
    }

    public DataException getDataException() {
        return this.dataException;
    }

    public void setUserIdentity(UserIdentity id) {
        this.userIdentity = id;
    }

    public UserIdentity getUserIdentity() {
        return this.userIdentity;
    }

    public Rectangle2D getExtendedQueryWindow(int bufferSize) {
        if (!this.isTileRequest()) {
            return this.queryWindow;
        }
        double xr = (double)bufferSize * this.queryWindow.getWidth() / this.deviceWindow.getWidth();
        double yr = (double)bufferSize * this.queryWindow.getHeight() / this.deviceWindow.getHeight();
        double minx = this.queryWindow.getMinX() - xr;
        double miny = this.queryWindow.getMinY() - yr;
        double maxx = this.queryWindow.getMaxX() + xr;
        double maxy = this.queryWindow.getMaxY() + yr;
        if (this.queryWindowConstraint != null) {
            if (minx < this.queryWindowConstraint.getMinX()) {
                minx = this.queryWindowConstraint.getMinX();
            }
            if (miny < this.queryWindowConstraint.getMinY()) {
                miny = this.queryWindowConstraint.getMinY();
            }
            if (maxx > this.queryWindowConstraint.getMaxX()) {
                maxx = this.queryWindowConstraint.getMaxX();
            }
            if (maxy > this.queryWindowConstraint.getMaxY()) {
                maxy = this.queryWindowConstraint.getMaxY();
            }
        }
        double w = maxx - minx;
        double h = maxy - miny;
        if (this.srs != null && this.srs.isGeodetic() && "DECIMAL DEGREE".equals(this.srs.getUnit())) {
            if (minx < -180.0) {
                minx = -180.0;
            }
            if (miny < -90.0) {
                miny = -90.0;
            }
            if (minx + w > 180.0) {
                w = 180.0 - minx;
            }
            if (miny + h > 90.0) {
                h = 90.0 - miny;
            }
        }
        return new Rectangle2D.Double(minx, miny, w, h);
    }

    public boolean isPDFformatRequest() {
        return this.isPDFrequest;
    }

    public void setPDFformatRequest(boolean pdf) {
        this.isPDFrequest = pdf;
    }

    public void setQueryWindowConstraint(Rectangle2D constraint) {
        this.queryWindowConstraint = constraint;
    }

    public Rectangle2D getQueryWindowConstraint() {
        return this.queryWindowConstraint;
    }

    public boolean shouldRenderMarkerSequence() {
        return this.markerSequenceFormat != 0;
    }

    public void resetMarkerSequence() {
        this.markerSequence = 0;
    }

    public void enableMarkerSequence(int format) {
        this.markerSequenceFormat = format;
    }

    public String getNextMarkerSequence() {
        if (this.markerSequenceFormat == 0) {
            return null;
        }
        ++this.markerSequence;
        if (this.markerSequenceFormat == 2) {
            if (this.markerSequence > 26) {
                return null;
            }
            return "" + (char)(65 + this.markerSequence - 1);
        }
        return this.markerSequence + "";
    }

    public void setUserLanguage(String userLanguage) {
        this.userLanguage = userLanguage;
    }

    public String getUserLanguage() {
        return this.userLanguage;
    }

    public boolean shouldReportError() {
        return this.dataException != null && this.isTileRequest();
    }

    protected int getThemeWindowBuffer() {
        return this.themeWindowBuffer;
    }

    protected void setThemeWindowBuffer(int buffer) {
        this.themeWindowBuffer = buffer;
    }

    public void processDataError(Exception error, Logger log, String message) throws DataException {
        if (!this.shouldIgnoreError(error, message)) {
            DataException de = null;
            de = error != null ? (message != null ? new DataException(message, error) : new DataException(error)) : new DataException(message);
            throw de;
        }
        if (log != null) {
            if (error != null) {
                log.log(Level.SEVERE, message, error);
            } else {
                log.log(Level.SEVERE, message);
            }
        }
    }

    private boolean shouldIgnoreError(Exception error, String message) {
        return !this.isTileRequest();
    }

    public double getDPI() {
        return this.dpi;
    }

    public void setDPI(double dotsPerInch) {
        if (dotsPerInch <= 0.0) {
            return;
        }
        this.dpi = dotsPerInch;
    }

    public void clearCasedLineHelperData() {
        if (this.casedLines != null) {
            this.casedLines.clear();
        }
    }

    public StyleCache getTemporaryStyleCache() {
        return this.tempStyleCache;
    }

    public void setTemporaryStyleCache(StyleCache sc) {
        this.tempStyleCache = sc;
    }

    public boolean isWithUTFGrid() {
        return this.isWithUTFGrid;
    }

    public void setIsWithUTFGrid(boolean b) {
        this.isWithUTFGrid = b;
    }

    public void setUTFGridResolution(short n) {
        this.utfgrid_resolution = n;
    }

    public UTFGrid initUTFGrid() {
        this.utfGrid = new UTFGrid(this.utfgrid_resolution);
        return this.utfGrid;
    }

    public UTFGrid getUTFGrid() {
        return this.utfGrid;
    }

    static {
        try {
            String lcOSName = System.getProperty("os.name").toLowerCase();
            MAC_OS_X = lcOSName.startsWith("mac os x");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

