/*
 * Decompiled with CFR 0.152.
 */
package oracle.sdovis;

import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import oracle.mapviewer.share.util.LogFactory;
import oracle.sdovis.DataException;
import oracle.sdovis.TileLayerRowData;
import oracle.sdovis.TileLayerStore;
import oracle.sdovis.ds.DSUtil;
import oracle.sdovis.util.DBTable;
import oracle.sdovis.util.Util;

public class TileLayerTable
extends DBTable
implements TileLayerStore {
    private static Logger log = LogFactory.getLogger(LogFactory.LoggerEnum.SDOVIS);
    private String mName = null;
    private String mDescription = null;
    private String mTilesTable = null;
    private String mIsOnline = "YES";
    private String mIsInternal = "YES";
    private StringBuffer mDefinition = null;
    private String mBaseMap = null;
    private byte[] mMapAdapter = null;
    private Clob mCLOBSVG;
    private Blob mBLOBImage;

    public TileLayerTable(String dataSrc, String tableName) {
        super(dataSrc, tableName);
    }

    public String getName() {
        return this.mName;
    }

    public void setName(String name) {
        this.mName = name;
    }

    public String getDescription() {
        return this.mDescription;
    }

    public void setDescription(String description) {
        this.mDescription = description;
    }

    public String getTilesTable() {
        return this.mTilesTable;
    }

    public void setTilesTable(String table) {
        this.mTilesTable = table;
    }

    public String isOnline() {
        return this.mIsOnline;
    }

    public void setIsOnline(String online) {
        if (online == null || !online.equalsIgnoreCase("YES") && !online.equalsIgnoreCase("NO")) {
            return;
        }
        this.mIsOnline = online.toUpperCase();
    }

    public String isInternal() {
        return this.mIsInternal;
    }

    public void setIsInternal(String internal) {
        if (internal == null || !internal.equalsIgnoreCase("YES") && !internal.equalsIgnoreCase("NO")) {
            return;
        }
        this.mIsInternal = internal.toUpperCase();
    }

    public StringBuffer getDefinition() {
        return this.mDefinition;
    }

    public void setDefinition(StringBuffer definition) {
        this.mDefinition = definition;
    }

    public String getBaseMap() {
        return this.mBaseMap;
    }

    public void setBaseMap(String bmap) {
        this.mBaseMap = bmap;
    }

    public byte[] getMapAdapter() {
        return this.mMapAdapter;
    }

    public void setMapAdapter(byte[] adapter) {
        this.mMapAdapter = adapter;
    }

    @Override
    public int update() throws SQLException {
        String name = this.mName;
        String desc = this.mDescription;
        String tilesTable = this.mTilesTable;
        String isOnline = this.mIsOnline;
        String isInternal = this.mIsInternal;
        StringBuffer def = this.mDefinition;
        String baseMap = this.mBaseMap;
        byte[] madpat = this.mMapAdapter;
        this.delete();
        this.mName = name;
        this.mDescription = desc;
        this.mTilesTable = tilesTable;
        this.mIsOnline = isOnline;
        this.mIsInternal = isInternal;
        this.mDefinition = def;
        this.mBaseMap = baseMap;
        this.mMapAdapter = madpat;
        int res = this.insert();
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int insert() throws SQLException {
        int res;
        this.mConnection = DSUtil.getDBConnection(this.mDataSource, null);
        boolean autoCommit = this.mConnection.getAutoCommit();
        this.mConnection.setAutoCommit(false);
        this.initInsertStatement();
        this.mInsertStatement.setString(1, this.mName.toUpperCase());
        this.mInsertStatement.setString(2, this.mDescription);
        this.mInsertStatement.setString(3, this.mTilesTable);
        this.mInsertStatement.setString(4, this.mIsOnline);
        this.mInsertStatement.setString(5, this.mIsInternal);
        if (this.mDBtypename == null || this.mDBtypename.equalsIgnoreCase("ORACLE")) {
            this.mInsertStatement.setString(6, this.mBaseMap);
            res = this.mInsertStatement.executeUpdate();
            this.mConnection.commit();
            this.mConnection.setAutoCommit(false);
            Statement stmt = this.mConnection.createStatement();
            String s = "SELECT definition, map_adapter FROM " + this.mTableName + " WHERE name='" + this.mName.toUpperCase() + "' FOR UPDATE";
            this.mResultSet = stmt.executeQuery(s);
            if (!this.mResultSet.next()) {
                System.err.println("Query: " + s);
                System.err.println("Cannot query " + this.mTableName + "! The inserted row is deleted.");
                res = this.delete();
                return res;
            }
            this.mCLOBSVG = this.mResultSet.getClob("DEFINITION");
            this.mBLOBImage = this.mResultSet.getBlob("MAP_ADAPTER");
            try {
                Util.putClobContents(this.mCLOBSVG, this.mDefinition.toString());
                if (this.mMapAdapter != null) {
                    Util.putBlobContents(this.mBLOBImage, this.mMapAdapter);
                }
                this.mConnection.commit();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            finally {
                try {
                    if (stmt != null) {
                        stmt.close();
                    }
                }
                catch (Exception e) {}
                this.close();
            }
        } else {
            this.mInsertStatement.setString(7, this.mBaseMap);
            String definition = null;
            if (this.mDefinition != null) {
                definition = this.mDefinition.toString();
            }
            if (definition == null) {
                this.mInsertStatement.setClob(6, (Clob)null);
            } else {
                ByteArrayOutputStream b = new ByteArrayOutputStream();
                try {
                    BufferedWriter w = new BufferedWriter(new OutputStreamWriter((OutputStream)b, "UTF8"));
                    w.write(definition);
                    w.close();
                }
                catch (Exception ex) {
                    // empty catch block
                }
                byte[] ba = b.toByteArray();
                ByteArrayInputStream barray = new ByteArrayInputStream(ba);
                this.mInsertStatement.setAsciiStream(6, (InputStream)barray, ba.length);
            }
            if (this.mMapAdapter == null) {
                this.mInsertStatement.setBlob(8, (Blob)null);
            } else {
                ByteArrayInputStream barray = new ByteArrayInputStream(this.mMapAdapter);
                this.mInsertStatement.setBinaryStream(8, (InputStream)barray, this.mMapAdapter.length);
            }
            res = this.mInsertStatement.executeUpdate();
            this.mConnection.commit();
            this.mConnection.setAutoCommit(autoCommit);
            this.close();
        }
        return res;
    }

    @Override
    public int delete() throws SQLException {
        this.mConnection = DSUtil.getDBConnection(this.mDataSource, null);
        boolean autoCommit = this.mConnection.getAutoCommit();
        this.mConnection.setAutoCommit(false);
        this.initDeleteStatement();
        this.mDeleteStatement.setString(1, this.mName.toUpperCase());
        int res = this.mDeleteStatement.executeUpdate();
        this.mConnection.commit();
        this.mConnection.setAutoCommit(autoCommit);
        this.close();
        this.mDefinition = null;
        this.mMapAdapter = null;
        this.mName = null;
        this.mTilesTable = null;
        this.mDescription = null;
        this.mCLOBSVG = null;
        this.mBLOBImage = null;
        this.mBaseMap = null;
        this.mIsOnline = "YES";
        this.mIsInternal = "YES";
        if (this.mConnection != null) {
            this.mConnection.close();
        }
        return res;
    }

    protected void finalize() {
        try {
            super.close();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    @Override
    protected void initDeleteStatement() throws SQLException {
        if (this.mDeleteStatement == null) {
            this.mDeleteStatement = this.mConnection.prepareStatement("DELETE FROM " + this.mTableName + " WHERE name = ?");
        }
    }

    @Override
    protected void initInsertStatement() throws SQLException {
        if (this.mInsertStatement == null) {
            this.mInsertStatement = this.mDBtypename == null || this.mDBtypename.equalsIgnoreCase("ORACLE") ? this.mConnection.prepareStatement("INSERT INTO user_sdo_cached_maps (name,description,tiles_table,is_online,is_internal,definition,base_map,map_adapter) VALUES(?, ?, ?, ?, ?, empty_clob(), ?, empty_blob())") : this.mConnection.prepareStatement("INSERT INTO user_sdo_cached_maps (name,description,tiles_table,is_online,is_internal,definition,base_map,map_adapter) VALUES(?, ?, ?, ?, ?, ?, ?, ?)");
        }
    }

    @Override
    protected void initUpdateStatement() throws SQLException {
    }

    @Override
    protected void updateLocalData() throws SQLException {
        this.updateLocalData(this.mResultSet);
    }

    protected void updateLocalData(ResultSet rs) throws SQLException {
        this.mName = rs.getString("NAME");
        this.mDescription = rs.getString("DESCRIPTION");
        this.mTilesTable = rs.getString("TILES_TABLE");
        this.mIsOnline = rs.getString("IS_ONLINE");
        this.mIsInternal = rs.getString("IS_INTERNAL");
        this.mBaseMap = rs.getString("BASE_MAP");
        this.mCLOBSVG = rs.getClob("DEFINITION");
        this.mBLOBImage = rs.getBlob("MAP_ADAPTER");
        try {
            this.mDefinition = new StringBuffer(this.mCLOBSVG.getSubString(1L, (int)this.mCLOBSVG.length()));
        }
        catch (SQLException e) {
            e.printStackTrace();
            this.mDefinition = null;
        }
        if (this.mBLOBImage == null) {
            this.mMapAdapter = null;
            return;
        }
        try {
            if (this.mBLOBImage.length() < 5L) {
                this.mMapAdapter = null;
                return;
            }
            this.mMapAdapter = this.mBLOBImage.getBytes(1L, (int)this.mBLOBImage.length());
        }
        catch (SQLException e) {
            e.printStackTrace();
            this.mMapAdapter = null;
        }
    }

    @Override
    public TileLayerRowData getTileLayerData(String name) throws DataException {
        TileLayerRowData tileLayerRowData;
        if (name == null) {
            return null;
        }
        Connection conn = null;
        Statement ps = null;
        ResultSet rs = null;
        try {
            conn = DSUtil.getDBConnection(this.mDataSource, null);
            String sql = "select * from user_sdo_cached_maps where name=?";
            ps = conn.prepareStatement(sql);
            ps.setString(1, name.toUpperCase());
            rs = ps.executeQuery();
            if (!rs.next()) {
                log.warning("Cannot find tile layer named " + name + " in all_sdo_styles");
                TileLayerRowData tileLayerRowData2 = null;
                return tileLayerRowData2;
            }
            this.updateLocalData(rs);
            TileLayerRowData row = new TileLayerRowData();
            row.name = this.mName;
            row.description = this.mDescription;
            row.tilesTable = this.mTilesTable;
            row.isOnline = this.mIsOnline;
            row.isInternal = this.mIsInternal;
            row.definition = this.mDefinition.toString();
            row.baseMap = this.mBaseMap;
            row.mapAdapter = this.mMapAdapter;
            tileLayerRowData = row;
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new DataException(e);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (SQLException e2) {}
            try {
                if (ps != null) {
                    ps.close();
                }
            }
            catch (SQLException e2) {}
            try {
                if (conn != null) {
                    conn.close();
                }
            }
            catch (SQLException e2) {}
        }
        return tileLayerRowData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List getTileLayerNamesWithSRID() {
        ArrayList<String> arrayList;
        ArrayList<String> res = null;
        Statement stmt = null;
        ResultSet rs = null;
        Connection conn = null;
        try {
            conn = DSUtil.getDBConnection(this.mDataSource, null);
            if (conn == null) {
                ArrayList<String> arrayList2 = res;
                return arrayList2;
            }
            res = new ArrayList<String>();
            String query = "SELECT name,definition from USER_SDO_CACHED_MAPS order by name";
            stmt = conn.prepareStatement(query);
            rs = stmt.executeQuery();
            while (rs.next()) {
                String name = rs.getString(1);
                Clob def = rs.getClob(2);
                String xml = null;
                int srid = 0;
                double xmin = Double.NaN;
                double ymin = Double.NaN;
                double xmax = Double.NaN;
                double ymax = Double.NaN;
                try {
                    StringBuffer defBuffer = new StringBuffer(def.getSubString(1L, (int)def.length()));
                    xml = defBuffer.toString();
                }
                catch (SQLException e) {
                    xml = null;
                }
                if (xml != null) {
                    int idx2;
                    int idx1 = xml.toUpperCase().indexOf("SRID=\"");
                    if (idx1 > -1) {
                        idx2 = xml.indexOf("\"", idx1 + 7);
                        String sridString = xml.substring(idx1 + 6, idx2);
                        try {
                            srid = Integer.parseInt(sridString);
                        }
                        catch (Exception ex) {
                            srid = 0;
                        }
                    }
                    if ((idx1 = xml.toUpperCase().indexOf("MINX=\"")) > -1) {
                        idx2 = xml.indexOf("\"", idx1 + 7);
                        String minx = xml.substring(idx1 + 6, idx2);
                        try {
                            xmin = Double.parseDouble(minx);
                        }
                        catch (Exception ex) {
                            xmin = Double.NaN;
                        }
                    }
                    if ((idx1 = xml.toUpperCase().indexOf("MINY=\"")) > -1) {
                        idx2 = xml.indexOf("\"", idx1 + 7);
                        String miny = xml.substring(idx1 + 6, idx2);
                        try {
                            ymin = Double.parseDouble(miny);
                        }
                        catch (Exception ex) {
                            ymin = Double.NaN;
                        }
                    }
                    if ((idx1 = xml.toUpperCase().indexOf("MAXX=\"")) > -1) {
                        idx2 = xml.indexOf("\"", idx1 + 7);
                        String maxx = xml.substring(idx1 + 6, idx2);
                        try {
                            xmax = Double.parseDouble(maxx);
                        }
                        catch (Exception ex) {
                            xmax = Double.NaN;
                        }
                    }
                    if ((idx1 = xml.toUpperCase().indexOf("MAXY=\"")) > -1) {
                        idx2 = xml.indexOf("\"", idx1 + 7);
                        String maxy = xml.substring(idx1 + 6, idx2);
                        try {
                            ymax = Double.parseDouble(maxy);
                        }
                        catch (Exception ex) {
                            ymax = Double.NaN;
                        }
                    }
                }
                res.add(name + ":" + srid + ":" + xmin + "," + ymin + "," + xmax + "," + ymax);
            }
            arrayList = res;
        }
        catch (Exception e) {
            log.severe(e.getMessage());
            ArrayList<String> arrayList3 = res;
            return arrayList3;
        }
        finally {
            try {
                rs.close();
            }
            catch (SQLException se) {
                log.severe(se.getMessage());
            }
            try {
                stmt.close();
            }
            catch (SQLException se) {
                log.severe(se.getMessage());
            }
            try {
                if (conn != null) {
                    conn.close();
                }
            }
            catch (SQLException se) {}
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getTileLayerDefinition(String tileLayer) {
        String xml = null;
        Statement stmt = null;
        ResultSet rs = null;
        Connection conn = null;
        try {
            conn = DSUtil.getDBConnection(this.mDataSource, null);
            if (conn == null) {
                String string = xml;
                return string;
            }
            String query = "SELECT definition from USER_SDO_CACHED_MAPS where name = ?";
            stmt = conn.prepareStatement(query);
            stmt.setString(1, tileLayer.toUpperCase());
            rs = stmt.executeQuery();
            if (rs.next()) {
                Clob def = rs.getClob("DEFINITION");
                try {
                    StringBuffer defBuffer = new StringBuffer(def.getSubString(1L, (int)def.length()));
                    xml = defBuffer.toString();
                }
                catch (SQLException e) {
                    xml = null;
                }
            }
        }
        catch (Exception e) {
            log.severe(e.getMessage());
            xml = null;
        }
        finally {
            try {
                rs.close();
            }
            catch (SQLException se) {
                log.severe(se.getMessage());
            }
            try {
                stmt.close();
            }
            catch (SQLException se) {
                log.severe(se.getMessage());
            }
            try {
                if (conn != null) {
                    conn.close();
                }
            }
            catch (SQLException se) {}
        }
        return xml;
    }
}

