/*
 * Decompiled with CFR 0.152.
 */
package oracle.sdovis;

import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.text.Bidi;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.mapviewer.share.LabelingHints;
import oracle.mapviewer.share.style.TextStyleModel;
import oracle.mapviewer.share.util.LogFactory;
import oracle.sdovis.JSDOGeometry;
import oracle.sdovis.LabelHelper;
import oracle.sdovis.MapMaker;
import oracle.sdovis.StyleFactory;
import oracle.sdovis.StyledFeature;
import oracle.sdovis.StyledFeatureI;
import oracle.sdovis.TextPlacementInfo;
import oracle.sdovis.VectorRenderer;
import oracle.sdovis.VisContext;
import oracle.sdovis.style.MarkerStyleModifiers;
import oracle.sdovis.style.Style;
import oracle.sdovis.style.StyleMarker;
import oracle.sdovis.style.StyleModifiers;
import oracle.sdovis.style.StyleNotApplicableException;
import oracle.sdovis.style.StyleText;
import oracle.sdovis.style.TextPath;
import oracle.sdovis.style.TextStyleModifiers;
import oracle.sdovis.util.BestFitText;
import oracle.sdovis.util.ShapeUtil;
import oracle.spatial.geometry.JGeometry;

public class TextLabeler {
    private static final Logger log = LogFactory.getLogger(LogFactory.LoggerEnum.SDOVIS);

    public static boolean applyTextLabel(Graphics2D g2, StyledFeatureI sf, StyleText stx, String label, boolean forcedLabeling, boolean labelOnlyOnce, boolean upsideDownLabels, VisContext vc) throws StyleNotApplicableException {
        if (stx == null) {
            return false;
        }
        if (((TextStyleModel)stx.getModel()).isSticky()) {
            forcedLabeling = true;
        }
        switch (sf.getGeomType()) {
            case 1: {
                return TextLabeler.labelPointFeature(g2, sf, stx, label, forcedLabeling, vc);
            }
            case 2: 
            case 6: {
                return TextLabeler.labelLineStringWithText(g2, stx, sf.getShape(), label, forcedLabeling || sf.getForceLabel(), labelOnlyOnce, upsideDownLabels, vc);
            }
            case 5: {
                if (!sf.getGeometry().isOrientedMultiPoint()) {
                    TextPlacementInfo[] tpis = TextLabeler.findTextLabelPointsOnMultiPoint(sf, stx, label, forcedLabeling, vc);
                    if (tpis != null) {
                        TextStyleModifiers textmods = (TextStyleModifiers)stx.convertToPixelSize(vc);
                        for (int i = 0; i < tpis.length; ++i) {
                            TextPlacementInfo tpi = tpis[i];
                            stx.apply(g2, tpi, vc, (StyleModifiers)textmods);
                        }
                    }
                    return true;
                }
                return TextLabeler.labelOrientedMultiPoint(g2, sf, stx, label, forcedLabeling, vc);
            }
            case 3: 
            case 7: {
                return TextLabeler.labelPolygonWithText(g2, stx, sf, label, forcedLabeling || sf.getForceLabel(), vc);
            }
        }
        return false;
    }

    public static TextPlacementInfo findTextLabelPointOnPointFeature(StyledFeatureI sf, StyleText stx, String label, boolean forcedLabeling, VisContext vc) {
        TextPlacementInfo tpa;
        TextStyleModifiers textmods = (TextStyleModifiers)stx.convertToPixelSize(vc);
        int originalFontSize = (int)((TextStyleModel)stx.getModel()).getFontSizeValue();
        int loopToSize = (int)((TextStyleModel)stx.getModel()).getMinFontSize();
        if (textmods != null && textmods instanceof TextStyleModifiers) {
            originalFontSize = textmods.getFontSize();
            loopToSize = textmods.getMinFontSize();
        } else {
            textmods = new TextStyleModifiers();
            textmods.setFontSize(originalFontSize);
            textmods.setHaloWidth(((TextStyleModel)stx.getModel()).getHaloWidth());
            textmods.setMinFontSize(loopToSize);
        }
        if (loopToSize < 1 || loopToSize > originalFontSize) {
            loopToSize = originalFontSize;
        }
        if (((TextStyleModel)stx.getModel()).getApplyOPointsHintsToSimplePoints() && (tpa = TextLabeler.findTextLabelPointUsingHints(textmods, originalFontSize, loopToSize, stx, label, sf, forcedLabeling, vc)) != null) {
            return tpa;
        }
        for (int i = originalFontSize; i >= loopToSize; --i) {
            textmods.setFontSize(i);
            Shape outline = StyleText.getStringOutline(label, (TextStyleModel)stx.getModel(), textmods);
            if (outline == null) {
                return null;
            }
            Rectangle2D textRect = outline.getBounds2D();
            TextPlacementInfo tpi = new TextPlacementInfo(label);
            tpi.setTextShape(outline);
            tpi.setTextShapeMBR((Rectangle2D)textRect.clone());
            if (((TextStyleModel)stx.getModel()).haloEnabled()) {
                float haloWidth = textmods.getHaloWidth();
                textRect.setRect(textRect.getX() - (double)haloWidth, textRect.getY() - (double)haloWidth, textRect.getWidth() + (double)(haloWidth * 2.0f), textRect.getHeight() + (double)(haloWidth * 2.0f));
            }
            float w = (float)textRect.getWidth();
            float h = (float)textRect.getHeight();
            float sx = (float)sf.getPoint().getX();
            float sy = (float)sf.getPoint().getY();
            Rectangle2D shpRect = sf.getShpMBR();
            if (shpRect == null) {
                shpRect = new Rectangle2D.Float(0.0f, 0.0f, 5.0f, 3.0f);
            } else {
                sx = (float)shpRect.getCenterX();
                sy = (float)shpRect.getCenterY();
            }
            float hgap = (float)shpRect.getWidth() / 2.0f + 2.0f;
            float vgap = (float)shpRect.getHeight() / 2.0f + 2.0f;
            float[][] positions = new float[][]{{sx + hgap, sy - h / 2.0f}, {sx - hgap - w, sy - h / 2.0f}, {sx - w / 2.0f, sy - vgap - h}, {sx - w / 2.0f, sy + vgap}, {sx + hgap - 2.0f, sy - vgap + 2.0f - h}, {sx + hgap - 2.0f, sy + vgap - 2.0f}, {sx - hgap + 2.0f - w, sy + vgap - 2.0f}, {sx - hgap + 2.0f - w, sy - vgap + 2.0f - h}};
            Vector<Integer> inWindow = new Vector<Integer>(8);
            for (int j = 0; j < positions.length; ++j) {
                textRect.setRect(positions[j][0], positions[j][1], w, h);
                if (!vc.deviceWindow.contains(textRect)) continue;
                if (!vc.getCRArray().conflicts(textRect) && !vc.getRenderedMarkerCRArray().conflicts(textRect)) {
                    tpi.setTextCenter((float)textRect.getCenterX(), (float)textRect.getCenterY());
                    return tpi;
                }
                if (i != loopToSize || !forcedLabeling || inWindow.contains(j)) continue;
                inWindow.add(j);
            }
            if (i != loopToSize || !forcedLabeling || inWindow.size() <= 0 && vc.isTileRequest()) continue;
            int minPos = 0;
            int minArea = Integer.MAX_VALUE;
            int tloop = inWindow.size() > 0 ? inWindow.size() : positions.length;
            for (int k = 0; k < tloop; ++k) {
                int currentPosition = tloop < positions.length ? (Integer)inWindow.get(k) : k;
                textRect.setRect(positions[currentPosition][0], positions[currentPosition][1], w, h);
                int currentArea = vc.getCRArray().agregateConflictArea(textRect) + vc.getRenderedMarkerCRArray().agregateConflictArea(textRect);
                if (currentArea >= minArea) continue;
                minPos = currentPosition;
                minArea = currentArea;
            }
            textRect.setRect(positions[minPos][0], positions[minPos][1], w, h);
            tpi.setTextCenter((float)textRect.getCenterX(), (float)textRect.getCenterY());
            return tpi;
        }
        return null;
    }

    public static TextPlacementInfo findTextLabelPointOnOrientedPoint(StyledFeatureI sf, StyleText stx, String label, boolean forcedLabeling, VisContext vc) {
        float sx = 0.0f;
        float sy = 0.0f;
        float cx = 0.0f;
        float cy = 0.0f;
        TextStyleModifiers textmods = (TextStyleModifiers)stx.convertToPixelSize(vc);
        Shape outline = StyleText.getStringOutline(label, (TextStyleModel)stx.getModel(), textmods);
        if (outline == null) {
            return null;
        }
        TextPlacementInfo tpi = new TextPlacementInfo(label);
        tpi.setTextShape(outline);
        Rectangle2D textRect = outline.getBounds2D();
        tpi.setTextShapeMBR(textRect);
        sx = (float)sf.getPoint().getX();
        sy = (float)sf.getPoint().getY();
        double angle = sf.getMarkerStyleOrientation();
        LabelingHints hints = ((TextStyleModel)stx.getModel()).getLabelingHints();
        Object halign = hints.get(LabelingHints.KEY_OPOINT_HALIGN);
        Object valign = hints.get(LabelingHints.KEY_OPOINT_VALIGN);
        if (halign == null) {
            halign = LabelingHints.VALUE_OPOINT_HALIGN_CENTER;
        }
        if (valign == null) {
            valign = LabelingHints.VALUE_OPOINT_VALIGN_MIDDLE;
        }
        double w = textRect.getWidth();
        double h = textRect.getHeight();
        cx = LabelingHints.VALUE_OPOINT_HALIGN_CENTER == halign ? sx : (LabelingHints.VALUE_OPOINT_HALIGN_START == halign ? (float)((double)sx + w / 2.0) : (float)((double)sx - w / 2.0));
        cy = LabelingHints.VALUE_OPOINT_VALIGN_MIDDLE == valign ? sy : (LabelingHints.VALUE_OPOINT_VALIGN_TOP == valign ? (float)((double)sy + h / 2.0) : (float)((double)sy - h / 2.0));
        tpi.setTextCenter(cx, cy);
        tpi.setRotation(angle, sx, sy);
        Rectangle2D dw = vc.getDeviceWindow();
        if (!vc.isTileRequest()) {
            return tpi;
        }
        Rectangle2D textMbr = TextLabeler.getTextMBR(tpi);
        if (dw.contains(textMbr)) {
            return tpi;
        }
        float buffer = vc.getThemeWindowBuffer();
        if (textMbr.getMinX() < 0.0 && sx > buffer || textMbr.getMinY() < 0.0 && sy > buffer || textMbr.getMaxX() > dw.getWidth() && (double)sx < dw.getWidth() - (double)buffer || textMbr.getMaxY() > dw.getHeight() && (double)sy < dw.getHeight() - (double)buffer) {
            return null;
        }
        return tpi;
    }

    private static TextPlacementInfo findTextLabelPointUsingHints(TextStyleModifiers textmods, int originalFontSize, int loopToSize, StyleText stx, String label, StyledFeatureI sf, boolean forcedLabeling, VisContext vc) {
        float sx = 0.0f;
        float sy = 0.0f;
        float cx = 0.0f;
        float cy = 0.0f;
        LabelingHints hints = ((TextStyleModel)stx.getModel()).getLabelingHints();
        Object halign = hints.get(LabelingHints.KEY_OPOINT_HALIGN);
        Object valign = hints.get(LabelingHints.KEY_OPOINT_VALIGN);
        if (halign == null) {
            halign = LabelingHints.VALUE_OPOINT_HALIGN_START;
        }
        if (valign == null) {
            valign = LabelingHints.VALUE_OPOINT_VALIGN_MIDDLE;
        }
        for (int i = originalFontSize; i >= loopToSize; --i) {
            textmods.setFontSize(i);
            Shape outline = StyleText.getStringOutline(label, (TextStyleModel)stx.getModel(), textmods);
            if (outline == null) {
                return null;
            }
            Rectangle2D textRect = outline.getBounds2D();
            TextPlacementInfo tpi = new TextPlacementInfo(label);
            tpi.setTextShape(outline);
            tpi.setTextShapeMBR((Rectangle2D)textRect.clone());
            if (((TextStyleModel)stx.getModel()).haloEnabled()) {
                float haloWidth = textmods.getHaloWidth();
                textRect.setRect(textRect.getX() - (double)haloWidth, textRect.getY() - (double)haloWidth, textRect.getWidth() + (double)(haloWidth * 2.0f), textRect.getHeight() + (double)(haloWidth * 2.0f));
            }
            float w = (float)textRect.getWidth();
            float h = (float)textRect.getHeight();
            sx = (float)sf.getPoint().getX();
            sy = (float)sf.getPoint().getY();
            Rectangle2D shpRect = sf.getShpMBR();
            if (shpRect == null) {
                shpRect = new Rectangle2D.Float(0.0f, 0.0f, 5.0f, 3.0f);
            } else {
                sx = (float)shpRect.getCenterX();
                sy = (float)shpRect.getCenterY();
            }
            float hgap = (float)shpRect.getWidth() / 2.0f + 2.0f;
            float vgap = (float)shpRect.getHeight() / 2.0f + 2.0f;
            cx = LabelingHints.VALUE_OPOINT_HALIGN_CENTER == halign ? sx : (LabelingHints.VALUE_OPOINT_HALIGN_START == halign ? (float)((double)(sx + hgap) + (double)w / 2.0) : (float)((double)(sx - hgap) - (double)w / 2.0));
            cy = LabelingHints.VALUE_OPOINT_VALIGN_MIDDLE == valign ? sy : (LabelingHints.VALUE_OPOINT_VALIGN_TOP == valign ? (float)((double)(sy + vgap) + (double)h / 2.0) : (float)((double)(sy - vgap) - (double)h / 2.0));
            tpi.setTextCenter(cx, cy);
            textRect.setRect((double)cx - (double)w / 2.0, (double)cy - (double)h / 2.0, w, h);
            if (!vc.deviceWindow.contains(textRect) || !forcedLabeling && (vc.getCRArray().conflicts(textRect) || vc.getRenderedMarkerCRArray().conflicts(textRect))) continue;
            return tpi;
        }
        return null;
    }

    public static TextPlacementInfo[] findTextLabelPointsOnMultiPoint(StyledFeatureI sf, StyleText stx, String label, boolean forcedLabeling, VisContext vc) {
        Shape shp = sf.getShape();
        if (shp == null) {
            return null;
        }
        PathIterator pi = shp.getPathIterator(null);
        float[] seg = new float[6];
        Vector<TextPlacementInfo> res = new Vector<TextPlacementInfo>();
        int index = 0;
        while (!pi.isDone()) {
            int t = pi.currentSegment(seg);
            if (t == 0 || t == 1) {
                TextPlacementInfo candidate;
                StyledFeature sfp = new StyledFeature();
                sfp.setGeomType(1);
                sfp.setPoint(new Point2D.Float(seg[0], seg[1]));
                if (sf.getMultiPointShapeMBRs() != null) {
                    sfp.setMBR(sf.getMultiPointShapeMBRs()[index]);
                }
                if ((candidate = TextLabeler.findTextLabelPointOnPointFeature(sfp, stx, label, forcedLabeling, vc)) != null) {
                    res.add(candidate);
                }
                ++index;
            }
            pi.next();
        }
        return res.toArray(new TextPlacementInfo[res.size()]);
    }

    public static TextPlacementInfo findTextLabelPointOnAreaFeature(Graphics2D g2, StyledFeatureI sf, StyleText stx, String label, boolean forcedLabeling, VisContext vc) {
        Shape shp = sf.getShape();
        if (shp == null) {
            return null;
        }
        TextStyleModifiers textmods = (TextStyleModifiers)stx.convertToPixelSize(vc);
        Shape outline = StyleText.getStringOutline(label, (TextStyleModel)stx.getModel(), textmods);
        if (outline == null) {
            return null;
        }
        TextPlacementInfo tpi = new TextPlacementInfo(label);
        tpi.setTextShape(outline);
        Rectangle2D textRect = outline.getBounds2D();
        tpi.setTextShapeMBR((Rectangle2D)textRect.clone());
        float tx = (float)textRect.getMinX();
        float ty = (float)textRect.getMinY();
        float w = (float)textRect.getWidth();
        float h = (float)textRect.getHeight();
        float[] res = null;
        if (!vc.isTileRequest()) {
            res = LabelHelper.findLoc4RectInPolygon(g2, shp, (double)((int)w + 2), (double)((int)h + 2), vc.getCRArray(), forcedLabeling, true, null);
        } else {
            res = LabelHelper.findLoc4RectInPolygon(shp, (int)w, (int)h, vc.getCRArray(), forcedLabeling, false, null);
            if (res != null) {
                float x = res[0];
                float y = res[1] - h;
                if ((double)(x + w / 2.0f) >= vc.deviceWindow.getMinX() && (double)(x + w / 2.0f) < vc.deviceWindow.getMaxX() && (double)(y + h / 2.0f) >= vc.deviceWindow.getMinY() && (double)(y + h / 2.0f) < vc.deviceWindow.getMaxY()) {
                    if (!vc.deviceWindow.contains(x, y) || !vc.deviceWindow.contains(x + w, y + h)) {
                        res = LabelHelper.findLoc4RectInPolygon(shp, (int)w, (int)h, vc.getCRArray(), forcedLabeling, false, vc.deviceWindow);
                    }
                } else {
                    res = null;
                }
            }
        }
        if (res != null) {
            tpi.setTextCenter(res[0] + w / 2.0f, res[1] - h / 2.0f);
            tpi.setRotation(res[2], res[0], res[1]);
            return tpi;
        }
        return null;
    }

    private static boolean labelPointFeature(Graphics2D g2, StyledFeatureI sf, StyleText stx, String label, boolean forcedLabeling, VisContext vc) throws StyleNotApplicableException {
        int w = (int)vc.getDeviceWindow().getWidth();
        int h = (int)vc.getDeviceWindow().getHeight();
        float sx = (float)sf.getPoint().getX();
        float sy = (float)sf.getPoint().getY();
        TextPlacementInfo tpi = null;
        if (sf.getGeometry() == null || !sf.getGeometry().isOrientedPoint() && !sf.labelAsOrientedPoint()) {
            if (sx < 0.0f || sx >= (float)w || sy < 0.0f || sy >= (float)h) {
                return false;
            }
            tpi = TextLabeler.findTextLabelPointOnPointFeature(sf, stx, label, forcedLabeling || sf.getForceLabel(), vc);
        } else {
            if (!vc.isTileRequest() && (sx < 0.0f || sx >= (float)w || sy < 0.0f || sy >= (float)h)) {
                return false;
            }
            tpi = TextLabeler.findTextLabelPointOnOrientedPoint(sf, stx, label, forcedLabeling || sf.getForceLabel(), vc);
        }
        if (tpi != null) {
            if (!sf.isAllowNakedPoints()) {
                sf.setAllowNakedPoints(true);
                Point2D pt = VectorRenderer.getPointOfPointFeature(sf, vc);
                if (pt != null) {
                    Style sty = null;
                    sty = sf.getFeatureStyle();
                    if (sty == null) {
                        sty = MapMaker.getStyleWithName(sf.getFeatureStyleName(), sf.getDataSource(), vc);
                    }
                    if (sty == null) {
                        sty = StyleFactory.getDefaultStyle(1);
                    }
                    if (sty instanceof StyleMarker) {
                        int msz = sf.getMarkerStyleSize();
                        int realw = 9;
                        int realh = 9;
                        StyleMarker msty = (StyleMarker)sty;
                        if (msz > 0) {
                            realw = msz;
                            realh = msz;
                        } else {
                            MarkerStyleModifiers stymods = (MarkerStyleModifiers)msty.convertToPixelSize(vc);
                            if (stymods != null) {
                                if (stymods.getWidth() > 0) {
                                    realw = stymods.getWidth();
                                }
                                if (stymods.getHeight() > 0) {
                                    realh = stymods.getHeight();
                                }
                            } else {
                                if (msty.getDesiredWidth() > 0) {
                                    realw = msty.getDesiredWidth();
                                }
                                if (msty.getDesiredHeight() > 0) {
                                    realh = msty.getDesiredHeight();
                                }
                            }
                        }
                        Rectangle2D.Float pr2 = new Rectangle2D.Float((float)(pt.getX() - (double)(realw / 2)), (float)(pt.getY() - (double)(realh / 2)), realw, realh);
                        if (vc.getCRArray().conflicts(pr2) && !forcedLabeling) {
                            return false;
                        }
                        VectorRenderer.drawMarkerOnPoint(g2, (StyleMarker)sty, sf, pt, vc, 9, 9);
                    }
                }
            }
            TextStyleModifiers textmods = (TextStyleModifiers)stx.convertToPixelSize(vc);
            stx.apply(g2, tpi, vc, (StyleModifiers)textmods);
            return true;
        }
        return false;
    }

    private static boolean labelOrientedMultiPoint(Graphics2D g2, StyledFeatureI sf, StyleText stx, String label, boolean forcedLabeling, VisContext vc) {
        int[] elemInfo = sf.getGeometry().getElemInfo();
        double[] oordsArray = sf.getGeometry().getOrdinatesArray();
        int dim = sf.getGeometry().getDimensions();
        float[] segCoords = new float[6];
        PathIterator pi = sf.getShape().getPathIterator(null);
        int index = 0;
        while (!pi.isDone()) {
            int t = pi.currentSegment(segCoords);
            if (t == 0 || t == 1) {
                StyledFeature sf2 = new StyledFeature();
                sf2.setPoint(new Point2D.Double(segCoords[0], segCoords[1]));
                sf2.setGeomType(1);
                sf2.setFeatureStyle(sf.getFeatureStyle());
                sf2.setFeatureStyleName(sf.getFeatureStyleName());
                sf2.setLabelStyle(sf.getLabelStyle());
                sf2.setLabelStyleName(sf.getLabelStyleName());
                int oordStart = elemInfo[index * 6] - 1;
                int orientStart = elemInfo[index * 6 + 3] - 1;
                int[] elinfo = new int[]{1, 1, 1, 3, 1, 0};
                double[] oords = new double[dim + 2];
                for (int i = 0; i < dim + 2; ++i) {
                    oords[i] = oordsArray[oordStart + i];
                }
                JGeometry geom = new JGeometry(dim * 1000 + 1, sf.getGeometry().getSRID(), elinfo, oords);
                sf2.setGeometry(JSDOGeometry.recast(geom));
                double ox = oordsArray[orientStart];
                double oy = oordsArray[orientStart + 1];
                sf2.setMarkerStyleOrientation(Math.atan2(-oy, ox));
                try {
                    TextLabeler.labelPointFeature(g2, sf2, stx, label, forcedLabeling, vc);
                }
                catch (StyleNotApplicableException e) {
                    // empty catch block
                }
            }
            pi.next();
            ++index;
        }
        return true;
    }

    private static boolean labelLineStringWithText(Graphics2D g2, StyleText stx, Shape shpIn, String label, boolean forcedLabeling, boolean labelOnlyOnce, boolean upsideDownLabels, VisContext vc) {
        double len = ShapeUtil.lengthOf(shpIn);
        Shape shp = null;
        try {
            shp = ShapeUtil.clipLineString(vc.getDeviceWindow(), shpIn);
        }
        catch (Exception ex) {
            log.log(Level.FINER, "exception while clipping a line string.", ex);
            return false;
        }
        if (shp == null || len == 0.0) {
            return false;
        }
        TextStyleModifiers textmods = (TextStyleModifiers)stx.convertToPixelSize(vc);
        int originalFontSize = (int)((TextStyleModel)stx.getModel()).getFontSizeValue();
        int loopToSize = (int)((TextStyleModel)stx.getModel()).getMinFontSize();
        if (textmods != null && textmods instanceof TextStyleModifiers) {
            originalFontSize = textmods.getFontSize();
            loopToSize = textmods.getMinFontSize();
        } else {
            textmods = new TextStyleModifiers();
            textmods.setHaloWidth(((TextStyleModel)stx.getModel()).getHaloWidth());
            textmods.setMinFontSize(loopToSize);
        }
        if (loopToSize < 1 || loopToSize > originalFontSize) {
            loopToSize = originalFontSize;
        }
        for (int i = originalFontSize; i >= loopToSize; --i) {
            StyleText nstx = (StyleText)stx.clone();
            TextStyleModel tsm = (TextStyleModel)nstx.getModel();
            tsm.setFont(tsm.deriveFont(i));
            tsm.setFontSizeValue(i);
            tsm.setFontSizeUnit("px");
            textmods.setFontSize(i);
            nstx.updateVisualWidthOfA(textmods);
            double textLen = nstx.getCoarseVisualLength(label);
            if (textLen == 0.0) {
                Rectangle2D lr = nstx.getVisualBounds(label, textmods);
                textLen = lr.getWidth();
            }
            if (textLen > len && !forcedLabeling) continue;
            try {
                Shape s = null;
                char[] chars = label.toCharArray();
                TextStyleModel bean = (TextStyleModel)nstx.getModel();
                if (bean.isStraightLineLabeling() || Bidi.requiresBidi(chars, 0, chars.length)) {
                    BestFitText bft = new BestFitText();
                    TextPath tp = new TextPath((TextStyleModel)nstx.getModel(), textmods);
                    s = bft.putTextOnBestFitLine(tp, g2, shp, label, textLen, vc.getCRArray(), forcedLabeling, labelOnlyOnce, upsideDownLabels);
                } else {
                    TextPath tp = new TextPath((TextStyleModel)nstx.getModel(), textmods);
                    s = tp.putTextOnPath(g2, shp, label, textLen, vc.getCRArray(), vc.getDeviceWindow(), i == loopToSize && forcedLabeling, labelOnlyOnce, upsideDownLabels);
                }
                if (s == null) continue;
                if (((TextStyleModel)nstx.getModel()).haloEnabled()) {
                    nstx.applyHalo(g2, s, textmods);
                }
                g2.setColor(((TextStyleModel)nstx.getModel()).getColor());
                g2.fill(s);
                return true;
            }
            catch (Exception e) {
                log.log(Level.FINER, "Exception while labeling text along path.", e);
            }
        }
        return false;
    }

    private static boolean labelPolygonWithText(Graphics2D g2, StyleText stx, StyledFeatureI sf, String label, boolean forcedLabeling, VisContext vc) {
        TextPlacementInfo tpi = TextLabeler.findTextLabelPointOnAreaFeature(g2, sf, stx, label, forcedLabeling, vc);
        if (tpi != null) {
            TextStyleModifiers textmods = (TextStyleModifiers)stx.convertToPixelSize(vc);
            stx.apply(g2, tpi, vc, (StyleModifiers)textmods);
            return true;
        }
        return false;
    }

    private static Rectangle2D getTextMBR(TextPlacementInfo tpi) {
        Shape shp = tpi.getTextShape();
        Rectangle2D r = tpi.getTextShapeMBR();
        AffineTransform at = new AffineTransform();
        double rotation = tpi.getRotation();
        if (rotation != 0.0) {
            at.setToRotation(rotation, tpi.getRotationAnchorX(), tpi.getRotationAnchorY());
        }
        float xtrans = (float)((double)tpi.getTextCenterX() - r.getCenterX());
        float ytrans = (float)((double)tpi.getTextCenterY() - r.getCenterY());
        if (xtrans != 0.0f || ytrans != 0.0f) {
            at.translate(xtrans, ytrans);
        }
        shp = at.createTransformedShape(shp);
        return shp.getBounds2D();
    }
}

