/*
 * Decompiled with CFR 0.152.
 */
package oracle.sdovis;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Logger;
import oracle.mapviewer.share.ext.SDataProvider;
import oracle.mapviewer.share.util.LogFactory;
import oracle.sdovis.CoherenceDataProvider;
import oracle.sdovis.util.ClassPathUpdate;

public class SDataProviderMgr {
    public static final String PROP_COHERENCE_CACHE = "oracle.sdovis.SDataProviderMgr.coherenceCacheName";
    private static final Logger log = LogFactory.getLogger(LogFactory.LoggerEnum.SDOVIS);
    static Hashtable<String, SDataProviderDescriptor> providers = new Hashtable(7);

    public static boolean registerProvider(String id, String className, String jarfile, Properties init) {
        if (id == null || className == null) {
            return false;
        }
        if (providers.get(id) != null) {
            log.warning("Spatial Provider " + id + " is already registered.");
            return true;
        }
        if (jarfile != null) {
            try {
                ClassPathUpdate.addFile(jarfile);
            }
            catch (Exception e) {
                log.severe("Unable to register spatial provider " + id);
                return false;
            }
        }
        String cacheName = null;
        if (init != null) {
            init.getProperty(PROP_COHERENCE_CACHE);
            init.remove(PROP_COHERENCE_CACHE);
        }
        SDataProviderDescriptor spdesc = new SDataProviderDescriptor();
        spdesc.initProperties = init;
        spdesc.className = className;
        spdesc.jarFile = jarfile;
        providers.put(id, spdesc);
        SDataProvider provider = SDataProviderMgr.getProviderInstance(id);
        if (provider == null) {
            log.severe("Unable to get an instance for spatial provider " + id);
            providers.remove(id);
            log.warning("Spatial Provider " + id + " has not been registered.");
            return false;
        }
        if (cacheName != null) {
            CoherenceDataProvider cacheDP = new CoherenceDataProvider(provider);
            Properties props = new Properties();
            props.setProperty("cacheName", cacheName);
            for (Map.Entry<Object, Object> e : init.entrySet()) {
                props.setProperty((String)e.getKey(), (String)e.getValue());
            }
            cacheDP.init(props);
            provider = cacheDP;
        }
        spdesc.sProvider = provider;
        log.info("Spatial Provider " + id + " has been registered.");
        return true;
    }

    public static void removeProvider(String id) {
        if (id == null) {
            return;
        }
        SDataProviderDescriptor spdesc = providers.remove(id);
        if (spdesc != null && spdesc.sProvider != null) {
            spdesc.sProvider.destroy();
        }
    }

    public static void removeAll() {
        for (SDataProviderDescriptor spdesc : providers.values()) {
            if (spdesc.sProvider == null) continue;
            spdesc.sProvider.destroy();
        }
        providers.clear();
    }

    public static String getProviderClassName(String id) {
        if (id == null) {
            return null;
        }
        SDataProviderDescriptor spdesc = providers.get(id);
        if (spdesc == null) {
            return null;
        }
        return spdesc.className;
    }

    public static String getProviderJarFile(String id) {
        if (id == null) {
            return null;
        }
        SDataProviderDescriptor spdesc = providers.get(id);
        if (spdesc == null) {
            return null;
        }
        return spdesc.jarFile;
    }

    public static String[] getProviderInitParameterNames(String id) {
        if (id == null) {
            return null;
        }
        SDataProviderDescriptor spdesc = providers.get(id);
        if (spdesc == null || spdesc.sProvider == null) {
            return null;
        }
        return spdesc.sProvider.getInitParameterNames();
    }

    public static String[] getProviderRuntimeParameterNames(String id) {
        if (id == null) {
            return null;
        }
        SDataProviderDescriptor spdesc = providers.get(id);
        if (spdesc == null || spdesc.sProvider == null) {
            return null;
        }
        return spdesc.sProvider.getRuntimeParameterNames();
    }

    public static String getProviderRuntimeParameterHintValue(String id, String runtimeParam) {
        if (id == null || runtimeParam == null) {
            return null;
        }
        SDataProviderDescriptor spdesc = providers.get(id);
        if (spdesc == null || spdesc.sProvider == null) {
            return null;
        }
        return spdesc.sProvider.getRuntimeParameterHintValue(runtimeParam);
    }

    public static String[] getProvidersID() {
        if (providers.size() == 0) {
            return null;
        }
        int i = 0;
        String[] prvds = new String[providers.size()];
        Enumeration<String> e = providers.keys();
        while (e.hasMoreElements()) {
            prvds[i] = e.nextElement();
            ++i;
        }
        return prvds;
    }

    public static SDataProvider getProviderInstance(String providerId) {
        if (providerId == null) {
            return null;
        }
        SDataProviderDescriptor psdesc = providers.get(providerId);
        SDataProvider dataProvider = psdesc.sProvider;
        if (dataProvider == null) {
            String className = SDataProviderMgr.getProviderClassName(providerId);
            if (className == null) {
                log.warning("Unable to find data provider class for provider " + providerId);
                return null;
            }
            try {
                Class<?> c = Class.forName(className);
                dataProvider = (SDataProvider)c.newInstance();
                dataProvider.init(psdesc.initProperties);
            }
            catch (Exception e) {
                log.warning("Unable to get data provider instance for class " + className);
            }
        }
        return dataProvider;
    }

    public static boolean setProviderInitProperties(String providerId, Properties init) {
        if (providerId == null) {
            return false;
        }
        SDataProviderDescriptor spdesc = providers.get(providerId);
        if (spdesc == null) {
            return false;
        }
        spdesc.initProperties = init;
        return true;
    }

    public static Properties getProviderInitProperties(String providerId) {
        if (providerId == null) {
            return null;
        }
        SDataProviderDescriptor spdesc = providers.get(providerId);
        if (spdesc == null) {
            return null;
        }
        return spdesc.initProperties;
    }

    private static class SDataProviderDescriptor {
        public SDataProvider sProvider = null;
        public Properties initProperties = null;
        public String className = null;
        public String jarFile = null;

        SDataProviderDescriptor() {
        }
    }
}

