/*
 * Decompiled with CFR 0.152.
 */
package oracle.sdovis;

import java.awt.Shape;
import java.awt.geom.Point2D;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import oracle.sdovis.util.ShapeUtil;

public class LiveFeature
implements Serializable {
    private int id;
    private String label = null;
    private String labelStyleName = null;
    private String renderStyleName = null;
    private int markerStyleSize = 0;
    private double[] radius = null;
    private double cx;
    private double cy;
    private Shape shape;
    private int geomType;
    String[] attrs;

    public LiveFeature() {
    }

    public LiveFeature(double x, double y) {
        this.cx = x;
        this.cy = y;
    }

    public Point2D getCenterAsPoint2D() {
        return new Point2D.Double(this.cx, this.cy);
    }

    public double getCenterX() {
        return this.cx;
    }

    public double getCenterY() {
        return this.cy;
    }

    public int getGeomType() {
        return this.geomType;
    }

    public void setGeomType(int t) {
        this.geomType = t;
    }

    public Shape getShape() {
        return this.shape;
    }

    public void setShape(Shape shp) {
        this.shape = shp;
    }

    public String[] getAttrs() {
        return this.attrs;
    }

    public void setAttrs(String[] as) {
        this.attrs = as;
    }

    public int getID() {
        return this.id;
    }

    public void setID(int i) {
        this.id = i;
    }

    public String getRenderStyleName() {
        return this.renderStyleName;
    }

    public void setRenderStyleName(String rs) {
        this.renderStyleName = rs;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String l) {
        this.label = l;
    }

    public String getLabelStyleName() {
        return this.labelStyleName;
    }

    public void setLabelStyleName(String ls) {
        this.labelStyleName = ls;
    }

    public int getMarkerStyleSize() {
        return this.markerStyleSize;
    }

    public void setMarkerStyleSize(int mss) {
        this.markerStyleSize = mss;
    }

    public void setCenter(double x, double y) {
        this.cx = x;
        this.cy = y;
    }

    public double[] getRadius() {
        return this.radius;
    }

    public void setRadius(double[] r) {
        this.radius = r;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(128);
        sb.append("GeoFeature:\n");
        sb.append("  id=" + this.id);
        sb.append("\n  label=" + this.label);
        sb.append("\n  labelStyleName=" + this.labelStyleName);
        sb.append("\n  renderStyleName=" + this.renderStyleName);
        sb.append("\n  markerStyleSize=" + this.markerStyleSize);
        sb.append("\n  radius=" + this.radius);
        sb.append("\n  x=" + this.cx + ", y=" + this.cy);
        return sb.toString();
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeInt(this.id);
        out.writeObject(this.label);
        out.writeObject(this.labelStyleName);
        out.writeObject(this.renderStyleName);
        out.writeInt(this.markerStyleSize);
        out.writeObject(this.radius);
        out.writeDouble(this.cx);
        out.writeDouble(this.cy);
        out.writeInt(this.geomType);
        out.writeObject(this.attrs);
        boolean hasShape = this.shape != null;
        out.writeBoolean(hasShape);
        if (this.shape != null) {
            ShapeUtil.store(this.shape, out);
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this.id = in.readInt();
        this.label = (String)in.readObject();
        this.labelStyleName = (String)in.readObject();
        this.renderStyleName = (String)in.readObject();
        this.markerStyleSize = in.readInt();
        this.radius = (double[])in.readObject();
        this.cx = in.readDouble();
        this.cy = in.readDouble();
        this.geomType = in.readInt();
        this.attrs = (String[])in.readObject();
        boolean hasShape = in.readBoolean();
        if (hasShape) {
            this.shape = ShapeUtil.load(in);
        }
    }
}

