/*
 * Decompiled with CFR 0.152.
 */
package oracle.sdovis;

import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.Ellipse2D;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.logging.Logger;
import oracle.mapviewer.share.util.LogFactory;
import oracle.sdovis.PointWithAlpha;
import oracle.sdovis.util.RectArray;

public class LabelHelper {
    private static Logger log = LogFactory.getLogger(LogFactory.LoggerEnum.SDOVIS);
    public static final int MIN_TEXT_BOX_WIDTH = 10;
    static final int TOLERANCE = 5;

    public static float[] findLoc4RectInEllipse(Shape shp, double width, double height, RectArray[] limitRects, boolean ignoreCollision, boolean allowRotation, Rectangle2D deviceView) {
        float[] result = new float[3];
        Ellipse2D e = (Ellipse2D)shp;
        double cx = e.getCenterX();
        double cy = e.getCenterY();
        double w = e.getWidth();
        double h = e.getHeight();
        if (ignoreCollision) {
            result[0] = (float)(cx - width / 2.0);
            result[1] = (float)(cy + height / 2.0);
            result[2] = 0.0f;
            return result;
        }
        if (w >= width && h >= height) {
            if (!LabelHelper.rectConflictsWithRectArrays(limitRects, cx - width / 2.0, cy - height / 2.0, width, height)) {
                LabelHelper.insertRectIntoRectArrays(limitRects, cx - width / 2.0, cy - height / 2.0, width, height);
                result[0] = (float)(cx - width / 2.0);
                result[1] = (float)(cy + height / 2.0);
                result[2] = 0.0f;
                return result;
            }
            if (w / 3.0 > width / 2.0) {
                if (!LabelHelper.rectConflictsWithRectArrays(limitRects, cx - w / 6.0 - width / 2.0, cy - height / 2.0, width, height)) {
                    LabelHelper.insertRectIntoRectArrays(limitRects, cx - w / 6.0 - width / 2.0, cy - height / 2.0, width, height);
                    result[0] = (float)(cx - w / 6.0 - width / 2.0);
                    result[1] = (float)(cy + height / 2.0);
                    result[2] = 0.0f;
                    return result;
                }
                if (!LabelHelper.rectConflictsWithRectArrays(limitRects, cx + w / 6.0 - width / 2.0, cy - height / 2.0, width, height)) {
                    LabelHelper.insertRectIntoRectArrays(limitRects, cx + w / 6.0 - width / 2.0, cy - height / 2.0, width, height);
                    result[0] = (float)(cx + w / 6.0 - width / 2.0);
                    result[1] = (float)(cy + height / 2.0);
                    result[2] = 0.0f;
                    return result;
                }
            }
            if (w * 0.8 > width) {
                if (!LabelHelper.rectConflictsWithRectArrays(limitRects, cx - width / 2.0, cy - h / 6.0 - height / 2.0, width, height)) {
                    LabelHelper.insertRectIntoRectArrays(limitRects, cx - width / 2.0, cy - h / 6.0 - height / 2.0, width, height);
                    result[0] = (float)(cx - width / 2.0);
                    result[1] = (float)(cy - h / 6.0 + height / 2.0);
                    result[2] = 0.0f;
                    return result;
                }
                if (!LabelHelper.rectConflictsWithRectArrays(limitRects, cx - width / 2.0, cy + h / 6.0 - height / 2.0, width, height)) {
                    LabelHelper.insertRectIntoRectArrays(limitRects, cx - width / 2.0, cy + h / 6.0 - height / 2.0, width, height);
                    result[0] = (float)(cx - width / 2.0);
                    result[1] = (float)(cy + h / 6.0 + height / 2.0);
                    result[2] = 0.0f;
                    return result;
                }
            }
        }
        if (!allowRotation) {
            return null;
        }
        if (w < h && w >= height && h >= width) {
            double tmp = height;
            height = width;
            width = tmp;
            float r = -1.5707964f;
            if (!LabelHelper.rectConflictsWithRectArrays(limitRects, cx - width / 2.0, cy - height / 2.0, width, height)) {
                LabelHelper.insertRectIntoRectArrays(limitRects, cx - width / 2.0, cy - height / 2.0, width, height);
                result[0] = (float)(cx + width / 2.0);
                result[1] = (float)(cy + height / 2.0);
                result[2] = r;
                return result;
            }
            if (h / 3.0 > height / 2.0) {
                if (!LabelHelper.rectConflictsWithRectArrays(limitRects, cx - width / 2.0, cy - h / 6.0 - height / 2.0, width, height)) {
                    LabelHelper.insertRectIntoRectArrays(limitRects, cx - width / 2.0, cy - h / 6.0 - height / 2.0, width, height);
                    result[0] = (float)(cx + width / 2.0);
                    result[1] = (float)(cy - h / 6.0 + height / 2.0);
                    result[2] = r;
                    return result;
                }
                if (!LabelHelper.rectConflictsWithRectArrays(limitRects, cx - width / 2.0, cy + h / 6.0 - height / 2.0, width, height)) {
                    LabelHelper.insertRectIntoRectArrays(limitRects, cx - width / 2.0, cy + h / 6.0 - height / 2.0, width, height);
                    result[0] = (float)(cx + width / 2.0);
                    result[1] = (float)(cy + h / 6.0 + height / 2.0);
                    result[2] = r;
                    return result;
                }
            }
            if (h * 0.8 > height) {
                if (!LabelHelper.rectConflictsWithRectArrays(limitRects, cx - w / 6.0 - width / 2.0, cy - height, width, height)) {
                    LabelHelper.insertRectIntoRectArrays(limitRects, cx - w / 6.0 - width / 2.0, cy - height / 2.0, width, height);
                    result[0] = (float)(cx - w / 6.0 + width / 2.0);
                    result[1] = (float)(cy + height / 2.0);
                    result[2] = r;
                    return result;
                }
                if (!LabelHelper.rectConflictsWithRectArrays(limitRects, cx + w / 6.0 - width / 2.0, cy - height / 2.0, width, height)) {
                    LabelHelper.insertRectIntoRectArrays(limitRects, cx + w / 6.0 - width / 2.0, cy - height / 2.0, width, height);
                    result[0] = (float)(cx + w / 6.0 + width / 2.0);
                    result[1] = (float)(cy + height / 2.0);
                    result[2] = r;
                    return result;
                }
            }
        }
        return null;
    }

    public static float[] findLoc4RectInPolygon(Shape shp, double width, double height, RectArray limitRects, boolean ignoreCollision, boolean allowRotation, Rectangle2D deviceView) {
        return LabelHelper.findLoc4RectInPolygon(null, shp, width, height, limitRects, ignoreCollision, allowRotation, deviceView);
    }

    public static float[] findLoc4RectInPolygon(Graphics2D g2, Shape shp, double width, double height, RectArray limitRects, boolean ignoreCollision, boolean allowRotation, Rectangle2D deviceView) {
        RectArray[] tmpRectArrayList = new RectArray[]{limitRects};
        return LabelHelper.findLoc4RectInPolygon(g2, shp, width, height, tmpRectArrayList, ignoreCollision, allowRotation, deviceView);
    }

    public static float[] findLoc4RectInPolygon(Shape shp, double width, double height, RectArray[] limitRects, boolean ignoreCollision, boolean allowRotation) {
        return LabelHelper.findLoc4RectInPolygon(null, shp, width, height, limitRects, ignoreCollision, allowRotation, null);
    }

    public static float[] findLoc4RectInPolygon(Graphics2D g2, Shape shp, double width, double height, RectArray[] limitRects, boolean ignoreCollision, boolean allowRotation, Rectangle2D deviceView) {
        if (shp instanceof Ellipse2D) {
            return LabelHelper.findLoc4RectInEllipse(shp, width, height, limitRects, ignoreCollision, allowRotation, deviceView);
        }
        if (width == height) {
            allowRotation = false;
        }
        if (shp == null) {
            return null;
        }
        float off = 5.0f;
        Rectangle shpRect = shp.getBounds();
        if ((shpRect.getWidth() < width || shpRect.getHeight() < height) && (shpRect.getWidth() < height || shpRect.getHeight() < width)) {
            if (!ignoreCollision) {
                return null;
            }
            float[] coords = new float[]{(float)(shpRect.getCenterX() - width / 2.0), (float)(shpRect.getCenterY() + height / 2.0), 0.0f};
            return coords;
        }
        float sx = (float)shpRect.getCenterX();
        float sy = (float)shpRect.getCenterY();
        float sw = (float)shpRect.getWidth();
        float sh = (float)shpRect.getHeight();
        int[] xArray = new int[]{(int)shpRect.getCenterX(), (int)(shpRect.getCenterX() - height), (int)(shpRect.getCenterX() + height), (int)(shpRect.getCenterX() - shpRect.getWidth() / 4.0), (int)(shpRect.getCenterX() - shpRect.getWidth() / 4.0 - height), (int)(shpRect.getCenterX() - shpRect.getWidth() / 4.0 + height), (int)(shpRect.getCenterX() + shpRect.getWidth() / 4.0), (int)(shpRect.getCenterX() + shpRect.getWidth() / 4.0 - height), (int)(shpRect.getCenterX() + shpRect.getWidth() / 4.0 + height)};
        int[] yArray = new int[]{(int)shpRect.getCenterY(), (int)(shpRect.getCenterY() - height), (int)(shpRect.getCenterY() + height), (int)(shpRect.getCenterY() - shpRect.getHeight() / 6.0), (int)(shpRect.getCenterY() - shpRect.getHeight() / 6.0 - height), (int)(shpRect.getCenterY() - shpRect.getHeight() / 6.0 + height), (int)(shpRect.getCenterY() + shpRect.getHeight() / 6.0), (int)(shpRect.getCenterY() + shpRect.getHeight() / 6.0 - height), (int)(shpRect.getCenterY() + shpRect.getHeight() / 6.0 + height), (int)(shpRect.getCenterY() - shpRect.getHeight() / 3.0), (int)(shpRect.getCenterY() - shpRect.getHeight() / 3.0 - height), (int)(shpRect.getCenterY() - shpRect.getHeight() / 3.0 + height), (int)(shpRect.getCenterY() + shpRect.getHeight() / 3.0), (int)(shpRect.getCenterY() + shpRect.getHeight() / 3.0 - height), (int)(shpRect.getCenterY() + shpRect.getHeight() / 3.0 + height)};
        double[] aArray = new double[18];
        double[] bArray = new double[18];
        for (int i = 0; i < 9; ++i) {
            aArray[i] = -(shpRect.getHeight() / shpRect.getWidth());
            aArray[9 + i] = shpRect.getHeight() / shpRect.getWidth();
        }
        double offset = height * Math.sqrt(1.0 + aArray[0] * aArray[0]);
        double boffset = shpRect.getMinY() - aArray[0] * shpRect.getMinX();
        bArray[0] = shpRect.getHeight() + boffset;
        bArray[1] = bArray[0] - offset;
        bArray[2] = bArray[0] + offset;
        bArray[3] = shpRect.getHeight() / 2.0 + boffset;
        bArray[4] = bArray[3] - offset;
        bArray[5] = bArray[3] + offset;
        bArray[6] = shpRect.getHeight() * 1.5 + boffset;
        bArray[7] = bArray[6] - offset;
        bArray[8] = bArray[6] + offset;
        bArray[9] = boffset = shpRect.getMinY() - aArray[aArray.length / 2] * shpRect.getMinX();
        bArray[10] = bArray[9] - offset;
        bArray[11] = bArray[9] + offset;
        bArray[12] = -shpRect.getHeight() / 2.0 + boffset;
        bArray[13] = bArray[12] - offset;
        bArray[14] = bArray[12] + offset;
        bArray[15] = shpRect.getHeight() / 2.0 + boffset;
        bArray[16] = bArray[15] - offset;
        bArray[17] = bArray[15] + offset;
        int lineNum = xArray.length + yArray.length + aArray.length;
        ArrayList[] intsectArray = new ArrayList[lineNum];
        for (int i = 0; i < lineNum; ++i) {
            intsectArray[i] = new ArrayList(6);
        }
        PathIterator pi = shp.getPathIterator(null);
        if (pi.isDone()) {
            return null;
        }
        double[] segcoords = new double[6];
        pi.currentSegment(segcoords);
        pi.next();
        int lx = (int)segcoords[0];
        int ly = (int)segcoords[1];
        int fx = lx;
        int fy = ly;
        while (!pi.isDone()) {
            int y;
            int x;
            block49: {
                block48: {
                    double tmpx;
                    double tmpy;
                    int j;
                    int type = 0;
                    try {
                        type = pi.currentSegment(segcoords);
                    }
                    catch (Exception e) {
                        return null;
                    }
                    pi.next();
                    x = (int)segcoords[0];
                    y = (int)segcoords[1];
                    if (type == 0) {
                        lx = x;
                        ly = y;
                        fx = x;
                        fy = y;
                        continue;
                    }
                    if (type != 4 && Math.abs(x - lx) <= 5 && Math.abs(y - ly) <= 5 || x == lx && y == ly) continue;
                    double a = 0.0;
                    if (lx - x != 0) {
                        a = (double)(y - ly) / (double)(x - lx);
                    }
                    double b = (double)ly - a * (double)lx;
                    if (lx == x) {
                        if ((double)sw >= width) {
                            for (j = 0; j < yArray.length; ++j) {
                                if ((yArray[j] < ly || yArray[j] > y) && (yArray[j] > ly || yArray[j] < y)) continue;
                                intsectArray[j].add(new PointWithAlpha(lx, yArray[j], LabelHelper.getAlphaValue(x, y, lx, ly, lx, yArray[j], true, false, 0.0, 0.0)));
                            }
                            for (j = 0; j < xArray.length; ++j) {
                                if (xArray[j] != lx) continue;
                                intsectArray[yArray.length + j].add(new PointWithAlpha(lx, ly, 1));
                                intsectArray[yArray.length + j].add(new PointWithAlpha(x, y, 1));
                                break;
                            }
                        }
                        if (allowRotation) {
                            for (j = 0; j < aArray.length; ++j) {
                                tmpy = aArray[j] * (double)lx + bArray[j];
                                if (!(tmpy >= (double)ly && tmpy <= (double)y) && (!(tmpy <= (double)ly) || !(tmpy >= (double)y))) continue;
                                intsectArray[xArray.length + yArray.length + j].add(new PointWithAlpha(lx, (int)tmpy, LabelHelper.getAlphaValue(x, y, lx, ly, lx, (int)tmpy, false, false, aArray[j], bArray[j])));
                            }
                        }
                    } else if (ly == y) {
                        for (j = 0; j < yArray.length; ++j) {
                            if (yArray[j] != ly) continue;
                            intsectArray[j].add(new PointWithAlpha(lx, ly, 1));
                            intsectArray[j].add(new PointWithAlpha(x, y, 1));
                            break;
                        }
                        if (allowRotation) {
                            if ((double)sh >= width) {
                                for (j = 0; j < xArray.length; ++j) {
                                    if ((xArray[j] < lx || xArray[j] > x) && (xArray[j] > lx || xArray[j] < x)) continue;
                                    intsectArray[yArray.length + j].add(new PointWithAlpha(xArray[j], ly, LabelHelper.getAlphaValue(x, y, lx, ly, xArray[j], ly, false, true, 0.0, 0.0)));
                                }
                            }
                            for (j = 0; j < aArray.length; ++j) {
                                tmpx = ((double)ly - bArray[j]) / aArray[j];
                                if (!(tmpx >= (double)lx && tmpx <= (double)x) && (!(tmpx <= (double)lx) || !(tmpx >= (double)x))) continue;
                                intsectArray[xArray.length + yArray.length + j].add(new PointWithAlpha((int)tmpx, ly, LabelHelper.getAlphaValue(x, y, lx, ly, (int)tmpx, ly, false, false, aArray[j], bArray[j])));
                            }
                        }
                    } else {
                        for (j = 0; j < yArray.length; ++j) {
                            tmpx = yArray[j] == ly ? (double)lx : (yArray[j] == y ? (double)x : ((double)yArray[j] - b) / a);
                            if (!((double)sw > width) || !(tmpx <= (double)lx && tmpx >= (double)x) && (!(tmpx >= (double)lx) || !(tmpx <= (double)x))) continue;
                            intsectArray[j].add(new PointWithAlpha((int)tmpx, yArray[j], LabelHelper.getAlphaValue(x, y, lx, ly, (int)tmpx, yArray[j], true, false, 0.0, 0.0)));
                        }
                        if (allowRotation) {
                            for (j = 0; j < xArray.length; ++j) {
                                tmpy = xArray[j] == x ? (double)y : (xArray[j] == lx ? (double)ly : a * (double)xArray[j] + b);
                                if (!((double)sh > width) || !(tmpy <= (double)ly && tmpy >= (double)y) && (!(tmpy >= (double)ly) || !(tmpy <= (double)y))) continue;
                                intsectArray[j + yArray.length].add(new PointWithAlpha(xArray[j], (int)tmpy, LabelHelper.getAlphaValue(x, y, lx, ly, xArray[j], (int)tmpy, false, true, 0.0, 0.0)));
                            }
                            for (j = 0; j < aArray.length; ++j) {
                                if (a != aArray[j]) {
                                    tmpx = (b - bArray[j]) / (aArray[j] - a);
                                    if (!(tmpx <= (double)x && tmpx >= (double)lx) && (!(tmpx >= (double)x) || !(tmpx <= (double)lx))) continue;
                                    intsectArray[xArray.length + yArray.length + j].add(new PointWithAlpha((int)tmpx, (int)(tmpx * a + b), LabelHelper.getAlphaValue(x, y, lx, ly, (int)tmpx, (int)(tmpx * a + b), false, false, aArray[j], bArray[j])));
                                    continue;
                                }
                                intsectArray[xArray.length + yArray.length + j].add(new PointWithAlpha(lx, ly, 1));
                                intsectArray[xArray.length + yArray.length + j].add(new PointWithAlpha(x, y, 1));
                                break;
                            }
                        }
                    }
                    if (type == 0) break block48;
                    if (type != 4) break block49;
                }
                lx = (int)segcoords[0];
                ly = (int)segcoords[1];
                continue;
            }
            lx = x;
            ly = y;
        }
        for (int i = 0; i < intsectArray.length; i += 3) {
            Point2D pos = LabelHelper.findPointInPointArray(g2, intsectArray, i, shpRect, width, height, limitRects, ignoreCollision, deviceView);
            if (pos == null) continue;
            double r = 0.0;
            r = i < yArray.length ? 0.0 : (i < xArray.length + yArray.length ? -1.5707963267948966 : Math.atan(aArray[i - xArray.length - yArray.length]));
            float[] coords = new float[]{(float)pos.getX(), (float)pos.getY(), (float)r};
            return coords;
        }
        if (!ignoreCollision) {
            return null;
        }
        float[] coords = new float[]{(float)(shpRect.getCenterX() - width / 2.0), (float)(shpRect.getCenterY() + height / 2.0), 0.0f};
        if (deviceView != null) {
            if (deviceView.getWidth() < width || deviceView.getHeight() < height) {
                return null;
            }
            if ((double)coords[0] < deviceView.getMinX()) {
                coords[0] = (float)deviceView.getMinX();
            } else if ((double)coords[0] + width > deviceView.getMaxX()) {
                coords[0] = (float)(deviceView.getMaxX() - width);
            }
            if ((double)coords[1] < deviceView.getMinY()) {
                coords[1] = (float)deviceView.getMinY();
            } else if ((double)coords[1] + width > deviceView.getMaxY()) {
                coords[1] = (float)(deviceView.getMaxY() - height);
            }
        }
        return coords;
    }

    private static int getAlphaValue(int x1, int y1, int x2, int y2, int ix, int iy, boolean isHorizontal, boolean isVertical, double gridA, double gridB) {
        if (!(x1 == ix && y1 == iy || x2 == ix && y2 == iy)) {
            return 0;
        }
        if (x2 == ix && y2 == iy) {
            int tmp = x1;
            x1 = x2;
            x2 = tmp;
            tmp = y1;
            y1 = y2;
            y2 = tmp;
        }
        if (isHorizontal) {
            if (y2 < iy) {
                return -1;
            }
            return 1;
        }
        if (isVertical) {
            if (x2 < ix) {
                return -1;
            }
            return 1;
        }
        if ((double)y2 < gridA * (double)x2 + gridB) {
            return -1;
        }
        return 1;
    }

    private static Point2D findPointInPointArray(Graphics2D g2, ArrayList[] intsectArray, int curIdx, Rectangle areaShape, double tw, double th, RectArray[] limitRects, boolean ignoreCollision, Rectangle2D deviceView) {
        int i;
        PointWithAlpha p2;
        PointWithAlpha p1;
        int i2;
        ArrayList pa = intsectArray[curIdx];
        ArrayList pa1 = intsectArray[curIdx + 1];
        ArrayList pa2 = intsectArray[curIdx + 2];
        LabelHelper.sortPointArray(pa);
        LabelHelper.sortPointArray(pa1);
        LabelHelper.sortPointArray(pa2);
        int centerIdx = -1;
        Point2D.Double result = null;
        if (pa.size() == 0) {
            return null;
        }
        double cx = areaShape.getCenterX();
        double cy = areaShape.getCenterY();
        if (((PointWithAlpha)pa.get(0)).getX() != ((PointWithAlpha)pa.get(pa.size() - 1)).getX()) {
            for (i2 = 0; i2 < pa.size() - 1; i2 += 2) {
                p1 = (PointWithAlpha)pa.get(i2);
                p2 = (PointWithAlpha)pa.get(i2 + 1);
                if ((double)p1.getX() >= cx) {
                    centerIdx = i2;
                    break;
                }
                if (i2 + 1 >= pa.size()) {
                    centerIdx = i2;
                    break;
                }
                if (!((double)p1.getX() <= cx) || !((double)p2.getX() >= cx)) continue;
                centerIdx = i2;
                break;
            }
            if (centerIdx < 0) {
                centerIdx = (pa.size() - 2) / 2 * 2;
            }
        } else {
            for (i2 = 0; i2 < pa.size() - 1; i2 += 2) {
                p1 = (PointWithAlpha)pa.get(i2);
                p2 = (PointWithAlpha)pa.get(i2 + 1);
                if ((double)p1.getY() >= cy) {
                    centerIdx = i2;
                    break;
                }
                if (i2 + 1 >= pa.size()) {
                    centerIdx = i2;
                    break;
                }
                if (!((double)p1.getY() <= cy) || !((double)p2.getY() >= cy)) continue;
                centerIdx = i2;
                break;
            }
            if (centerIdx < 0) {
                centerIdx = (pa.size() - 2) / 2 * 2;
            }
        }
        if (centerIdx == pa.size() - 1) {
            centerIdx -= 2;
        }
        for (i = centerIdx; i >= 0; i -= 2) {
            result = LabelHelper.findPointOnSegment((PointWithAlpha)pa.get(i), (PointWithAlpha)pa.get(i + 1), pa1, pa2, tw, th, intsectArray, limitRects, ignoreCollision, deviceView);
            if (result == null) continue;
            return result;
        }
        for (i = centerIdx + 2; i < pa.size() - 1; i += 2) {
            result = LabelHelper.findPointOnSegment((PointWithAlpha)pa.get(i), (PointWithAlpha)pa.get(i + 1), pa1, pa2, tw, th, intsectArray, limitRects, ignoreCollision, deviceView);
            if (result == null) continue;
            return result;
        }
        return result;
    }

    private static boolean segmentValidInPointArray(ArrayList pa, double x, double y, double tw) {
        if (pa.size() < 2) {
            return false;
        }
        PointWithAlpha p1 = (PointWithAlpha)pa.get(0);
        PointWithAlpha p2 = (PointWithAlpha)pa.get(pa.size() - 1);
        if (p1.getX() == p2.getX() && p1.getY() == p2.getY()) {
            return false;
        }
        if (p1.getX() - p2.getX() == 0) {
            for (int i = 0; i < pa.size() - 1; i += 2) {
                p1 = (PointWithAlpha)pa.get(i);
                p2 = (PointWithAlpha)pa.get(i + 1);
                if ((double)p1.getY() > y) {
                    return false;
                }
                if (!(y >= (double)p1.getY()) || !(y <= (double)p2.getY()) || !((double)p2.getY() - y > tw)) continue;
                return true;
            }
        } else {
            for (int i = 0; i < pa.size() - 1; i += 2) {
                p1 = (PointWithAlpha)pa.get(i);
                p2 = (PointWithAlpha)pa.get(i + 1);
                if ((double)p1.getX() > x) {
                    return false;
                }
                if (!(x >= (double)p1.getX()) || !(x <= (double)p2.getX()) || !((x - (double)p2.getX()) * (x - (double)p2.getX()) + (y - (double)p2.getY()) * (y - (double)p2.getY()) > tw * tw)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean rectConflictsWithRectArrays(RectArray[] limitRects, Rectangle2D rect) {
        if (limitRects == null) {
            return false;
        }
        for (int i = 0; i < limitRects.length; ++i) {
            if (!limitRects[i].conflicts(rect)) continue;
            return true;
        }
        return false;
    }

    public static boolean rectConflictsWithRectArrays(RectArray[] limitRects, double x, double y, double width, double height) {
        if (limitRects == null) {
            return false;
        }
        for (int i = 0; i < limitRects.length; ++i) {
            if (limitRects[i] == null || !limitRects[i].conflicts(x, y, width, height)) continue;
            return true;
        }
        return false;
    }

    public static void insertRectIntoRectArrays(RectArray[] limitRects, Rectangle2D rect) {
        if (limitRects == null) {
            return;
        }
        for (int i = 0; i < limitRects.length; ++i) {
            if (limitRects[i] == null) continue;
            limitRects[i].insert(rect);
        }
    }

    public static void insertRectIntoRectArrays(RectArray[] limitRects, double x, double y, double width, double height) {
        if (limitRects == null) {
            return;
        }
        for (int i = 0; i < limitRects.length; ++i) {
            if (limitRects[i] == null) continue;
            limitRects[i].insert(x, y, width, height);
        }
    }

    private static Point2D.Double findPointOnSegment(PointWithAlpha p1, PointWithAlpha p2, ArrayList pa1, ArrayList pa2, double tw, double th, ArrayList[] intsectArray, RectArray[] limitRects, boolean ignoreCollision, Rectangle2D deviceView) {
        Point2D.Double result = null;
        double length = 0.0;
        double rx = 0.0;
        double ry = 0.0;
        double fx = 0.0;
        double fy = 0.0;
        boolean foundRegardLessConfict = false;
        if (p1.getX() == p2.getX()) {
            length = p2.getY() - p1.getY();
            if (length > tw) {
                Rectangle2D.Double rect;
                double y;
                double x = (double)p1.getX() - th;
                if (LabelHelper.segmentValidInPointArray(pa1, x, y = (double)p1.getY() + (length - tw) / 2.0, tw)) {
                    rect = new Rectangle2D.Double(x, y, th, tw);
                    if (deviceView == null || deviceView.contains(rect)) {
                        if (!LabelHelper.rectConflictsWithRectArrays(limitRects, rect)) {
                            LabelHelper.insertRectIntoRectArrays(limitRects, rect);
                            return new Point2D.Double(x + th, y + tw);
                        }
                        if (ignoreCollision) {
                            foundRegardLessConfict = true;
                            fx = x;
                            fy = y + tw;
                            rx = x;
                            ry = y;
                        }
                    }
                }
                if (LabelHelper.segmentValidInPointArray(pa2, x, y, tw)) {
                    rect = new Rectangle2D.Double(x + th, y, th, tw);
                    if (deviceView == null || deviceView.contains(rect)) {
                        if (!LabelHelper.rectConflictsWithRectArrays(limitRects, x + th, y, th, tw)) {
                            LabelHelper.insertRectIntoRectArrays(limitRects, x + th, y, th, tw);
                            return new Point2D.Double(x + th + th, y + tw);
                        }
                        if (ignoreCollision && !foundRegardLessConfict) {
                            foundRegardLessConfict = true;
                            fx = x + th;
                            fy = y + tw;
                            rx = x + th;
                            ry = y;
                        }
                    }
                }
                if (length > tw * 2.0) {
                    y = (double)p1.getY() + (length / 2.0 - tw) / 2.0;
                    rect = new Rectangle2D.Double(x, y, th, tw);
                    if ((deviceView == null || deviceView.contains(rect)) && LabelHelper.segmentValidInPointArray(pa1, x, y, tw)) {
                        if (!LabelHelper.rectConflictsWithRectArrays(limitRects, x, y, th, tw)) {
                            LabelHelper.insertRectIntoRectArrays(limitRects, x, y, th, tw);
                            return new Point2D.Double(x + th, y + tw);
                        }
                        if (ignoreCollision && !foundRegardLessConfict) {
                            foundRegardLessConfict = true;
                            fx = x;
                            fy = y + tw;
                            rx = x;
                            ry = y;
                        }
                    }
                    rect = new Rectangle2D.Double(x + th, y, th, tw);
                    if ((deviceView == null || deviceView.contains(rect)) && LabelHelper.segmentValidInPointArray(pa2, x, y, tw)) {
                        if (!LabelHelper.rectConflictsWithRectArrays(limitRects, x + th, y, th, tw)) {
                            LabelHelper.insertRectIntoRectArrays(limitRects, x + th, y, th, tw);
                            return new Point2D.Double(x + th + th, y + tw);
                        }
                        if (ignoreCollision && !foundRegardLessConfict) {
                            foundRegardLessConfict = true;
                            fx = x + th;
                            fy = y + tw;
                            rx = x + th;
                            ry = y;
                        }
                    }
                    y = (double)p1.getY() + (3.0 * length / 2.0 - tw) / 2.0;
                    rect = new Rectangle2D.Double(x, y, th, tw);
                    if ((deviceView == null || deviceView.contains(rect)) && LabelHelper.segmentValidInPointArray(pa1, x, y, tw)) {
                        if (!LabelHelper.rectConflictsWithRectArrays(limitRects, x, y, th, tw)) {
                            LabelHelper.insertRectIntoRectArrays(limitRects, x, y, th, tw);
                            return new Point2D.Double(x + th, y + tw);
                        }
                        if (ignoreCollision && !foundRegardLessConfict) {
                            foundRegardLessConfict = true;
                            fx = x;
                            fy = y + tw;
                            rx = x;
                            ry = y;
                        }
                    }
                    rect = new Rectangle2D.Double(x + th, y, th, tw);
                    if ((deviceView == null || deviceView.contains(rect)) && LabelHelper.segmentValidInPointArray(pa2, x, y, tw)) {
                        if (!LabelHelper.rectConflictsWithRectArrays(limitRects, x + th, y, th, tw)) {
                            LabelHelper.insertRectIntoRectArrays(limitRects, x + th, y, th, tw);
                            return new Point2D.Double(x + th + th, y + tw);
                        }
                        if (ignoreCollision && !foundRegardLessConfict) {
                            foundRegardLessConfict = true;
                            fx = x + th;
                            fy = y + tw;
                            rx = x + th;
                            ry = y;
                        }
                    }
                }
            }
            double tmp = tw;
            th = tw = th;
        } else if (p1.getY() == p2.getY()) {
            length = p2.getX() - p1.getX();
            if (length > tw) {
                double x = (double)p1.getX() + (length - tw) / 2.0;
                double y = (double)p1.getY() - th;
                Rectangle2D.Double rect = new Rectangle2D.Double(x, y, tw, th);
                if ((deviceView == null || deviceView.contains(rect)) && LabelHelper.segmentValidInPointArray(pa1, x, y, tw)) {
                    if (!LabelHelper.rectConflictsWithRectArrays(limitRects, x, y, tw, th)) {
                        LabelHelper.insertRectIntoRectArrays(limitRects, x, y, tw, th);
                        return new Point2D.Double(x, y + th);
                    }
                    if (ignoreCollision && !foundRegardLessConfict) {
                        foundRegardLessConfict = true;
                        fx = x;
                        fy = y;
                        rx = x;
                        ry = y;
                    }
                }
                rect = new Rectangle2D.Double(x, y + th, tw, th);
                if ((deviceView == null || deviceView.contains(rect)) && LabelHelper.segmentValidInPointArray(pa2, x, y + th, tw)) {
                    if (!LabelHelper.rectConflictsWithRectArrays(limitRects, x, y + th, tw, th)) {
                        LabelHelper.insertRectIntoRectArrays(limitRects, x, y + th, tw, th);
                        return new Point2D.Double(x, y + th + th);
                    }
                    if (ignoreCollision && !foundRegardLessConfict) {
                        foundRegardLessConfict = true;
                        fx = x;
                        fy = y + th;
                        rx = x;
                        ry = y + th;
                    }
                }
                if (length > tw * 1.5) {
                    x = (double)p1.getX() + (length / 3.0 - tw / 2.0);
                    rect = new Rectangle2D.Double(x, y, tw, th);
                    if ((deviceView == null || deviceView.contains(rect)) && LabelHelper.segmentValidInPointArray(pa1, x, y, tw)) {
                        if (!LabelHelper.rectConflictsWithRectArrays(limitRects, x, y, tw, th)) {
                            LabelHelper.insertRectIntoRectArrays(limitRects, x, y, tw, th);
                            return new Point2D.Double(x, y + th);
                        }
                        if (ignoreCollision && !foundRegardLessConfict) {
                            foundRegardLessConfict = true;
                            fx = x;
                            fy = y;
                            rx = x;
                            ry = y;
                        }
                    }
                    rect = new Rectangle2D.Double(x, y + th, tw, th);
                    if ((deviceView == null || deviceView.contains(rect)) && LabelHelper.segmentValidInPointArray(pa2, x, y + th, tw)) {
                        if (!LabelHelper.rectConflictsWithRectArrays(limitRects, x, y + th, tw, th)) {
                            LabelHelper.insertRectIntoRectArrays(limitRects, x, y + th, tw, th);
                            return new Point2D.Double(x, y + th + th);
                        }
                        if (ignoreCollision && !foundRegardLessConfict) {
                            foundRegardLessConfict = true;
                            fx = x;
                            fy = y + th;
                            rx = x;
                            ry = y + th;
                        }
                    }
                    x = (double)p1.getX() + (2.0 * length / 3.0 - tw / 2.0);
                    rect = new Rectangle2D.Double(x, y, tw, th);
                    if ((deviceView == null || deviceView.contains(rect)) && LabelHelper.segmentValidInPointArray(pa1, x, y, tw)) {
                        if (!LabelHelper.rectConflictsWithRectArrays(limitRects, x, y, tw, th)) {
                            LabelHelper.insertRectIntoRectArrays(limitRects, x, y, tw, th);
                            return new Point2D.Double(x, y + th);
                        }
                        if (ignoreCollision && !foundRegardLessConfict) {
                            foundRegardLessConfict = true;
                            fx = x;
                            fy = y;
                            rx = x;
                            ry = y;
                        }
                    }
                    rect = new Rectangle2D.Double(x, y + th, tw, th);
                    if ((deviceView == null || deviceView.contains(rect)) && LabelHelper.segmentValidInPointArray(pa2, x, y + th, tw)) {
                        if (!LabelHelper.rectConflictsWithRectArrays(limitRects, x, y + th, tw, th)) {
                            LabelHelper.insertRectIntoRectArrays(limitRects, x, y + th, tw, th);
                            return new Point2D.Double(x, y + th + th);
                        }
                        if (ignoreCollision && !foundRegardLessConfict) {
                            foundRegardLessConfict = true;
                            fx = x;
                            fy = y + th;
                            rx = x;
                            ry = y + th;
                        }
                    }
                }
                if (length > tw * 3.0) {
                    x = (double)p1.getX() + (length / 6.0 - tw / 2.0);
                    rect = new Rectangle2D.Double(x, y, tw, th);
                    if ((deviceView == null || deviceView.contains(rect)) && LabelHelper.segmentValidInPointArray(pa1, x, y, tw)) {
                        if (!LabelHelper.rectConflictsWithRectArrays(limitRects, x, y, tw, th)) {
                            LabelHelper.insertRectIntoRectArrays(limitRects, x, y, tw, th);
                            return new Point2D.Double(x, y + th);
                        }
                        if (ignoreCollision && !foundRegardLessConfict) {
                            foundRegardLessConfict = true;
                            fx = x;
                            fy = y;
                            rx = x;
                            ry = y;
                        }
                    }
                    rect = new Rectangle2D.Double(x, y + th, tw, th);
                    if ((deviceView == null || deviceView.contains(rect)) && LabelHelper.segmentValidInPointArray(pa2, x, y + th, tw)) {
                        if (!LabelHelper.rectConflictsWithRectArrays(limitRects, x, y + th, tw, th)) {
                            LabelHelper.insertRectIntoRectArrays(limitRects, x, y + th, tw, th);
                            return new Point2D.Double(x, y + th + th);
                        }
                        if (ignoreCollision && !foundRegardLessConfict) {
                            foundRegardLessConfict = true;
                            fx = x;
                            fy = y + th;
                            rx = x;
                            ry = y + th;
                        }
                    }
                    x = (double)p1.getX() + (5.0 * length / 6.0 - tw / 2.0);
                    rect = new Rectangle2D.Double(x, y, tw, th);
                    if ((deviceView == null || deviceView.contains(rect)) && LabelHelper.segmentValidInPointArray(pa1, x, y, tw)) {
                        if (!LabelHelper.rectConflictsWithRectArrays(limitRects, x, y, tw, th)) {
                            LabelHelper.insertRectIntoRectArrays(limitRects, x, y, tw, th);
                            return new Point2D.Double(x, y + th);
                        }
                        if (ignoreCollision && !foundRegardLessConfict) {
                            foundRegardLessConfict = true;
                            fx = x;
                            fy = y;
                            rx = x;
                            ry = y;
                        }
                    }
                    rect = new Rectangle2D.Double(x, y + th, tw, th);
                    if ((deviceView == null || deviceView.contains(rect)) && LabelHelper.segmentValidInPointArray(pa2, x, y + th, tw)) {
                        if (!LabelHelper.rectConflictsWithRectArrays(limitRects, x, y + th, tw, th)) {
                            LabelHelper.insertRectIntoRectArrays(limitRects, x, y + th, tw, th);
                            return new Point2D.Double(x, y + th + th);
                        }
                        if (ignoreCollision && !foundRegardLessConfict) {
                            foundRegardLessConfict = true;
                            fx = x;
                            fy = y + th;
                            rx = x;
                            ry = y + th;
                        }
                    }
                }
            }
        } else {
            length = Math.sqrt((p2.getX() - p1.getX()) * (p2.getX() - p1.getX()) + (p2.getY() - p1.getY()) * (p2.getY() - p1.getY()));
            if (length > tw) {
                double belta = Math.atan((double)(p2.getY() - p1.getY()) / (double)(p2.getX() - p1.getX()));
                double cos = Math.cos(belta);
                double sin = Math.sin(belta);
                double rw = cos * (tw + th);
                double rh = Math.abs(sin * (tw + th));
                double xoffset = sin * th;
                double yoffset = cos * th;
                double x = (double)p1.getX() + (length - tw) * (double)(p2.getX() - p1.getX()) / (2.0 * length);
                double y = (double)p1.getY() + (length - tw) * (double)(p2.getY() - p1.getY()) / (2.0 * length);
                double x2 = (double)p1.getX() + (length + tw) * (double)(p2.getX() - p1.getX()) / (2.0 * length);
                double y2 = (double)p1.getY() + (length + tw) * (double)(p2.getY() - p1.getY()) / (2.0 * length);
                if ((deviceView == null || deviceView.contains(x, y) && deviceView.contains(x2, y2)) && LabelHelper.segmentValidInPointArray(pa1, x + xoffset, y - yoffset, tw)) {
                    if (!LabelHelper.lineConflictsWithRectArray(limitRects, x, y, x2, y2, th)) {
                        return new Point2D.Double(x, y);
                    }
                    if (ignoreCollision && !foundRegardLessConfict) {
                        foundRegardLessConfict = true;
                        fx = x;
                        fy = y;
                        rx = x;
                        double d = ry = sin > 0.0 ? y : y - rh;
                    }
                }
                if ((deviceView == null || deviceView.contains(x - xoffset, y + yoffset) && deviceView.contains(x2 - xoffset, y2 + yoffset)) && LabelHelper.segmentValidInPointArray(pa2, x - xoffset, y + yoffset, tw)) {
                    if (!LabelHelper.lineConflictsWithRectArray(limitRects, x - xoffset, y + yoffset, x2 - xoffset, y2 + yoffset, th)) {
                        return new Point2D.Double(x - xoffset, y + yoffset);
                    }
                    if (ignoreCollision && !foundRegardLessConfict) {
                        foundRegardLessConfict = true;
                        fx = x - xoffset;
                        fy = y + yoffset;
                        rx = fx;
                        ry = (sin > 0.0 ? y : y - rh) + yoffset;
                    }
                }
                if (length > tw * 2.0) {
                    x = (double)p1.getX() + (length / 2.0 - tw) * (double)(p2.getX() - p1.getX()) / (2.0 * length);
                    y = (double)p1.getY() + (length / 2.0 - tw) * (double)(p2.getY() - p1.getY()) / (2.0 * length);
                    x2 = (double)p1.getX() + (length / 2.0 + tw) * (double)(p2.getX() - p1.getX()) / (2.0 * length);
                    y2 = (double)p1.getY() + (length / 2.0 + tw) * (double)(p2.getY() - p1.getY()) / (2.0 * length);
                    if ((deviceView == null || deviceView.contains(x, y) && deviceView.contains(x2, y2)) && LabelHelper.segmentValidInPointArray(pa1, x + xoffset, y - yoffset, tw)) {
                        if (!LabelHelper.lineConflictsWithRectArray(limitRects, x, y, x2, y2, th)) {
                            return new Point2D.Double(x, y);
                        }
                        if (ignoreCollision && !foundRegardLessConfict) {
                            foundRegardLessConfict = true;
                            fx = x;
                            fy = y;
                            rx = x;
                            double d = ry = sin > 0.0 ? y : y - rh;
                        }
                    }
                    if ((deviceView == null || deviceView.contains(x - xoffset, y + yoffset) && deviceView.contains(x2 - xoffset, y2 + yoffset)) && LabelHelper.segmentValidInPointArray(pa2, x - xoffset, y + yoffset, tw)) {
                        if (!LabelHelper.lineConflictsWithRectArray(limitRects, x - xoffset, y + yoffset, x2 - xoffset, y2 + yoffset, th)) {
                            return new Point2D.Double(x - xoffset, y + yoffset);
                        }
                        if (ignoreCollision && !foundRegardLessConfict) {
                            foundRegardLessConfict = true;
                            fx = x - xoffset;
                            fy = y + yoffset;
                            rx = fx;
                            ry = (sin > 0.0 ? y : y - rh) + yoffset;
                        }
                    }
                    x = (double)p1.getX() + (3.0 * length / 2.0 - tw) * (double)(p2.getX() - p1.getX()) / (2.0 * length);
                    y = (double)p1.getY() + (3.0 * length / 2.0 - tw) * (double)(p2.getY() - p1.getY()) / (2.0 * length);
                    x2 = (double)p1.getX() + (3.0 * length / 2.0 + tw) * (double)(p2.getX() - p1.getX()) / (2.0 * length);
                    y2 = (double)p1.getY() + (3.0 * length / 2.0 + tw) * (double)(p2.getY() - p1.getY()) / (2.0 * length);
                    if ((deviceView == null || deviceView.contains(x, y) && deviceView.contains(x2, y2)) && LabelHelper.segmentValidInPointArray(pa1, x + xoffset, y - yoffset, tw)) {
                        if (!LabelHelper.lineConflictsWithRectArray(limitRects, x, y, x2, y2, th)) {
                            return new Point2D.Double(x, y);
                        }
                        if (ignoreCollision && !foundRegardLessConfict) {
                            foundRegardLessConfict = true;
                            fx = x;
                            fy = y;
                            rx = x;
                            double d = ry = sin > 0.0 ? y : y - rh;
                        }
                    }
                    if ((deviceView == null || deviceView.contains(x - xoffset, y + yoffset) && deviceView.contains(x2 - xoffset, y2 + yoffset)) && LabelHelper.segmentValidInPointArray(pa2, x - xoffset, y + yoffset, tw)) {
                        if (!LabelHelper.lineConflictsWithRectArray(limitRects, x - xoffset, y + yoffset, x2 - xoffset, y2 + yoffset, th)) {
                            return new Point2D.Double(x - xoffset, y + yoffset);
                        }
                        if (ignoreCollision && !foundRegardLessConfict) {
                            foundRegardLessConfict = true;
                            fx = x - xoffset;
                            fy = y + yoffset;
                            rx = fx;
                            ry = (sin > 0.0 ? y : y - rh) + yoffset;
                        }
                    }
                }
                tw = rw;
                th = rh;
            }
        }
        if (ignoreCollision && foundRegardLessConfict) {
            LabelHelper.insertRectIntoRectArrays(limitRects, rx, ry, tw, th);
            return new Point2D.Double(fx, fy);
        }
        return result;
    }

    private static void sortPointArray(ArrayList pa) {
        PointWithAlpha p2;
        PointWithAlpha p1;
        boolean switched = true;
        while (switched) {
            switched = false;
            for (int j = 0; j < pa.size() - 1; ++j) {
                p1 = (PointWithAlpha)pa.get(j);
                p2 = (PointWithAlpha)pa.get(j + 1);
                if (p1.getX() > p2.getX()) {
                    pa.set(j, p2);
                    pa.set(j + 1, p1);
                    switched = true;
                    continue;
                }
                if (p1.getX() != p2.getX() || p1.getY() <= p2.getY()) continue;
                pa.set(j, p2);
                pa.set(j + 1, p1);
                switched = true;
            }
        }
        int i = 0;
        while (i < pa.size() - 1) {
            p1 = (PointWithAlpha)pa.get(i);
            p2 = (PointWithAlpha)pa.get(i + 1);
            if (p1.getY() == p2.getY() && p1.getX() == p2.getX()) {
                if (p1.getAlpha() * p2.getAlpha() == -1) {
                    pa.remove(i);
                    continue;
                }
                pa.remove(i);
                pa.remove(i);
                continue;
            }
            ++i;
        }
    }

    public static ArrayList getBoundingRectsWithoutConflicts(RectArray limitRects, double x1, double y1, double x2, double y2, double width) {
        RectArray[] tmpRectArrayList = new RectArray[]{limitRects};
        return LabelHelper.getBoundingRectsWithoutConflicts(tmpRectArrayList, x1, y1, x2, y2, width);
    }

    public static ArrayList getBoundingRectsWithoutConflicts(RectArray[] limitRects, double x1, double y1, double x2, double y2, double width) {
        double b2;
        if (x1 == x2) {
            Rectangle2D.Double rect = new Rectangle2D.Double(x1 - width, Math.min(y1, y2), width, Math.abs(y2 - y1));
            if (LabelHelper.rectConflictsWithRectArrays(limitRects, rect)) {
                return null;
            }
            ArrayList<Rectangle2D.Double> result = new ArrayList<Rectangle2D.Double>(1);
            result.add(rect);
            return result;
        }
        if (y1 == y2) {
            Rectangle2D.Double rect = new Rectangle2D.Double(Math.min(x1, x2), y1 - width, Math.abs(x2 - x1), width);
            if (LabelHelper.rectConflictsWithRectArrays(limitRects, rect)) {
                return null;
            }
            ArrayList<Rectangle2D.Double> result = new ArrayList<Rectangle2D.Double>(1);
            result.add(rect);
            return result;
        }
        double xlen = Math.abs(x2 - x1);
        double ylen = Math.abs(y2 - y1);
        double len = Math.sqrt((x2 - x1) * (x2 - x1) + (y2 - y1) * (y2 - y1));
        double a = (y2 - y1) * 1.0 / (x2 - x1);
        double xoff = width * ylen / len;
        double yoff = width * xlen / len;
        double b1 = (1.0 * y1 * x2 - x1 * y2) / (x2 - x1);
        if (x1 < x2) {
            b2 = b1;
            b1 -= width * len / xlen;
            if (y1 < y2) {
                x1 += xoff;
                y1 -= yoff;
                x2 += xoff;
                y2 -= yoff;
            } else {
                x1 -= xoff;
                y1 -= yoff;
                x2 -= xoff;
                y2 -= yoff;
            }
        } else {
            b2 = b1 + width * len / xlen;
        }
        if (y1 > y2) {
            double tmp = x1;
            x1 = x2;
            x2 = tmp;
            tmp = y1;
            y1 = y2;
            y2 = tmp;
        }
        double step = Math.max(10.0, width);
        ArrayList<Rectangle2D.Double> rectArray = new ArrayList<Rectangle2D.Double>((int)(xlen / step + 1.0));
        step = x2 < x1 ? -step : step;
        double xstart = x1 + (x1 < x2 ? -xoff : xoff);
        double ystart = y1;
        while (step > 0.0 && xstart < x2 || step < 0.0 && xstart > x2) {
            double xend = xstart + step;
            if (step > 0.0 && xend > x2 || step < 0.0 && xend < x2) {
                xend = x2;
            }
            double yend = xend * a + b2;
            yend = Math.min(yend, y2 + width);
            Rectangle2D.Double rect = new Rectangle2D.Double(Math.min(xstart, xend), Math.min(ystart, yend), Math.abs(xend - xstart), Math.abs(yend - ystart));
            if (LabelHelper.rectConflictsWithRectArrays(limitRects, rect)) {
                return null;
            }
            rectArray.add(rect);
            xstart = xend;
            ystart = xend * a + b1;
        }
        return rectArray;
    }

    public static boolean lineConflictsWithRectArray(RectArray[] limitRects, double x1, double y1, double x2, double y2, double width) {
        ArrayList boundingRects = LabelHelper.getBoundingRectsWithoutConflicts(limitRects, x1, y1, x2, y2, width);
        if (boundingRects == null) {
            return true;
        }
        for (int i = 0; i < boundingRects.size(); ++i) {
            LabelHelper.insertRectIntoRectArrays(limitRects, (Rectangle2D)boundingRects.get(i));
        }
        return false;
    }
}

