/*
 * Decompiled with CFR 0.152.
 */
package oracle.sdovis;

import com.sun.media.jai.codec.ByteArraySeekableStream;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.ParameterBlock;
import java.io.ByteArrayInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import javax.media.jai.BorderExtender;
import javax.media.jai.InterpolationBicubic;
import javax.media.jai.InterpolationBicubic2;
import javax.media.jai.InterpolationBilinear;
import javax.media.jai.InterpolationNearest;
import javax.media.jai.JAI;
import javax.media.jai.PlanarImage;
import javax.media.jai.RenderedOp;
import javax.media.jai.operator.MedianFilterDescriptor;
import javax.media.jai.operator.ShearDescriptor;
import javax.media.jai.operator.TransposeDescriptor;
import javax.vecmath.Vector3d;
import oracle.mapviewer.share.util.LogFactory;
import oracle.sdovis.CustomImageRenderer;
import oracle.sdovis.GeoRasterTheme;
import oracle.sdovis.GlobalVisContext;
import oracle.sdovis.ImageTheme;
import oracle.sdovis.JSDOGeometry;
import oracle.sdovis.MapMaker;
import oracle.sdovis.RSBundle;
import oracle.sdovis.Renderer;
import oracle.sdovis.ShadedReliefTheme;
import oracle.sdovis.Theme;
import oracle.sdovis.VisContext;
import oracle.sdovis.WMTSTheme;
import oracle.sdovis.XFViewPort;
import oracle.sdovis.raytracing.Render3DException;
import oracle.sdovis.theme.GeoRasterThemeDefinition;
import oracle.sdovis.theme.GeoRasterThemeProducer;
import oracle.sdovis.theme.ImageThemeDefinition;
import oracle.sdovis.theme.ShadedReliefThemeDefinition;
import oracle.sdovis.theme.ShadedReliefThemeProducer;
import oracle.sdovis.theme.ThemeDefinition;
import oracle.sdovis.theme.WMTSThemeDefinition;
import oracle.sdovis.util.ImageUtils;

public class ImageRenderer
implements Renderer {
    private static Logger log = LogFactory.getLogger(LogFactory.LoggerEnum.SDOVIS);
    private String currentFormat = null;

    public void prepare() {
    }

    @Override
    public void render(Graphics2D g2, Theme t, VisContext vc) {
        if (t instanceof ImageTheme) {
            ThemeDefinition idef;
            ImageTheme it = null;
            try {
                it = (ImageTheme)t;
            }
            catch (Exception e) {
                log.severe(e.getMessage());
                return;
            }
            String fmt = null;
            if (it instanceof WMTSTheme) {
                idef = (WMTSThemeDefinition)it.getDefinition();
                fmt = ((WMTSThemeDefinition)idef).getFormat().toUpperCase();
            } else {
                idef = (ImageThemeDefinition)it.getDefinition();
                fmt = ((ImageThemeDefinition)idef).getImageFormat().toUpperCase();
            }
            log.finer("format of image theme data: " + fmt);
            if ("GIF".equals(fmt) || "JPEG".equals(fmt) || "JPG".equals(fmt) || "PNG".equals(fmt) || "TIFF".equals(fmt) || fmt.trim().startsWith("IMAGE/")) {
                this.renderImageTheme(g2, it, vc.getImageScaling(), vc);
            } else {
                CustomImageRenderer cir = GlobalVisContext.findCustomImageRenderer(fmt);
                if (cir != null) {
                    this.renderImageThemeUsingCIR(g2, it, cir, vc.getImageScaling(), vc);
                } else {
                    log.severe(RSBundle.getMsg("MAPVIEWER-01011") + fmt);
                }
            }
        } else if (t instanceof ShadedReliefTheme) {
            ShadedReliefTheme srt = null;
            try {
                srt = (ShadedReliefTheme)t;
            }
            catch (Exception e) {
                log.log(Level.SEVERE, e.getMessage(), e);
                return;
            }
            this.renderShadedReliefTheme(g2, srt, vc.getImageScaling(), vc);
        } else {
            GeoRasterTheme gt = null;
            try {
                gt = (GeoRasterTheme)t;
            }
            catch (Exception e) {
                log.log(Level.SEVERE, e.getMessage(), e);
                return;
            }
            this.renderGeoRasterTheme(g2, gt, vc.getImageScaling(), vc);
        }
    }

    @Override
    public void label(Graphics2D g2, Theme t, VisContext vc) {
    }

    private void renderImageTheme(Graphics2D g2, ImageTheme it, boolean imgScaling, VisContext vc) {
        byte[][] images = it.getImages();
        double[][] mbrs = it.getMBRs();
        if (images == null || images.length == 0) {
            return;
        }
        for (int i = 0; i < images.length; ++i) {
            float alpha = 0.0f;
            float transparency = 0.0f;
            if (it instanceof WMTSTheme) {
                this.currentFormat = ((WMTSThemeDefinition)it.getDefinition()).getFormat();
                transparency = it.getDecorator().getOpacity();
                if (transparency >= 0.0f && transparency < 1.0f) {
                    alpha = transparency;
                }
            } else {
                this.currentFormat = ((ImageThemeDefinition)it.getDefinition()).getImageFormat();
                alpha = ((ImageThemeDefinition)it.getDefinition()).getAlpha();
                transparency = it.getDecorator().getOpacity();
                if (transparency >= 0.0f && transparency < 1.0f) {
                    alpha = transparency;
                }
            }
            this.renderImage(g2, images[i], mbrs[i], imgScaling, alpha, vc);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void renderImage(Graphics2D g2, byte[] image, double[] mbr, boolean imgScaling, float alpha, VisContext vc) {
        log.finest("image[].length=" + image.length);
        BufferedImage img = null;
        if (this.currentFormat != null && (this.currentFormat.equalsIgnoreCase("TIFF") || this.currentFormat.toUpperCase().indexOf("TIF") > -1)) {
            this.renderTIFFImage(g2, image, mbr, imgScaling, alpha, vc);
            return;
        }
        try {
            img = ImageIO.read(new ByteArrayInputStream(image));
        }
        catch (Exception ex) {
            log.severe(RSBundle.getMsg("MAPVIEWER-01012"));
            return;
        }
        log.finest("image ground mbr=" + mbr[0] + "," + mbr[1] + " " + mbr[2] + "," + mbr[3]);
        Point2D.Double ul = new Point2D.Double();
        Point2D.Double lr = new Point2D.Double();
        AffineTransform mAT = vc.getAffineXF();
        if (mAT != null) {
            mAT.transform(new Point2D.Double(mbr[0], mbr[3]), ul);
            mAT.transform(new Point2D.Double(mbr[2], mbr[1]), lr);
        }
        if (img != null) {
            int sx = (int)((Point2D)ul).getX();
            int sy = (int)((Point2D)ul).getY();
            int iw = ((Image)img).getWidth(null);
            int ih = ((Image)img).getHeight(null);
            log.finest("image width: " + iw + ", height:" + ih);
            log.finest("rendering image at: " + sx + ", " + sy);
            Composite cOld = null;
            if (alpha > 0.0f && alpha < 1.0f) {
                cOld = g2.getComposite();
                g2.setComposite(AlphaComposite.getInstance(3, alpha));
            }
            AffineTransform aft = g2.getTransform();
            Object hint = g2.getRenderingHint(RenderingHints.KEY_INTERPOLATION);
            if (hint == null) {
                hint = RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR;
            }
            try {
                boolean applyRotation = false;
                if (vc.getRotation() != 0.0 && !MapMaker.isSpecial(vc.getQueryWindow())) {
                    double rotation = -1.0 * vc.getRotation() * Math.PI / 180.0;
                    Point2D.Double center = new Point2D.Double();
                    mAT.transform(new Point2D.Double(vc.getQueryWindow().getCenterX(), vc.getQueryWindow().getCenterY()), center);
                    AffineTransform rot = AffineTransform.getRotateInstance(rotation, ((Point2D)center).getX(), ((Point2D)center).getY());
                    g2.setTransform(rot);
                    g2.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
                    applyRotation = true;
                }
                if (imgScaling) {
                    g2.drawImage(img, sx, sy, (int)(((Point2D)lr).getX() - ((Point2D)ul).getX() + 1.0), (int)(((Point2D)lr).getY() - ((Point2D)ul).getY() + 1.0), null);
                } else {
                    log.finest("Drawing image in original resolution.");
                    if (vc.getDeviceWindow().contains(10.0, ih - sy) || vc.getDeviceWindow().contains(iw - sx, 10.0)) {
                        g2.drawImage(img, sx, sy, iw + 1, ih + 1, null);
                    } else {
                        g2.drawImage((Image)img, sx, sy, null);
                    }
                }
                if (applyRotation) {
                    g2.setTransform(aft);
                    g2.setRenderingHint(RenderingHints.KEY_INTERPOLATION, hint);
                }
            }
            catch (Exception ex) {
                g2.setTransform(aft);
                g2.setRenderingHint(RenderingHints.KEY_INTERPOLATION, hint);
                log.severe(ex.getMessage());
            }
            finally {
                if (alpha > 0.0f && alpha < 1.0f) {
                    try {
                        g2.setComposite(cOld);
                    }
                    catch (Exception e) {}
                }
                if (img != null) {
                    ImageUtils.removeImageFromTracker(img);
                    img.flush();
                    img = null;
                }
            }
        }
    }

    private void renderImageThemeUsingCIR(Graphics2D g2, ImageTheme it, CustomImageRenderer cir, boolean imageScaling, VisContext vc) {
        byte[][] images = it.getImages();
        double[][] mbrs = it.getMBRs();
        if (images == null || images.length == 0) {
            return;
        }
        try {
            cir.renderImages(g2, images, mbrs, vc.getQueryWindow(), vc.getDeviceWindow(), vc.getAffineXF(), imageScaling);
        }
        catch (Exception e) {
            log.log(Level.SEVERE, e.getMessage(), e);
        }
        images = null;
        mbrs = null;
    }

    private void renderShadedReliefTheme(Graphics2D g2, ShadedReliefTheme srt, boolean imgScaling, VisContext vc) {
        double[][] mbrs = srt.getMBRs();
        ShadedReliefThemeProducer srp = (ShadedReliefThemeProducer)srt.getProducer();
        ShadedReliefThemeDefinition srd = (ShadedReliefThemeDefinition)srt.getDefinition();
        if (mbrs == null || mbrs.length == 0 || srp.getRenderedImages().size() == 0) {
            log.warning("Shaded Relief theme " + srt.getName() + " has no rendered images.");
            return;
        }
        GeoRasterThemeDefinition gd = (GeoRasterThemeDefinition)srd.getGeorDef();
        for (int i = 0; i < mbrs.length; ++i) {
            RenderedImage ri = srp.getShadedReliefRenderedImage(i);
            if (mbrs[i] == null || ri == null) continue;
            double imgRot = 0.0;
            int imgTransf = 0;
            Point2D imgRotRef = null;
            boolean imgFlip = srp.isImageFlipped(i);
            JSDOGeometry imgMask = null;
            double rotation = srp.getImageRotation(i);
            if (rotation != 0.0) {
                imgRot = rotation;
                imgRotRef = srp.getImageRotationRefPoint(i);
                imgMask = srp.getImageRotationMask(i);
                imgTransf = srp.getImageTransformation(i);
            }
            float alpha = gd.getAlpha();
            float transparency = srt.getDecorator().getOpacity();
            if (transparency >= 0.0f && transparency < 1.0f) {
                alpha = transparency;
            }
            Vector<JSDOGeometry> polyMasks = null;
            if (srp.getPolygonMask() != null) {
                polyMasks = new Vector<JSDOGeometry>();
                polyMasks.add(srp.getPolygonMask());
            } else if (srp.getPolygonMasks() != null && srp.getPolygonMasks().size() > 0) {
                if (gd.getPolygonMaskGeoRasterJoinColumn() != null) {
                    String georasterId = srp.getGeoRasterIds().get(i);
                    polyMasks = srp.getPolygonMasks().get(georasterId);
                } else {
                    polyMasks = srp.getPolygonMasks().get("1");
                }
            }
            JSDOGeometry reprojMask = srp.getImageReprojectionMask(i);
            if (reprojMask != null) {
                if (polyMasks == null) {
                    polyMasks = new Vector();
                }
                polyMasks.add(reprojMask);
            }
            String modelLocation = srp.getImageModelLocation(i);
            this.renderGeoRasterImage(g2, ri, mbrs[i], imgScaling, alpha, vc, polyMasks, imgRot, imgRotRef, imgFlip, imgMask, imgTransf, modelLocation, GeoRasterThemeDefinition.RENDER_INTERPOLATE_BILINEAR, false);
            mbrs[i] = null;
        }
        mbrs = null;
    }

    private void renderGeoRasterTheme(Graphics2D g2, GeoRasterTheme gt, boolean imgScaling, VisContext vc) {
        BufferedImage img;
        double[][] mbrs = gt.getMBRs();
        GeoRasterThemeProducer gp = (GeoRasterThemeProducer)gt.getProducer();
        GeoRasterThemeDefinition gd = (GeoRasterThemeDefinition)gt.getDefinition();
        if (mbrs == null || mbrs.length == 0 || gp.getRenderedImages().size() == 0) {
            log.warning("GeoRaster theme " + gt.getName() + " has no rendered images.");
            return;
        }
        Vector<JSDOGeometry> reprojectionMasks = new Vector<JSDOGeometry>();
        for (int i = 0; i < mbrs.length; ++i) {
            RenderedImage ri = gp.getRenderedImage(i);
            if (mbrs[i] == null || ri == null) continue;
            double imgRot = 0.0;
            int imgTransf = 0;
            Point2D imgRotRef = null;
            boolean imgFlip = gp.isImageFlipped(i);
            JSDOGeometry imgMask = null;
            double rotation = gp.getImageRotation(i);
            if (rotation != 0.0) {
                imgRot = rotation;
                imgRotRef = gp.getImageRotationRefPoint(i);
                imgMask = gp.getImageRotationMask(i);
                imgTransf = gp.getImageTransformation(i);
            }
            float alpha = gd.getAlpha();
            float transparency = gt.getDecorator().getOpacity();
            if (transparency >= 0.0f && transparency < 1.0f) {
                alpha = transparency;
            }
            Vector<JSDOGeometry> polyMasks = null;
            if (gp.getPolygonMask() != null) {
                polyMasks = new Vector<JSDOGeometry>();
                polyMasks.add(gp.getPolygonMask());
            } else if (gp.getPolygonMasks() != null && gp.getPolygonMasks().size() > 0) {
                if (gd.getPolygonMaskGeoRasterJoinColumn() != null) {
                    String georasterId = gp.getGeoRasterIds().get(i);
                    polyMasks = gp.getPolygonMasks().get(georasterId);
                } else {
                    polyMasks = gp.getPolygonMasks().get("1");
                }
            }
            JSDOGeometry reprojMask = gp.getImageReprojectionMask(i);
            if (reprojMask != null) {
                if (polyMasks == null) {
                    polyMasks = new Vector();
                }
                polyMasks.add(reprojMask);
                reprojectionMasks.add(reprojMask);
            }
            String modelLocation = gp.getImageModelLocation(i);
            this.renderGeoRasterImage(g2, ri, mbrs[i], imgScaling, alpha, vc, polyMasks, imgRot, imgRotRef, imgFlip, imgMask, imgTransf, modelLocation, gd.getRenderInterpolationHint(), gp.hasQueryWindow2());
            mbrs[i] = null;
        }
        mbrs = null;
        if (gp.isPreparedWithReprojection() && gp.getRenderedImages().size() > 0 && (img = vc.getMapImage()) != null) {
            ParameterBlock pb;
            if (((GeoRasterThemeDefinition)gp.getTheme().getDefinition()).getFilterReprojectionResult()) {
                pb = new ParameterBlock();
                pb.addSource(img);
                pb.add(MedianFilterDescriptor.MEDIAN_MASK_SQUARE);
                pb.add(3);
                BufferedImage bmnew = JAI.create((String)"MedianFilter", (ParameterBlock)pb, null).getAsBufferedImage();
                if (bmnew != null) {
                    g2.drawImage((Image)bmnew, 0, 0, null);
                    log.info("Median filter applied on reprojected result.");
                    bmnew.flush();
                    bmnew = null;
                }
            } else if (reprojectionMasks.size() > 0 && gp.getRenderedImages().size() > 1) {
                pb = new ParameterBlock();
                pb.addSource(img);
                pb.add(MedianFilterDescriptor.MEDIAN_MASK_SQUARE);
                pb.add(3);
                BufferedImage bmnew = JAI.create((String)"MedianFilter", (ParameterBlock)pb, null).getAsBufferedImage();
                BufferedImage filterImage = this.filterReprojectionBoundaries(bmnew, reprojectionMasks, vc.getQueryWindow());
                if (filterImage != null) {
                    g2.drawImage((Image)filterImage, 0, 0, null);
                    log.info("Filter applied on adjacent boundaries of reprojected result.");
                    filterImage.flush();
                    filterImage = null;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void renderGeoRasterImage(Graphics2D g2, RenderedImage ri, double[] mbr, boolean imgScaling, float alpha, VisContext vc, Vector<JSDOGeometry> mask, double imgRot, Point2D imgRotRefPoint, boolean imgFlip, JSDOGeometry imgMask, int imgTransf, String modelLocation, String renderInterpolateHint, boolean hasQueryWindow2) {
        log.finest("image ground mbr=" + mbr[0] + "," + mbr[1] + " " + mbr[2] + "," + mbr[3]);
        Point2D.Double ul = new Point2D.Double();
        Point2D.Double lr = new Point2D.Double();
        int iw = ri.getWidth();
        int ih = ri.getHeight();
        AffineTransform mAT = vc.getAffineXF();
        if (mAT != null) {
            mAT.transform(new Point2D.Double(mbr[0], mbr[3]), ul);
            mAT.transform(new Point2D.Double(mbr[2], mbr[1]), lr);
        }
        if (ri != null) {
            double off = 0.0;
            int sx = (int)(((Point2D)ul).getX() - off);
            int sy = (int)(((Point2D)ul).getY() - off);
            int ex = (int)(((Point2D)lr).getX() + off);
            int ey = (int)(((Point2D)lr).getY() + off);
            if (hasQueryWindow2) {
                int lrx;
                Rectangle2D rect = vc.getDeviceWindow();
                if ((double)sx >= rect.getWidth()) {
                    lrx = ex - sx;
                    sx = 0;
                    ex = lrx;
                } else if (sx < 0) {
                    lrx = ex - sx;
                    sx = (int)rect.getWidth() - lrx;
                    ex = sx + lrx;
                }
            }
            log.finest("image width: " + iw + ", height:" + ih);
            log.finest("rendering image at: " + sx + ", " + sy + ", " + ex + ", " + ey);
            BufferedImage bimage = null;
            if (ri instanceof BufferedImage) {
                log.finer("Rendered Image is buffered image.");
                bimage = (BufferedImage)ri;
            } else {
                log.finer("Rendered Image is not buffered image.");
                if (ri instanceof PlanarImage) {
                    bimage = ((PlanarImage)ri).getAsBufferedImage();
                    log.finer("Planar Image converted to BufferedImage.");
                } else {
                    log.info("Unable to render this type of Java Image.");
                    return;
                }
            }
            if (bimage == null) {
                log.info("Unable to render null image.");
                return;
            }
            if (imgFlip) {
                bimage = this.flipImage(bimage);
            }
            if (imgRot != 0.0) {
                bimage = this.transformImage(bimage, imgRot, imgRotRefPoint, imgTransf);
            }
            if (imgMask != null) {
                Vector<JSDOGeometry> iMask = new Vector<JSDOGeometry>();
                iMask.add(imgMask);
                bimage = this.applyPolygonMask(bimage, mbr, iMask, modelLocation);
            }
            if (mask != null) {
                bimage = this.applyPolygonMask(bimage, mbr, mask, modelLocation);
            }
            Composite cOld = null;
            if (alpha > 0.0f && alpha < 1.0f) {
                cOld = g2.getComposite();
                g2.setComposite(AlphaComposite.getInstance(3, alpha));
            }
            Image bmnew = null;
            AffineTransform aft = g2.getTransform();
            try {
                if (!imgScaling) {
                    log.warning("Image scaling set to false is ignored. GeoRaster image is always scaled");
                }
                double scalex = ((double)(ex - sx) + 1.0) / (double)bimage.getWidth();
                double scaley = ((double)(ey - sy) + 1.0) / (double)bimage.getHeight();
                ParameterBlock pb = new ParameterBlock();
                pb.addSource(bimage);
                pb.add((float)scalex);
                pb.add((float)scaley);
                pb.add(0.0f);
                pb.add(0.0f);
                BorderExtender extender = BorderExtender.createInstance((int)1);
                RenderingHints rh = null;
                InterpolationNearest interp = null;
                if (renderInterpolateHint == null) {
                    interp = new InterpolationNearest();
                } else if (renderInterpolateHint.equalsIgnoreCase(GeoRasterThemeDefinition.RENDER_INTERPOLATE_BILINEAR)) {
                    interp = new InterpolationBilinear();
                    rh = new RenderingHints(JAI.KEY_BORDER_EXTENDER, extender);
                } else if (renderInterpolateHint.equalsIgnoreCase(GeoRasterThemeDefinition.RENDER_INTERPOLATE_BICUBIC)) {
                    interp = new InterpolationBicubic(8);
                    rh = new RenderingHints(JAI.KEY_BORDER_EXTENDER, extender);
                } else if (renderInterpolateHint.equalsIgnoreCase(GeoRasterThemeDefinition.RENDER_INTERPOLATE_BICUBIC2)) {
                    interp = new InterpolationBicubic2(8);
                    rh = new RenderingHints(JAI.KEY_BORDER_EXTENDER, extender);
                } else {
                    interp = new InterpolationNearest();
                }
                log.finest("Rendering interpolation hint: " + renderInterpolateHint);
                pb.add(interp);
                bmnew = JAI.create((String)"scale", (ParameterBlock)pb, (RenderingHints)rh).getAsBufferedImage();
                boolean applyRotation = false;
                if (vc.getRotation() != 0.0 && !MapMaker.isSpecial(vc.getQueryWindow())) {
                    double rotation = -1.0 * (vc.getRotation() * Math.PI / 180.0);
                    Point2D.Double center = new Point2D.Double();
                    mAT.transform(new Point2D.Double(vc.getQueryWindow().getCenterX(), vc.getQueryWindow().getCenterY()), center);
                    AffineTransform rot = AffineTransform.getRotateInstance(rotation, ((Point2D)center).getX(), ((Point2D)center).getY());
                    g2.setTransform(rot);
                    applyRotation = true;
                }
                g2.drawImage(bmnew, sx, sy, null);
                if (applyRotation) {
                    g2.setTransform(aft);
                }
            }
            catch (Exception eix) {
                g2.setTransform(aft);
                log.severe(eix.getMessage());
            }
            finally {
                if (alpha > 0.0f && alpha < 1.0f) {
                    try {
                        g2.setComposite(cOld);
                    }
                    catch (Exception e) {}
                }
                if (bmnew != null) {
                    bmnew.flush();
                    bmnew = null;
                }
            }
        }
    }

    private BufferedImage applyPolygonMask(BufferedImage bimage, double[] mbr, Vector<JSDOGeometry> mask, String modelLocation) {
        if (bimage == null) {
            return bimage;
        }
        if (mask != null && mask.size() > 0) {
            BufferedImage argbimage = new BufferedImage(bimage.getWidth(), bimage.getHeight(), 2);
            Graphics2D gg = argbimage.createGraphics();
            gg.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            gg.drawImage((Image)bimage, 0, 0, null);
            XFViewPort mXFViewPort = new XFViewPort();
            mXFViewPort.setStrict(true);
            mXFViewPort.setDataView(mbr[0], mbr[1], mbr[2], mbr[3]);
            mXFViewPort.setDeviceView(0, 0, bimage.getWidth(), bimage.getHeight());
            AffineTransform transf = mXFViewPort.getAffineTransform();
            for (int i = 0; i < mask.size(); ++i) {
                JSDOGeometry maskElem = mask.get(i);
                Shape shp = maskElem.createShape(transf);
                BufferedImage maskimage = new BufferedImage(bimage.getWidth(), bimage.getHeight(), 2);
                Graphics2D mg = maskimage.createGraphics();
                mg.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                mg.setPaint(Color.blue);
                mg.fill(shp);
                mg.dispose();
                gg.setComposite(AlphaComposite.getInstance(6, 1.0f));
                gg.drawImage((Image)maskimage, 0, 0, null);
            }
            gg.dispose();
            return argbimage;
        }
        return bimage;
    }

    private BufferedImage filterReprojectionBoundaries(BufferedImage bimage, Vector<JSDOGeometry> masks, Rectangle2D mbr) {
        if (bimage == null) {
            return null;
        }
        if (masks != null && masks.size() > 0) {
            BufferedImage argbimage = new BufferedImage(bimage.getWidth(), bimage.getHeight(), 2);
            Graphics2D gg = argbimage.createGraphics();
            gg.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            gg.drawImage((Image)bimage, 0, 0, null);
            XFViewPort mXFViewPort = new XFViewPort();
            mXFViewPort.setStrict(true);
            mXFViewPort.setDataView(mbr.getMinX(), mbr.getMinY(), mbr.getMaxX(), mbr.getMaxY());
            mXFViewPort.setDeviceView(0, 0, bimage.getWidth(), bimage.getHeight());
            AffineTransform transf = mXFViewPort.getAffineTransform();
            BufferedImage maskimage = new BufferedImage(bimage.getWidth(), bimage.getHeight(), 2);
            Graphics2D mg = maskimage.createGraphics();
            mg.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            for (int i = 0; i < masks.size(); ++i) {
                JSDOGeometry maskElem = masks.get(i);
                Shape shp = maskElem.createShape(transf);
                mg.setColor(Color.red);
                mg.setStroke(new BasicStroke(4.0f));
                mg.draw(shp);
            }
            mg.dispose();
            gg.setComposite(AlphaComposite.getInstance(6, 1.0f));
            gg.drawImage((Image)maskimage, 0, 0, null);
            gg.dispose();
            return argbimage;
        }
        return null;
    }

    private BufferedImage flipImage(BufferedImage bimage) {
        if (bimage == null) {
            return null;
        }
        return JAI.create((String)"transpose", (RenderedImage)bimage, (Object)TransposeDescriptor.FLIP_VERTICAL).getAsBufferedImage();
    }

    private BufferedImage transformImage(BufferedImage bimage, double imgRot, Point2D imgRotRefPoint, int imgTransf) {
        if (bimage == null) {
            return null;
        }
        double rotation = -1.0 * (imgRot * Math.PI / 180.0);
        BufferedImage transfImg = null;
        ParameterBlock pb = null;
        pb = new ParameterBlock();
        pb.addSource(bimage);
        if (imgTransf == 2 || imgTransf == 3) {
            pb.add((float)rotation);
            if (imgTransf == 2) {
                pb.add(ShearDescriptor.SHEAR_HORIZONTAL);
            } else {
                pb.add(ShearDescriptor.SHEAR_VERTICAL);
            }
            pb.add(0.0f);
            pb.add(0.0f);
            pb.add(new InterpolationNearest());
            transfImg = JAI.create((String)"shear", (ParameterBlock)pb, null).getAsBufferedImage();
        } else {
            if (imgRotRefPoint == null) {
                pb.add((float)(bimage.getWidth() / 2));
                pb.add((float)(bimage.getHeight() / 2));
            } else {
                pb.add((float)imgRotRefPoint.getX());
                pb.add((float)imgRotRefPoint.getY());
            }
            pb.add((float)rotation);
            pb.add(new InterpolationNearest());
            transfImg = JAI.create((String)"rotate", (ParameterBlock)pb, null).getAsBufferedImage();
        }
        return transfImg;
    }

    public void saveTGA(String filename, int width, int height, Raster ras) throws FileNotFoundException, IOException, Render3DException {
        if (!(filename = filename.trim()).endsWith(".tga")) {
            // empty if block
        }
        FileOutputStream fos = new FileOutputStream(filename);
        byte[] header = new byte[18];
        for (int i = 0; i < 18; ++i) {
            header[i] = i == 2 ? 2 : (i == 12 ? (int)(width % 256) : (i == 13 ? (int)(width / 256) : (i == 14 ? (int)(height % 256) : (i == 15 ? (int)(height / 256) : (i == 16 ? 24 : (i == 17 ? 32 : 0))))));
        }
        fos.write(header);
        fos.flush();
        for (int y = 0; y < height; ++y) {
            byte[] data = new byte[width * 3];
            int z = 0;
            for (int x = 0; x < width; ++x) {
                double[] pix = new double[ras.getNumBands()];
                pix = ras.getPixel(x, y, pix);
                Vector3d v = new Vector3d(pix);
                data[z] = this.clampColorComponent(v.z);
                data[z + 1] = this.clampColorComponent(v.y);
                data[z + 2] = this.clampColorComponent(v.x);
                z += 3;
            }
            fos.write(data);
        }
        fos.flush();
        fos.close();
    }

    private byte clampColorComponent(double c) {
        int tmp = (int)(c * 255.0);
        if (tmp < 0) {
            tmp = 0;
        }
        if (tmp > 255) {
            tmp = 255;
        }
        return (byte)tmp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void renderTIFFImage(Graphics2D g2, byte[] img, double[] mbr, boolean imgScaling, float alpha, VisContext vc) {
        if (img == null) {
            return;
        }
        ByteArraySeekableStream stream = null;
        try {
            stream = new ByteArraySeekableStream(img);
        }
        catch (Exception e) {
            log.severe("Unable to create TIFF image.");
            return;
        }
        RenderedOp ri = JAI.create((String)"stream", (Object)stream);
        log.finest("image ground mbr=" + mbr[0] + "," + mbr[1] + " " + mbr[2] + "," + mbr[3]);
        Point2D.Double ul = new Point2D.Double();
        Point2D.Double lr = new Point2D.Double();
        AffineTransform mAT = vc.getAffineXF();
        if (mAT != null) {
            mAT.transform(new Point2D.Double(mbr[0], mbr[3]), ul);
            mAT.transform(new Point2D.Double(mbr[2], mbr[1]), lr);
        }
        if (ri != null) {
            int sx = (int)((Point2D)ul).getX();
            int sy = (int)((Point2D)ul).getY();
            int iw = ri.getWidth();
            int ih = ri.getHeight();
            log.finest("image width: " + iw + ", height:" + ih);
            log.finest("rendering image at: " + sx + ", " + sy);
            BufferedImage bimage = null;
            if (ri instanceof BufferedImage) {
                log.finer("Rendered Image is buffered image.");
                bimage = (BufferedImage)ri;
            } else {
                log.finer("Rendered Image is not buffered image.");
                if (ri instanceof PlanarImage) {
                    bimage = ((PlanarImage)ri).getAsBufferedImage();
                    log.finer("Planar Image converted to BufferedImage.");
                } else {
                    log.info("Unable to render this type of Java Image.");
                    return;
                }
            }
            if (bimage == null) {
                log.info("Unable to render null image.");
                return;
            }
            Composite cOld = null;
            if (alpha > 0.0f && alpha < 1.0f) {
                cOld = g2.getComposite();
                g2.setComposite(AlphaComposite.getInstance(3, alpha));
            }
            AffineTransform aft = g2.getTransform();
            Object hint = g2.getRenderingHint(RenderingHints.KEY_INTERPOLATION);
            if (hint == null) {
                hint = RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR;
            }
            try {
                boolean applyRotation = false;
                if (vc.getRotation() != 0.0 && !MapMaker.isSpecial(vc.getQueryWindow())) {
                    double rotation = -1.0 * vc.getRotation() * Math.PI / 180.0;
                    Point2D.Double center = new Point2D.Double();
                    mAT.transform(new Point2D.Double(vc.getQueryWindow().getCenterX(), vc.getQueryWindow().getCenterY()), center);
                    AffineTransform rot = AffineTransform.getRotateInstance(rotation, ((Point2D)center).getX(), ((Point2D)center).getY());
                    g2.setTransform(rot);
                    g2.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
                    applyRotation = true;
                }
                if (imgScaling) {
                    g2.drawImage(bimage, sx, sy, (int)(((Point2D)lr).getX() - ((Point2D)ul).getX() + 1.0), (int)(((Point2D)lr).getY() - ((Point2D)ul).getY() + 1.0), null);
                } else {
                    log.finest("Drawing image in original resolution.");
                    if (vc.getDeviceWindow().contains(10.0, ih - sy) || vc.getDeviceWindow().contains(iw - sx, 10.0)) {
                        g2.drawImage(bimage, sx, sy, iw + 1, ih + 1, null);
                    } else {
                        g2.drawImage((Image)bimage, sx, sy, null);
                    }
                }
                if (applyRotation) {
                    g2.setTransform(aft);
                    g2.setRenderingHint(RenderingHints.KEY_INTERPOLATION, hint);
                }
            }
            catch (Exception ex) {
                g2.setTransform(aft);
                g2.setRenderingHint(RenderingHints.KEY_INTERPOLATION, hint);
                log.severe(ex.getMessage());
            }
            finally {
                if (alpha > 0.0f && alpha < 1.0f) {
                    try {
                        g2.setComposite(cOld);
                    }
                    catch (Exception e) {}
                }
                bimage.flush();
                bimage = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void renderImage(Graphics2D g2, Image img, double[] mbr, float alpha, VisContext vc) {
        if (img == null) {
            log.finest("Image is null. Rendering aborted.");
            return;
        }
        if (mbr == null) {
            log.warning("Image MBR not defined. Rendering aborted.");
            return;
        }
        log.finest("Image ground mbr=" + mbr[0] + "," + mbr[1] + " " + mbr[2] + "," + mbr[3]);
        Point2D.Double ul = new Point2D.Double();
        Point2D.Double lr = new Point2D.Double();
        AffineTransform mAT = vc.getAffineXF();
        if (mAT != null) {
            mAT.transform(new Point2D.Double(mbr[0], mbr[3]), ul);
            mAT.transform(new Point2D.Double(mbr[2], mbr[1]), lr);
        }
        if (img != null) {
            int sx = (int)((Point2D)ul).getX();
            int sy = (int)((Point2D)ul).getY();
            int iw = img.getWidth(null);
            int ih = img.getHeight(null);
            log.finest("image width: " + iw + ", height:" + ih);
            log.finest("rendering image at: " + sx + ", " + sy);
            Composite cOld = null;
            if (alpha > 0.0f && alpha < 1.0f) {
                cOld = g2.getComposite();
                g2.setComposite(AlphaComposite.getInstance(3, alpha));
            }
            AffineTransform aft = g2.getTransform();
            Object hint = g2.getRenderingHint(RenderingHints.KEY_INTERPOLATION);
            if (hint == null) {
                hint = RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR;
            }
            try {
                boolean applyRotation = false;
                if (vc.getRotation() != 0.0 && !MapMaker.isSpecial(vc.getQueryWindow())) {
                    double rotation = -1.0 * vc.getRotation() * Math.PI / 180.0;
                    Point2D.Double center = new Point2D.Double();
                    mAT.transform(new Point2D.Double(vc.getQueryWindow().getCenterX(), vc.getQueryWindow().getCenterY()), center);
                    AffineTransform rot = AffineTransform.getRotateInstance(rotation, ((Point2D)center).getX(), ((Point2D)center).getY());
                    g2.setTransform(rot);
                    g2.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
                    applyRotation = true;
                }
                g2.drawImage(img, sx, sy, (int)(((Point2D)lr).getX() - ((Point2D)ul).getX() + 1.0), (int)(((Point2D)lr).getY() - ((Point2D)ul).getY() + 1.0), null);
                if (applyRotation) {
                    g2.setTransform(aft);
                    g2.setRenderingHint(RenderingHints.KEY_INTERPOLATION, hint);
                }
            }
            catch (Exception ex) {
                g2.setTransform(aft);
                g2.setRenderingHint(RenderingHints.KEY_INTERPOLATION, hint);
                log.severe(ex.getMessage());
            }
            finally {
                if (alpha > 0.0f && alpha < 1.0f) {
                    try {
                        g2.setComposite(cOld);
                    }
                    catch (Exception e) {}
                }
            }
        }
    }

    static {
        System.setProperty("com.sun.media.jai.disableMediaLib", "true");
    }
}

