/*
 * Decompiled with CFR 0.152.
 */
package oracle.sdovis;

import java.awt.Color;
import java.util.Vector;
import oracle.sdovis.CoordArray;
import oracle.sdovis.JSDOGeometry;
import oracle.sdovis.Proj;
import oracle.sdovis.SRS;
import oracle.sdovis.style.Style;
import oracle.sdovis.style.StyleColor;

public class Graticule {
    double clon;
    double clat;
    double spacing;
    double density = 1.0;
    Proj proj;
    JSDOGeometry bg;
    JSDOGeometry[] res;
    int srid;
    private static StyleColor style = new StyleColor(null, new Color(85, 85, 204, 140));

    public Graticule(Proj prj, double clon, double clat, double spacing, double density, int srid) {
        this.proj = prj;
        this.clon = clon;
        this.clat = clat;
        this.spacing = Math.abs(spacing);
        this.density = Math.abs(density);
        this.srid = srid;
        this.getGraticule();
    }

    public JSDOGeometry[] get() {
        return this.res;
    }

    private void project(JSDOGeometry[] meridians, JSDOGeometry[] parallels) {
        int i;
        int i2;
        JSDOGeometry[] m = new JSDOGeometry[meridians.length];
        JSDOGeometry[] p = new JSDOGeometry[parallels.length];
        for (i2 = 0; i2 < m.length; ++i2) {
            m[i2] = SRS.proj(meridians[i2], this.proj, this.srid);
        }
        for (i2 = 0; i2 < p.length; ++i2) {
            p[i2] = SRS.proj(parallels[i2], this.proj, this.srid);
        }
        int len = m.length + p.length;
        if (this.bg != null) {
            ++len;
        }
        this.res = new JSDOGeometry[len];
        for (i = 0; i < m.length; ++i) {
            this.res[i] = m[i];
        }
        for (i = 0; i < p.length; ++i) {
            this.res[i + m.length] = p[i];
        }
        if (this.bg != null) {
            this.res[len - 1] = this.bg;
        }
    }

    public static Style getStyle() {
        return style;
    }

    private void getGraticule() {
        double[] bgc;
        Vector<JSDOGeometry> vm = new Vector<JSDOGeometry>(60);
        double x = this.clon;
        vm.add(this.getMeridian(x));
        for (x = this.clon + this.spacing; x <= 360.0; x += this.spacing) {
            vm.add(this.getMeridian(x));
        }
        for (x = this.clon - this.spacing; x >= -360.0; x -= this.spacing) {
            vm.add(this.getMeridian(x));
        }
        Vector<JSDOGeometry> vp = new Vector<JSDOGeometry>(60);
        double y = this.clat;
        JSDOGeometry geom = this.getParallel(y);
        if (geom != null) {
            vp.add(geom);
        }
        for (y = this.clat + this.spacing; y < 90.0; y += this.spacing) {
            geom = this.getParallel(y);
            if (geom == null) continue;
            vp.add(geom);
        }
        geom = this.getParallel(90.0);
        if (geom != null) {
            vp.add(geom);
        }
        for (y = this.clat - this.spacing; y > -90.0; y -= this.spacing) {
            geom = this.getParallel(y);
            if (geom == null) continue;
            vp.add(geom);
        }
        geom = this.getParallel(-90.0);
        if (geom != null) {
            vp.add(geom);
        }
        if ((bgc = this.proj.getBoundingGeom()) != null) {
            this.bg = JSDOGeometry.recast(JSDOGeometry.createLinearLineString((double[])bgc, (int)2, (int)0));
        }
        JSDOGeometry[] meridians = vm.toArray(new JSDOGeometry[vm.size()]);
        JSDOGeometry[] parallels = vp.toArray(new JSDOGeometry[vp.size()]);
        this.project(meridians, parallels);
    }

    private JSDOGeometry getMeridian(double x) {
        CoordArray ca = new CoordArray(400);
        for (int i = 90; i >= -90; --i) {
            ca.add(x, i);
        }
        return JSDOGeometry.recast(JSDOGeometry.createLinearLineString((double[])ca.getAll(), (int)2, (int)0));
    }

    private JSDOGeometry getParallel(double y) {
        double[] pc = this.proj.getParallel(y, this.density);
        if (pc != null) {
            return JSDOGeometry.recast(JSDOGeometry.createLinearLineString((double[])pc, (int)2, (int)0));
        }
        return null;
    }
}

