/*
 * Decompiled with CFR 0.152.
 */
package oracle.sdovis;

public class CoordArray {
    int dim = 2;
    int count = 0;
    int capacity = 0;
    double[] coords = null;
    boolean sorted = false;

    public CoordArray(int initialCapacity) {
        this.ensure(initialCapacity);
    }

    public CoordArray(int dim, int initialCapacity) {
        this.dim = dim;
        this.ensure(initialCapacity);
    }

    public CoordArray(int dim, int initialCapacity, boolean sorted) {
        this.dim = dim;
        this.ensure(initialCapacity);
        this.sorted = sorted;
    }

    public void reset() {
        this.count = 0;
        this.sorted = false;
    }

    public int getNumCoords() {
        return this.count;
    }

    public int getCapacity() {
        return this.capacity;
    }

    public void close() {
        if (this.count == 0) {
            return;
        }
        this.add(this.coords[0], this.coords[1]);
    }

    public void remove(int pos) {
        System.arraycopy(this.coords, (pos + 1) * this.dim, this.coords, pos * this.dim, (this.count - 1 - pos) * this.dim);
        --this.count;
    }

    public int find(double x, double y) {
        for (int i = 0; i < this.count; ++i) {
            double _x = this.coords[i * this.dim];
            double _y = this.coords[i * this.dim + 1];
            if (x != _x || y != _y) continue;
            return i;
        }
        return -1;
    }

    public boolean getSorted() {
        return this.sorted;
    }

    public void setSorted(boolean v) {
        this.sorted = v;
    }

    public void add(double x, double y) {
        if (this.capacity <= this.count) {
            this.ensure((int)((double)this.capacity * 1.2));
        }
        this.coords[this.dim * this.count] = x;
        this.coords[this.dim * this.count + 1] = y;
        ++this.count;
    }

    public void addSortY(double x, double y) {
        double Y;
        int i = -1;
        while (++i < this.count && !((Y = this.coords[i * this.dim + 1]) > y)) {
        }
        this.addAt(x, y, i);
    }

    public void addAt(double x, double y, int pos) {
        if (this.capacity <= this.count) {
            this.ensure(this.capacity * 2);
        }
        int off = this.dim * pos;
        double tx = this.coords[off];
        double ty = this.coords[off + 1];
        this.coords[off] = x;
        this.coords[off + 1] = y;
        System.arraycopy(this.coords, (pos + 1) * this.dim, this.coords, (pos + 2) * this.dim, (this.count - pos) * this.dim);
        this.coords[(pos + 1) * this.dim] = tx;
        this.coords[(pos + 1) * this.dim + 1] = ty;
        ++this.count;
    }

    public void replaceAt(double x, double y, int pos) {
        this.coords[this.dim * pos] = x;
        this.coords[this.dim * pos + 1] = y;
    }

    public double getX(int pos) {
        return this.coords[pos * this.dim];
    }

    public double getY(int pos) {
        return this.coords[pos * this.dim + 1];
    }

    public double getLastX() {
        return this.coords[(this.count - 1) * this.dim];
    }

    public double getLastY() {
        return this.coords[(this.count - 1) * this.dim + 1];
    }

    public double[] getAll() {
        double[] res = new double[this.count * this.dim];
        System.arraycopy(this.coords, 0, res, 0, this.count * this.dim);
        return res;
    }

    public float[] getAllFloat() {
        float[] res = new float[this.count * this.dim];
        for (int i = 0; i < this.count * this.dim; ++i) {
            res[i] = (float)this.coords[i];
        }
        return res;
    }

    private void ensure(int newCapacity) {
        if (this.capacity >= newCapacity) {
            return;
        }
        double[] tmpCoords = new double[newCapacity * this.dim];
        if (this.coords != null && this.count > 0) {
            System.arraycopy(this.coords, 0, tmpCoords, 0, this.count * this.dim);
        }
        this.coords = tmpCoords;
        this.capacity = newCapacity;
    }
}

