/*
 * Decompiled with CFR 0.152.
 */
package oracle.sdovis;

import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Logger;
import oracle.mapviewer.share.util.LogFactory;
import oracle.sdovis.StyledFeatureI;
import oracle.sdovis.VisContext;
import oracle.sdovis.style.LineStyleModifiers;
import oracle.sdovis.style.Style;
import oracle.sdovis.style.StyleLine;

public class CasedLineHelper {
    private static Logger log = LogFactory.getLogger(LogFactory.LoggerEnum.SDOVIS);
    int initialSize = 250;
    ArrayList<String> zOrderedThemes = new ArrayList(10);
    HashMap<String, List> themes;
    List<c1> orphanFeatures;
    int size = 0;

    public CasedLineHelper(int sizeHint) {
        this.initialSize = sizeHint;
    }

    public void clear() {
        this.size = 0;
        this.zOrderedThemes = new ArrayList(10);
        if (this.orphanFeatures != null) {
            this.orphanFeatures.clear();
            this.orphanFeatures = null;
        }
        if (this.themes != null && this.themes.size() > 0) {
            Iterator<List> i = this.themes.values().iterator();
            while (i.hasNext()) {
                i.next().clear();
            }
            this.themes.clear();
            this.themes = null;
        }
    }

    public int size() {
        return this.size;
    }

    public void addStyledFeature(StyledFeatureI sf, Shape shp, Style sty) {
        ArrayList<c1> list;
        c1 c = new c1(sf, shp, sty);
        String theme = sf.getThemeName();
        if (theme == null) {
            if (this.orphanFeatures == null) {
                this.orphanFeatures = new ArrayList<c1>(this.initialSize);
            }
            this.orphanFeatures.add(c);
            ++this.size;
            return;
        }
        theme = theme.toUpperCase();
        if (this.themes == null) {
            this.themes = new HashMap(23);
        }
        if ((list = this.themes.get(theme)) == null) {
            if (!this.zOrderedThemes.contains(theme)) {
                this.zOrderedThemes.add(theme);
            }
            list = new ArrayList<c1>(this.initialSize);
            this.themes.put(theme, list);
        }
        list.add(c);
        ++this.size;
    }

    public void renderCasedLines(Graphics2D g2, VisContext vc) {
        boolean aa = vc.getAntialiasing();
        if (aa) {
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        } else {
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        }
        if (this.orphanFeatures != null) {
            log.finest("rendering cased lines: orphan featutres.");
            this.renderCasedLinesOfATheme(g2, vc, this.orphanFeatures);
        }
        for (int i = 0; i < this.zOrderedThemes.size(); ++i) {
            String theme = this.zOrderedThemes.get(i);
            List ar = this.themes.get(theme);
            log.finest("rendering cased lines for theme: " + theme);
            this.renderCasedLinesOfATheme(g2, vc, ar);
        }
    }

    public void renderCasedLinesOfATheme(Graphics2D g2, VisContext vc, List ar) {
        LineStyleModifiers linemods;
        StyleLine sty;
        Shape shp;
        StyledFeatureI sf;
        c1 o;
        int i;
        if (ar == null || ar.size() == 0) {
            return;
        }
        Hashtable<String, LineStyleModifiers> stymodifiers = new Hashtable<String, LineStyleModifiers>();
        for (i = 0; i < ar.size(); ++i) {
            o = (c1)ar.get(i);
            sf = o.sf;
            shp = o.shp;
            sty = (StyleLine)o.style;
            linemods = null;
            if (sty.getModel().getName() != null) {
                linemods = (LineStyleModifiers)stymodifiers.get(sty.getModel().getName().toUpperCase());
            }
            if (linemods == null) {
                linemods = (LineStyleModifiers)sty.convertToPixelSize(vc);
            }
            if (linemods != null && sty.getModel().getName() != null) {
                stymodifiers.put(sty.getModel().getName().toUpperCase(), linemods);
            }
            try {
                sty.casedFill1(vc, g2, shp, sf.getGeomType(), null, null, vc.getCRArray(), sf.getRenderableAttributes(), linemods);
                continue;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        for (i = 0; i < ar.size(); ++i) {
            o = (c1)ar.get(i);
            sf = o.sf;
            shp = o.shp;
            sty = (StyleLine)o.style;
            linemods = null;
            if (sty.getModel().getName() != null) {
                linemods = (LineStyleModifiers)stymodifiers.get(sty.getModel().getName().toUpperCase());
            }
            if (linemods == null) {
                linemods = (LineStyleModifiers)sty.convertToPixelSize(vc);
            }
            if (linemods != null && sty.getModel().getName() != null) {
                stymodifiers.put(sty.getModel().getName().toUpperCase(), linemods);
            }
            try {
                sty.casedFill2(vc, g2, shp, sf.getGeomType(), null, null, vc.getCRArray(), sf.getRenderableAttributes(), linemods);
                continue;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        for (i = 0; i < ar.size(); ++i) {
            o = (c1)ar.get(i);
            sf = o.sf;
            shp = o.shp;
            sty = (StyleLine)o.style;
            linemods = null;
            if (sty.getModel().getName() != null) {
                linemods = (LineStyleModifiers)stymodifiers.get(sty.getModel().getName().toUpperCase());
            }
            if (linemods == null) {
                linemods = (LineStyleModifiers)sty.convertToPixelSize(vc);
            }
            if (linemods != null && sty.getModel().getName() != null) {
                stymodifiers.put(sty.getModel().getName().toUpperCase(), linemods);
            }
            try {
                sty.casedFill3(vc, g2, shp, sf.getGeomType(), null, null, vc.getCRArray(), sf.getRenderableAttributes(), linemods);
                continue;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
    }

    public static class c1 {
        public Shape shp;
        public StyledFeatureI sf;
        public Style style;

        public c1(StyledFeatureI _sf, Shape _shp, Style _sty) {
            this.sf = _sf;
            this.shp = _shp;
            this.style = _sty;
        }
    }
}

