/*
 * Decompiled with CFR 0.152.
 */
package oracle.sdovis;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.mapviewer.share.util.LogFactory;
import oracle.sdovis.cache.CacheGroup;
import oracle.sdovis.cache.SubRegion;

public class CacheMgr2 {
    private static Logger log = LogFactory.getLogger(LogFactory.LoggerEnum.SDOVIS);
    static final String ROOT_REGION = "SDOVIS_DATA";
    static long MAX_CACHE_SIZE = 0x2000000L;
    static int MAX_OBJECTS = 80000000;
    static int REFRESH_INTERVAL = 40;
    private static boolean initialized = false;
    private static boolean enabled = true;
    static boolean _poll_statistics = false;
    static PollerThread pollerThread = null;
    private static int count = 0;
    private static long currentCacheSize = 0L;
    static Hashtable subRegions = null;

    public static boolean isReady() {
        return initialized && enabled;
    }

    public static void setMaxCacheSize(int mb) {
        MAX_CACHE_SIZE = mb * 1024 * 1024;
        if (mb <= 0) {
            enabled = false;
            log.warning("In memory cache will be disabled.");
        } else {
            enabled = true;
            log.info("In memory cache limit set to: " + mb + "MB");
        }
    }

    public static long getMaxCacheSize() {
        return MAX_CACHE_SIZE;
    }

    public static void setMaxObjects(int num) {
        MAX_OBJECTS = num;
    }

    public static int getMaxObjects() {
        return MAX_OBJECTS;
    }

    public static void setReportStats(boolean v) {
        _poll_statistics = v;
    }

    public static synchronized void init() {
        if (initialized) {
            return;
        }
        try {
            subRegions = new Hashtable(11, 0.95f);
            count = 0;
            currentCacheSize = 0L;
            initialized = true;
            log.info("Spatial Data Cache opened. Region=SDOVIS_DATA.");
            log.info("\tmax_cache_size=" + MAX_CACHE_SIZE / 1024L / 1024L + " MB.");
            if (_poll_statistics) {
                CacheMgr2.startStatsPoller();
            }
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "Error initializing cache manager.", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void destroy() {
        if (pollerThread != null) {
            pollerThread.stopMe();
        }
        pollerThread = null;
        if (!initialized || !enabled) {
            return;
        }
        try {
            Enumeration enumer = subRegions.elements();
            while (enumer.hasMoreElements()) {
                SubRegion sr = (SubRegion)enumer.nextElement();
                sr.clear();
            }
            subRegions.clear();
        }
        catch (Exception ex) {
            log.severe(ex.getMessage());
        }
        finally {
            initialized = false;
        }
    }

    public static boolean hasRoom(int size) {
        return currentCacheSize + (long)size < MAX_CACHE_SIZE;
    }

    public static void increaseSize(long size) {
        currentCacheSize += size;
    }

    public static void decreaseSize(long size) {
        currentCacheSize -= size;
    }

    public static long getCurrentSize() {
        return currentCacheSize;
    }

    public static String getSubRegionName(Connection conn) {
        try {
            DatabaseMetaData md = conn.getMetaData();
            String user = md.getUserName();
            String url = md.getURL();
            return CacheMgr2.getSubRegionName(user, url);
        }
        catch (Exception ex) {
            log.severe(ex.getMessage());
            return null;
        }
    }

    public static String getSubRegionName(String user, String url) {
        return "sdovis_subreg_" + (user != null ? user.toLowerCase() : "default") + "_" + (url != null ? url : "url");
    }

    public static synchronized String createSubRegion(Connection conn) {
        try {
            DatabaseMetaData md = conn.getMetaData();
            String user = md.getUserName();
            String url = md.getURL();
            return CacheMgr2.createSubRegion(user, url);
        }
        catch (Exception ex) {
            log.severe(ex.getMessage());
            return null;
        }
    }

    public static synchronized String createSubRegion(String user, String url) {
        if (!initialized || !enabled) {
            return null;
        }
        String subRegionName = CacheMgr2.getSubRegionName(user, url);
        if (CacheMgr2.subRegionExists(subRegionName)) {
            return subRegionName;
        }
        SubRegion sr = new SubRegion(subRegionName);
        subRegions.put(subRegionName, sr);
        log.info("sub region " + subRegionName + " created in cache.");
        return subRegionName;
    }

    public static synchronized String createSubRegion(String subRegionName) {
        if (!initialized || !enabled || subRegionName == null) {
            return null;
        }
        if (CacheMgr2.subRegionExists(subRegionName)) {
            return subRegionName;
        }
        SubRegion sr = new SubRegion(subRegionName);
        subRegions.put(subRegionName, sr);
        log.info("sub region " + subRegionName + " created in cache.");
        return subRegionName;
    }

    public static synchronized boolean subRegionExists(String sr) {
        if (!initialized || !enabled) {
            return false;
        }
        return subRegions.containsKey(sr);
    }

    public static synchronized SubRegion getSubRegion(String sr) {
        return (SubRegion)subRegions.get(sr);
    }

    public static synchronized boolean groupExists(String subRegion, String gr) {
        if (!initialized || !enabled) {
            return false;
        }
        SubRegion sr = CacheMgr2.getSubRegion(subRegion);
        if (sr == null) {
            return false;
        }
        return sr.groupExists(gr);
    }

    public static synchronized CacheGroup getGroup(String subRegion, String gr) {
        if (!initialized || !enabled) {
            return null;
        }
        SubRegion sr = CacheMgr2.getSubRegion(subRegion);
        if (sr == null) {
            return null;
        }
        return sr.getGroup(gr);
    }

    public static synchronized void removeGroup(String subRegion, String gr) {
        if (!initialized || !enabled) {
            return;
        }
        SubRegion sr = CacheMgr2.getSubRegion(subRegion);
        if (sr == null) {
            return;
        }
        sr.removeGroup(gr);
    }

    public static void createGeomGroup(String subRegion, String group, int initialCapacity, boolean pinned) {
        CacheGroup cg;
        if (!initialized || !enabled) {
            return;
        }
        if (CacheMgr2.groupExists(subRegion, group) && (cg = CacheMgr2.getSubRegion(subRegion).getGroup(group)).isPinned() == pinned) {
            return;
        }
        log.info("Creating/replacing a geometry cache group: " + subRegion + " : " + group + ".");
        try {
            SubRegion sr = CacheMgr2.getSubRegion(subRegion);
            if (sr == null) {
                throw new Exception("cannot find the specified subregion: " + subRegion);
            }
            sr.createNewGroup(group, initialCapacity, pinned);
        }
        catch (Exception ce) {
            log.severe(ce.getMessage());
        }
    }

    public static void createImageGroup(String subRegion, String group) {
        if (!initialized || !enabled) {
            return;
        }
        if (CacheMgr2.groupExists(subRegion, group)) {
            return;
        }
        log.info("creating an image cache group: " + subRegion + " : " + group + ".");
        try {
            SubRegion sr = CacheMgr2.getSubRegion(subRegion);
            sr.createNewGroup(group, 0, false);
        }
        catch (Exception ce) {
            log.severe(ce.getMessage());
        }
    }

    public static void createGeoRasterGroup(String subRegion, String group) {
        if (!initialized || !enabled) {
            return;
        }
        if (CacheMgr2.groupExists(subRegion, group)) {
            return;
        }
        log.info("creating an image cache group: " + subRegion + " : " + group + ".");
        try {
            SubRegion sr = CacheMgr2.getSubRegion(subRegion);
            sr.createNewGroup(group, 0, false);
        }
        catch (Exception ce) {
            log.severe(ce.getMessage());
        }
    }

    public static void createImageURLGroup(String subRegion, String group) {
        if (!initialized || !enabled) {
            return;
        }
        if (CacheMgr2.groupExists(subRegion, group)) {
            return;
        }
        log.info("creating an image URL cache group: " + subRegion + " : " + group + ".");
        try {
            SubRegion sr = CacheMgr2.getSubRegion(subRegion);
            sr.createNewGroup(group, 0, false);
        }
        catch (Exception ce) {
            log.severe(ce.getMessage());
        }
    }

    public static void createGroup(String subRegion, String group) {
        if (!initialized || !enabled) {
            return;
        }
        if (CacheMgr2.groupExists(subRegion, group)) {
            return;
        }
        log.info("creating a cache group: " + subRegion + " : " + group + ".");
        try {
            SubRegion sr = CacheMgr2.getSubRegion(subRegion);
            if (sr == null) {
                throw new Exception("cannot find the specified subregion: " + subRegion);
            }
            sr.createNewGroup(group, 0, false);
        }
        catch (Exception ce) {
            log.severe(ce.getMessage());
        }
    }

    public static synchronized Object getWFSCapabilities(String name, String subRegion, String group) {
        if (!initialized) {
            return null;
        }
        if (!enabled) {
            return null;
        }
        try {
            CacheGroup cg = CacheMgr2.getGroup(subRegion, group);
            return cg.get(name);
        }
        catch (Exception oe) {
            log.warning("cannot get object using WFS cache loader.");
            return null;
        }
    }

    public static synchronized void put(String subRegion, String group, Object key, Object obj, long size) {
        try {
            CacheGroup cg = CacheMgr2.getGroup(subRegion, group);
            if (cg == null) {
                return;
            }
            cg.put(key, obj, size);
        }
        catch (Exception e) {
            log.severe(e.getMessage());
        }
    }

    public static synchronized Object getGeometry(String name, Object arg, String subRegion, String group) {
        if (!initialized) {
            return null;
        }
        if (!enabled) {
            return null;
        }
        try {
            CacheGroup cg = CacheMgr2.getGroup(subRegion, group);
            return cg.get(name);
        }
        catch (Exception oe) {
            log.warning("cannot get object using geom cache loader.");
            return null;
        }
    }

    public static synchronized Object getImage(String name, Object arg, String subRegion, String group) {
        if (!initialized) {
            return null;
        }
        if (!enabled) {
            return null;
        }
        try {
            CacheGroup cg = CacheMgr2.getGroup(subRegion, group);
            return cg.get(name);
        }
        catch (Exception oe) {
            log.warning("cannot get image from cache.");
            return null;
        }
    }

    public static synchronized Object getGeoRasterBlock(String name, Object arg, String subRegion, String group) {
        if (!initialized) {
            return null;
        }
        if (!enabled) {
            return null;
        }
        try {
            CacheGroup cg = CacheMgr2.getGroup(subRegion, group);
            return cg.get(name);
        }
        catch (Exception oe) {
            log.warning("cannot load image using cache loader.");
            return null;
        }
    }

    public static void invalidate(String subRegion) {
        if (!initialized || !enabled) {
            return;
        }
        try {
            SubRegion sr = CacheMgr2.getSubRegion(subRegion);
            sr.clear();
            log.info("Invalidated subregion " + subRegion);
        }
        catch (Exception ce) {
            log.severe(ce.getMessage());
        }
    }

    public static void invalidate(String subRegion, String group) {
        if (!initialized || !enabled) {
            return;
        }
        try {
            CacheGroup cg = CacheMgr2.getGroup(subRegion, group);
            cg.clear();
            log.info("Invalidated group " + group + " in subregion " + subRegion);
        }
        catch (Exception ce) {
            log.severe(ce.getMessage());
        }
    }

    public static void invalidate() {
        if (!initialized || !enabled) {
            return;
        }
        try {
            Enumeration enumer = subRegions.elements();
            while (enumer.hasMoreElements()) {
                SubRegion sr = (SubRegion)enumer.nextElement();
                sr.invalidate();
            }
            currentCacheSize = 0L;
        }
        catch (Exception ex) {
            log.severe(ex.getMessage());
        }
    }

    public static String collectStatistics() {
        if (!initialized || !enabled) {
            return "Cache Info: cache not initialized or enabled.";
        }
        try {
            StringBuffer s = new StringBuffer("\nMapViewer Spatial Data Cache info (upper limit=" + MAX_CACHE_SIZE / 1024L + "kb):\n" + "\tIn Memory Cache Size:     " + currentCacheSize / 1024L + " kb\n");
            Enumeration enumer = subRegions.elements();
            while (enumer.hasMoreElements()) {
                SubRegion sr = (SubRegion)enumer.nextElement();
                s.append(sr.report(1));
            }
            return s.toString();
        }
        catch (Exception e) {
            log.severe(e.getMessage());
            return e.getMessage();
        }
    }

    private static void startStatsPoller() {
        if (pollerThread != null && !pollerThread.getStop()) {
            pollerThread.stopMe();
        }
        pollerThread = new PollerThread();
        pollerThread.start();
    }

    static class PollerThread
    extends Thread {
        boolean stop = false;

        PollerThread() {
        }

        public void stopMe() {
            this.stop = true;
        }

        public boolean getStop() {
            return this.stop;
        }

        @Override
        public void run() {
            long t0 = System.currentTimeMillis();
            while (!this.stop) {
                long t1 = System.currentTimeMillis();
                if (t1 - t0 < 300000L) {
                    try {
                        Thread.sleep(300000L);
                    }
                    catch (Exception e) {}
                    continue;
                }
                t0 = t1;
                log.info(CacheMgr2.collectStatistics());
            }
        }
    }
}

