/*
 * Decompiled with CFR 0.152.
 */
package oracle.sdovis;

import java.util.logging.Logger;
import oracle.mapviewer.share.util.LogFactory;
import oracle.sdovis.BaseMap;
import oracle.sdovis.DBMapMaker;
import oracle.sdovis.SRS;
import oracle.sdovis.SRSCache;
import oracle.sdovis.Theme;
import oracle.sdovis.VisContext;
import oracle.sdovis.ds.DSManager;

public class BaseMap2
extends BaseMap {
    private static final Logger log = LogFactory.getLogger(LogFactory.LoggerEnum.SDOVIS);
    protected ZoomLevel[] zoomLevels;

    public void setZoomLevels(ZoomLevel[] zoomLevels) {
        this.zoomLevels = zoomLevels;
    }

    public ZoomLevel[] getZoomLevels() {
        return this.zoomLevels;
    }

    @Override
    public int addMapToMapMaker(DBMapMaker mm) {
        if (this.zoomLevels == null) {
            return 0;
        }
        ZoomLevel z = this.determineZoomLevel(mm.getVisContext());
        if (z == null) {
            return 0;
        }
        BaseMap.PredefinedThemeDesc[] themes = z.themes;
        int count = 0;
        for (int i = 0; i < themes.length; ++i) {
            try {
                BaseMap2.addPredefinedTheme(mm, themes[i], i);
                ++count;
                continue;
            }
            catch (Exception e) {
                e.printStackTrace(System.err);
            }
        }
        return count;
    }

    private static void addPredefinedTheme(DBMapMaker mm, BaseMap.PredefinedThemeDesc td, int idx) throws Exception {
        Theme th = mm.addPredefinedTheme(td.name, mm.getVisContext().getMasterDataSourceName(), idx, td.mods, null, null);
    }

    private ZoomLevel determineZoomLevel(VisContext vc) {
        double scale = vc.getCurrentScale();
        SRSCache sc = DSManager.getSRSCache(vc.getMasterDataSourceName());
        double gap = Double.POSITIVE_INFINITY;
        int zidx = -1;
        for (int i = 0; i < this.zoomLevels.length; ++i) {
            ZoomLevel z = this.zoomLevels[i];
            int srid = z.srid;
            double z_scale = z.scale;
            SRS srs = sc.get(srid);
            double z_native_scale = srs.getScreenInchScale(z_scale, null);
            double z_gap = Math.abs(z_native_scale - scale);
            if (!(z_gap < gap)) continue;
            gap = z_gap;
            zidx = i;
        }
        log.finest("for current scale: " + scale + ", best zoom level is: " + zidx);
        return zidx < 0 ? null : this.zoomLevels[zidx];
    }

    public static class ZoomLevel {
        public int id;
        public int srid;
        public double scale;
        public BaseMap.PredefinedThemeDesc[] themes;
    }
}

