/*
 * Decompiled with CFR 0.152.
 */
package oracle.sdovis;

import java.text.NumberFormat;
import java.util.Hashtable;
import oracle.mapviewer.share.theme.ThemeDecorator;
import oracle.sdovis.DBMapMaker;
import oracle.sdovis.Theme;

public class BaseMap {
    protected String name;
    protected double initX;
    protected double initY;
    protected String description;
    protected boolean keepThemesOrder = false;
    protected PredefinedThemeDesc[] themes;
    protected Hashtable customTags = new Hashtable();

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void setInitX(double initX) {
        this.initX = initX;
    }

    public double getInitX() {
        return this.initX;
    }

    public void setInitY(double initY) {
        this.initY = initY;
    }

    public double getInitY() {
        return this.initY;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public void setThemes(PredefinedThemeDesc[] themes) {
        this.themes = themes;
    }

    public PredefinedThemeDesc[] getThemes() {
        return this.themes;
    }

    public String[] getThemeNames() {
        if (this.themes == null || this.themes.length == 0) {
            return null;
        }
        String[] thNames = new String[this.themes.length];
        for (int i = 0; i < this.themes.length; ++i) {
            thNames[i] = this.themes[i].name;
        }
        return thNames;
    }

    public int addMapToMapMaker(DBMapMaker mm) {
        if (this.themes == null) {
            return 0;
        }
        int count = 0;
        for (int i = 0; i < this.themes.length; ++i) {
            try {
                Theme th = BaseMap.addPredefinedTheme(mm, this.themes[i], count);
                if (th == null) continue;
                ++count;
                continue;
            }
            catch (Exception e) {
                e.printStackTrace(System.err);
            }
        }
        if (this.keepThemesOrder) {
            mm.getVisContext().setKeepThemesOrder(true);
        }
        return count;
    }

    public int addMapToMapMaker(DBMapMaker mm, String childlayer) {
        if (this.themes == null) {
            return 0;
        }
        String[] strSubset = null;
        if (childlayer != null && childlayer.length() > 0) {
            strSubset = childlayer.split(",");
        }
        int count = 0;
        block4: for (int i = 0; i < this.themes.length; ++i) {
            if (strSubset != null && strSubset.length > 0) {
                boolean found = false;
                for (int k = 0; k < strSubset.length; ++k) {
                    if (!strSubset[k].trim().equalsIgnoreCase(this.themes[i].getName())) continue;
                    try {
                        Theme th = BaseMap.addPredefinedTheme(mm, this.themes[i], count);
                        if (th == null) continue block4;
                        ++count;
                    }
                    catch (Exception e) {
                        e.printStackTrace(System.err);
                    }
                    continue block4;
                }
                continue;
            }
            try {
                Theme th = BaseMap.addPredefinedTheme(mm, this.themes[i], count);
                if (th == null) continue;
                ++count;
                continue;
            }
            catch (Exception e) {
                e.printStackTrace(System.err);
            }
        }
        if (this.keepThemesOrder) {
            mm.getVisContext().setKeepThemesOrder(true);
        }
        return count;
    }

    private static Theme addPredefinedTheme(DBMapMaker mm, PredefinedThemeDesc td, int idx) throws Exception {
        return mm.addPredefinedTheme(td.name, mm.getVisContext().getMasterDataSourceName(), idx, td.mods, null, null);
    }

    public Hashtable getCustomTags() {
        return this.customTags;
    }

    public void setCustomTags(Hashtable tags) {
        this.customTags = tags == null ? new Hashtable() : tags;
    }

    public String getCustomTag(String tag) {
        if (tag == null || this.customTags.size() == 0) {
            return null;
        }
        return (String)this.customTags.get(tag);
    }

    public void addCustomTag(String tag, String value) {
        if (tag == null || value == null) {
            return;
        }
        this.customTags.put(tag, value);
    }

    public void removeCustomTag(String tag) {
        if (tag == null) {
            return;
        }
        this.customTags.remove(tag);
    }

    public int getNumberOfCustomtags() {
        return this.customTags.size();
    }

    public void clearCustomTags() {
        this.customTags.clear();
    }

    public boolean getKeepThemesOrder() {
        return this.keepThemesOrder;
    }

    public void setKeepThemesOrder(boolean keep) {
        this.keepThemesOrder = keep;
    }

    public static final class PredefinedThemeDesc {
        public String name = null;
        public ThemeDecorator mods = new ThemeDecorator();

        public String getName() {
            return this.name;
        }

        public void setName(String nm) {
            this.name = nm;
        }

        public double getMinRenderScale() {
            if (this.mods == null) {
                return Double.POSITIVE_INFINITY;
            }
            return this.mods.getMinScale();
        }

        public void setMinRenderScale(double value) {
            if (this.mods != null) {
                this.mods.setMinScale(value);
            }
        }

        public String getMinRenderScaleAsString() {
            if (this.mods == null) {
                return "";
            }
            if (Double.isInfinite(this.mods.getMinScale())) {
                return "";
            }
            NumberFormat nf = NumberFormat.getInstance();
            nf.setMaximumFractionDigits(6);
            return nf.format(this.mods.getMinScale());
        }

        public void setMinRenderScaleAsString(String value) {
            if (this.mods != null) {
                NumberFormat nf = NumberFormat.getInstance();
                nf.setMaximumFractionDigits(6);
                try {
                    this.mods.setMinScale(nf.parse(value).doubleValue());
                }
                catch (Exception e) {
                    this.mods.setMinScale(Double.POSITIVE_INFINITY);
                }
            }
        }

        public double getMaxRenderScale() {
            if (this.mods == null) {
                return Double.NEGATIVE_INFINITY;
            }
            return this.mods.getMaxScale();
        }

        public void setMaxRenderScale(double value) {
            if (this.mods != null) {
                this.mods.setMaxScale(value);
            }
        }

        public String getMaxRenderScaleAsString() {
            if (this.mods == null) {
                return "";
            }
            if (Double.isInfinite(this.mods.getMaxScale())) {
                return "";
            }
            NumberFormat nf = NumberFormat.getInstance();
            nf.setMaximumFractionDigits(6);
            return nf.format(this.mods.getMaxScale());
        }

        public void setMaxRenderScaleAsString(String value) {
            if (this.mods != null) {
                NumberFormat nf = NumberFormat.getInstance();
                nf.setMaximumFractionDigits(6);
                try {
                    this.mods.setMaxScale(nf.parse(value).doubleValue());
                }
                catch (Exception e) {
                    this.mods.setMaxScale(Double.NEGATIVE_INFINITY);
                }
            }
        }

        public String getScaleType() {
            if (this.mods != null) {
                return this.mods.getScaleType();
            }
            return "RATIO";
        }

        public void setScaleType(String type) {
            if (this.mods != null) {
                if (type == null) {
                    this.mods.setScaleType("RATIO");
                } else {
                    this.mods.setScaleType(type);
                }
            }
        }
    }
}

