/*
 * Decompiled with CFR 0.152.
 */
package oracle.mapviewer.share.util;

import oracle.dms.instrument.Event;
import oracle.dms.instrument.Noun;
import oracle.dms.instrument.PhaseEvent;
import oracle.dms.instrument.State;

public class SensorCreator {
    public static Noun Base = Noun.create((String)"/sensorBase");

    public static PhaseEvent createPhaseEvent(NounsEnum type, String nounName, String sensorName, String sensorDescription) {
        Noun rootNoun = SensorCreator.getNoun(type, nounName);
        PhaseEvent newSensor = PhaseEvent.create((Noun)rootNoun, (String)sensorName, (String)sensorDescription);
        newSensor.deriveMetric(511);
        return newSensor;
    }

    public static Event createEvent(NounsEnum type, String nounName, String sensorName, String sensorDescription) {
        Noun rootNoun = SensorCreator.getNoun(type, nounName);
        Event newSensor = Event.create((Noun)rootNoun, (String)sensorName, (String)sensorDescription);
        return newSensor;
    }

    public static State createState(NounsEnum type, String nounName, String sensorName, byte valueType, String units, String sensorDescription) {
        Noun rootNoun = SensorCreator.getNoun(type, nounName);
        State newSensor = State.create((Noun)rootNoun, (String)sensorName, (byte)valueType, (String)units, (String)sensorDescription);
        newSensor.deriveMetric(511);
        return newSensor;
    }

    private static Noun getNoun(NounsEnum type, String name) {
        if (type == NounsEnum.TILE) {
            return Noun.create((Noun)Base, (String)name, (String)"MAPS_TileServer");
        }
        if (type == NounsEnum.MAPDATASERVER) {
            return Noun.create((Noun)Base, (String)name, (String)"MAPS_MapDataServer");
        }
        if (type == NounsEnum.MAPMAKER) {
            return Noun.create((Noun)Base, (String)name, (String)"MAPS_MapMaker");
        }
        if (type == NounsEnum.THEMEPRODUCER) {
            return Noun.create((Noun)Base, (String)name, (String)"MAPS_ThemeProducer");
        }
        if (type == NounsEnum.FOISERVER) {
            return Noun.create((Noun)Base, (String)name, (String)"MAPS_FOIServer");
        }
        if (type == NounsEnum.TEST) {
            return Noun.create((Noun)Base, (String)name, (String)"MAPS_TEST");
        }
        return Noun.create((Noun)Base, (String)name, (String)"MAPS_Default");
    }

    public static enum NounsEnum {
        TILE,
        MAPDATASERVER,
        MAPMAKER,
        THEMEPRODUCER,
        FOISERVER,
        TEST;

    }
}

