/*
 * Decompiled with CFR 0.152.
 */
package oracle.mapviewer.share.stylex;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import oracle.mapviewer.share.Field;
import oracle.mapviewer.share.XMLUtil;
import oracle.mapviewer.share.stylex.Bucket;
import oracle.mapviewer.share.stylex.CollectionBucket;
import oracle.mapviewer.share.stylex.RangedBucket;

public class BucketSeries
implements Cloneable,
Serializable {
    static final long serialVersionUID = -7483215977788946390L;
    public static final int SCHEME_CUSTOM = 1;
    public static final int SCHEME_EQUAL_INTERVAL = 2;
    public static final int SCHEME_NATURAL_BREAKS = 3;
    public static final int SCHEME_QUANTILE = 4;
    public final int SCHEME_STANDARD_DEVIATION = 5;
    ArrayList buckets = new ArrayList();
    int scheme = 1;
    String defaultRenderStyleName;
    String defaultLabelStyleName;
    transient Object defaultRenderStyle;
    transient Object defaultLabelStyle;

    public Object clone() {
        try {
            BucketSeries obj = (BucketSeries)super.clone();
            if (this.buckets != null && this.buckets.size() > 0) {
                obj.buckets = new ArrayList();
                for (int i = 0; i < this.buckets.size(); ++i) {
                    Bucket bkt = (Bucket)this.buckets.get(i);
                    obj.buckets.add(bkt.clone());
                }
            }
            return obj;
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError(e.toString());
        }
    }

    public void setBuckets(ArrayList buckets) {
        this.buckets = buckets;
    }

    public ArrayList getBuckets() {
        return this.buckets;
    }

    public void setScheme(int scheme) {
        this.scheme = scheme;
    }

    public int getScheme() {
        return this.scheme;
    }

    public void add(Bucket o) {
        if (o == null) {
            return;
        }
        this.buckets.add(o);
        this.setLastBucket();
    }

    public void remove(Bucket o) {
        if (o == null) {
            return;
        }
        this.buckets.remove(o);
        this.setLastBucket();
    }

    public void removeAll() {
        this.buckets.clear();
    }

    public int size() {
        return this.buckets.size();
    }

    public Bucket getBucketById(String bucketId) {
        if (this.buckets == null || this.buckets.size() == 0) {
            return null;
        }
        for (int i = 0; i < this.buckets.size(); ++i) {
            Bucket object = (Bucket)this.buckets.get(i);
            if (!object.getBucketId().equalsIgnoreCase(bucketId)) continue;
            return object;
        }
        return null;
    }

    public Bucket getBucket(Field v) {
        if (this.buckets == null || this.buckets.size() == 0) {
            return null;
        }
        Bucket defBkt = null;
        for (int i = 0; i < this.buckets.size(); ++i) {
            Bucket object = (Bucket)this.buckets.get(i);
            if (object.isDefaultBucket()) {
                defBkt = object;
            }
            if (v == null || !object.contains(v)) continue;
            return object;
        }
        return defBkt;
    }

    public int getBucketIndex(Field v) {
        if (this.buckets == null || this.buckets.size() == 0) {
            return -1;
        }
        int defBktIdx = -1;
        for (int i = 0; i < this.buckets.size(); ++i) {
            Bucket object = (Bucket)this.buckets.get(i);
            if (object.isDefaultBucket()) {
                defBktIdx = i;
            }
            if (v == null || !object.contains(v)) continue;
            return i;
        }
        return defBktIdx;
    }

    public Bucket getBucket(int index) {
        return (Bucket)this.buckets.get(index);
    }

    public void setDefaultRenderStyleName(String defaultRenderStyleName) {
        this.defaultRenderStyleName = defaultRenderStyleName;
    }

    public String getDefaultRenderStyleName() {
        return this.defaultRenderStyleName;
    }

    public void setDefaultLabelStyleName(String defaultLabelStyleName) {
        this.defaultLabelStyleName = defaultLabelStyleName;
    }

    public String getDefaultLabelStyleName() {
        return this.defaultLabelStyleName;
    }

    public void setDefaultRenderStyle(Object defaultRenderStyle) {
        this.defaultRenderStyle = defaultRenderStyle;
    }

    public Object getDefaultRenderStyle() {
        return this.defaultRenderStyle;
    }

    public void setDefaultLabelStyle(Object defaultLabelStyle) {
        this.defaultLabelStyle = defaultLabelStyle;
    }

    public Object getDefaultLabelStyle() {
        return this.defaultLabelStyle;
    }

    public String toXMLString() {
        StringBuffer xmlDef = new StringBuffer(1024);
        switch (this.scheme) {
            case 2: {
                xmlDef.append("    <Buckets ");
                int size = this.buckets.size();
                RangedBucket lowbucket = (RangedBucket)this.buckets.get(0);
                RangedBucket highbucket = (RangedBucket)this.buckets.get(size - 1);
                Field low = lowbucket.getLowerBoundValue();
                Field high = highbucket.getUpperBoundValue();
                xmlDef.append("low=\"").append(low.toString()).append("\" high=\"").append(high.toString()).append("\"");
                xmlDef.append(" nbuckets=\"").append(size).append("\"");
                boolean hasstyles = false;
                int idxstyle = 0;
                for (int i = 0; i < size; ++i) {
                    if (((Bucket)this.buckets.get(i)).getRenderStyleName() == null) continue;
                    hasstyles = true;
                    idxstyle = i;
                    break;
                }
                if (hasstyles) {
                    String renderStyle = ((Bucket)this.buckets.get(idxstyle)).getRenderStyleName();
                    xmlDef.append(" styles=\"").append(XMLUtil.replaceXMLEntities(renderStyle));
                    for (int i = idxstyle + 1; i < this.buckets.size(); ++i) {
                        if (((Bucket)this.buckets.get(i)).getRenderStyleName() == null) continue;
                        String rdstyle = ((Bucket)this.buckets.get(i)).getRenderStyleName();
                        xmlDef.append(",").append(XMLUtil.replaceXMLEntities(rdstyle));
                    }
                    xmlDef.append("\"");
                }
                boolean haslabels = false;
                int idxlabel = 0;
                for (int i = 0; i < this.buckets.size(); ++i) {
                    if (((Bucket)this.buckets.get(i)).getLabelStyleName() == null) continue;
                    haslabels = true;
                    idxlabel = i;
                    break;
                }
                if (haslabels) {
                    String labelStyle = ((Bucket)this.buckets.get(idxlabel)).getLabelStyleName();
                    xmlDef.append(" label_styles=\"").append(XMLUtil.replaceXMLEntities(labelStyle));
                    for (int i = idxlabel + 1; i < this.buckets.size(); ++i) {
                        if (((Bucket)this.buckets.get(i)).getLabelStyleName() == null) continue;
                        String lbStyle = ((Bucket)this.buckets.get(i)).getLabelStyleName();
                        xmlDef.append(",").append(XMLUtil.replaceXMLEntities(lbStyle));
                    }
                    xmlDef.append("\"");
                }
                if (this.defaultRenderStyleName != null) {
                    xmlDef.append(" default_style=\"").append(XMLUtil.replaceXMLEntities(this.defaultRenderStyleName)).append("\"");
                }
                if (this.defaultLabelStyleName != null) {
                    xmlDef.append(" default_label_style=\"").append(XMLUtil.replaceXMLEntities(this.defaultLabelStyleName)).append("\"");
                }
                xmlDef.append("/>");
                return xmlDef.toString();
            }
            case 1: {
                if (this.buckets.size() == 0) {
                    return "";
                }
                Bucket bkt = (Bucket)this.buckets.get(0);
                if (bkt instanceof RangedBucket) {
                    return this.getRangedBucketsXml(xmlDef);
                }
                if (bkt instanceof CollectionBucket) {
                    return this.getCollectionBucketsXml(xmlDef);
                }
                return "Unknown bucket type.";
            }
        }
        return "Unsupported bucket classification scheme.";
    }

    private String getRangedBucketsXml(StringBuffer xmlDef) {
        xmlDef.append("    <Buckets");
        if (this.defaultRenderStyleName != null) {
            xmlDef.append(" default_style=\"").append(XMLUtil.replaceXMLEntities(this.defaultRenderStyleName)).append("\"");
        }
        if (this.defaultLabelStyleName != null) {
            xmlDef.append(" default_label_style=\"").append(XMLUtil.replaceXMLEntities(this.defaultLabelStyleName)).append("\"");
        }
        xmlDef.append(">\n");
        for (int i = 0; i < this.buckets.size(); ++i) {
            Field highv;
            Field lowv;
            xmlDef.append("      <RangedBucket seq=\"").append(i).append("\"");
            RangedBucket rb = (RangedBucket)this.buckets.get(i);
            if (rb.getBucketLabel() != null) {
                xmlDef.append(" label=\"").append(XMLUtil.replaceXMLEntities(rb.getBucketLabel())).append("\"");
            }
            if ((lowv = rb.getLowerBoundValue()) != null) {
                xmlDef.append(" low=\"").append(lowv.toString()).append("\"");
            }
            if ((highv = rb.getUpperBoundValue()) != null) {
                xmlDef.append(" high=\"").append(highv.toString()).append("\"");
            }
            if (rb.getRenderStyleName() != null) {
                xmlDef.append(" style=\"").append(XMLUtil.replaceXMLEntities(rb.getRenderStyleName())).append("\"");
            }
            if (rb.getLabelStyleName() != null) {
                xmlDef.append(" label_style=\"").append(XMLUtil.replaceXMLEntities(rb.getLabelStyleName())).append("\"");
            }
            xmlDef.append(" />\n");
        }
        xmlDef.append("    </Buckets>");
        return xmlDef.toString();
    }

    private String getCollectionBucketsXml(StringBuffer xmlDef) {
        xmlDef.append("    <Buckets");
        if (this.defaultRenderStyleName != null) {
            xmlDef.append(" default_style=\"").append(XMLUtil.replaceXMLEntities(this.defaultRenderStyleName)).append("\"");
        }
        if (this.defaultLabelStyleName != null) {
            xmlDef.append(" default_label_style=\"").append(XMLUtil.replaceXMLEntities(this.defaultLabelStyleName)).append("\"");
        }
        xmlDef.append(">\n");
        for (int i = 0; i < this.buckets.size(); ++i) {
            xmlDef.append("      <CollectionBucket seq=\"").append(i).append("\"");
            CollectionBucket cb = (CollectionBucket)this.buckets.get(i);
            if (cb.getBucketLabel() != null) {
                xmlDef.append(" label=\"").append(XMLUtil.replaceXMLEntities(cb.getBucketLabel())).append("\"");
            }
            if (cb.getKeepWhiteSpace()) {
                xmlDef.append(" keep_white_space=\"true\"");
            }
            if (cb.getType() != null) {
                xmlDef.append(" type=\"" + XMLUtil.replaceXMLEntities(cb.getType().toLowerCase()) + "\"");
            }
            if (!cb.getDelimiter().equals(",")) {
                xmlDef.append(" delimiter=\"").append(XMLUtil.replaceXMLEntities(cb.getDelimiter())).append("\"");
            }
            if (cb.getRenderStyleName() != null) {
                xmlDef.append(" style=\"").append(XMLUtil.replaceXMLEntities(cb.getRenderStyleName())).append("\"");
            }
            if (cb.getLabelStyleName() != null) {
                xmlDef.append(" label_style=\"").append(XMLUtil.replaceXMLEntities(cb.getLabelStyleName())).append("\"");
            }
            xmlDef.append(">");
            Collection items = cb.getMembers();
            if (items != null) {
                int c = 0;
                for (Field f : items) {
                    if (c == 0) {
                        xmlDef.append(XMLUtil.replaceXMLEntities(f.toString()));
                    } else {
                        xmlDef.append(XMLUtil.replaceXMLEntities(cb.getDelimiter() + f.toString()));
                    }
                    ++c;
                }
            }
            xmlDef.append("</CollectionBucket>\n");
        }
        xmlDef.append("    </Buckets>");
        return xmlDef.toString();
    }

    public void setupEqualRangedBuckets(double min, double max, int nBuckets) {
        this.buckets.clear();
        double incr = (max - min) / (double)nBuckets;
        double v0 = min;
        for (int i = 0; i < nBuckets; ++i) {
            RangedBucket rb = new RangedBucket("" + i, new Field(v0), new Field(v0 + incr));
            this.buckets.add(rb);
            v0 += incr;
            if (i != nBuckets - 1) continue;
            rb.setAsLastBucket(true);
        }
        this.scheme = 2;
    }

    public void setupEqualRangedBuckets(long min, long max, int nBuckets) {
        this.buckets.clear();
        long incr = (max - min) / (long)nBuckets;
        long v0 = min;
        for (int i = 0; i < nBuckets; ++i) {
            RangedBucket rb = new RangedBucket("" + i, new Field(v0), new Field(v0 + incr));
            this.buckets.add(rb);
            v0 += incr;
            if (i != nBuckets - 1) continue;
            rb.setAsLastBucket(true);
        }
        this.scheme = 2;
    }

    public double getEqualRangedMinValue() {
        if (this.scheme != 2 || this.size() == 0) {
            return Double.NEGATIVE_INFINITY;
        }
        double min = Double.NEGATIVE_INFINITY;
        for (int i = 0; i < this.size(); ++i) {
            RangedBucket bkt = (RangedBucket)this.getBucket(i);
            Field low = bkt.getLowerBoundValue();
            if (low == null || low.getValue() == null) continue;
            String value = low.getValue().toString();
            double v = Double.parseDouble(value);
            if (i == 0) {
                min = v;
                continue;
            }
            if (!(v < min)) continue;
            min = v;
        }
        return min;
    }

    public double getEqualRangedMaxValue() {
        if (this.scheme != 2 || this.size() == 0) {
            return Double.POSITIVE_INFINITY;
        }
        double max = Double.POSITIVE_INFINITY;
        for (int i = 0; i < this.size(); ++i) {
            RangedBucket bkt = (RangedBucket)this.getBucket(i);
            Field high = bkt.getUpperBoundValue();
            if (high == null || high.getValue() == null) continue;
            String value = high.getValue().toString();
            double v = Double.parseDouble(value);
            if (i == 0) {
                max = v;
                continue;
            }
            if (!(v > max)) continue;
            max = v;
        }
        return max;
    }

    private void setLastBucket() {
        if (this.size() < 1) {
            return;
        }
        for (int i = 0; i < this.size(); ++i) {
            Bucket bkt = this.getBucket(i);
            bkt.setAsLastBucket(false);
        }
        if (this.scheme != 1) {
            return;
        }
        int lastRangedBucket = -1;
        Field lowrb = null;
        Field highrb = null;
        for (int i = 0; i < this.size(); ++i) {
            Bucket bkt = this.getBucket(i);
            if (!(bkt instanceof RangedBucket)) continue;
            Field low = ((RangedBucket)bkt).getLowerBoundValue();
            Field high = ((RangedBucket)bkt).getUpperBoundValue();
            if (lowrb == null && highrb == null) {
                lastRangedBucket = i;
                lowrb = low;
                highrb = high;
                continue;
            }
            if (highrb == null || high != null && (low == null || lowrb != null && lowrb.compareTo(low) > 0 || highrb.compareTo(low) > 0)) continue;
            lastRangedBucket = i;
            lowrb = low;
            highrb = high;
        }
        if (lastRangedBucket > -1) {
            Bucket bkt = this.getBucket(lastRangedBucket);
            bkt.setAsLastBucket(true);
        }
    }
}

