/*
 * Decompiled with CFR 0.152.
 */
package oracle.mapviewer.share.stylex;

import java.awt.Color;
import oracle.mapviewer.share.SizeDefinition2D;
import oracle.mapviewer.share.XMLUtil;
import oracle.mapviewer.share.style.AbstractStyleModel;
import oracle.mapviewer.share.style.StyleUtils;
import oracle.mapviewer.share.stylex.BarInfo;

public class BarChartStyleModel
extends AbstractStyleModel {
    static final long serialVersionUID = 421486313470893323L;
    double minValue = Double.NaN;
    double maxValue = Double.NaN;
    int numBars = 0;
    BarInfo[] bars = null;
    SizeDefinition2D barSize = new SizeDefinition2D(45.0, 25.0, null);
    boolean shareScale = true;
    boolean showXAxis = false;
    Color strokeColor = null;

    public BarChartStyleModel() {
        this.type = 9;
        this.bars = new BarInfo[0];
    }

    public BarChartStyleModel(BarInfo[] bars) {
        this.type = 9;
        if (bars == null || bars.length == 0) {
            throw new IllegalArgumentException("invalid argument(s).");
        }
        this.bars = bars;
        this.numBars = bars.length;
    }

    @Override
    public Object clone() {
        BarChartStyleModel obj = (BarChartStyleModel)super.clone();
        if (this.bars != null) {
            obj.bars = new BarInfo[this.bars.length];
            for (int i = 0; i < this.bars.length; ++i) {
                obj.bars[i] = new BarInfo(this.bars[i].name, this.bars[i].color);
            }
        }
        obj.setBarSize(this.barSize);
        return obj;
    }

    @Override
    public String getTypeName() {
        return "ADVANCED";
    }

    public void setBarSize(SizeDefinition2D size) {
        this.barSize = new SizeDefinition2D(45.0, 25.0, null);
        if (size == null) {
            return;
        }
        this.barSize.setSize(size.getWidth(), size.getHeight());
        this.barSize.setUnit(size.getUnit());
    }

    public SizeDefinition2D getBarSize() {
        return this.barSize;
    }

    @Override
    public String toXMLString() {
        String wStr = StyleUtils.getUSLocaleFormat(this.barSize.getWidth());
        wStr = StyleUtils.cleanDecimalZeros(wStr, 1);
        String hStr = StyleUtils.getUSLocaleFormat(this.barSize.getHeight());
        hStr = StyleUtils.cleanDecimalZeros(hStr, 1);
        String unit = "";
        if (this.barSize.getUnit() != null && !this.barSize.getUnit().equalsIgnoreCase("px")) {
            unit = this.barSize.getUnit();
        }
        if (this.barSize.isPixelUnit()) {
            wStr = String.valueOf((int)this.barSize.getWidth());
            hStr = String.valueOf((int)this.barSize.getHeight());
        }
        String xmlDef = "<?xml version=\"1.0\" ?>\n";
        xmlDef = xmlDef + "<AdvancedStyle>\n   <BarChartStyle";
        xmlDef = xmlDef + " width=\"" + wStr + unit + "\" height=\"" + hStr + unit + "\" " + "share_scale=\"" + (this.shareScale ? "true" : "false") + "\"";
        if (!Double.isNaN(this.maxValue) && !Double.isNaN(this.minValue)) {
            xmlDef = xmlDef + "\n      min_value=\"" + this.minValue + "\" max_value=\"" + this.maxValue + "\"";
        }
        if (this.showXAxis) {
            xmlDef = xmlDef + " show_x_axis=\"true\"";
        }
        if (this.strokeColor != null) {
            String stroke = " stroke=\"" + StyleUtils.getHexidecimalString(this.strokeColor) + "\"";
            int alpha = this.strokeColor.getAlpha();
            if (alpha < 255) {
                stroke = stroke + " stroke-opacity=\"" + alpha + "\"";
            }
            xmlDef = xmlDef + stroke;
        }
        xmlDef = xmlDef + ">\n";
        if (this.bars != null) {
            for (int i = 0; i < this.bars.length; ++i) {
                BarInfo _bi = this.bars[i];
                xmlDef = xmlDef + "       <Bar name=\"" + XMLUtil.replaceXMLEntities(_bi.name) + "\"";
                if (_bi.color != null) {
                    xmlDef = xmlDef + " color=\"" + StyleUtils.getHexidecimalString(_bi.color) + "\"";
                }
                xmlDef = xmlDef + " />\n";
            }
        }
        xmlDef = xmlDef + "   </BarChartStyle>\n</AdvancedStyle>\n";
        return xmlDef;
    }

    public void setWidth(int width) {
        this.barSize.setWidth(width);
    }

    public void setWidth(double width) {
        this.barSize.setWidth(width);
    }

    public int getWidth() {
        return (int)this.barSize.getWidth();
    }

    public double getDoubleWidth() {
        return this.barSize.getWidth();
    }

    public void setHeight(int height) {
        this.barSize.setHeight(height);
    }

    public void setHeight(double height) {
        this.barSize.setHeight(height);
    }

    public int getHeight() {
        return (int)this.barSize.getHeight();
    }

    public double getDoubleHeight() {
        return this.barSize.getHeight();
    }

    public String getSizeUnit() {
        return this.barSize.getUnit();
    }

    public void setSizeUnit(String unit) {
        this.barSize.setUnit(unit);
    }

    public int getNumBars() {
        return this.numBars;
    }

    public void setBars(BarInfo[] bars) {
        this.bars = bars;
        this.numBars = bars == null ? 0 : bars.length;
    }

    public BarInfo[] getBars() {
        return this.bars;
    }

    public void setMinValue(double minValue) {
        this.minValue = minValue;
    }

    public double getMinValue() {
        return this.minValue;
    }

    public void setMaxValue(double maxValue) {
        this.maxValue = maxValue;
    }

    public double getMaxValue() {
        return this.maxValue;
    }

    public void setMinMaxValues(double min, double max) {
        this.minValue = Math.min(min, max);
        this.maxValue = Math.max(min, max);
    }

    public void setShareScale(boolean sharedScale) {
        this.shareScale = sharedScale;
    }

    public boolean isShareScale() {
        return this.shareScale;
    }

    public BarInfo getBarInfo(int index) {
        return this.bars[index];
    }

    public void setShowXAxis(boolean showXAxis) {
        this.showXAxis = showXAxis;
    }

    public boolean isShowXAxis() {
        return this.showXAxis;
    }

    @Override
    public String[] getStyleDependency() {
        return null;
    }

    public void setStrokeColor(Color strokeColor) {
        this.strokeColor = strokeColor;
    }

    public Color getStrokeColor() {
        return this.strokeColor;
    }
}

