/*
 * Decompiled with CFR 0.152.
 */
package oracle.mapviewer.share;

import java.util.Vector;
import oracle.mapviewer.share.Field;
import oracle.mapviewer.share.TopoChildFeatureDescriptor;
import oracle.mapviewer.share.TopoPrimitiveDescriptor;

public class TopoFeatureDescriptor {
    private String topology = null;
    private String featureTable = null;
    private String topoColumn = null;
    private int layerId = 0;
    private int featureId = 0;
    private int topoType = 0;
    private Vector<TopoChildFeatureDescriptor> childFeatures = new Vector();
    private Vector<TopoPrimitiveDescriptor> primitives = new Vector();
    private Vector<Field> attributes = new Vector();

    public String getTopology() {
        return this.topology;
    }

    public void setTopology(String name) {
        this.topology = name;
    }

    public String getFeatureTable() {
        return this.featureTable;
    }

    public void setFeatureTable(String table) {
        this.featureTable = table;
    }

    public String getTopoColumn() {
        return this.topoColumn;
    }

    public void setTopoColumn(String column) {
        this.topoColumn = column;
    }

    public int getLayerId() {
        return this.layerId;
    }

    public void setLayerId(int id) {
        this.layerId = id;
    }

    public int getFeatureId() {
        return this.featureId;
    }

    public void setFeatureId(int id) {
        this.featureId = id;
    }

    public int getTopoFeatureType() {
        return this.topoType;
    }

    public void setTopoFeatureType(int type) {
        this.topoType = type < 1 || type > 4 ? 0 : type;
    }

    public void addPrimitive(TopoPrimitiveDescriptor primitive) {
        if (primitive == null) {
            return;
        }
        this.primitives.add(primitive);
    }

    public boolean removePrimitive(TopoPrimitiveDescriptor primitive) {
        if (primitive == null) {
            return false;
        }
        return this.primitives.remove(primitive);
    }

    public TopoPrimitiveDescriptor[] getPrimitives() {
        if (this.primitives.size() == 0) {
            return null;
        }
        return this.primitives.toArray(new TopoPrimitiveDescriptor[this.primitives.size()]);
    }

    public void clearPrimitives() {
        this.primitives.clear();
    }

    public int getNumberOfPrimitives() {
        return this.primitives.size();
    }

    public void addChildFeature(TopoChildFeatureDescriptor child) {
        if (child == null) {
            return;
        }
        this.childFeatures.add(child);
    }

    public boolean removeChildFeature(TopoChildFeatureDescriptor child) {
        if (child == null) {
            return false;
        }
        return this.childFeatures.remove(child);
    }

    public TopoChildFeatureDescriptor[] getChildFeatures() {
        if (this.childFeatures.size() == 0) {
            return null;
        }
        return this.childFeatures.toArray(new TopoChildFeatureDescriptor[this.childFeatures.size()]);
    }

    public void clearChildFeatures() {
        this.childFeatures.clear();
    }

    public int getNumberOfChildFeatures() {
        return this.childFeatures.size();
    }

    public void addAttribute(Field attr) {
        if (attr == null) {
            return;
        }
        this.attributes.add(attr);
    }

    public boolean removeAttribute(Field attr) {
        if (attr == null) {
            return false;
        }
        return this.attributes.remove(attr);
    }

    public Field[] getAttributes() {
        if (this.attributes.size() == 0) {
            return null;
        }
        return this.attributes.toArray(new Field[this.attributes.size()]);
    }

    public void clearAttributes() {
        this.attributes.clear();
    }

    public int getNumberOfAttributes() {
        return this.attributes.size();
    }

    public String toXML() {
        TopoChildFeatureDescriptor[] tcfds;
        TopoPrimitiveDescriptor[] tpds;
        String out = "<topo_geometry>\n";
        out = out + "  <tg_id>" + this.featureId + "</tg_id>\n";
        out = out + "  <tg_layer_id>" + this.layerId + "</tg_layer_id>\n";
        out = out + "  <tg_type>" + this.topoType + "</tg_type>\n";
        if (this.topology != null) {
            out = out + "  <topology>" + this.topoType + "</topology>\n";
        }
        if (this.featureTable != null) {
            out = out + "  <feature_table>" + this.topoType + "</feature_table>\n";
        }
        if (this.topoColumn != null) {
            out = out + "  <topo_column>" + this.topoType + "</topo_column>\n";
        }
        if ((tpds = this.getPrimitives()) != null && tpds.length > 0) {
            out = out + "   <topo_primitives>\n";
            for (int i = 0; i < tpds.length; ++i) {
                out = out + "      <topo_primitive topo_id=\"" + tpds[i].getTopoId() + "\" topo_type=\"" + tpds[i].getTopoType() + "\" />\n";
            }
            out = out + "   </topo_primitives>\n";
        }
        if ((tcfds = this.getChildFeatures()) != null && tcfds.length > 0) {
            out = out + "   <child_features>\n";
            for (int i = 0; i < tcfds.length; ++i) {
                out = out + "      <child_feature layer_id=\"" + tcfds[i].getLayerId() + "\" feature_id=\"" + tcfds[i].getFeatureId() + "\" />\n";
            }
            out = out + "   </child_features>\n";
        }
        out = out + "</topo_geometry>";
        return out;
    }
}

