/*
 * Decompiled with CFR 0.152.
 */
package oracle.mapviewer.share;

import java.awt.Color;
import java.awt.Font;
import java.io.Serializable;

public class ScaleBar
implements Serializable {
    static final long serialVersionUID = 3230604429528980407L;
    protected boolean rendered = true;
    public static final String US_MODE = "US_MODE";
    public static final String METRIC_MODE = "METRIC_MODE";
    public static final String DUAL_MODES = "DUAL_MODES";
    public static final Color DEFAULT_COLOR1 = new Color(68, 68, 68, 210);
    public static final Color DEFAULT_COLOR2 = new Color(238, 238, 238, 210);
    public static final Font DEFAULT_FONT = new Font("Serif", 0, 12);
    private Color color1 = DEFAULT_COLOR1;
    private Color color2 = DEFAULT_COLOR2;
    private int lengthHint = 0;
    private Color labelColor = Color.black;
    private Font labelFont = DEFAULT_FONT;
    private float labelHaloSize = 0.0f;
    private String mode = "METRIC_MODE";
    private String position = "NORTH_EAST";
    private String labelPosition = "TOP";
    private int offsetX = 0;
    private int offsetY = 0;
    private boolean transformToWGS84 = false;

    public Object clone() {
        ScaleBar bar = new ScaleBar();
        bar.color1 = this.color1;
        bar.color2 = this.color2;
        bar.lengthHint = this.lengthHint;
        bar.labelColor = this.labelColor;
        bar.labelFont = this.labelFont;
        bar.labelHaloSize = this.labelHaloSize;
        bar.mode = this.mode;
        bar.position = this.position;
        bar.labelPosition = this.labelPosition;
        bar.offsetX = this.offsetX;
        bar.offsetY = this.offsetY;
        return bar;
    }

    public void setMode(String mode) {
        if (mode != null) {
            this.mode = mode.toUpperCase();
        }
    }

    public String getMode() {
        return this.mode;
    }

    public void setColor1(Color color1) {
        this.color1 = color1;
    }

    public Color getColor1() {
        return this.color1;
    }

    public void setColor2(Color color2) {
        this.color2 = color2;
    }

    public Color getColor2() {
        return this.color2;
    }

    public void setLengthHint(int lenHint) {
        this.lengthHint = lenHint;
    }

    public int getLengthHint() {
        return this.lengthHint;
    }

    public void setLabelColor(Color labelColor) {
        this.labelColor = labelColor;
    }

    public Color getLabelColor() {
        return this.labelColor;
    }

    public void setLabelFont(Font labelFont) {
        this.labelFont = labelFont;
    }

    public Font getLabelFont() {
        return this.labelFont;
    }

    public void setLabelHaloSize(float labelHaloSize) {
        this.labelHaloSize = labelHaloSize;
    }

    public float getLabelHaloSize() {
        return this.labelHaloSize;
    }

    public void setPosition(String pos) {
        if ("SOUTH_EAST".equals(pos = pos.toUpperCase()) || "NORTH_EAST".equals(pos) || "SOUTH_WEST".equals(pos) || "NORTH_WEST".equals(pos) || "NORTH".equals(pos) || "SOUTH".equals(pos)) {
            this.position = pos;
        } else {
            System.err.println("invalid position for scale bar specified.");
        }
    }

    public String getPosition() {
        return this.position;
    }

    public void setRendered(boolean rendered) {
        this.rendered = rendered;
    }

    public boolean isRendered() {
        return this.rendered;
    }

    public int getOffsetX() {
        return this.offsetX;
    }

    public void setOffsetX(int offset) {
        this.offsetX = offset <= 0 ? 0 : offset;
    }

    public int getOffsetY() {
        return this.offsetY;
    }

    public void setOffsetY(int offset) {
        this.offsetY = offset <= 0 ? 0 : offset;
    }

    public String getLabelPosition() {
        return this.labelPosition;
    }

    public void setLabelPosition(String pos) {
        if (pos == null || !pos.equalsIgnoreCase("TOP") && !pos.equalsIgnoreCase("BOTTOM")) {
            return;
        }
        this.labelPosition = pos.toUpperCase();
    }

    public void setTransformToWGS84(boolean transform) {
        this.transformToWGS84 = transform;
    }

    public boolean getTransformToWGS84() {
        return this.transformToWGS84;
    }
}

