/*
 * Decompiled with CFR 0.152.
 */
package oracle.mapviewer.share;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Properties;
import oracle.sdovis.util.Util;

public class RenderingRule
implements Serializable {
    public static String FILL_COLOR_CHANGE = "FILL_COLOR";
    public static String MARKER_SIZE_SCALE_FACTOR_CHANGE = "MARKER_SIZE_SCALE_FACTOR";
    private String styleName = null;
    private String[] styleColumns = null;
    private String subStyleName = null;
    private String[] subStyleColumns = null;
    private String subStyleChangeProperty = FILL_COLOR_CHANGE;
    private double minScale = Double.NaN;
    private double maxScale = Double.NaN;
    public static String LABEL_ALWAYS_ON_PROPERTY = "label_always_on";
    public static String NO_REPETITIVE_LABEL_PROPERTY = "no_repetitive_label";
    public static String UPSIDE_DOWN_LABELS_PROPERTY = "upside_down_labels";
    public static String ALLOW_NAKED_POINTS_PROPERTY = "allow_naked_points";
    private Properties labelProperties = new Properties();

    public String getStyleName() {
        return this.styleName;
    }

    public void setStyleName(String name) {
        this.styleName = name;
    }

    public String[] getStyleColumns() {
        return this.styleColumns;
    }

    public String getStyleColumnsAsString() {
        if (this.styleColumns == null || this.styleColumns.length == 0) {
            return null;
        }
        String res = this.styleColumns[0];
        for (int i = 1; i < this.styleColumns.length; ++i) {
            res = res + "," + this.styleColumns[i];
        }
        return res;
    }

    public void setStyleColumns(String[] columns) {
        this.styleColumns = columns;
    }

    public void setStyleColumnsAsString(String columns) {
        if (columns == null) {
            this.styleColumns = null;
        } else {
            ArrayList cols = Util.splitBy(columns, ",");
            if (cols == null || cols.size() == 0) {
                this.styleColumns = null;
            } else {
                this.styleColumns = new String[cols.size()];
                for (int i = 0; i < cols.size(); ++i) {
                    this.styleColumns[i] = cols.get(i).toString();
                }
            }
        }
    }

    public String getSubStyleName() {
        return this.subStyleName;
    }

    public void setSubStyleName(String name) {
        this.subStyleName = name;
    }

    public String[] getSubStyleColumns() {
        return this.subStyleColumns;
    }

    public void setSubStyleColumns(String[] columns) {
        this.subStyleColumns = columns;
    }

    public String getSubStyleColumnsAsString() {
        if (this.subStyleColumns == null || this.subStyleColumns.length == 0) {
            return null;
        }
        String res = this.subStyleColumns[0];
        for (int i = 1; i < this.subStyleColumns.length; ++i) {
            res = res + "," + this.subStyleColumns[i];
        }
        return res;
    }

    public void setSubStyleColumnsAsString(String columns) {
        if (columns == null) {
            this.subStyleColumns = null;
        } else {
            ArrayList cols = Util.splitBy(columns, ",");
            if (cols == null || cols.size() == 0) {
                this.subStyleColumns = null;
            } else {
                this.subStyleColumns = new String[cols.size()];
                for (int i = 0; i < cols.size(); ++i) {
                    this.subStyleColumns[i] = cols.get(i).toString();
                }
            }
        }
    }

    public String getSubStyleChangeProperty() {
        return this.subStyleChangeProperty;
    }

    public void setSubStyleChangeProperty(String prop) {
        this.subStyleChangeProperty = prop;
    }

    public static String[] getChangePropertyNames() {
        String[] changes = new String[]{FILL_COLOR_CHANGE, MARKER_SIZE_SCALE_FACTOR_CHANGE};
        return changes;
    }

    public void setScaleRange(double minScale, double maxScale) {
        this.minScale = minScale;
        this.maxScale = maxScale;
    }

    public double getMinScale() {
        return this.minScale;
    }

    public void setMinScale(double scale) {
        this.minScale = scale;
    }

    public double getMaxScale() {
        return this.maxScale;
    }

    public void setMaxScale(double scale) {
        this.maxScale = scale;
    }

    public boolean isScaleRangeDefined() {
        return !Double.isNaN(this.minScale) || !Double.isNaN(this.maxScale);
    }

    public boolean isWithinScaleLimits(double ratioScale) {
        if (!this.isScaleRangeDefined()) {
            return true;
        }
        if (ratioScale == Double.NEGATIVE_INFINITY || ratioScale == Double.POSITIVE_INFINITY || ratioScale == 0.0) {
            return true;
        }
        double minScale = this.getMinScale();
        double maxScale = this.getMaxScale();
        if (Double.isNaN(minScale) && Double.isNaN(maxScale)) {
            return true;
        }
        if (!Double.isNaN(minScale)) {
            if (!Double.isNaN(maxScale)) {
                return ratioScale > maxScale && ratioScale <= minScale;
            }
            return ratioScale <= minScale;
        }
        return ratioScale > maxScale;
    }

    public String getLabelProperty(String property) {
        if (property == null) {
            return null;
        }
        return this.labelProperties.getProperty(property);
    }

    public void setLabelProperty(String propertyName, String propertyValue) {
        if (propertyName == null || propertyValue == null) {
            return;
        }
        this.labelProperties.put(propertyName, propertyValue);
    }

    public RenderingRule getCopy() {
        RenderingRule copy = new RenderingRule();
        copy.setStyleName(this.styleName);
        copy.setStyleColumns(this.styleColumns);
        copy.setSubStyleName(this.subStyleName);
        copy.setSubStyleColumns(this.subStyleColumns);
        copy.setSubStyleChangeProperty(this.subStyleChangeProperty);
        copy.setMinScale(this.minScale);
        copy.setMaxScale(this.maxScale);
        if (this.labelProperties.size() > 0) {
            String[] keys = new String[this.labelProperties.size()];
            int count = 0;
            Enumeration<Object> e = this.labelProperties.keys();
            while (e.hasMoreElements()) {
                keys[count] = (String)e.nextElement();
                ++count;
            }
            for (int i = 0; i < keys.length; ++i) {
                String propertyValue = (String)this.labelProperties.get(keys[i]);
                copy.setLabelProperty(keys[i], propertyValue);
            }
        }
        return copy;
    }
}

