/*
 * Decompiled with CFR 0.152.
 */
package oracle.mapviewer.share;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import oracle.mapviewer.share.FeatureDescriptor;
import oracle.mapviewer.share.SimpleFeatureI;

public class FeatureGroup
implements Serializable {
    FeatureDescriptor type;
    List<SimpleFeatureI> features = null;
    String name;
    int srid = -1;
    boolean geodeticSrid = false;
    String idAttr = null;
    String baseTable = null;
    String spatialAttr = null;
    String spatialType = null;
    String workspace = null;
    double[] mbr;

    public int getSrid() {
        return this.srid;
    }

    public void setSrid(int srid) {
        this.srid = srid;
    }

    public boolean isGeodeticSrid() {
        return this.geodeticSrid;
    }

    public void setIsGeodeticSrid(boolean geodetic) {
        this.geodeticSrid = geodetic;
    }

    public double[] getMbr() {
        return this.mbr;
    }

    public void setMbr(double[] mbr) {
        this.mbr = mbr;
    }

    public FeatureGroup(String name) {
        this.name = name;
        this.features = new ArrayList<SimpleFeatureI>();
    }

    public FeatureGroup(int initialSize, String name) {
        this.name = name;
        this.features = new ArrayList<SimpleFeatureI>(initialSize);
    }

    public void setType(FeatureDescriptor ftype) {
        this.type = ftype;
    }

    public FeatureDescriptor getType() {
        return this.type;
    }

    public List<SimpleFeatureI> getFeatures() {
        return this.features;
    }

    public void addFeature(SimpleFeatureI feature) {
        this.features.add(feature);
        this.updateMBR(feature);
        if (this.srid < 0) {
            this.srid = feature.getGeometry().srid;
        }
    }

    public String getName() {
        return this.name;
    }

    private void updateMBR(SimpleFeatureI feature) {
        if (this.mbr == null) {
            this.mbr = new double[4];
            this.mbr[0] = Double.POSITIVE_INFINITY;
            this.mbr[1] = Double.POSITIVE_INFINITY;
            this.mbr[2] = Double.NEGATIVE_INFINITY;
            this.mbr[3] = Double.NEGATIVE_INFINITY;
        }
        if (feature != null && feature.getGeometry() != null) {
            double[] geomMbr = feature.getGeometry().getMbr();
            if (geomMbr == null) {
                return;
            }
            if (this.mbr[0] > geomMbr[0]) {
                this.mbr[0] = geomMbr[0];
            }
            if (this.mbr[1] > geomMbr[1]) {
                this.mbr[1] = geomMbr[1];
            }
            if (geomMbr.length == 4) {
                if (this.mbr[2] < geomMbr[2]) {
                    this.mbr[2] = geomMbr[2];
                }
                if (this.mbr[3] < geomMbr[3]) {
                    this.mbr[3] = geomMbr[3];
                }
            } else {
                if (this.mbr[2] < geomMbr[3]) {
                    this.mbr[2] = geomMbr[3];
                }
                if (this.mbr[3] < geomMbr[4]) {
                    this.mbr[3] = geomMbr[4];
                }
            }
        }
    }

    public String getIdAttribute() {
        return this.idAttr;
    }

    public void setIdAttribute(String attr) {
        this.idAttr = attr;
    }

    public String getBaseTable() {
        return this.baseTable;
    }

    public void setBaseTable(String table) {
        this.baseTable = table;
    }

    public String getSpatialAttribute() {
        return this.spatialAttr;
    }

    public void setSpatialAttribute(String attr) {
        this.spatialAttr = attr;
    }

    public String getSpatialType() {
        return this.spatialType;
    }

    public void setSpatialType(String type) {
        this.spatialType = type;
    }

    public String getWorkspace() {
        return this.workspace;
    }

    public void setWorkspace(String wksp) {
        this.workspace = wksp;
    }
}

