/*
 * Decompiled with CFR 0.152.
 */
package oracle.mapviewer.share;

import java.util.Hashtable;

public class ArrayParameter {
    private String typeName = null;
    private Object value = null;
    private String dataSource = null;
    private static Hashtable descriptorTable = new Hashtable(10);

    public ArrayParameter(String typeName, Object value) {
        this.typeName = typeName;
        this.value = value;
    }

    public ArrayParameter(String typeName, Object value, String dataSource) {
        if (typeName != null) {
            this.typeName = typeName.toUpperCase();
        }
        this.value = value;
        if (dataSource != null) {
            this.dataSource = dataSource.toUpperCase();
        }
    }

    public String getTypeName() {
        return this.typeName;
    }

    public Object getValue() {
        return this.value;
    }

    public String toString() {
        int i;
        Object[] array;
        String arrayValue = "";
        if (this.value instanceof double[]) {
            array = (double[])this.value;
            for (i = 0; i < array.length; ++i) {
                if (i > 0) {
                    arrayValue = arrayValue + ":";
                }
                arrayValue = arrayValue + array[i];
            }
        } else if (this.value instanceof int[]) {
            array = (int[])this.value;
            for (i = 0; i < array.length; ++i) {
                if (i > 0) {
                    arrayValue = arrayValue + ":";
                }
                arrayValue = arrayValue + (int)array[i];
            }
        }
        if (this.value instanceof String[]) {
            array = (String[])this.value;
            for (i = 0; i < array.length; ++i) {
                if (i > 0) {
                    arrayValue = arrayValue + ":";
                }
                arrayValue = arrayValue + '\"' + array[i].replace("\\", "\\\\").replace("\"", "\\\"") + '\"';
            }
        }
        return this.typeName + ";" + this.dataSource + ";" + arrayValue;
    }

    public static Hashtable getDescriptorTable() {
        return descriptorTable;
    }

    public void setDataSource(String dataSource) {
        this.dataSource = dataSource;
    }

    public String getDataSource() {
        return this.dataSource;
    }
}

