/*
 * Decompiled with CFR 0.152.
 */
package oracle.lbs.util;

import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import javax.management.ObjectName;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import oracle.lbs.mapserver.core.MSBundle;
import oracle.mapviewer.share.util.LogFactory;
import weblogic.application.ready.ReadyLifecycleManager;

public class ServerInitListener
implements ServletContextListener {
    private static Logger log = LogFactory.getLogger(LogFactory.LoggerEnum.MAPVIEWER);
    public static String ORACLE_MAPS_CONFIG_ENV = "ORACLE_MAPS_CONFIG";
    public static String ORACLE_MAPS_CONFIG = "oracle.maps.config";
    static ServletContext servletContext = null;
    static String configFile = null;
    static String configHomeFolder = null;
    static String privateRootFolder = null;
    static String publicRootFolder = null;
    static MBeanServer mbeanServer = null;
    static String logsFolder = null;
    static String templatesFolder = null;
    public static final int INIT_READY_OMS = 1;
    public static final int INIT_READY_FOI = 2;
    public static final int INIT_READY_MCS = 3;
    public static final int INIT_READY_MDS = 4;
    public static final int INIT_THREAD_READY_OMS = 11;
    public static final int INIT_THREAD_READY_FOI = 21;
    public static final int INIT_THREAD_READY_MCS = 31;
    public static final int INIT_THREAD_READY_MDS = 41;
    private static boolean init_ready_oms = false;
    private static boolean init_ready_foi = false;
    private static boolean init_ready_mcs = false;
    private static boolean init_ready_mds = false;
    private static boolean init_thread_ready_oms = false;
    private static boolean init_thread_ready_foi = false;
    private static boolean init_thread_ready_mcs = false;
    private static boolean init_thread_ready_mds = false;

    public void contextDestroyed(ServletContextEvent evt) {
        ServerInitListener.unregisterMBeans();
        mbeanServer = null;
        ServerInitListener.setPrivateRootFolder(null);
        ServerInitListener.setConfigHomeFolder(null);
        log.info("=====> Oracle MapViewer shutting down. <=====");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void contextInitialized(ServletContextEvent evt) {
        ServletContext ctx = servletContext = evt.getServletContext();
        configFile = System.getProperty(ORACLE_MAPS_CONFIG);
        if (configFile != null && new File(configFile).exists()) {
            log.info("Got MapViewer config file location from JVM option '-Doracle.maps.config'.");
            this.recordConfigInfo(ctx, configFile);
            return;
        }
        configFile = ctx.getInitParameter(ORACLE_MAPS_CONFIG);
        if (configFile != null && new File(configFile).exists()) {
            log.info("Got MapViewer config file location from context-param in web.xml.");
            this.recordConfigInfo(ctx, configFile);
            return;
        }
        InputStream is = null;
        try {
            is = this.getClass().getResourceAsStream("/oracle/maps/config.properties");
            Properties p = new Properties();
            p.load(is);
            configFile = p.getProperty(ORACLE_MAPS_CONFIG);
            if (configFile != null && new File(configFile).exists()) {
                log.info("Got MapViewer config file location from /oracle/maps/config.properties.");
                this.recordConfigInfo(ctx, configFile);
                return;
            }
        }
        catch (Exception ex) {
            configFile = null;
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (Throwable ignore) {}
            }
        }
        String myRoot = ctx.getRealPath("/");
        if (myRoot == null || myRoot.length() == 0) {
            try {
                URL webinfURL = ctx.getResource("/WEB-INF");
                File webinfFile = new File(webinfURL.toURI());
                myRoot = webinfFile.getParent();
            }
            catch (Exception ex) {
                log.severe(ex.getMessage());
                log.severe(MSBundle.getMsg((String)"MAPVIEWER-00071"));
            }
        }
        if (myRoot != null && myRoot.length() > 0) {
            if (!myRoot.endsWith(File.separator)) {
                myRoot = myRoot + File.separator;
            }
            ServerInitListener.setPublicRootFolder(myRoot);
            configFile = myRoot + "WEB-INF" + File.separator + "conf" + File.separator + "mapViewerConfig.xml";
            if (configFile != null && new File(configFile).exists()) {
                this.recordConfigInfo(ctx, configFile);
                return;
            }
        }
        log.severe(MSBundle.getMsg((String)"MAPVIEWER-00072"));
    }

    private void recordConfigInfo(ServletContext ctx, String configFile) {
        ctx.setAttribute(ORACLE_MAPS_CONFIG, (Object)configFile);
        String configHome = this.getConfigHome(configFile);
        ServerInitListener.setConfigHomeFolder(configHome);
        ServerInitListener.setPrivateRootFolder(configHome);
        log.info("=====> Config file being loaded: " + configFile + ". <=====");
    }

    private String getConfigHome(String configFile) {
        if (configFile == null) {
            return null;
        }
        File file = new File(configFile);
        if (!file.exists() || file.isDirectory()) {
            return null;
        }
        try {
            String cf = file.getCanonicalPath();
            File cfgFile = new File(cf);
            return cfgFile.getParent();
        }
        catch (Exception ex) {
            return null;
        }
    }

    public static String getPrivateRootFolder() {
        return privateRootFolder;
    }

    public static void setPrivateRootFolder(String configHomeDir) {
        if (configHomeDir == null) {
            privateRootFolder = null;
            return;
        }
        if (configHomeDir.endsWith(File.separator)) {
            configHomeDir = configHomeDir.substring(0, configHomeDir.length() - 1);
        }
        if (configHomeDir.endsWith(File.separator + "conf") || configHomeDir.endsWith(File.separator + "/config")) {
            try {
                String parent;
                File f = new File(configHomeDir);
                privateRootFolder = parent = f.getParent();
            }
            catch (Exception ex) {
                log.warning("Cannot get parent folder of: " + configHomeDir);
                privateRootFolder = configHomeDir;
            }
        } else {
            privateRootFolder = configHomeDir;
        }
        if (!privateRootFolder.endsWith(File.separator)) {
            privateRootFolder = privateRootFolder + File.separator;
        }
        templatesFolder = privateRootFolder + "templates" + File.separator;
        log.info("MapViewer private root folder is set to: " + privateRootFolder);
    }

    public static String getConfigHomeFolder() {
        return configHomeFolder;
    }

    public static void setConfigHomeFolder(String configHomeFolder) {
        if (configHomeFolder == null) {
            ServerInitListener.configHomeFolder = null;
            return;
        }
        if (!configHomeFolder.endsWith(File.separator)) {
            configHomeFolder = configHomeFolder + File.separator;
        }
        ServerInitListener.configHomeFolder = configHomeFolder;
        log.info("MapViewer config home dir: " + ServerInitListener.configHomeFolder);
    }

    public static String getPublicRootFolder() {
        return publicRootFolder;
    }

    public static void setPublicRootFolder(String publicRootFolder) {
        ServerInitListener.publicRootFolder = publicRootFolder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unregisterMBeans() {
        ObjectName obj;
        try {
            if (mbeanServer == null) {
                log.warning("mbean server is null.");
                return;
            }
            log.info("mbean domain: " + mbeanServer.getDefaultDomain());
            obj = new ObjectName(mbeanServer.getDefaultDomain() + ":name=OMSConfig");
            mbeanServer.unregisterMBean(obj);
            log.info("OMSConfig mbean unregistered.");
        }
        catch (Throwable ex) {
            log.log(Level.INFO, "Cannot unregister OMSConfig mbean: " + ex.getMessage());
        }
        try {
            obj = new ObjectName(mbeanServer.getDefaultDomain() + ":name=MCSConfig");
            mbeanServer.unregisterMBean(obj);
            log.info("MCSConfig mbean unregistered.");
        }
        catch (Throwable ex) {
            log.log(Level.INFO, "Cannot unregister MCSConfig mbean: " + ex.getMessage());
        }
        finally {
            mbeanServer = null;
        }
    }

    public static synchronized MBeanServer getMbeanServer() {
        if (mbeanServer != null) {
            return mbeanServer;
        }
        mbeanServer = MBeanServerFactory.createMBeanServer();
        return mbeanServer;
    }

    public static void setMbeanServer(MBeanServer mbeanServer) {
        ServerInitListener.mbeanServer = mbeanServer;
    }

    public static String getConfigFile() {
        return configFile;
    }

    public static void setConfigFile(String configFile) {
        ServerInitListener.configFile = configFile;
    }

    public static String getLogsFolder() {
        return logsFolder;
    }

    public static void setLogsFolder(String logsFolder) {
        ServerInitListener.logsFolder = logsFolder.endsWith(File.separator) ? logsFolder : logsFolder + File.separator;
    }

    public static ServletContext getServletContext() {
        return servletContext;
    }

    public static String getTemplatesFolder() {
        return templatesFolder;
    }

    public static synchronized void updateStatus(int initID, boolean state) {
        try {
            Class.forName("weblogic.application.ready.ReadyLifecycleManager", false, ServerInitListener.class.getClassLoader());
        }
        catch (ClassNotFoundException e) {
            log.warning("WebLogic Ready Lifecycle Manager not found in class path.");
            return;
        }
        try {
            Class.forName("weblogic/invocation/ComponentInvocationContextManager", false, ServerInitListener.class.getClassLoader());
        }
        catch (ClassNotFoundException e) {
            return;
        }
        switch (initID) {
            case 1: {
                init_ready_oms = state;
                break;
            }
            case 11: {
                init_thread_ready_oms = state;
                break;
            }
            case 2: {
                init_ready_foi = state;
                break;
            }
            case 21: {
                init_thread_ready_foi = state;
                break;
            }
            case 3: {
                init_ready_mcs = state;
                break;
            }
            case 31: {
                init_thread_ready_mcs = state;
                break;
            }
            case 4: {
                init_ready_mds = state;
                break;
            }
            case 41: {
                init_thread_ready_mds = state;
            }
        }
        if (state) {
            if (init_ready_oms && init_thread_ready_oms && init_ready_foi && init_thread_ready_foi && init_ready_mcs && init_thread_ready_mcs && init_ready_mds && init_thread_ready_mds) {
                try {
                    int status = ReadyLifecycleManager.getInstance().ready();
                    log.fine("Weblogic ready status: " + status);
                }
                catch (Exception e) {
                    log.warning("Failed to update WebLogic server status to 'ready'. ");
                }
            }
        } else {
            try {
                int status = ReadyLifecycleManager.getInstance().notReady();
                log.fine("Weblogic not-ready status: " + status);
            }
            catch (Exception e) {
                log.warning("Failed to update server status to 'not ready'. ");
            }
        }
    }
}

