/*
 * Decompiled with CFR 0.152.
 */
package oracle.jrf.templates;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import oracle.jrf.templates.Application;
import oracle.jrf.templates.EnvConfig;
import oracle.jrf.templates.JDBCSystemResource;
import oracle.jrf.templates.Library;
import oracle.jrf.templates.ShutdownClass;
import oracle.jrf.templates.StartupClass;
import oracle.jrf.templates.Template;
import oracle.jrf.templates.URLProvider;
import oracle.jrf.templates.WLDFSystemResource;

public abstract class AbstractTemplate
implements Template {
    protected String name;
    protected String version;
    protected String oracleHome;
    protected Map<String, List<Application>> applications = new HashMap<String, List<Application>>();
    protected Map<String, Application> allApplications = new HashMap<String, Application>();
    protected Map<String, List<Library>> libraries = new HashMap<String, List<Library>>();
    protected Map<String, Library> allLibraries = new HashMap<String, Library>();
    protected Map<String, List<StartupClass>> startupClasses = new HashMap<String, List<StartupClass>>();
    protected Map<String, StartupClass> allStartupClasses = new HashMap<String, StartupClass>();
    protected Map<String, List<ShutdownClass>> shutdownClasses = new HashMap<String, List<ShutdownClass>>();
    protected Map<String, ShutdownClass> allShutdownClasses = new HashMap<String, ShutdownClass>();
    protected Map<String, List<URLProvider>> urlProviders = new HashMap<String, List<URLProvider>>();
    protected Map<String, URLProvider> allUrlProviders = new HashMap<String, URLProvider>();
    protected Map<String, List<JDBCSystemResource>> jdbcSystemResources = new HashMap<String, List<JDBCSystemResource>>();
    protected Map<String, JDBCSystemResource> allJdbcSystemResources = new HashMap<String, JDBCSystemResource>();
    protected Map<String, List<WLDFSystemResource>> wldfSystemResources = new HashMap<String, List<WLDFSystemResource>>();
    protected Map<String, WLDFSystemResource> allWldfSystemResources = new HashMap<String, WLDFSystemResource>();
    protected Map<String, EnvConfig> allEnvConfigs = new HashMap<String, EnvConfig>();
    protected Map<String, List<String>> configGroupReferences = new HashMap<String, List<String>>();
    protected List<Template> subTemplates = new ArrayList<Template>();

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getVersion() {
        return this.version;
    }

    @Override
    public String getOracleHome() {
        return this.oracleHome;
    }

    @Override
    public Map<String, Application> getApplications() {
        return this.allApplications;
    }

    @Override
    public List<Application> getApplications(String groupName) {
        List<Application> list = this.applications.get(groupName);
        if (list == null) {
            return Collections.EMPTY_LIST;
        }
        return list;
    }

    @Override
    public Map<String, Library> getLibraries() {
        return this.allLibraries;
    }

    @Override
    public List<Library> getLibraries(String groupName) {
        List<Library> list = this.libraries.get(groupName);
        if (list == null) {
            return Collections.EMPTY_LIST;
        }
        return list;
    }

    @Override
    public Map<String, StartupClass> getStartupClasses() {
        return this.allStartupClasses;
    }

    @Override
    public List<StartupClass> getStartupClasses(String groupName) {
        List<StartupClass> list = this.startupClasses.get(groupName);
        if (list == null) {
            return Collections.EMPTY_LIST;
        }
        return list;
    }

    @Override
    public Map<String, ShutdownClass> getShutdownClasses() {
        return this.allShutdownClasses;
    }

    @Override
    public List<ShutdownClass> getShutdownClasses(String groupName) {
        List<ShutdownClass> list = this.shutdownClasses.get(groupName);
        if (list == null) {
            return Collections.EMPTY_LIST;
        }
        return list;
    }

    @Override
    public Map<String, URLProvider> getURLProviders() {
        return this.allUrlProviders;
    }

    @Override
    public List<URLProvider> getURLProviders(String groupName) {
        List<URLProvider> list = this.urlProviders.get(groupName);
        if (list == null) {
            return Collections.EMPTY_LIST;
        }
        return list;
    }

    @Override
    public Map<String, JDBCSystemResource> getJDBCSystemResources() {
        return this.allJdbcSystemResources;
    }

    @Override
    public List<JDBCSystemResource> getJDBCSystemResources(String groupName) {
        List<JDBCSystemResource> list = this.jdbcSystemResources.get(groupName);
        if (list == null) {
            return Collections.EMPTY_LIST;
        }
        return list;
    }

    @Override
    public Map<String, WLDFSystemResource> getWLDFSystemResources() {
        return this.allWldfSystemResources;
    }

    @Override
    public List<WLDFSystemResource> getWLDFSystemResources(String groupName) {
        List<WLDFSystemResource> list = this.wldfSystemResources.get(groupName);
        if (list == null) {
            return Collections.EMPTY_LIST;
        }
        return list;
    }

    @Override
    public List<String> getConfigGroupReferences(String groupName) {
        List<String> list = this.configGroupReferences.get(groupName);
        if (list == null) {
            return Collections.EMPTY_LIST;
        }
        return list;
    }

    @Override
    public Map<String, EnvConfig> getEnvConfigs() {
        return this.allEnvConfigs;
    }

    @Override
    public List<Template> getSubTemplates() {
        return this.subTemplates;
    }

    public String toString() {
        return this.getName() + " " + this.getVersion();
    }
}

