/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.ceditor.tint;

import java.util.logging.Level;
import javax.ide.util.MetaClass;
import oracle.ide.ExtensionRegistry;
import oracle.ide.ceditor.tint.TintProvider;

final class TintProviderReference {
    private final MetaClass<TintProvider> providerClass;
    private final String name;
    private TintProvider provider;

    public TintProviderReference(String name, MetaClass<TintProvider> providerClass) {
        this.name = name;
        this.providerClass = providerClass;
    }

    public String name() {
        return this.name;
    }

    public synchronized TintProvider provider() {
        try {
            if (this.provider == null) {
                this.provider = (TintProvider)this.providerClass.newInstance();
                this.provider.initialize();
            }
        }
        catch (Exception e) {
            ExtensionRegistry.getExtensionRegistry().getLogger().log(Level.SEVERE, "Failed to create editor-tint provider from class " + this.providerClass.getClassName(), e);
            this.provider = null;
        }
        return this.provider;
    }
}

