/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.ceditor.tint;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import oracle.ide.Context;
import oracle.ide.ExtensionRegistry;
import oracle.ide.ceditor.EditorPluginsFactory;
import oracle.ide.ceditor.tint.TintProvider;
import oracle.ideimpl.ceditor.tint.TintHook;
import oracle.ideimpl.ceditor.tint.TintProviderReference;
import oracle.javatools.editor.plugins.EditorPlugin;

public final class TintEditorPluginsFactory
implements EditorPluginsFactory {
    public static final String TINT_COMMAND = "oracle.ide.ceditor.tint.enable";

    public List createPlugins(Context ideContext) {
        ArrayList<EditorPlugin> plugins = new ArrayList<EditorPlugin>();
        ArrayList<String> pluginNames = new ArrayList<String>();
        for (TintProviderReference providerRef : TintHook.get().providers()) {
            TintProvider provider = providerRef.provider();
            EditorPlugin plugin = provider.getTintPlugin(ideContext);
            if (plugin == null) continue;
            plugins.add(plugin);
            pluginNames.add(providerRef.name());
        }
        if (plugins.size() > 1) {
            String names = "";
            for (String name : pluginNames) {
                names = names + name + " ";
            }
            ExtensionRegistry.getExtensionRegistry().getLogger().log(Level.SEVERE, "More than one editor tinter is attempting to tint: " + ideContext.getNode().getShortLabel() + ", " + names);
        }
        return plugins;
    }
}

