/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.macros.ui;

import java.util.ArrayList;
import java.util.List;
import javax.swing.DefaultListCellRenderer;
import javax.swing.ListCellRenderer;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import oracle.ide.Context;
import oracle.ideimpl.macros.MacroUtils;
import oracle.javatools.ui.completion.CompletionProvider;

public class MacroCompletionProvider
implements CompletionProvider<String> {
    public final DefaultListCellRenderer renderer = new DefaultListCellRenderer();
    private List<String> macroStrings;

    public MacroCompletionProvider(Context context) {
        this.macroStrings = MacroUtils.getMacroExpressions(context);
    }

    public ListCellRenderer getCellRenderer() {
        return this.renderer;
    }

    public boolean handlesInsight(Document doc, int pos) {
        try {
            String currentTextValue = doc.getText(0, pos);
            int macroStart = currentTextValue.lastIndexOf("$");
            int macroEnd = currentTextValue.indexOf(125, macroStart);
            if (macroStart != -1 && macroEnd == -1) {
                return true;
            }
        }
        catch (BadLocationException e) {
            return false;
        }
        return false;
    }

    public String[] getInsightData(Document doc, int pos) {
        ArrayList<String> matches = new ArrayList<String>();
        try {
            String currentTextValue = doc.getText(0, pos);
            int macroStart = currentTextValue.lastIndexOf(36);
            if (macroStart == -1) {
                macroStart = 0;
            }
            String prefix = currentTextValue.substring(macroStart, pos).toLowerCase();
            for (String s : this.macroStrings) {
                if (!s.toLowerCase().startsWith(prefix)) continue;
                matches.add(s);
            }
        }
        catch (BadLocationException e) {
            return new String[0];
        }
        return matches.toArray(new String[matches.size()]);
    }

    public void completeInsight(Document doc, int pos, String insightObject) {
        try {
            int macroStart = doc.getText(0, pos).lastIndexOf(36);
            int macroEnd = doc.getText(macroStart, doc.getLength() - macroStart).indexOf(125);
            macroEnd = macroEnd == -1 ? doc.getLength() : macroStart + macroEnd + 1;
            int macroLength = macroEnd - macroStart;
            doc.remove(macroStart, macroLength);
            doc.insertString(macroStart, insightObject, null);
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }

    public boolean isAutoPopupChar(char c) {
        return true;
    }
}

