/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.macros;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import javax.ide.extension.ElementName;
import javax.ide.extension.Extension;
import javax.ide.extension.spi.ExtensionLogRecord;
import javax.ide.util.MetaClass;
import oracle.ide.Context;
import oracle.ide.ExtensionRegistry;
import oracle.ide.extension.HashStructureHook;
import oracle.ide.extension.HashStructureHookEvent;
import oracle.ide.extension.HashStructureHookListener;
import oracle.ide.extension.rules.Rule;
import oracle.ide.extension.rules.RuleEngine;
import oracle.ide.macros.MacroHandler;
import oracle.ide.model.Project;
import oracle.ide.model.Workspace;
import oracle.ide.panels.Navigable;
import oracle.ideimpl.macros.DeclarativeMacroHandler;
import oracle.ideimpl.macros.MacroDeclaration;
import oracle.javatools.data.HashStructure;

public final class MacroHook {
    private static final ElementName HOOK_NAME = new ElementName("http://xmlns.oracle.com/ide/extension/ide-macros", "macro-hook");
    private static HashStructureHook hashStructureHook;
    private static Map<String, ToolDescription<Navigable>> macroNavigables;
    private static Map<String, ToolDescription<MacroHandler>> macroHandlers;
    private static Set<String> _emittedErrors;

    static List<Navigable> getMacroNavigables(Workspace workspace, Project project) {
        return MacroHook.getNavigables(workspace, project, macroNavigables);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<Navigable> getNavigables(Workspace workspace, Project project, Map<String, ToolDescription<Navigable>> navigables) {
        Class<MacroHook> clazz = MacroHook.class;
        synchronized (MacroHook.class) {
            MacroHook.primeHook();
            ArrayList copy = new ArrayList(navigables.values());
            // ** MonitorExit[var4_3] (shouldn't be in output)
            return new ArrayList<Navigable>(MacroHook.getToolsAsMap(copy, workspace, project).values());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Map<String, MacroHandler> getMacroHandlers(Workspace workspace, Project project) {
        Class<MacroHook> clazz = MacroHook.class;
        synchronized (MacroHook.class) {
            MacroHook.primeHook();
            ArrayList copy = new ArrayList(macroHandlers.values());
            // ** MonitorExit[var3_2] (shouldn't be in output)
            return MacroHook.getToolsAsMap(copy, workspace, project);
        }
    }

    public static List<MacroDeclaration> getMacros(String qualifier, Workspace workspace, Project project) {
        ArrayList<MacroDeclaration> macros = new ArrayList<MacroDeclaration>();
        for (ToolDescription<MacroHandler> tool : macroHandlers.values()) {
            if (!((ToolDescription)tool).rulesApply(workspace, project)) continue;
            for (MacroDeclaration declaration : ((ToolDescription)tool).getMacroDeclarations(qualifier)) {
                Context context;
                RuleEngine engine;
                String rule = declaration.getRule();
                if (rule == null || rule.trim().length() <= 0 || (engine = RuleEngine.getInstance()).getRule(rule) == null || !engine.evaluateRule(rule, context = new Context(workspace, project))) continue;
                macros.add(declaration);
            }
        }
        return macros;
    }

    private static void primeMacroNavigables() {
        if (macroNavigables == null) {
            macroNavigables = new LinkedHashMap<String, ToolDescription<Navigable>>();
        }
    }

    private static void primeMacroHandlers() {
        if (macroHandlers == null) {
            macroHandlers = new LinkedHashMap<String, ToolDescription<MacroHandler>>();
        }
    }

    private static <T> Map<String, T> getToolsAsMap(List<ToolDescription<T>> copy, Workspace workspace, Project project) {
        HashMap<String, T> list = new HashMap<String, T>(copy.size());
        for (ToolDescription<T> desc : copy) {
            T tool;
            if (!((ToolDescription)desc).rulesApply(workspace, project) || (tool = desc.getTool()) == null) continue;
            list.put(desc.getKey(), tool);
        }
        return list;
    }

    private static synchronized void primeHook() {
        if (hashStructureHook == null) {
            MacroHook.primeMacroHandlers();
            MacroHook.primeMacroNavigables();
            hashStructureHook = (HashStructureHook)ExtensionRegistry.getExtensionRegistry().getHook(HOOK_NAME);
            if (hashStructureHook == null) {
                return;
            }
            hashStructureHook.addHashStructureHookListener(new HashStructureHookListener(){

                public void elementVisited(HashStructureHookEvent e) {
                    this.addItemsFromHook(e.getNewElementHashStructure());
                }

                public void listenerAttached(HashStructureHookEvent e) {
                    this.addItemsFromHook(e.getCombinedHashStructure());
                }

                private void addItemsFromHook(HashStructure hashStructure) {
                    MacroHook.addToolsFromHook(hashStructure, Category.MACRO_NAVIGABLE);
                    MacroHook.addToolsFromHook(hashStructure, Category.MACRO_HANDLER);
                }
            });
        }
    }

    private static synchronized void addToolsFromHook(HashStructure hashStructure, Category category) {
        List definitions = hashStructure.getAsList(category.toString());
        if (definitions != null && definitions.size() > 0) {
            block4: for (Object definition : definitions) {
                HashStructure defHash = (HashStructure)definition;
                String rule = MacroHook.getRuleFromHash(defHash, category);
                String className = MacroHook.getClassNameFromHash(defHash, category);
                String extensionId = HashStructureHook.getExtensionId((HashStructure)defHash);
                if (!MacroHook.isMissingRule(rule, className, category.name(), extensionId) && !MacroHook.isValidRule(rule, className, category.name(), extensionId)) continue;
                switch (category) {
                    default: {
                        assert (false);
                        continue block4;
                    }
                    case MACRO_NAVIGABLE: {
                        MacroHook.addTool(defHash, category, macroNavigables);
                        continue block4;
                    }
                    case MACRO_HANDLER: 
                }
                MacroHook.addTool(defHash, category, macroHandlers);
            }
        }
    }

    private static String getClassNameFromHash(HashStructure defHash, Category category) {
        String className = null;
        switch (category) {
            case MACRO_NAVIGABLE: {
                className = defHash.getString("parent-panel/traversable-class/#text");
                break;
            }
            case MACRO_HANDLER: {
                className = defHash.getString("class");
            }
        }
        if (className == null && HashStructureHook.getExtensionId((HashStructure)defHash) != null) {
            className = "extension " + HashStructureHook.getExtensionId((HashStructure)defHash);
        }
        return className;
    }

    private static boolean isMissingRule(String rule, String className, String category, String extensionId) {
        if (rule == null || rule.trim().length() == 0) {
            MacroHook.ruleError("Missing", className, category, extensionId);
            return true;
        }
        return false;
    }

    private static boolean isValidRule(String rule, String className, String category, String extensionId) {
        RuleEngine engine = RuleEngine.getInstance();
        Rule engineRule = engine.getRule(rule);
        HashSet<String> acceptedRules = new HashSet<String>(2);
        acceptedRules.add("project-has-techscope");
        acceptedRules.add("always-enabled");
        acceptedRules.add("project-content-has-contents");
        if (engineRule == null || !engineRule.matchesType(acceptedRules)) {
            MacroHook.ruleError("Invalid", className, category, extensionId);
            return false;
        }
        return true;
    }

    private static void ruleError(String prefix, String className, String category, String extensionId) {
        MacroHook.logError(prefix + " rule attribute in " + className + " registration", category, extensionId);
    }

    private static <T> void addTool(HashStructure hashStructure, Category category, Map<String, ToolDescription<T>> tools) {
        String extensionId = HashStructureHook.getExtensionId((HashStructure)hashStructure);
        ToolDescription desc = new ToolDescription(hashStructure, extensionId, category);
        String key = desc.getKey();
        if (tools.containsKey(key)) {
            MacroHook.logDuplicateTool(key, category, extensionId);
        }
        tools.put(key, desc);
    }

    private static void logDuplicateTool(String className, Category category, String extensionId) {
        MacroHook.logError("Duplicate Registration: " + className, category.toString(), extensionId);
    }

    private static synchronized void logError(String msg, String category, String extensionId) {
        StringBuilder buf = new StringBuilder();
        buf.append(msg);
        buf.append(" in ");
        buf.append(category);
        if (extensionId != null) {
            buf.append(" in extension ");
            buf.append(extensionId);
        }
        if (_emittedErrors == null) {
            _emittedErrors = new HashSet<String>();
        }
        if (!_emittedErrors.contains(buf.toString())) {
            _emittedErrors.add(buf.toString());
            ExtensionRegistry.getExtensionRegistry().getLogger().log(Level.SEVERE, buf.toString());
            if (extensionId != null) {
                Extension ext = ExtensionRegistry.getExtensionRegistry().findExtension(extensionId);
                ExtensionLogRecord record = new ExtensionLogRecord(Level.SEVERE, buf.toString(), ext, -1);
                ExtensionRegistry.getExtensionRegistry().getManifestLogger().log((LogRecord)record);
            }
        }
    }

    private static String getRuleFromHash(HashStructure hash, Category category) {
        String rule = null;
        if (hash == null) {
            rule = "always-enabled";
        } else {
            switch (category) {
                case MACRO_NAVIGABLE: {
                    rule = hash.getString("parent-panel/rule/#text");
                    break;
                }
                case MACRO_HANDLER: {
                    rule = hash.getString("rule");
                    break;
                }
                default: {
                    rule = "always-enabled";
                }
            }
        }
        return rule;
    }

    private static final class ToolDescription<T> {
        private String extensionId;
        private T tool;
        private HashStructure hash;
        private Category category;
        private String key;

        private ToolDescription(HashStructure hash, String extensionId, Category category) {
            this.hash = hash;
            this.extensionId = extensionId;
            this.category = category;
        }

        private ToolDescription(T tool, Category category, String key) {
            this.tool = tool;
            this.category = category;
            this.key = key;
        }

        public String getKey() {
            if (this.key == null) {
                switch (this.category) {
                    default: {
                        assert (false) : "Unknown category in getKey()";
                        break;
                    }
                    case MACRO_HANDLER: {
                        this.key = ToolDescription.getAttributeValue(this.hash, "qualifier", this.category, this.extensionId);
                        break;
                    }
                    case MACRO_NAVIGABLE: {
                        this.key = ToolDescription.getAttributeValue(this.hash, "parent-panel", this.category, this.extensionId);
                    }
                }
            }
            return this.key;
        }

        public synchronized T getTool() {
            if (this.tool == null) {
                ClassLoader classLoader = ToolDescription.getClassLoader(this.extensionId);
                switch (this.category) {
                    default: {
                        assert (false) : "Unknown category in getTool()";
                        return null;
                    }
                    case MACRO_HANDLER: {
                        String classValue = ToolDescription.getAttributeValue(this.hash, "class", this.category, this.extensionId);
                        MetaClass metaClass = new MetaClass(classLoader, classValue);
                        try {
                            this.tool = metaClass.newInstance();
                            if (!(this.tool instanceof DeclarativeMacroHandler)) break;
                            DeclarativeMacroHandler mh = (DeclarativeMacroHandler)this.tool;
                            mh.setClassLoader(classLoader);
                            String qual = ToolDescription.getAttributeValue(this.hash, "qualifier", this.category, this.extensionId);
                            mh.setQualifier(qual);
                            String qualDesc = ToolDescription.getAttributeValue(this.hash, "qualifier-label", this.category, this.extensionId);
                            mh.setQualifierDescription(qualDesc);
                            List<MacroDeclaration> macros = this.getMacroDeclarations(qual);
                            for (MacroDeclaration macro : macros) {
                                mh.addMacroDeclaration(macro);
                            }
                            break;
                        }
                        catch (Exception ex) {
                            MacroHook.logError("Failed to create Tool from class " + classValue, this.category.toString(), this.extensionId);
                            break;
                        }
                    }
                    case MACRO_NAVIGABLE: {
                        Navigable parentPanel = this.getPanel("parent-panel", classLoader);
                        if (parentPanel != null) {
                            List<Navigable> childPanels = this.getChildPanels(classLoader);
                            for (Navigable childPanel : childPanels) {
                                parentPanel.addChildNavigable(childPanel);
                            }
                        }
                        this.tool = parentPanel;
                    }
                }
            }
            return this.tool;
        }

        private List<Navigable> getChildPanels(ClassLoader classLoader) {
            List list = this.hash.getAsList("child-panel");
            ArrayList<Navigable> childPanels = new ArrayList<Navigable>();
            if (list != null) {
                for (int i = 0; i < list.size(); ++i) {
                    HashStructure childHash;
                    Navigable childPanel;
                    Object object = list.get(i);
                    if (!(object instanceof HashStructure) || (childPanel = this.getNavigable(childHash = (HashStructure)object, classLoader)) == null) continue;
                    childPanels.add(childPanel);
                }
            }
            return childPanels;
        }

        private Navigable getPanel(String name, ClassLoader classLoader) {
            Object object;
            if (this.hash.containsKey(name) && (object = this.hash.getObject(name)) instanceof HashStructure) {
                HashStructure panelHash = (HashStructure)object;
                return this.getNavigable(panelHash, classLoader);
            }
            return null;
        }

        private Navigable getNavigable(HashStructure hash, ClassLoader classLoader) {
            String traversableClass = ToolDescription.getAttributeValue(hash, "traversable-class/#text", this.category, this.extensionId);
            if (traversableClass != null) {
                MetaClass metaClass = new MetaClass(classLoader, traversableClass);
                try {
                    Class clazz = metaClass.toClass();
                    String label = ToolDescription.getAttributeValue(hash, "label/#text", this.category, this.extensionId);
                    return new Navigable(label, clazz);
                }
                catch (Exception ex) {
                    MacroHook.logError("Failed to create Class for class " + traversableClass, this.category.toString(), this.extensionId);
                }
            }
            return null;
        }

        private static String getAttributeValue(HashStructure hash, String name, Category category, String extensionId) {
            String value = hash.getString(name, null);
            if (value == null || value.trim().length() == 0) {
                MacroHook.logError("Missing attribute " + name, category.toString(), extensionId);
            }
            return value;
        }

        private static ClassLoader getClassLoader(String extensionId) {
            ClassLoader loader = null;
            if (extensionId != null) {
                loader = ExtensionRegistry.getExtensionRegistry().getClassLoader(extensionId);
            }
            if (loader == null) {
                loader = MacroHook.class.getClass().getClassLoader();
            }
            return loader;
        }

        private boolean rulesApply(Workspace workspace, Project project) {
            String rule = MacroHook.getRuleFromHash(this.hash, this.category);
            if (rule != null && rule.trim().length() > 0) {
                RuleEngine engine = RuleEngine.getInstance();
                if (engine.getRule(rule) != null) {
                    Context context = new Context(workspace, project);
                    return engine.evaluateRule(rule, context);
                }
                return false;
            }
            return true;
        }

        private List<MacroDeclaration> getMacroDeclarations(String qualifier) {
            List list = this.hash.getAsList("macro");
            ArrayList<MacroDeclaration> macros = new ArrayList<MacroDeclaration>();
            if (list != null) {
                for (int i = 0; i < list.size(); ++i) {
                    MacroDeclaration macro;
                    Object object = list.get(i);
                    if (!(object instanceof HashStructure)) continue;
                    HashStructure childHash = (HashStructure)object;
                    String qualifierFromDom = ToolDescription.getAttributeValue(this.hash, "qualifier", this.category, this.extensionId);
                    if (qualifierFromDom == null || !qualifierFromDom.equals(qualifier) || (macro = this.getMacroDeclaration(qualifier, childHash)) == null) continue;
                    macros.add(macro);
                }
            }
            return macros;
        }

        private MacroDeclaration getMacroDeclaration(String qualifier, HashStructure hash) {
            MacroDeclaration md = new MacroDeclaration();
            md.setQualifier(qualifier);
            md.setRule(MacroHook.getRuleFromHash(hash, Category.MACRO_HANDLER));
            md.setName(ToolDescription.getAttributeValue(hash, "name", this.category, this.extensionId));
            md.setDescription(ToolDescription.getAttributeValue(hash, "description", this.category, this.extensionId));
            md.setClassName(ToolDescription.getAttributeValue(hash, "class", this.category, this.extensionId));
            md.setIsPathExpression("true".equals(ToolDescription.getAttributeValue(hash, "isPathMacro", this.category, this.extensionId)));
            md.setRequiresContext("true".equals(ToolDescription.getAttributeValue(hash, "requiresContext", this.category, this.extensionId)));
            return md;
        }
    }

    private static enum Category {
        MACRO_NAVIGABLE{

            public String toString() {
                return "macro-navigable";
            }
        }
        ,
        MACRO_HANDLER{

            public String toString() {
                return "macro-handler";
            }
        };

    }
}

